/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.util.HexUtils;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.MD5Encoder;
import org.apache.catalina.util.StringManager;

public abstract class RealmBase
implements Lifecycle,
Realm {
    protected Container container = null;
    protected int debug = 0;
    protected String digest = null;
    protected static final String info = "org.apache.catalina.realm.RealmBase/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected MessageDigest md = null;
    protected static final MD5Encoder md5Encoder = new MD5Encoder();
    protected static MessageDigest md5Helper;
    protected static StringManager sm;
    protected boolean started = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);

    static {
        sm = StringManager.getManager("org.apache.catalina.realm");
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public Principal authenticate(String username, String credentials) {
        String serverCredentials = this.getPassword(username);
        if (serverCredentials == null || !serverCredentials.equals(credentials)) {
            return null;
        }
        return this.getPrincipal(username);
    }

    public Principal authenticate(String username, String clientDigest, String nOnce, String nc, String cnonce, String qop, String realm, String md5a2) {
        String md5a1 = this.getDigest(username, realm);
        if (md5a1 == null) {
            return null;
        }
        String serverDigestValue = String.valueOf(md5a1) + ":" + nOnce + ":" + nc + ":" + cnonce + ":" + qop + ":" + md5a2;
        String serverDigest = md5Encoder.encode(md5Helper.digest(serverDigestValue.getBytes()));
        if (serverDigest.equals(clientDigest)) {
            return this.getPrincipal(username);
        }
        return null;
    }

    public Principal authenticate(String username, byte[] credentials) {
        return this.authenticate(username, credentials.toString());
    }

    protected String digest(String credentials) {
        if (this.md == null) {
            return credentials;
        }
        RealmBase realmBase = this;
        synchronized (realmBase) {
            try {
                this.md.reset();
                this.md.update(credentials.getBytes());
                String string = HexUtils.convert(this.md.digest());
                Object var4_5 = null;
                return string;
            }
            catch (Exception e10) {
                this.log(sm.getString("realmBase.digest"), e10);
                String string = credentials;
                Object var4_6 = null;
                return string;
            }
        }
    }

    public Container getContainer() {
        return this.container;
    }

    public int getDebug() {
        return this.debug;
    }

    public String getDigest() {
        return this.digest;
    }

    protected String getDigest(String username, String realmName) {
        if (md5Helper == null) {
            try {
                md5Helper = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e10) {
                e10.printStackTrace();
                throw new IllegalStateException();
            }
        }
        String digestValue = String.valueOf(username) + ":" + realmName + ":" + this.getPassword(username);
        byte[] digest = md5Helper.digest(digestValue.getBytes());
        return md5Encoder.encode(digest);
    }

    public String getInfo() {
        return info;
    }

    protected abstract String getName();

    protected abstract String getPassword(String var1);

    protected abstract Principal getPrincipal(String var1);

    public boolean hasRole(Principal principal, String role) {
        if (principal == null || role == null || !(principal instanceof GenericPrincipal)) {
            return false;
        }
        GenericPrincipal gp = (GenericPrincipal)principal;
        if (gp.getRealm() != this) {
            return false;
        }
        boolean result = gp.hasRole(role);
        if (this.debug >= 2) {
            String name = principal.getName();
            if (result) {
                this.log(sm.getString("realmBase.hasRoleSuccess", name, role));
            } else {
                this.log(sm.getString("realmBase.hasRoleFailure", name, role));
            }
        }
        return result;
    }

    protected void log(String message) {
        Logger logger = null;
        String name = null;
        if (this.container != null) {
            logger = this.container.getLogger();
            name = this.container.getName();
        }
        if (logger != null) {
            logger.log(String.valueOf(this.getName()) + "[" + name + "]: " + message);
        } else {
            System.out.println(String.valueOf(this.getName()) + "[" + name + "]: " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = null;
        String name = null;
        if (this.container != null) {
            logger = this.container.getLogger();
            name = this.container.getName();
        }
        if (logger != null) {
            logger.log(String.valueOf(this.getName()) + "[" + name + "]: " + message, throwable);
        } else {
            System.out.println(String.valueOf(this.getName()) + "[" + name + "]: " + message);
            throwable.printStackTrace(System.out);
        }
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void setContainer(Container container) {
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new IllegalStateException(sm.getString("realmBase.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.digest != null) {
            try {
                this.md = MessageDigest.getInstance(this.digest);
            }
            catch (NoSuchAlgorithmException e10) {
                throw new LifecycleException(sm.getString("realmBase.algorithm", this.digest), e10);
            }
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new IllegalStateException(sm.getString("realmBase.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.md = null;
    }
}

