/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlException;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.catalina.loader.Extension;
import org.apache.catalina.loader.Reloader;

public class StandardClassLoader
extends URLClassLoader
implements Reloader {
    protected ArrayList available = new ArrayList();
    protected HashMap classCache = new HashMap();
    protected int debug = 0;
    protected boolean delegate = false;
    protected String[] repositories = new String[0];
    protected ArrayList required = new ArrayList();
    private ArrayList filePermissionList = new ArrayList();
    private HashMap loaderPC = new HashMap();
    private SecurityManager securityManager = null;
    private boolean policy_refresh = false;
    private ClassLoader parent = null;
    private ClassLoader system = null;
    protected URLStreamHandlerFactory factory = null;

    public StandardClassLoader() {
        super(new URL[0]);
        this.parent = this.getParent();
        this.system = ClassLoader.getSystemClassLoader();
        this.securityManager = System.getSecurityManager();
    }

    public StandardClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        this.parent = parent;
        this.system = ClassLoader.getSystemClassLoader();
        this.securityManager = System.getSecurityManager();
    }

    public StandardClassLoader(ClassLoader parent, URLStreamHandlerFactory factory) {
        super(new URL[0], parent, factory);
        this.factory = factory;
    }

    public StandardClassLoader(URLStreamHandlerFactory factory) {
        super(new URL[0], null, factory);
        this.factory = factory;
    }

    public StandardClassLoader(String[] repositories) {
        super(StandardClassLoader.convert(repositories));
        this.parent = this.getParent();
        this.system = ClassLoader.getSystemClassLoader();
        this.securityManager = System.getSecurityManager();
        if (repositories != null) {
            int i2 = 0;
            while (i2 < repositories.length) {
                this.addRepositoryInternal(repositories[i2]);
                ++i2;
            }
        }
    }

    public StandardClassLoader(String[] repositories, ClassLoader parent) {
        super(StandardClassLoader.convert(repositories), parent);
        this.parent = parent;
        this.system = ClassLoader.getSystemClassLoader();
        this.securityManager = System.getSecurityManager();
        if (repositories != null) {
            int i2 = 0;
            while (i2 < repositories.length) {
                this.addRepositoryInternal(repositories[i2]);
                ++i2;
            }
        }
    }

    public StandardClassLoader(URL[] repositories, ClassLoader parent) {
        super(repositories, parent);
        this.parent = parent;
        this.system = ClassLoader.getSystemClassLoader();
        this.securityManager = System.getSecurityManager();
        if (repositories != null) {
            int i2 = 0;
            while (i2 < repositories.length) {
                this.addRepositoryInternal(repositories[i2].toString());
                ++i2;
            }
        }
    }

    public void addRepository(String repository) {
        if (this.debug >= 1) {
            this.log("addRepository(" + repository + ")");
        }
        try {
            URLStreamHandler streamHandler = null;
            String protocol = StandardClassLoader.parseProtocol(repository);
            if (this.factory != null) {
                streamHandler = this.factory.createURLStreamHandler(protocol);
            }
            URL url = new URL(null, repository, streamHandler);
            super.addURL(url);
        }
        catch (MalformedURLException e10) {
            throw new IllegalArgumentException(e10.toString());
        }
        this.addRepositoryInternal(repository);
    }

    protected void addRepositoryInternal(String repository) {
        URLStreamHandler streamHandler = null;
        String protocol = StandardClassLoader.parseProtocol(repository);
        if (this.factory != null) {
            streamHandler = this.factory.createURLStreamHandler(protocol);
        }
        if (!repository.endsWith("/")) {
            try {
                URLConnection conn;
                URL url;
                JarFile jarFile = null;
                Manifest manifest = null;
                if (repository.startsWith("jar:")) {
                    url = new URL(null, repository, streamHandler);
                    conn = (JarURLConnection)url.openConnection();
                    conn.setAllowUserInteraction(false);
                    conn.setDoInput(true);
                    conn.setDoOutput(false);
                    conn.connect();
                    jarFile = ((JarURLConnection)conn).getJarFile();
                } else if (repository.startsWith("file://")) {
                    jarFile = new JarFile(repository.substring(7));
                } else if (repository.startsWith("file:")) {
                    jarFile = new JarFile(repository.substring(5));
                } else if (repository.endsWith(".jar")) {
                    url = new URL(null, repository, streamHandler);
                    conn = url.openConnection();
                    JarInputStream jis = new JarInputStream(conn.getInputStream());
                    manifest = jis.getManifest();
                } else {
                    throw new IllegalArgumentException("addRepositoryInternal:  Invalid URL '" + repository + "'");
                }
                if (manifest != null || jarFile != null) {
                    if (manifest == null && jarFile != null) {
                        manifest = jarFile.getManifest();
                    }
                    if (manifest != null) {
                        Iterator extensions = Extension.getAvailable(manifest).iterator();
                        while (extensions.hasNext()) {
                            this.available.add(extensions.next());
                        }
                        extensions = Extension.getRequired(manifest).iterator();
                        while (extensions.hasNext()) {
                            this.required.add(extensions.next());
                        }
                    }
                }
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (Throwable t2) {
                t2.printStackTrace();
                throw new IllegalArgumentException("addRepositoryInternal: " + t2);
            }
        }
        String[] stringArray = this.repositories;
        synchronized (stringArray) {
            String[] results = new String[this.repositories.length + 1];
            System.arraycopy(this.repositories, 0, results, 0, this.repositories.length);
            results[this.repositories.length] = repository;
            this.repositories = results;
        }
    }

    protected static URL[] convert(String[] input) {
        return StandardClassLoader.convert(input, null);
    }

    protected static URL[] convert(String[] input, URLStreamHandlerFactory factory) {
        URLStreamHandler streamHandler = null;
        URL[] url = new URL[input.length];
        int i2 = 0;
        while (i2 < url.length) {
            try {
                String protocol = StandardClassLoader.parseProtocol(input[i2]);
                streamHandler = factory != null ? factory.createURLStreamHandler(protocol) : null;
                url[i2] = new URL(null, input[i2], streamHandler);
            }
            catch (MalformedURLException malformedURLException) {
                url[i2] = null;
            }
            ++i2;
        }
        return url;
    }

    public Extension[] findAvailable() {
        Extension[] extensions;
        ArrayList results = new ArrayList();
        Iterator available = ((AbstractList)this.available).iterator();
        while (available.hasNext()) {
            results.add(available.next());
        }
        ClassLoader loader = this;
        while ((loader = loader.getParent()) != null) {
            if (!(loader instanceof StandardClassLoader)) continue;
            extensions = ((StandardClassLoader)loader).findAvailable();
            int i2 = 0;
            while (i2 < extensions.length) {
                results.add(extensions[i2]);
                ++i2;
            }
        }
        extensions = new Extension[results.size()];
        return results.toArray(extensions);
    }

    public Class findClass(String name) throws ClassNotFoundException {
        int i2;
        if (this.debug >= 3) {
            this.log("    findClass(" + name + ")");
        }
        if (this.securityManager != null && (i2 = name.lastIndexOf(46)) >= 0) {
            try {
                if (this.debug >= 4) {
                    this.log("      securityManager.checkPackageDefinition");
                }
                this.securityManager.checkPackageDefinition(name.substring(0, i2));
            }
            catch (Exception se) {
                if (this.debug >= 4) {
                    this.log("      -->Exception-->ClassNotFoundException", se);
                }
                throw new ClassNotFoundException(name);
            }
        }
        Class<?> clazz = null;
        try {
            if (this.debug >= 4) {
                this.log("      super.findClass(" + name + ")");
            }
            try {
                clazz = super.findClass(name);
            }
            catch (AccessControlException accessControlException) {
                throw new ClassNotFoundException(name);
            }
            catch (RuntimeException e10) {
                if (this.debug >= 4) {
                    this.log("      -->RuntimeException Rethrown", e10);
                }
                throw e10;
            }
            if (clazz == null) {
                if (this.debug >= 3) {
                    this.log("    --> Returning ClassNotFoundException");
                }
                throw new ClassNotFoundException(name);
            }
        }
        catch (ClassNotFoundException e11) {
            if (this.debug >= 3) {
                this.log("    --> Passing on ClassNotFoundException", e11);
            }
            throw e11;
        }
        int i3 = 0;
        while (i3 < this.repositories.length) {
            if (this.repositories[i3].endsWith("/")) {
                String pathname = this.repositories[i3].substring(0, this.repositories[i3].length() - 1);
                if (this.debug >= 4) {
                    this.log("      Checking repository " + pathname);
                }
                if (pathname.startsWith("file://")) {
                    pathname = pathname.substring(7);
                } else if (pathname.startsWith("file:")) {
                    pathname = pathname.substring(5);
                }
                pathname = String.valueOf(pathname) + File.separatorChar + name.replace('.', File.separatorChar) + ".class";
                try {
                    File file = new File(pathname);
                    if (file.exists() && file.canRead()) {
                        if (this.debug >= 3) {
                            this.log("    Caching from '" + file.getAbsolutePath() + "' modified '" + new Timestamp(file.lastModified()) + "'");
                        }
                        this.classCache.put(name, new ClassCacheEntry(clazz, file, file.lastModified()));
                    }
                }
                catch (AccessControlException accessControlException) {}
            }
            ++i3;
        }
        if (this.debug >= 4) {
            this.log("      Returning class " + clazz);
        }
        if (this.debug >= 4 && clazz != null) {
            this.log("      Loaded by " + clazz.getClassLoader());
        }
        return clazz;
    }

    protected InputStream findLoadedResource(String name) {
        return null;
    }

    public String[] findRepositories() {
        return this.repositories;
    }

    public Extension[] findRequired() {
        Extension[] extensions;
        ArrayList results = new ArrayList();
        Iterator required = ((AbstractList)this.required).iterator();
        while (required.hasNext()) {
            results.add(required.next());
        }
        ClassLoader loader = this;
        while ((loader = loader.getParent()) != null) {
            if (!(loader instanceof StandardClassLoader)) continue;
            extensions = ((StandardClassLoader)loader).findRequired();
            int i2 = 0;
            while (i2 < extensions.length) {
                results.add(extensions[i2]);
                ++i2;
            }
        }
        extensions = new Extension[results.size()];
        return results.toArray(extensions);
    }

    public URL findResource(String name) {
        if (this.debug >= 3) {
            this.log("    findResource(" + name + ")");
        }
        URL url = super.findResource(name);
        if (this.debug >= 3) {
            if (url != null) {
                this.log("    --> Returning '" + url.toString() + "'");
            } else {
                this.log("    --> Resource not found, returning null");
            }
        }
        return url;
    }

    public Enumeration findResources(String name) throws IOException {
        if (this.debug >= 3) {
            this.log("    findResources(" + name + ")");
        }
        return super.findResources(name);
    }

    public int getDebug() {
        return this.debug;
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    protected final PermissionCollection getPermissions(CodeSource codeSource) {
        String codeUrl;
        PermissionCollection pc;
        if (!this.policy_refresh) {
            Policy policy = Policy.getPolicy();
            policy.refresh();
            this.policy_refresh = true;
        }
        if ((pc = (PermissionCollection)this.loaderPC.get(codeUrl = codeSource.getLocation().toString())) == null && (pc = super.getPermissions(codeSource)) != null) {
            Iterator perms = ((AbstractList)this.filePermissionList).iterator();
            while (perms.hasNext()) {
                FilePermission fp = (FilePermission)perms.next();
                pc.add(fp);
            }
            this.loaderPC.put(codeUrl, pc);
        }
        return pc;
    }

    public URL getResource(String name) {
        ClassLoader loader;
        if (this.debug >= 2) {
            this.log("getResource(" + name + ")");
        }
        URL url = null;
        if (this.delegate) {
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((url = loader.getResource(name)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning '" + url.toString() + "'");
                }
                return url;
            }
        }
        if (this.debug >= 3) {
            this.log("  Searching local repositories");
        }
        if ((url = this.findResource(name)) != null) {
            if (this.debug >= 2) {
                this.log("  --> Returning '" + url.toString() + "'");
            }
            return url;
        }
        if (!this.delegate) {
            loader = this.parent;
            if (loader == null) {
                loader = this.system;
            }
            if ((url = loader.getResource(name)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning '" + url.toString() + "'");
                }
                return url;
            }
        }
        if (this.debug >= 2) {
            this.log("  --> Resource not found, returning null");
        }
        return null;
    }

    public InputStream getResourceAsStream(String name) {
        URL url;
        if (this.debug >= 2) {
            this.log("getResourceAsStream(" + name + ")");
        }
        InputStream stream = null;
        stream = this.findLoadedResource(name);
        if (stream != null) {
            if (this.debug >= 2) {
                this.log("  --> Returning stream from cache");
            }
            return stream;
        }
        if (this.delegate) {
            ClassLoader loader;
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((stream = loader.getResourceAsStream(name)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning stream from parent");
                }
                return stream;
            }
        }
        if (this.debug >= 3) {
            this.log("  Searching local repositories");
        }
        if ((url = this.findResource(name)) != null) {
            if (this.debug >= 2) {
                this.log("  --> Returning stream from local");
            }
            try {
                return url.openStream();
            }
            catch (IOException e10) {
                this.log("url.openStream(" + url.toString() + ")", e10);
                return null;
            }
        }
        if (!this.delegate) {
            ClassLoader loader;
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((stream = loader.getResourceAsStream(name)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning stream from parent");
                }
                return stream;
            }
        }
        if (this.debug >= 2) {
            this.log("  --> Resource not found, returning null");
        }
        return null;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        int i2;
        if (this.debug >= 2) {
            this.log("loadClass(" + name + ", " + resolve + ")");
        }
        Class<?> clazz = null;
        clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (this.debug >= 3) {
                this.log("  Returning class from cache");
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (name.startsWith("java.")) {
            ClassLoader loader = this.system;
            clazz = loader.loadClass(name);
            if (clazz != null) {
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            throw new ClassNotFoundException(name);
        }
        if (this.securityManager != null && (i2 = name.lastIndexOf(46)) >= 0) {
            try {
                this.securityManager.checkPackageAccess(name.substring(0, i2));
            }
            catch (SecurityException se) {
                String error = "Security Violation, attempt to use Restricted Class: " + name;
                System.out.println(error);
                se.printStackTrace();
                this.log(error);
                throw new ClassNotFoundException(error);
            }
        }
        if (this.delegate) {
            ClassLoader loader;
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            try {
                clazz = loader.loadClass(name);
                if (clazz != null) {
                    if (this.debug >= 3) {
                        this.log("  Loading class from parent");
                    }
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (this.debug >= 3) {
            this.log("  Searching local repositories");
        }
        try {
            clazz = this.findClass(name);
            if (clazz != null) {
                if (this.debug >= 3) {
                    this.log("  Loading class from local repository");
                }
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (!this.delegate) {
            ClassLoader loader;
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            try {
                clazz = loader.loadClass(name);
                if (clazz != null) {
                    if (this.debug >= 3) {
                        this.log("  Loading class from parent");
                    }
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        throw new ClassNotFoundException(name);
    }

    private void log(String message) {
        System.out.println("StandardClassLoader: " + message);
    }

    private void log(String message, Throwable throwable) {
        System.out.println("StandardClassLoader: " + message);
        throwable.printStackTrace(System.out);
    }

    public boolean modified() {
        if (this.debug >= 2) {
            this.log("modified()");
        }
        if (this.classCache.size() < 1) {
            return false;
        }
        ClassCacheEntry[] entries = new ClassCacheEntry[]{};
        HashMap hashMap = this.classCache;
        synchronized (hashMap) {
            entries = this.classCache.values().toArray(entries);
        }
        int i2 = 0;
        while (i2 < entries.length) {
            if (entries[i2].origin instanceof File) {
                File origin = (File)entries[i2].origin;
                if (entries[i2].lastModified != origin.lastModified()) {
                    if (this.debug >= 2) {
                        this.log("  Class '" + entries[i2].loadedClass.getName() + "' was modified");
                    }
                    return true;
                }
            } else if (entries[i2].origin instanceof URL) {
                try {
                    URL url = (URL)entries[i2].origin;
                    URLConnection urlConn = url.openConnection();
                    if (entries[i2].lastModified != urlConn.getLastModified()) {
                        if (this.debug >= 2) {
                            this.log("  Class '" + entries[i2].loadedClass.getName() + "' was modified");
                        }
                        return true;
                    }
                }
                catch (IOException iOException) {}
            }
            ++i2;
        }
        return false;
    }

    protected static String parseProtocol(String spec) {
        if (spec == null) {
            return "";
        }
        int pos = spec.indexOf(58);
        if (pos <= 0) {
            return "";
        }
        return spec.substring(0, pos).trim();
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public void setDelegate(boolean delegate) {
        this.delegate = delegate;
    }

    public void setPermissions(String path) {
        if (this.securityManager != null) {
            this.filePermissionList.add(new FilePermission(String.valueOf(path) + "-", "read"));
        }
    }

    public void setPermissions(URL url) {
        this.setPermissions(url.toString());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("StandardClassLoader\r\n");
        sb.append("  available:\r\n");
        Iterator available = ((AbstractList)this.available).iterator();
        while (available.hasNext()) {
            sb.append("    ");
            sb.append(available.next().toString());
            sb.append("\r\n");
        }
        sb.append("  delegate: ");
        sb.append(this.delegate);
        sb.append("\r\n");
        sb.append("  repositories:\r\n");
        int i2 = 0;
        while (i2 < this.repositories.length) {
            sb.append("    ");
            sb.append(this.repositories[i2]);
            sb.append("\r\n");
            ++i2;
        }
        sb.append("  required:\r\n");
        Iterator required = ((AbstractList)this.required).iterator();
        while (required.hasNext()) {
            sb.append("    ");
            sb.append(required.next().toString());
            sb.append("\r\n");
        }
        if (this.getParent() != null) {
            sb.append("----------> Parent Classloader:\r\n");
            sb.append(this.getParent().toString());
            sb.append("\r\n");
        }
        return sb.toString();
    }

    private static class ClassCacheEntry {
        long lastModified;
        Class loadedClass;
        Object origin;

        public ClassCacheEntry(Class loadedClass, Object origin, long lastModified) {
            this.loadedClass = loadedClass;
            this.origin = origin;
            this.lastModified = lastModified;
        }
    }

    private static class ResourceCacheEntry {
        long lastModified;
        byte[] loadedResource;
        Object origin;

        public ResourceCacheEntry(byte[] loadedResource, Object origin, long lastModified) {
            this.loadedResource = loadedResource;
            this.origin = origin;
            this.lastModified = lastModified;
        }
    }
}

