/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.http;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.ServletInputStream;
import org.apache.catalina.connector.HttpRequestBase;
import org.apache.catalina.connector.http.HttpHeader;
import org.apache.catalina.connector.http.HttpRequestStream;
import org.apache.catalina.connector.http.HttpResponseImpl;
import org.apache.catalina.util.Enumerator;

final class HttpRequestImpl
extends HttpRequestBase {
    protected static final int INITIAL_POOL_SIZE = 10;
    protected static final int POOL_SIZE_INCREMENT = 5;
    protected InetAddress inet = null;
    protected static final String info = "org.apache.catalina.connector.http.HttpRequestImpl/1.0";
    protected HttpHeader[] headerPool = new HttpHeader[10];
    protected int nextHeader = 0;
    protected HttpHeader connectionHeader = null;
    protected HttpHeader transferEncodingHeader = null;

    HttpRequestImpl() {
    }

    public void addHeader(String name, String value) {
        if (this.nextHeader == this.headerPool.length) {
            HttpHeader[] newHeaderPool = new HttpHeader[this.headerPool.length + 5];
            int i2 = 0;
            while (i2 < this.nextHeader) {
                newHeaderPool[i2] = this.headerPool[i2];
                ++i2;
            }
            this.headerPool = newHeaderPool;
        }
        this.headerPool[this.nextHeader++] = new HttpHeader(name, value);
    }

    HttpHeader allocateHeader() {
        if (this.nextHeader == this.headerPool.length) {
            HttpHeader[] newHeaderPool = new HttpHeader[this.headerPool.length + 5];
            int i2 = 0;
            while (i2 < this.nextHeader) {
                newHeaderPool[i2] = this.headerPool[i2];
                ++i2;
            }
            this.headerPool = newHeaderPool;
        }
        if (this.headerPool[this.nextHeader] == null) {
            this.headerPool[this.nextHeader] = new HttpHeader();
        }
        return this.headerPool[this.nextHeader];
    }

    public ServletInputStream createInputStream() throws IOException {
        return new HttpRequestStream(this, (HttpResponseImpl)this.response);
    }

    public void finishRequest() throws IOException {
        if (this.reader == null && this.stream == null && this.getContentLength() != 0 && this.getProtocol().equals("HTTP/1.1")) {
            this.getInputStream();
        }
        super.finishRequest();
    }

    public String getHeader(String name) {
        name = name.toLowerCase();
        int i2 = 0;
        while (i2 < this.nextHeader) {
            if (this.headerPool[i2].equals(name)) {
                return new String(this.headerPool[i2].value, 0, this.headerPool[i2].valueEnd);
            }
            ++i2;
        }
        return null;
    }

    public HttpHeader getHeader(HttpHeader header) {
        int i2 = 0;
        while (i2 < this.nextHeader) {
            if (this.headerPool[i2].equals(header)) {
                return this.headerPool[i2];
            }
            ++i2;
        }
        return null;
    }

    public HttpHeader getHeader(char[] headerName) {
        int i2 = 0;
        while (i2 < this.nextHeader) {
            if (this.headerPool[i2].equals(headerName)) {
                return this.headerPool[i2];
            }
            ++i2;
        }
        return null;
    }

    public Enumeration getHeaderNames() {
        ArrayList<String> tempArrayList = new ArrayList<String>();
        int i2 = 0;
        while (i2 < this.nextHeader) {
            tempArrayList.add(new String(this.headerPool[i2].name, 0, this.headerPool[i2].nameEnd));
            ++i2;
        }
        return new Enumerator(tempArrayList);
    }

    public Enumeration getHeaders(String name) {
        name = name.toLowerCase();
        ArrayList<String> tempArrayList = new ArrayList<String>();
        int i2 = 0;
        while (i2 < this.nextHeader) {
            if (this.headerPool[i2].equals(name)) {
                tempArrayList.add(new String(this.headerPool[i2].value, 0, this.headerPool[i2].valueEnd));
            }
            ++i2;
        }
        return new Enumerator(tempArrayList);
    }

    InetAddress getInet() {
        return this.inet;
    }

    public String getInfo() {
        return info;
    }

    public String getRemoteAddr() {
        return this.inet.getHostAddress();
    }

    public String getRemoteHost() {
        return this.inet.getHostName();
    }

    void nextHeader() {
        ++this.nextHeader;
    }

    public void recycle() {
        super.recycle();
        this.inet = null;
        this.nextHeader = 0;
        this.connectionHeader = null;
    }

    void setInet(InetAddress inet) {
        this.inet = inet;
    }
}

