/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.BadCommandException;
import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.iap.ResponseHandler;
import com.sun.mail.imap.ACL;
import com.sun.mail.imap.DefaultFolder;
import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.imap.IMAPStore;
import com.sun.mail.imap.MessageLiteral;
import com.sun.mail.imap.Quota;
import com.sun.mail.imap.Rights;
import com.sun.mail.imap.Utility;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.IMAPResponse;
import com.sun.mail.imap.protocol.ListInfo;
import com.sun.mail.imap.protocol.MailboxInfo;
import com.sun.mail.imap.protocol.Status;
import com.sun.mail.imap.protocol.UID;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.ReadOnlyFolderException;
import javax.mail.StoreClosedException;
import javax.mail.UIDFolder;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchException;
import javax.mail.search.SearchTerm;

public class IMAPFolder
extends Folder
implements UIDFolder,
ResponseHandler {
    protected String fullName;
    protected String name;
    protected int type;
    protected char separator;
    protected Flags availableFlags;
    protected Flags permanentFlags;
    protected boolean exists = false;
    protected IMAPProtocol protocol;
    protected Vector messageCache;
    protected Object messageCacheLock;
    protected Hashtable uidTable;
    protected static final char UNKNOWN_SEPARATOR = '\uffff';
    private boolean opened = false;
    private boolean reallyClosed = true;
    private int total = -1;
    private int recent = -1;
    private int realTotal = -1;
    private int uidvalidity = -1;
    private boolean doExpungeNotification = true;
    private Status cachedStatus = null;
    private long cachedStatusTime = 0L;
    private boolean debug = false;
    private boolean connectionPoolDebug;
    static /* synthetic */ Class class$javax$mail$Flags;

    protected IMAPFolder(String string, char c10, IMAPStore iMAPStore) {
        super(iMAPStore);
        this.fullName = string;
        this.separator = c10;
        this.messageCacheLock = new Object();
        this.debug = iMAPStore.getSession().getDebug();
        this.connectionPoolDebug = iMAPStore.getConnectionPoolDebug();
    }

    protected IMAPFolder(ListInfo listInfo, IMAPStore iMAPStore) {
        this(listInfo.name, listInfo.separator, iMAPStore);
        if (listInfo.hasInferiors) {
            this.type |= 2;
        }
        if (listInfo.canOpen) {
            this.type |= 1;
        }
        this.exists = true;
    }

    private void checkExists() throws MessagingException {
        if (!this.exists && !this.exists()) {
            throw new FolderNotFoundException(this, this.fullName + " not found");
        }
    }

    private void checkClosed() {
        if (this.opened) {
            throw new IllegalStateException("This operation is not allowed on an open folder");
        }
    }

    private void checkOpened() throws FolderClosedException {
        if (!this.opened) {
            if (this.reallyClosed) {
                throw new IllegalStateException("This operation is not allowed on a closed folder");
            }
            throw new FolderClosedException(this, "Lost folder connection to server");
        }
    }

    private void checkRange(int n2) throws MessagingException {
        if (n2 < 1) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 <= this.total) {
            return;
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.keepConnectionAlive(false);
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        if (n2 > this.total) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void checkFlags(Flags flags) throws MessagingException {
        if (this.mode != 2) {
            throw new IllegalStateException("Cannot change flags on READ_ONLY folder: " + this.fullName);
        }
        if (!this.availableFlags.contains(flags)) {
            throw new MessagingException("These flags are not supported by this implementation");
        }
    }

    public String getName() {
        if (this.name == null) {
            try {
                this.name = this.fullName.substring(this.fullName.lastIndexOf(this.getSeparator0()) + 1);
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public Folder getParent() throws MessagingException {
        char c10 = this.getSeparator0();
        int n2 = this.fullName.lastIndexOf(c10);
        if (n2 != -1) {
            return new IMAPFolder(this.fullName.substring(0, n2), c10, (IMAPStore)this.store);
        }
        return new DefaultFolder((IMAPStore)this.store);
    }

    public boolean exists() throws MessagingException {
        ListInfo[] listInfoArray = null;
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    listInfoArray = iMAPProtocol.list("", this.fullName);
                }
                Object var6_7 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
                Object var6_8 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        if (listInfoArray != null) {
            this.fullName = listInfoArray[0].name;
            this.separator = listInfoArray[0].separator;
            if (listInfoArray[0].hasInferiors) {
                this.type |= 2;
            }
            if (listInfoArray[0].canOpen) {
                this.type |= 1;
            }
            this.exists = true;
        } else {
            this.exists = false;
        }
        return this.exists;
    }

    public Folder[] list(String string) throws MessagingException {
        return this.doList(string, false);
    }

    public Folder[] listSubscribed(String string) throws MessagingException {
        return this.doList(string, true);
    }

    private Folder[] doList(String string, boolean bl2) throws MessagingException {
        this.checkExists();
        if (!this.isDirectory()) {
            return new Folder[0];
        }
        ListInfo[] listInfoArray = null;
        IMAPProtocol iMAPProtocol = null;
        char c10 = this.getSeparator0();
        try {
            Object var10_12;
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    listInfoArray = bl2 ? iMAPProtocol.lsub("", this.fullName + c10 + string) : iMAPProtocol.list("", this.fullName + c10 + string);
                }
                var10_12 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (CommandFailedException commandFailedException) {
                var10_12 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
                var10_12 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        if (listInfoArray == null) {
            return new Folder[0];
        }
        int n2 = 0;
        if (listInfoArray[0].name.equals(this.fullName + c10)) {
            n2 = 1;
        }
        Folder[] folderArray = new IMAPFolder[listInfoArray.length - n2];
        int n3 = n2;
        while (n3 < listInfoArray.length) {
            folderArray[n3 - n2] = new IMAPFolder(listInfoArray[n3], (IMAPStore)this.store);
            ++n3;
        }
        return folderArray;
    }

    public synchronized char getSeparator() throws MessagingException {
        this.checkExists();
        return this.getSeparator0();
    }

    private synchronized char getSeparator0() throws MessagingException {
        if (this.separator == '\uffff') {
            ListInfo[] listInfoArray = null;
            IMAPProtocol iMAPProtocol = null;
            try {
                try {
                    iMAPProtocol = this.getStoreProtocol();
                    Object object = this.lockFor(iMAPProtocol);
                    synchronized (object) {
                        listInfoArray = iMAPProtocol.isREV1() ? iMAPProtocol.list(this.fullName, "") : iMAPProtocol.list("", this.fullName);
                    }
                    Object var6_7 = null;
                    this.releaseStoreProtocol(iMAPProtocol);
                }
                catch (ConnectionException connectionException) {
                    this.throwClosedException(iMAPProtocol, connectionException);
                    Object var6_8 = null;
                    this.releaseStoreProtocol(iMAPProtocol);
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                this.releaseStoreProtocol(iMAPProtocol);
                throw throwable;
            }
            this.separator = listInfoArray != null ? listInfoArray[0].separator : (char)47;
        }
        return this.separator;
    }

    public int getType() throws MessagingException {
        this.checkExists();
        return this.type;
    }

    public boolean isSubscribed() {
        ListInfo[] listInfoArray = null;
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    listInfoArray = iMAPProtocol.lsub("", this.fullName);
                }
                Object var6_6 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ProtocolException protocolException) {
                Object var6_7 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        return listInfoArray != null;
    }

    public void setSubscribed(boolean bl2) throws MessagingException {
        this.checkExists();
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    if (bl2) {
                        iMAPProtocol.subscribe(this.fullName);
                    } else {
                        iMAPProtocol.unsubscribe(this.fullName);
                    }
                }
                Object var7_7 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (CommandFailedException commandFailedException) {
                Object var7_8 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
                Object var7_9 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
    }

    public synchronized boolean create(int n2) throws MessagingException {
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    if ((n2 & 1) == 0) {
                        iMAPProtocol.create(this.fullName + this.getSeparator0());
                    } else {
                        ListInfo[] listInfoArray;
                        iMAPProtocol.create(this.fullName);
                        if ((n2 & 2) != 0 && (listInfoArray = iMAPProtocol.list("", this.fullName)) != null && !listInfoArray[0].hasInferiors) {
                            iMAPProtocol.delete(this.fullName);
                            throw new MessagingException("Unsupported type");
                        }
                    }
                }
                Object var7_10 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (CommandFailedException commandFailedException) {
                boolean bl2 = false;
                Object var7_11 = null;
                this.releaseStoreProtocol(iMAPProtocol);
                return bl2;
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
                Object var7_12 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        this.exists = true;
        this.type = n2;
        this.notifyFolderListeners(1);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean hasNewMessages() throws MessagingException {
        boolean bl2;
        IMAPProtocol iMAPProtocol;
        block20: {
            boolean bl3;
            block19: {
                boolean bl4;
                block18: {
                    this.checkExists();
                    if (this.opened) {
                        Object object = this.messageCacheLock;
                        synchronized (object) {
                            try {
                                this.keepConnectionAlive(true);
                            }
                            catch (ConnectionException connectionException) {
                                throw new FolderClosedException(this, connectionException.getMessage());
                            }
                            catch (ProtocolException protocolException) {
                                throw new MessagingException(protocolException.getMessage(), protocolException);
                            }
                        }
                        if (this.recent <= 0) return false;
                        return true;
                    }
                    iMAPProtocol = null;
                    try {
                        try {
                            iMAPProtocol = this.getStoreProtocol();
                            Object object = this.lockFor(iMAPProtocol);
                            synchronized (object) {
                                ListInfo[] listInfoArray = iMAPProtocol.list("", this.fullName);
                                if (listInfoArray != null) {
                                    if (listInfoArray[0].changeState == 1) {
                                        boolean bl5 = true;
                                        // MONITOREXIT @DISABLED, blocks:[16, 2, 3, 6, 13] lbl25 : MonitorExitStatement: MONITOREXIT : var2_4
                                        Object var9_13 = null;
                                        this.releaseStoreProtocol(iMAPProtocol);
                                        return bl5;
                                    }
                                    if (listInfoArray[0].changeState == 2) {
                                        bl4 = false;
                                        // MONITOREXIT @DISABLED, blocks:[16, 2, 3, 6, 15] lbl32 : MonitorExitStatement: MONITOREXIT : var2_4
                                        break block18;
                                    }
                                }
                                Status status = this.getStatus();
                                if (status.recent > 0) {
                                    bl3 = true;
                                    // MONITOREXIT @DISABLED, blocks:[2, 3, 6, 14] lbl38 : MonitorExitStatement: MONITOREXIT : var2_4
                                    break block19;
                                }
                                bl2 = false;
                            }
                            break block20;
                        }
                        catch (BadCommandException badCommandException) {
                            boolean bl6 = false;
                            Object var9_17 = null;
                            this.releaseStoreProtocol(iMAPProtocol);
                            return bl6;
                        }
                        catch (ConnectionException connectionException) {
                            throw new StoreClosedException(this.store, connectionException.getMessage());
                        }
                        catch (ProtocolException protocolException) {
                            throw new MessagingException(protocolException.getMessage(), protocolException);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_18 = null;
                        this.releaseStoreProtocol(iMAPProtocol);
                        throw throwable;
                    }
                }
                Object var9_14 = null;
                this.releaseStoreProtocol(iMAPProtocol);
                return bl4;
            }
            Object var9_15 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            return bl3;
        }
        Object var9_16 = null;
        this.releaseStoreProtocol(iMAPProtocol);
        return bl2;
    }

    public Folder getFolder(String string) throws MessagingException {
        if (this.exists && !this.isDirectory()) {
            throw new MessagingException("Cannot contain subfolders");
        }
        char c10 = this.getSeparator0();
        return new IMAPFolder(this.fullName + c10 + string, c10, (IMAPStore)this.store);
    }

    public synchronized boolean delete(boolean bl2) throws MessagingException {
        Object object;
        this.checkClosed();
        if (bl2) {
            object = this.list();
            int n2 = 0;
            while (n2 < ((Folder[])object).length) {
                object[n2].delete(bl2);
                ++n2;
            }
        }
        object = null;
        try {
            try {
                object = this.getStoreProtocol();
                Object object2 = this.lockFor((IMAPProtocol)object);
                synchronized (object2) {
                    ((IMAPProtocol)object).delete(this.fullName);
                }
                Object var7_9 = null;
                this.releaseStoreProtocol((IMAPProtocol)object);
            }
            catch (CommandFailedException commandFailedException) {
                boolean bl3 = false;
                Object var7_10 = null;
                this.releaseStoreProtocol((IMAPProtocol)object);
                return bl3;
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            this.releaseStoreProtocol((IMAPProtocol)object);
            throw throwable;
        }
        this.exists = false;
        this.notifyFolderListeners(2);
        return true;
    }

    public synchronized boolean renameTo(Folder folder) throws MessagingException {
        this.checkClosed();
        this.checkExists();
        if (folder.getStore() != this.store) {
            throw new MessagingException("Can't rename across Stores");
        }
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    iMAPProtocol.rename(this.fullName, folder.getFullName());
                }
                Object var7_8 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (CommandFailedException commandFailedException) {
                boolean bl2 = false;
                Object var7_9 = null;
                this.releaseStoreProtocol(iMAPProtocol);
                return bl2;
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        this.exists = false;
        this.notifyFolderRenamedListeners(folder);
        return true;
    }

    public synchronized void open(int n2) throws MessagingException {
        this.checkClosed();
        this.checkExists();
        if ((this.type & 1) == 0) {
            throw new MessagingException("folder cannot contain messages");
        }
        MailboxInfo mailboxInfo = null;
        this.protocol = ((IMAPStore)this.store).getProtocol(this);
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                mailboxInfo = n2 == 1 ? this.protocol.examine(this.fullName) : this.protocol.select(this.fullName);
            }
            catch (ProtocolException protocolException) {
                try {
                    this.protocol.logout();
                }
                catch (ProtocolException protocolException2) {
                    // empty catch block
                }
                this.protocol = null;
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
            if (mailboxInfo.mode != n2) {
                try {
                    this.protocol.logout();
                }
                catch (ProtocolException protocolException) {
                    // empty catch block
                }
                this.protocol = null;
                throw new ReadOnlyFolderException(this, "Cannot open in desired mode");
            }
            this.opened = true;
            this.reallyClosed = false;
            this.mode = mailboxInfo.mode;
            this.availableFlags = mailboxInfo.availableFlags;
            this.permanentFlags = mailboxInfo.permanentFlags;
            this.total = this.realTotal = mailboxInfo.total;
            this.recent = mailboxInfo.recent;
            this.uidvalidity = mailboxInfo.uidvalidity;
            this.protocol.addResponseHandler(this);
            this.messageCache = new Vector(this.total);
            int n3 = 0;
            while (n3 < this.total) {
                this.messageCache.addElement(new IMAPMessage(this, n3 + 1, n3 + 1));
                ++n3;
            }
        }
        this.notifyConnectionListeners(1);
    }

    public synchronized void fetch(Message[] messageArray, FetchProfile fetchProfile) throws MessagingException {
        this.checkOpened();
        IMAPMessage.fetch(this, messageArray, fetchProfile);
    }

    public synchronized void setFlags(Message[] messageArray, Flags flags, boolean bl2) throws MessagingException {
        this.checkOpened();
        this.checkFlags(flags);
        if (messageArray.length == 0) {
            return;
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.protocol.storeFlags(Utility.toMessageSet(messageArray, null), flags, bl2);
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
    }

    public synchronized void close(boolean bl2) throws MessagingException {
        Object object = this.messageCacheLock;
        synchronized (object) {
            if (!this.opened && this.reallyClosed) {
                throw new IllegalStateException("This operation is not allowed on a closed folder");
            }
            this.reallyClosed = true;
            if (!this.opened) {
                return;
            }
            try {
                block15: {
                    try {
                        if (((IMAPStore)this.store).isConnectionPoolFull()) {
                            if (this.debug) {
                                System.out.println("DEBUG: pool is full, not adding an Authenticated connection");
                            }
                            if (bl2) {
                                this.protocol.close();
                            }
                            this.protocol.logout();
                            break block15;
                        }
                        if (!bl2) {
                            try {
                                MailboxInfo mailboxInfo = this.protocol.examine(this.fullName);
                            }
                            catch (ProtocolException protocolException) {
                                this.protocol.disconnect();
                            }
                        }
                        this.protocol.close();
                    }
                    catch (ProtocolException protocolException) {
                        throw new MessagingException(protocolException.getMessage(), protocolException);
                    }
                }
                Object var5_6 = null;
                this.cleanup(true);
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.cleanup(true);
                throw throwable;
            }
        }
    }

    private void cleanup(boolean bl2) {
        this.releaseProtocol(bl2);
        this.protocol = null;
        this.messageCache = null;
        this.uidTable = null;
        this.exists = false;
        this.opened = false;
        this.notifyConnectionListeners(3);
    }

    public synchronized boolean isOpen() {
        Object object = this.messageCacheLock;
        synchronized (object) {
            if (this.opened) {
                try {
                    this.keepConnectionAlive(false);
                }
                catch (ProtocolException protocolException) {
                    // empty catch block
                }
            }
        }
        return this.opened;
    }

    public Flags getPermanentFlags() {
        return this.permanentFlags;
    }

    public synchronized int getMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            try {
                Status status = this.getStatus();
                return status.total;
            }
            catch (BadCommandException badCommandException) {
                IMAPProtocol iMAPProtocol = null;
                try {
                    try {
                        iMAPProtocol = this.getStoreProtocol();
                        Object object = this.lockFor(iMAPProtocol);
                        synchronized (object) {
                            MailboxInfo mailboxInfo = iMAPProtocol.examine(this.fullName);
                            iMAPProtocol.close();
                            int n2 = mailboxInfo.total;
                            // MONITOREXIT @DISABLED, blocks:[17, 1, 2, 3, 7, 8] lbl17 : MonitorExitStatement: MONITOREXIT : var3_8
                            Object var8_14 = null;
                            this.releaseStoreProtocol(iMAPProtocol);
                            return n2;
                        }
                    }
                    catch (ProtocolException protocolException) {
                        throw new MessagingException(protocolException.getMessage(), protocolException);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_15 = null;
                    this.releaseStoreProtocol(iMAPProtocol);
                    throw throwable;
                }
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.keepConnectionAlive(true);
                int n3 = this.total;
                return n3;
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
    }

    public synchronized int getNewMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            try {
                Status status = this.getStatus();
                return status.recent;
            }
            catch (BadCommandException badCommandException) {
                IMAPProtocol iMAPProtocol = null;
                try {
                    try {
                        iMAPProtocol = this.getStoreProtocol();
                        Object object = this.lockFor(iMAPProtocol);
                        synchronized (object) {
                            MailboxInfo mailboxInfo = iMAPProtocol.examine(this.fullName);
                            iMAPProtocol.close();
                            int n2 = mailboxInfo.recent;
                            // MONITOREXIT @DISABLED, blocks:[17, 1, 2, 3, 7, 8] lbl17 : MonitorExitStatement: MONITOREXIT : var3_8
                            Object var8_14 = null;
                            this.releaseStoreProtocol(iMAPProtocol);
                            return n2;
                        }
                    }
                    catch (ProtocolException protocolException) {
                        throw new MessagingException(protocolException.getMessage(), protocolException);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_15 = null;
                    this.releaseStoreProtocol(iMAPProtocol);
                    throw throwable;
                }
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.keepConnectionAlive(true);
                int n3 = this.recent;
                return n3;
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
    }

    public synchronized int getUnreadMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            try {
                Status status = this.getStatus();
                return status.unseen;
            }
            catch (BadCommandException badCommandException) {
                return -1;
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        Flags flags = new Flags();
        flags.add(Flags.Flag.SEEN);
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] nArray = this.protocol.search(new FlagTerm(flags, false));
                int n2 = nArray.length;
                return n2;
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    private Status getStatus() throws ProtocolException {
        int n2 = ((IMAPStore)this.store).getStatusCacheTimeout();
        if (n2 > 0 && this.cachedStatus != null && System.currentTimeMillis() - this.cachedStatusTime < (long)n2) {
            return this.cachedStatus;
        }
        IMAPProtocol iMAPProtocol = null;
        try {
            iMAPProtocol = this.getStoreProtocol();
            Object object = this.lockFor(iMAPProtocol);
            synchronized (object) {
                Status status = iMAPProtocol.status(this.fullName, null);
                if (n2 > 0) {
                    this.cachedStatus = status;
                    this.cachedStatusTime = System.currentTimeMillis();
                }
                Status status2 = status;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl15 : MonitorExitStatement: MONITOREXIT : var3_3
                Object var8_6 = null;
                this.releaseStoreProtocol(iMAPProtocol);
                return status2;
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
    }

    public synchronized Message getMessage(int n2) throws MessagingException {
        this.checkOpened();
        this.checkRange(n2);
        return (Message)this.messageCache.elementAt(n2 - 1);
    }

    public void appendMessages(Message[] messageArray) throws MessagingException {
        block17: {
            this.checkExists();
            int n2 = ((IMAPStore)this.store).getAppendBufferSize();
            IMAPProtocol iMAPProtocol = null;
            try {
                try {
                    iMAPProtocol = this.getStoreProtocol();
                    int n3 = 0;
                    while (n3 < messageArray.length) {
                        block16: {
                            MessageLiteral messageLiteral;
                            Message message = messageArray[n3];
                            try {
                                messageLiteral = new MessageLiteral(message, message.getSize() > n2 ? 0 : n2);
                            }
                            catch (IOException iOException) {
                                throw new MessagingException("IOException while appending messages", iOException);
                            }
                            catch (MessageRemovedException messageRemovedException) {
                                break block16;
                            }
                            Object object = this.messageCacheLock;
                            synchronized (object) {
                                Object object2 = this.lockFor(iMAPProtocol);
                                synchronized (object2) {
                                    Date date = message.getReceivedDate();
                                    if (date == null) {
                                        date = message.getSentDate();
                                    }
                                    iMAPProtocol.append(this.fullName, message.getFlags(), date, messageLiteral);
                                }
                            }
                        }
                        ++n3;
                    }
                }
                catch (ConnectionException connectionException) {
                    this.throwClosedException(iMAPProtocol, connectionException);
                    Object var13_17 = null;
                    this.releaseStoreProtocol(iMAPProtocol);
                    break block17;
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
                Object var13_16 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                this.releaseStoreProtocol(iMAPProtocol);
                throw throwable;
            }
        }
    }

    public synchronized void copyMessages(Message[] messageArray, Folder folder) throws MessagingException {
        this.checkOpened();
        if (messageArray.length == 0) {
            return;
        }
        if (folder.getStore() == this.store) {
            Object object = this.messageCacheLock;
            synchronized (object) {
                try {
                    this.protocol.copy(Utility.toMessageSet(messageArray, null), folder.getFullName());
                }
                catch (CommandFailedException commandFailedException) {
                    if (commandFailedException.getMessage().indexOf("TRYCREATE") != -1) {
                        throw new FolderNotFoundException(folder, folder.getFullName() + " does not exist");
                    }
                    throw new MessagingException(commandFailedException.getMessage(), commandFailedException);
                }
                catch (ConnectionException connectionException) {
                    throw new FolderClosedException(this, connectionException.getMessage());
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
            }
        }
        super.copyMessages(messageArray, folder);
    }

    public synchronized Message[] expunge() throws MessagingException {
        this.checkOpened();
        Vector<IMAPMessage> vector = new Vector<IMAPMessage>();
        Object object = this.messageCacheLock;
        synchronized (object) {
            this.doExpungeNotification = false;
            try {
                try {
                    this.protocol.expunge();
                }
                catch (CommandFailedException commandFailedException) {
                    if (this.mode != 2) {
                        throw new IllegalStateException("Cannot expunge READ_ONLY folder: " + this.fullName);
                    }
                    throw new MessagingException(commandFailedException.getMessage(), commandFailedException);
                }
                catch (ConnectionException connectionException) {
                    throw new FolderClosedException(this, connectionException.getMessage());
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
                Object var7_3 = null;
                this.doExpungeNotification = true;
            }
            catch (Throwable throwable) {
                Object var7_4 = null;
                this.doExpungeNotification = true;
                throw throwable;
            }
            int n2 = 0;
            while (n2 < this.messageCache.size()) {
                IMAPMessage iMAPMessage = (IMAPMessage)this.messageCache.elementAt(n2);
                if (iMAPMessage.isExpunged()) {
                    long l2;
                    vector.addElement(iMAPMessage);
                    this.messageCache.removeElementAt(n2);
                    if (this.uidTable == null || (l2 = iMAPMessage.getUID()) == -1L) continue;
                    this.uidTable.remove(new Long(l2));
                    continue;
                }
                iMAPMessage.setMessageNumber(iMAPMessage.getSequenceNumber());
                ++n2;
            }
        }
        this.total = this.messageCache.size();
        Object[] objectArray = new Message[vector.size()];
        vector.copyInto(objectArray);
        if (objectArray.length > 0) {
            this.notifyMessageRemovedListeners(true, (Message[])objectArray);
        }
        return objectArray;
    }

    public synchronized Message[] search(SearchTerm searchTerm) throws MessagingException {
        this.checkOpened();
        try {
            Message[] messageArray = null;
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] nArray = this.protocol.search(searchTerm);
                if (nArray != null) {
                    messageArray = new IMAPMessage[nArray.length];
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        messageArray[n2] = this.getMessageBySeqNumber(nArray[n2]);
                        ++n2;
                    }
                }
            }
            return messageArray;
        }
        catch (CommandFailedException commandFailedException) {
            return super.search(searchTerm);
        }
        catch (SearchException searchException) {
            return super.search(searchTerm);
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    public synchronized Message[] search(SearchTerm searchTerm, Message[] messageArray) throws MessagingException {
        this.checkOpened();
        if (messageArray.length == 0) {
            return messageArray;
        }
        try {
            Message[] messageArray2 = null;
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] nArray = this.protocol.search(Utility.toMessageSet(messageArray, null), searchTerm);
                if (nArray != null) {
                    messageArray2 = new IMAPMessage[nArray.length];
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        messageArray2[n2] = this.getMessageBySeqNumber(nArray[n2]);
                        ++n2;
                    }
                }
            }
            return messageArray2;
        }
        catch (CommandFailedException commandFailedException) {
            return super.search(searchTerm, messageArray);
        }
        catch (SearchException searchException) {
            return super.search(searchTerm, messageArray);
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    public long getUIDValidity() throws MessagingException {
        if (this.opened) {
            return this.uidvalidity;
        }
        IMAPProtocol iMAPProtocol = null;
        Status status = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    String[] stringArray = new String[]{"UIDVALIDITY"};
                    status = iMAPProtocol.status(this.fullName, stringArray);
                }
                Object var7_9 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("Cannot obtain UIDValidity", badCommandException);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
                Object var7_10 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        return status.uidvalidity;
    }

    public synchronized Message getMessageByUID(long l2) throws MessagingException {
        this.checkOpened();
        Long l3 = new Long(l2);
        IMAPMessage iMAPMessage = null;
        if (this.uidTable != null) {
            iMAPMessage = (IMAPMessage)this.uidTable.get(l3);
            if (iMAPMessage != null) {
                return iMAPMessage;
            }
        } else {
            this.uidTable = new Hashtable();
        }
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                UID uID = this.protocol.fetchSequenceNumber(l2);
                if (uID != null) {
                    iMAPMessage = (IMAPMessage)this.messageCache.elementAt(uID.msgno - 1);
                    iMAPMessage.setUID(uID.uid);
                    this.uidTable.put(l3, iMAPMessage);
                }
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
        return iMAPMessage;
    }

    public synchronized Message[] getMessagesByUID(long l2, long l3) throws MessagingException {
        Message[] messageArray;
        this.checkOpened();
        if (this.uidTable == null) {
            this.uidTable = new Hashtable();
        }
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                UID[] uIDArray = this.protocol.fetchSequenceNumbers(l2, l3);
                messageArray = new Message[uIDArray.length];
                int n2 = 0;
                while (n2 < uIDArray.length) {
                    IMAPMessage iMAPMessage = (IMAPMessage)this.messageCache.elementAt(uIDArray[n2].msgno - 1);
                    iMAPMessage.setUID(uIDArray[n2].uid);
                    messageArray[n2] = iMAPMessage;
                    this.uidTable.put(new Long(uIDArray[n2].uid), iMAPMessage);
                    ++n2;
                }
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
        return messageArray;
    }

    public synchronized Message[] getMessagesByUID(long[] lArray) throws MessagingException {
        int n2;
        Object object;
        Message[] messageArray;
        this.checkOpened();
        long[] lArray2 = lArray;
        if (this.uidTable != null) {
            messageArray = new Vector();
            int n3 = 0;
            while (n3 < lArray.length) {
                object = new Long(lArray[n3]);
                if (!this.uidTable.containsKey(object)) {
                    messageArray.addElement(object);
                }
                ++n3;
            }
            n2 = messageArray.size();
            lArray2 = new long[n2];
            int n4 = 0;
            while (n4 < n2) {
                lArray2[n4] = (Long)messageArray.elementAt(n4);
                ++n4;
            }
        } else {
            this.uidTable = new Hashtable();
        }
        if (lArray2.length > 0) {
            try {
                messageArray = this.messageCacheLock;
                synchronized (messageArray) {
                    object = this.protocol.fetchSequenceNumbers(lArray2);
                    n2 = 0;
                    while (n2 < ((UID[])object).length) {
                        IMAPMessage iMAPMessage = (IMAPMessage)this.messageCache.elementAt(object[n2].msgno - 1);
                        iMAPMessage.setUID(object[n2].uid);
                        this.uidTable.put(new Long(object[n2].uid), iMAPMessage);
                        ++n2;
                    }
                }
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        messageArray = new Message[lArray.length];
        int n5 = 0;
        while (n5 < lArray.length) {
            messageArray[n5] = (Message)this.uidTable.get(new Long(lArray[n5]));
            ++n5;
        }
        return messageArray;
    }

    public synchronized long getUID(Message message) throws MessagingException {
        if (message.getFolder() != this) {
            throw new NoSuchElementException("Message does not belong to this folder");
        }
        this.checkOpened();
        IMAPMessage iMAPMessage = (IMAPMessage)message;
        long l2 = iMAPMessage.getUID();
        if (l2 != -1L) {
            return l2;
        }
        UID uID = null;
        Object object = this.messageCacheLock;
        synchronized (object) {
            iMAPMessage.checkExpunged();
            try {
                uID = this.protocol.fetchUID(iMAPMessage.getSequenceNumber());
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        if (uID != null) {
            l2 = uID.uid;
            iMAPMessage.setUID(l2);
            if (this.uidTable == null) {
                this.uidTable = new Hashtable();
            }
            this.uidTable.put(new Long(l2), iMAPMessage);
        }
        return l2;
    }

    public Quota[] getQuota() throws MessagingException {
        Quota[] quotaArray = null;
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    quotaArray = iMAPProtocol.getQuotaRoot(this.fullName);
                }
                Object var7_7 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("QUOTA not supported", badCommandException);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
                Object var7_8 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        return quotaArray;
    }

    public void setQuota(Quota quota) throws MessagingException {
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    iMAPProtocol.setQuota(quota);
                }
                Object var7_7 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("QUOTA not supported", badCommandException);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
                Object var7_8 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
    }

    public ACL[] getACL() throws MessagingException {
        ACL[] aCLArray = null;
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    aCLArray = iMAPProtocol.getACL(this.fullName);
                }
                Object var7_7 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("ACL not supported", badCommandException);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
                Object var7_8 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        return aCLArray;
    }

    public void addACL(ACL aCL) throws MessagingException {
        this.setACL(aCL, '\u0000');
    }

    public void removeACL(String string) throws MessagingException {
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    iMAPProtocol.deleteACL(this.fullName, string);
                }
                Object var7_7 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("ACL not supported", badCommandException);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
                Object var7_8 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
    }

    public void addRights(ACL aCL) throws MessagingException {
        this.setACL(aCL, '+');
    }

    public void removeRights(ACL aCL) throws MessagingException {
        this.setACL(aCL, '-');
    }

    public Rights[] listRights(String string) throws MessagingException {
        Rights[] rightsArray = null;
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    rightsArray = iMAPProtocol.listRights(this.fullName, string);
                }
                Object var8_8 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("ACL not supported", badCommandException);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
                Object var8_9 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        return rightsArray;
    }

    public Rights myRights() throws MessagingException {
        Rights rights = null;
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    rights = iMAPProtocol.myRights(this.fullName);
                }
                Object var7_7 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("ACL not supported", badCommandException);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
                Object var7_8 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        return rights;
    }

    private void setACL(ACL aCL, char c10) throws MessagingException {
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    iMAPProtocol.setACL(this.fullName, c10, aCL);
                }
                Object var8_8 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("ACL not supported", badCommandException);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
                Object var8_9 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
    }

    public void handleResponse(Response response) {
        if (response.isBYE()) {
            if (this.opened) {
                this.cleanup(false);
            }
            return;
        }
        if (response.isOK()) {
            ((IMAPStore)this.store).handleResponse(response);
            return;
        }
        if (!(response instanceof IMAPResponse)) {
            System.out.println("UNEXPECTED RESPONSE : " + response.toString());
            System.out.println("CONTACT javamail@sun.com");
            return;
        }
        IMAPResponse iMAPResponse = (IMAPResponse)response;
        if (iMAPResponse.keyEquals("EXISTS")) {
            int n2 = iMAPResponse.getNumber();
            if (n2 <= this.realTotal) {
                return;
            }
            int n3 = n2 - this.realTotal;
            Message[] messageArray = new Message[n3];
            int n4 = 0;
            while (n4 < n3) {
                IMAPMessage iMAPMessage = new IMAPMessage(this, ++this.total, ++this.realTotal);
                messageArray[n4] = iMAPMessage;
                this.messageCache.addElement(iMAPMessage);
                ++n4;
            }
            this.notifyMessageAddedListeners(messageArray);
        } else if (iMAPResponse.keyEquals("EXPUNGE")) {
            Message[] messageArray;
            IMAPMessage iMAPMessage = this.getMessageBySeqNumber(iMAPResponse.getNumber());
            iMAPMessage.setExpunged(true);
            int n5 = iMAPMessage.getMessageNumber();
            while (n5 < this.total) {
                messageArray = (Message[])this.messageCache.elementAt(n5);
                if (!messageArray.isExpunged()) {
                    messageArray.setSequenceNumber(messageArray.getSequenceNumber() - 1);
                }
                ++n5;
            }
            --this.realTotal;
            if (this.doExpungeNotification) {
                messageArray = new Message[]{iMAPMessage};
                this.notifyMessageRemovedListeners(false, messageArray);
            }
        } else if (iMAPResponse.keyEquals("FETCH")) {
            FetchResponse fetchResponse = (FetchResponse)iMAPResponse;
            Flags flags = (Flags)((Object)fetchResponse.getItem(class$javax$mail$Flags == null ? (class$javax$mail$Flags = IMAPFolder.class$("javax.mail.Flags")) : class$javax$mail$Flags));
            if (flags != null) {
                IMAPMessage iMAPMessage = this.getMessageBySeqNumber(fetchResponse.getNumber());
                iMAPMessage._setFlags(flags);
                this.notifyMessageChangedListeners(1, iMAPMessage);
            }
        } else if (iMAPResponse.keyEquals("RECENT")) {
            this.recent = iMAPResponse.getNumber();
        }
    }

    void handleResponses(Response[] responseArray) {
        int n2 = 0;
        while (n2 < responseArray.length) {
            if (responseArray[n2] != null) {
                this.handleResponse(responseArray[n2]);
            }
            ++n2;
        }
    }

    protected synchronized IMAPProtocol getStoreProtocol() throws ProtocolException {
        if (this.opened && !((IMAPStore)this.store).hasSeparateStoreConnection()) {
            if (this.connectionPoolDebug) {
                System.out.println("DEBUG: getStoreProtocol() - using our own connection");
            }
            return this.protocol;
        }
        if (this.connectionPoolDebug) {
            System.out.println("DEBUG: getStoreProtocol() - borrowing a connection");
        }
        return ((IMAPStore)this.store).getStoreProtocol();
    }

    private synchronized void throwClosedException(IMAPProtocol iMAPProtocol, Exception exception) throws FolderClosedException, StoreClosedException {
        if (iMAPProtocol == this.protocol) {
            throw new FolderClosedException(this, exception.getMessage());
        }
        throw new StoreClosedException(this.store, exception.getMessage());
    }

    public IMAPProtocol getProtocol() {
        return this.protocol;
    }

    public Object doCommand(ProtocolCommand protocolCommand) throws MessagingException {
        if (!this.opened) {
            IMAPProtocol iMAPProtocol = null;
            try {
                try {
                    iMAPProtocol = this.getStoreProtocol();
                    Object object = this.lockFor(iMAPProtocol);
                    synchronized (object) {
                        Object object2 = protocolCommand.doCommand(iMAPProtocol);
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 6, 14] lbl10 : MonitorExitStatement: MONITOREXIT : var3_4
                        Object var7_11 = null;
                        this.releaseStoreProtocol(iMAPProtocol);
                        return object2;
                    }
                }
                catch (ConnectionException connectionException) {
                    throw new StoreClosedException(this.store, connectionException.getMessage());
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                this.releaseStoreProtocol(iMAPProtocol);
                throw throwable;
            }
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                Object object3 = protocolCommand.doCommand(this.getProtocol());
                return object3;
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
    }

    protected synchronized Object lockFor(IMAPProtocol iMAPProtocol) {
        if (iMAPProtocol == this.protocol) {
            return this.messageCacheLock;
        }
        return new Object();
    }

    protected synchronized void releaseStoreProtocol(IMAPProtocol iMAPProtocol) {
        if (iMAPProtocol != this.protocol) {
            ((IMAPStore)this.store).releaseStoreProtocol(iMAPProtocol);
        }
    }

    private synchronized void releaseProtocol(boolean bl2) {
        if (this.protocol != null) {
            this.protocol.removeResponseHandler(this);
            if (bl2) {
                ((IMAPStore)this.store).releaseProtocol(this, this.protocol);
            } else {
                ((IMAPStore)this.store).releaseProtocol(this, null);
            }
        }
    }

    private void keepConnectionAlive(boolean bl2) throws ProtocolException {
        if (System.currentTimeMillis() - this.protocol.getTimestamp() > 1000L) {
            this.protocol.noop();
        }
        if (bl2 && ((IMAPStore)this.store).hasSeparateStoreConnection()) {
            IMAPProtocol iMAPProtocol = null;
            try {
                iMAPProtocol = ((IMAPStore)this.store).getStoreProtocol();
                if (System.currentTimeMillis() - iMAPProtocol.getTimestamp() > 1000L) {
                    iMAPProtocol.noop();
                }
                Object var4_3 = null;
                ((IMAPStore)this.store).releaseStoreProtocol(iMAPProtocol);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ((IMAPStore)this.store).releaseStoreProtocol(iMAPProtocol);
                throw throwable;
            }
        }
    }

    IMAPMessage getMessageBySeqNumber(int n2) {
        int n3 = n2 - 1;
        while (n3 < this.total) {
            IMAPMessage iMAPMessage = (IMAPMessage)this.messageCache.elementAt(n3);
            if (iMAPMessage.getSequenceNumber() == n2) {
                return iMAPMessage;
            }
            ++n3;
        }
        return null;
    }

    private boolean isDirectory() {
        return (this.type & 2) != 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface ProtocolCommand {
        public Object doCommand(IMAPProtocol var1) throws ProtocolException;
    }
}

