/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.iap;

import com.sun.mail.iap.ByteArray;
import com.sun.mail.util.ASCIIUtility;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ResponseInputStream
extends BufferedInputStream {
    private static final int increment = 256;
    private byte[] buffer = null;
    private int sz = 0;
    private int idx = 0;

    public ResponseInputStream(InputStream inputStream) {
        super(inputStream, 2048);
    }

    public ByteArray readResponse() throws IOException {
        this.buffer = new byte[128];
        this.idx = 0;
        this.sz = 128;
        this.read0();
        return new ByteArray(this.buffer, 0, this.idx);
    }

    private void read0() throws IOException {
        int n2 = 0;
        boolean bl2 = false;
        while (!bl2 && (n2 = this.pos >= this.count ? this.read() : this.buf[this.pos++] & 0xFF) != -1) {
            switch (n2) {
                case 10: {
                    if (this.idx <= 0 || this.buffer[this.idx - 1] != 13) break;
                    bl2 = true;
                }
            }
            if (this.idx >= this.sz) {
                this.growBuffer(256);
            }
            this.buffer[this.idx++] = (byte)n2;
        }
        if (n2 == -1) {
            throw new IOException();
        }
        if (this.idx >= 5 && this.buffer[this.idx - 3] == 125) {
            int n3 = this.idx - 4;
            while (n3 >= 0) {
                if (this.buffer[n3] == 123) break;
                --n3;
            }
            if (n3 < 0) {
                return;
            }
            int n4 = 0;
            try {
                n4 = ASCIIUtility.parseInt(this.buffer, n3 + 1, this.idx - 3);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            if (n4 > 0) {
                int n5 = this.sz - this.idx;
                if (n4 > n5) {
                    this.growBuffer(256 > n4 - n5 ? 256 : n4 - n5);
                }
                while (n4 > 0) {
                    int n6 = this.read(this.buffer, this.idx, n4);
                    n4 -= n6;
                    this.idx += n6;
                }
            }
            this.read0();
        }
    }

    private void growBuffer(int n2) {
        byte[] byArray = new byte[this.sz + n2];
        if (this.buffer != null) {
            System.arraycopy(this.buffer, 0, byArray, 0, this.idx);
        }
        this.buffer = byArray;
        this.sz += n2;
    }
}

