/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.jtsxa;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.ErrorLog;
import com.sun.jts.jta.TransactionState;
import com.sun.jts.jtsxa.OTSResource;
import com.sun.jts.jtsxa.OTSResourceHelper;
import com.sun.jts.jtsxa.OTSResourcePOA;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.Request;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.Vote;
import org.omg.CosTransactions.otid_t;
import org.omg.PortableServer.POA;

public class OTSResourceImpl
extends OTSResourcePOA
implements OTSResource {
    private static POA poa = null;
    private OTSResource thisRef = null;
    private XAResource xaRes = null;
    private Xid xid = null;
    private TransactionState tranState = null;
    private NO_IMPLEMENT no_implement = new NO_IMPLEMENT("This is a locally constrained object.");

    public OTSResourceImpl(Xid xid, XAResource xaRes, TransactionState tranState) {
        this.xaRes = xaRes;
        this.xid = xid;
        this.tranState = tranState;
    }

    public void commit() throws NotPrepared, HeuristicRollback, HeuristicHazard, HeuristicMixed, SystemException {
        try {
            this.xaRes.commit(this.xid, false);
        }
        catch (Exception ex2) {
            this.destroy();
            if (!(ex2 instanceof XAException)) {
                throw new INTERNAL(0, CompletionStatus.COMPLETED_MAYBE);
            }
            XAException e10 = (XAException)ex2;
            if (e10.errorCode == 6) {
                throw new HeuristicRollback();
            }
            if (e10.errorCode == 8) {
                throw new HeuristicHazard();
            }
            if (e10.errorCode == 5) {
                throw new HeuristicMixed();
            }
            if (e10.errorCode == 105) {
                throw new NotPrepared();
            }
            throw new INTERNAL(0, CompletionStatus.COMPLETED_MAYBE);
        }
        this.destroy();
    }

    public void commit_one_phase() throws HeuristicHazard, SystemException {
        try {
            this.xaRes.commit(this.xid, true);
        }
        catch (Exception ex2) {
            this.destroy();
            if (!(ex2 instanceof XAException)) {
                throw new INTERNAL(0, CompletionStatus.COMPLETED_MAYBE);
            }
            XAException e10 = (XAException)ex2;
            if (e10.errorCode == 6) {
                throw new HeuristicHazard();
            }
            if (e10.errorCode == 8) {
                throw new HeuristicHazard();
            }
            if (e10.errorCode == 5) {
                throw new HeuristicHazard();
            }
            if (e10.errorCode >= 100 && e10.errorCode <= 107) {
                return;
            }
            throw new INTERNAL(0, CompletionStatus.COMPLETED_MAYBE);
        }
        this.destroy();
    }

    public void forget() {
        try {
            this.xaRes.forget(this.xid);
        }
        catch (XAException xAException) {
            // empty catch block
        }
        this.destroy();
    }

    public Vote prepare() throws HeuristicHazard, HeuristicMixed {
        int rc = -6;
        try {
            rc = this.xaRes.prepare(this.xid);
        }
        catch (XAException xAException) {
            // empty catch block
        }
        if (rc == 0) {
            return Vote.VoteCommit;
        }
        if (rc == 3) {
            this.destroy();
            return Vote.VoteReadOnly;
        }
        this.destroy();
        return Vote.VoteRollback;
    }

    public void rollback() throws HeuristicCommit, HeuristicMixed, HeuristicHazard, SystemException {
        try {
            if (this.tranState == null) {
                this.xaRes.rollback(this.xid);
            } else {
                this.tranState.rollback(this.xaRes);
            }
        }
        catch (Exception ex2) {
            this.destroy();
            if (!(ex2 instanceof XAException)) {
                throw new INTERNAL(0, CompletionStatus.COMPLETED_MAYBE);
            }
            XAException e10 = (XAException)ex2;
            if (e10.errorCode == 7) {
                throw new HeuristicCommit();
            }
            if (e10.errorCode == 8) {
                throw new HeuristicHazard();
            }
            if (e10.errorCode == 5) {
                throw new HeuristicMixed();
            }
            throw new INTERNAL(0, CompletionStatus.COMPLETED_MAYBE);
        }
        this.destroy();
    }

    public otid_t getGlobalTID() {
        byte[] gtrid = this.xid.getGlobalTransactionId();
        byte[] otidData = new byte[gtrid.length];
        System.arraycopy(gtrid, 0, otidData, 0, gtrid.length);
        otid_t otid = new otid_t(this.xid.getFormatId(), 0, otidData);
        return otid;
    }

    public OTSResource getCORBAObjReference() {
        if (this.thisRef == null) {
            if (poa == null) {
                poa = Configuration.getPOA("transient");
            }
            try {
                poa.activate_object(this);
                this.thisRef = OTSResourceHelper.narrow(poa.servant_to_reference(this));
            }
            catch (Exception exc) {
                ErrorLog.error(7, new java.lang.Object[]{"XAResource"}, true);
            }
        }
        return this.thisRef;
    }

    private void destroy() {
        if (poa != null && this.thisRef != null) {
            try {
                poa.deactivate_object(poa.reference_to_id(this.thisRef));
                this.thisRef = null;
            }
            catch (Exception exc) {
                ErrorLog.error(8, new java.lang.Object[]{"OTSResource"}, false);
            }
        }
    }

    private void ensureInitialized() {
    }

    public Object _duplicate() {
        throw this.no_implement;
    }

    public void _release() {
        throw this.no_implement;
    }

    public boolean _is_a(String repository_id) {
        throw this.no_implement;
    }

    public boolean _is_equivalent(Object that) {
        throw this.no_implement;
    }

    public boolean _non_existent() {
        throw this.no_implement;
    }

    public int _hash(int maximum) {
        throw this.no_implement;
    }

    public Request _request(String operation) {
        throw this.no_implement;
    }

    public Request _create_request(Context ctx, String operation, NVList arg_list, NamedValue result) {
        throw this.no_implement;
    }

    public Request _create_request(Context ctx, String operation, NVList arg_list, NamedValue result, ExceptionList exceptions, ContextList contexts) {
        throw this.no_implement;
    }

    public Object _get_interface_def() {
        throw this.no_implement;
    }

    public Policy _get_policy(int policy_type) {
        throw this.no_implement;
    }

    public DomainManager[] _get_domain_managers() {
        throw this.no_implement;
    }

    public Object _set_policy_override(Policy[] policies, SetOverrideType set_add) {
        throw this.no_implement;
    }
}

