/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.util;

import com.sun.jms.util.Statistics;

public class Statistician {
    String name;
    int count = 0;
    float minimum = Float.MAX_VALUE;
    float maximum = Float.MIN_VALUE;
    float sampleSum = 0.0f;
    float sampleSumSquares = 0.0f;
    long startTime;

    public void reset() {
        this.count = 0;
        this.minimum = Float.MAX_VALUE;
        this.maximum = 0.0f;
        this.sampleSum = 0.0f;
        this.sampleSumSquares = 0.0f;
        this.startTime = 0L;
    }

    public Statistician() {
        this("");
    }

    public Statistician(String name) {
        this.name = name;
        this.reset();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void start() {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
    }

    public void addSample(float sample) {
        ++this.count;
        this.sampleSum += sample;
        this.sampleSumSquares += sample * sample;
        if (sample > this.maximum) {
            this.maximum = sample;
        }
        if (sample < this.minimum) {
            this.minimum = sample;
        }
    }

    public int getCount() {
        return this.count;
    }

    public float getMean() {
        float mean = 0.0f;
        if (this.count > 0) {
            mean = this.sampleSum / (float)this.count;
        }
        return mean;
    }

    public float getMaximum() {
        return this.maximum;
    }

    public float getMinimum() {
        return this.minimum;
    }

    public float getElapsedTime() {
        long now = System.currentTimeMillis();
        long deltaTime = now - this.startTime;
        return deltaTime;
    }

    public float getStdDeviation() {
        float stdDev = 0.0f;
        if (this.count > 0) {
            stdDev = (float)Math.sqrt(this.sampleSumSquares) / (float)this.count;
        }
        return stdDev;
    }

    public float getThroughput() {
        return (float)this.count / this.getElapsedTime() * 1000.0f;
    }

    public Statistics getStatistics() {
        Statistics stats = new Statistics(this.getCount(), this.getMinimum(), this.getMaximum(), this.getMean(), this.getStdDeviation(), this.getThroughput());
        return stats;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.name);
        sb.append(" Mean = ");
        sb.append(this.getMean());
        sb.append(" Max = ");
        sb.append(this.getMaximum());
        sb.append(" Min = ");
        sb.append(this.getMinimum());
        sb.append(" StdDev = ");
        sb.append(this.getStdDeviation());
        sb.append(" over ");
        sb.append(this.count);
        sb.append(" samples");
        sb.append(" Throughput = " + this.getThroughput());
        return sb.toString();
    }
}

