/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.XidImpl;
import com.sun.jms.service.DBManager;
import com.sun.jms.service.SessionImpl;
import com.sun.jms.service.TxnContext;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.JMSException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class TxnContextManager {
    private static TxnContextManager instance = new TxnContextManager();
    public static final Logger logger = Log.getLogger(1);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.service.LocalStrings");
    private HashMap txnContexts = new HashMap();
    private int nextTxnId = 0;
    private boolean recoveryComplete = true;

    private TxnContextManager() {
    }

    public static TxnContextManager getInstance() {
        return instance;
    }

    public void start(Xid xid, int flag, SessionImpl session) throws JMSException, XAException {
        if (!this.recoveryComplete) {
            logger.info("New txn can't be started until recovery is complete.");
            XAException ex2 = new XAException(resource.getString("txnmanager.cant_start_new_txn_until_recovery_is_complete"));
            ex2.errorCode = -6;
            throw ex2;
        }
        HashMap hashMap = this.txnContexts;
        synchronized (hashMap) {
            TxnContext tcontext = (TxnContext)this.txnContexts.get(xid);
            try {
                if (tcontext == null) {
                    tcontext = new TxnContext(xid, this.nextTxnId++);
                    this.registerTxnContext(xid, tcontext);
                }
                tcontext.start(flag, session);
            }
            catch (XAException ex3) {
                this.abortTxn(xid);
                throw ex3;
            }
        }
    }

    public void end(Xid xid, int flag, SessionImpl session, Collection acknowledgments) throws JMSException, XAException {
        TxnContext tcontext = null;
        HashMap hashMap = this.txnContexts;
        synchronized (hashMap) {
            tcontext = (TxnContext)this.txnContexts.get(xid);
        }
        if (tcontext == null) {
            logger.info("End Failed, transaction not found.");
            XAException ex2 = new XAException(resource.getString("txnmanager.end_failed"));
            ex2.errorCode = -6;
            throw ex2;
        }
        try {
            tcontext.end(flag, session, acknowledgments);
        }
        catch (XAException ex3) {
            this.abortTxn(xid);
            throw ex3;
        }
    }

    public void commit(Xid xid, boolean onePhase) throws JMSException, XAException {
        TxnContext tcontext = null;
        HashMap hashMap = this.txnContexts;
        synchronized (hashMap) {
            tcontext = (TxnContext)this.txnContexts.get(xid);
        }
        if (tcontext == null) {
            logger.info("Commit failed, transaction not found.");
            XAException ex2 = new XAException(resource.getString("txnmanager.commit_failed"));
            ex2.errorCode = -6;
            throw ex2;
        }
        try {
            tcontext.commit(onePhase);
            this.releaseTxnContext(xid);
        }
        catch (XAException ex3) {
            this.abortTxn(xid);
            throw ex3;
        }
    }

    public int prepare(Xid xid) throws JMSException, XAException {
        int result;
        TxnContext tcontext = null;
        HashMap hashMap = this.txnContexts;
        synchronized (hashMap) {
            tcontext = (TxnContext)this.txnContexts.get(xid);
        }
        if (tcontext == null) {
            logger.info("Prepare failed, transaction not found.");
            this.abortTxn(xid);
            XAException ex2 = new XAException(resource.getString("txnmanager.prepare_failed"));
            ex2.errorCode = -6;
            throw ex2;
        }
        try {
            result = tcontext.prepare();
        }
        catch (XAException ex3) {
            this.abortTxn(xid);
            throw ex3;
        }
        if (result == 3) {
            this.releaseTxnContext(xid);
        }
        return result;
    }

    public void rollback(Xid xid) throws JMSException, XAException {
        TxnContext tcontext = null;
        HashMap hashMap = this.txnContexts;
        synchronized (hashMap) {
            tcontext = (TxnContext)this.txnContexts.get(xid);
        }
        if (tcontext == null) {
            logger.info("Rollback failed, transaction not found.");
            XAException ex2 = new XAException(resource.getString("txnmanager.rollback_failed"));
            ex2.errorCode = -6;
            throw ex2;
        }
        try {
            tcontext.rollback();
            this.releaseTxnContext(xid);
        }
        catch (XAException ex3) {
            this.abortTxn(xid);
            throw ex3;
        }
    }

    public void rollbackAll() {
        XidImpl[] recoverList = this.recover(0x1000000);
        int i2 = 0;
        while (i2 < recoverList.length) {
            try {
                this.rollback(recoverList[i2]);
            }
            catch (Throwable t2) {
                logger.info("Could not rollback during recovery for xid: " + recoverList[i2].toString() + "\n" + t2.toString());
            }
            ++i2;
        }
        if (!this.recoveryComplete) {
            logger.info("Can't complete auto-recovery..");
        } else {
            logger.fine("Auto-recovery complete");
        }
    }

    public void initializeRecovery() throws JMSException, XAException {
        XAResource jdbcXAResource = null;
        XAConnection jdbcXAConnection = null;
        int flags = 0x1000000;
        Xid[] dbXid = null;
        if (this.txnContexts.size() > 0) {
            logger.info("Recover failed, txn contextx already exist.");
            XAException ex2 = new XAException(resource.getString("txnmanager.recover_failed_txn_context_already_exists"));
            ex2.errorCode = -5;
            throw ex2;
        }
        try {
            jdbcXAConnection = DBManager.getInstance().getXADBConnection();
            jdbcXAResource = jdbcXAConnection.getXAResource();
        }
        catch (SQLException sqle) {
            logger.info("Recover failed, could not get XA resource: " + sqle.toString());
            XAException ex3 = new XAException(MessageFormat.format(resource.getString("txnmanager.recover_failed_could_not_get_xa_resource"), sqle.getMessage()));
            ex3.errorCode = -5;
            throw ex3;
        }
        try {
            dbXid = jdbcXAResource.recover(flags);
        }
        catch (XAException ex4) {
            logger.info("Recover failed, could not get xid list: " + ex4.toString());
            throw ex4;
        }
        if (logger.isLogging(5)) {
            logger.fine(dbXid.length + " XA transactions to recover using flag:" + Integer.toHexString(flags));
        }
        int i2 = 0;
        while (i2 < dbXid.length) {
            HashMap ex3 = this.txnContexts;
            synchronized (ex3) {
                TxnContext tcontext = new TxnContext(dbXid[i2], this.nextTxnId++);
                if (tcontext.recover()) {
                    this.registerTxnContext(dbXid[i2], tcontext);
                    if (logger.isLogging(5)) {
                        logger.fine("Recovered transaction xid: " + dbXid[i2]);
                    }
                } else {
                    logger.info("Could not recover transaction xid: " + dbXid[i2]);
                }
            }
            ++i2;
        }
        try {
            jdbcXAConnection.close();
        }
        catch (SQLException esql) {
            logger.info(esql);
        }
        this.recoveryComplete = this.txnContexts.size() == 0;
    }

    public XidImpl[] recover(int flags) {
        XidImpl[] recoveredXid;
        if (this.recoveryComplete || flags == 0) {
            return new XidImpl[0];
        }
        HashMap hashMap = this.txnContexts;
        synchronized (hashMap) {
            recoveredXid = new XidImpl[this.txnContexts.size()];
            Iterator it = this.txnContexts.keySet().iterator();
            int i2 = 0;
            while (i2 < this.txnContexts.size()) {
                XidImpl xid = (XidImpl)it.next();
                recoveredXid[i2] = new XidImpl(xid);
                ++i2;
            }
        }
        return recoveredXid;
    }

    public boolean isRecoveryComplete() {
        return this.recoveryComplete;
    }

    public static void printDebugInfo() {
        StringBuffer text = new StringBuffer(300);
        text.append("\n\nTransaction Tables\n==================\n");
        text.append("\nNumber of active txnContexts: " + TxnContextManager.instance.txnContexts.size());
        text.append(", Next available local txnId: " + TxnContextManager.instance.nextTxnId);
        logger.debugInfo(text.toString());
        Iterator iter = TxnContextManager.instance.txnContexts.values().iterator();
        while (iter.hasNext()) {
            ((TxnContext)iter.next()).printDebugInfo();
        }
    }

    private void releaseTxnContext(Xid xid) {
        TxnContext tcontext = null;
        HashMap hashMap = this.txnContexts;
        synchronized (hashMap) {
            tcontext = (TxnContext)this.txnContexts.remove(xid);
            if (!this.recoveryComplete && this.txnContexts.size() == 0) {
                this.recoveryComplete = true;
            }
        }
        if (tcontext != null) {
            tcontext.close();
        }
    }

    private void registerTxnContext(Xid xid, TxnContext tcontext) throws XAException {
        HashMap hashMap = this.txnContexts;
        synchronized (hashMap) {
            if (this.txnContexts.containsKey(xid)) {
                throw new XAException(-8);
            }
            this.txnContexts.put(new XidImpl(xid), tcontext);
        }
    }

    private boolean abortTxn(Xid xid) {
        TxnContext tcontext = null;
        boolean result = true;
        logger.finer("Aborting transaction for Xid:" + xid.toString());
        HashMap hashMap = this.txnContexts;
        synchronized (hashMap) {
            tcontext = (TxnContext)this.txnContexts.get(xid);
        }
        try {
            try {
                if (tcontext != null) {
                    tcontext.rollback();
                }
                result = true;
            }
            catch (XAException ex2) {
                logger.info("Abort failed, clean up local resources.: " + ex2.toString());
                logger.info(ex2);
                result = false;
                Object var7_8 = null;
                this.releaseTxnContext(xid);
            }
            Object var7_7 = null;
            this.releaseTxnContext(xid);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.releaseTxnContext(xid);
            throw throwable;
        }
        return result;
    }
}

