/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.DestinationImpl;
import com.sun.jms.MessageImpl;
import com.sun.jms.service.ConnectionImpl;
import com.sun.jms.service.Consumer;
import com.sun.jms.service.ConsumerImpl;
import com.sun.jms.service.DBManager;
import com.sun.jms.service.DurableSubscription;
import com.sun.jms.service.MessageConsumerImpl;
import com.sun.jms.util.JmsResourceBundle;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Topic;

public class TopicImpl
extends com.sun.jms.service.DestinationImpl
implements Topic {
    boolean hasDurableSubscribers = false;
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.service.LocalStrings");

    public TopicImpl(String name, boolean isTemporary, boolean persistenceRequired) {
        super(name, isTemporary, persistenceRequired);
        if (!isTemporary) {
            this.loadDurableSubscribers();
        }
    }

    public TopicImpl(String name) {
        this(name, false);
    }

    private void loadDurableSubscribers() {
        Collection durableSubscribers = DurableSubscription.loadDurableSubscribersForDestination(this);
        if (durableSubscribers.size() > 0) {
            this.hasDurableSubscribers = true;
        }
    }

    ConsumerImpl getDurableSubscriber(String clientID, String subscriptionName) throws JMSException {
        ConsumerImpl durableSubscriber = null;
        ArrayList arrayList = this.consumers;
        synchronized (arrayList) {
            Iterator consumerIter = ((AbstractList)this.consumers).iterator();
            while (consumerIter.hasNext()) {
                ConsumerImpl consumer = (ConsumerImpl)consumerIter.next();
                if (!consumer.isDurableSubscriber() || !consumer.matches(clientID, subscriptionName)) continue;
                durableSubscriber = consumer;
                break;
            }
        }
        return durableSubscriber;
    }

    public TopicImpl(String name, boolean isTemporary) {
        this(name, isTemporary, true);
    }

    public String getTopicName() throws JMSException {
        return this.getName();
    }

    public boolean isQueue() {
        return false;
    }

    boolean sendMessageToConsumers(MessageImpl msg) throws JMSException {
        ArrayList arrayList = this.consumers;
        synchronized (arrayList) {
            if (com.sun.jms.service.DestinationImpl.logger.isLogging(6)) {
                com.sun.jms.service.DestinationImpl.logger.finer("msg: " + msg + ",  consumers size: " + this.consumers.size());
            }
            Connection con = null;
            try {
                ConsumerImpl consumer;
                Iterator consumerIter = ((AbstractList)this.consumers).iterator();
                try {
                    Object var8_11;
                    try {
                        con = DBManager.getInstance().getDBConnection();
                        con.setAutoCommit(false);
                        while (consumerIter.hasNext()) {
                            consumer = (ConsumerImpl)consumerIter.next();
                            try {
                                if (!consumer.selectorMatch(msg)) continue;
                                consumer.preSendProcessing(msg, con);
                            }
                            catch (JMSException jmse) {
                                if (!com.sun.jms.service.DestinationImpl.logger.isLogging(2)) continue;
                                com.sun.jms.service.DestinationImpl.logger.warning(MessageFormat.format(resource.getString("topicimpl.unacked_warning"), jmse.getMessage()));
                            }
                        }
                        con.commit();
                    }
                    catch (SQLException sqle) {
                        if (com.sun.jms.service.DestinationImpl.logger.isLogging(2)) {
                            com.sun.jms.service.DestinationImpl.logger.warning(MessageFormat.format(resource.getString("topicimpl.unacked_warning"), sqle.getMessage()));
                        }
                        var8_11 = null;
                        DBManager.getInstance().closeDBConnection(con);
                    }
                    var8_11 = null;
                    DBManager.getInstance().closeDBConnection(con);
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    DBManager.getInstance().closeDBConnection(con);
                    throw throwable;
                }
                consumerIter = ((AbstractList)this.consumers).iterator();
                while (consumerIter.hasNext()) {
                    consumer = (ConsumerImpl)consumerIter.next();
                    try {
                        if (!consumer.selectorMatch(msg)) continue;
                        consumer.sendMessage(msg);
                    }
                    catch (JMSException e10) {
                        if (!com.sun.jms.service.DestinationImpl.logger.isLogging(2)) continue;
                        com.sun.jms.service.DestinationImpl.logger.warning(MessageFormat.format(resource.getString("topicimpl.could_not_send_message"), msg.toString(), msg.getDestinationName(), e10.getMessage()));
                    }
                }
            }
            catch (ConcurrentModificationException e11) {
                com.sun.jms.service.DestinationImpl.logger.warning(e11);
            }
        }
        return true;
    }

    DestinationImpl getDestinationWrapper() {
        com.sun.jms.TopicImpl dest = new com.sun.jms.TopicImpl(this.name);
        return dest;
    }

    public boolean hasDurableSubscribers() {
        return this.hasDurableSubscribers;
    }

    boolean registerDurableSubscriber(ConsumerImpl consumer, String clientID, String subscriptionName) throws JMSException {
        boolean foundMatch = false;
        ArrayList arrayList = this.consumers;
        synchronized (arrayList) {
            this.hasDurableSubscribers = true;
            ListIterator<ConsumerImpl> consumerIter = ((AbstractList)this.consumers).listIterator();
            while (consumerIter.hasNext()) {
                ConsumerImpl c10 = (ConsumerImpl)consumerIter.next();
                if (!c10.isDurableSubscriber() || !c10.matches(clientID, subscriptionName)) continue;
                if (c10.isActive()) {
                    throw new JMSException(resource.getString("topicimpl.subscription_is_already_active"));
                }
                com.sun.jms.service.DestinationImpl.logger.info("Replacing durable subscriber");
                consumerIter.set(consumer);
                foundMatch = true;
                break;
            }
            if (!foundMatch) {
                if (com.sun.jms.service.DestinationImpl.logger.isLogging(6)) {
                    com.sun.jms.service.DestinationImpl.logger.finer("Adding new durable subscriber");
                }
                this.register(consumer);
            }
        }
        return foundMatch;
    }

    public void delete() throws JMSException {
        Consumer consumer;
        Iterator consumerIter = ((AbstractList)this.consumers).iterator();
        while (consumerIter.hasNext()) {
            ConnectionImpl con;
            consumer = (Consumer)consumerIter.next();
            if (!consumer.isDurableSubscriber() || !consumer.isActive() || (con = consumer.getConnection()) == null || !con.ping()) continue;
            throw new IllegalStateException(MessageFormat.format(resource.getString("topicimpl.can_not_delete_topic"), this.getName(), consumer.toString()));
        }
        super.delete();
        consumerIter = ((AbstractList)((ArrayList)this.consumers.clone())).iterator();
        while (consumerIter.hasNext()) {
            consumer = (Consumer)consumerIter.next();
            if (!consumer.isDurableSubscriber()) continue;
            consumer.deleteDurableSubscription();
        }
    }

    void registerWaitForSynchronousReceive(MessageConsumerImpl consumer) throws JMSException {
        com.sun.jms.service.DestinationImpl.logger.warning(resource.getString("topicimpl.method_not_implemented"));
    }

    void deregisterWaitForSynchronousReceive(MessageConsumerImpl consumer) {
        com.sun.jms.service.DestinationImpl.logger.warning(resource.getString("topicimpl.method_not_implemented"));
    }

    public void printDebugInfo() {
        com.sun.jms.service.DestinationImpl.logger.debugInfo("DestinationType: Topic");
        super.printDebugInfo();
        if (this.hasDurableSubscribers) {
            DurableSubscription.printDurableSubscribers(this.getName());
        }
    }
}

