/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.service.ConnectionImpl;
import com.sun.jms.service.DestinationImpl;
import com.sun.jms.service.QueueReceiverImpl;
import com.sun.jms.service.SessionImpl;
import com.sun.jms.service.TopicImpl;
import com.sun.jms.util.JmsResourceBundle;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.jms.JMSException;

public class QueueSessionImpl
extends SessionImpl {
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.service.LocalStrings");

    QueueSessionImpl(ConnectionImpl parentConnection) {
        super(parentConnection);
    }

    QueueSessionImpl(ConnectionImpl parentConnection, boolean isTransacted, int acknowledgeMode) {
        super(parentConnection, isTransacted, acknowledgeMode);
    }

    TopicImpl createTopic(String name, boolean isTemporary) throws JMSException {
        throw new JMSException(resource.getString("queuesessionimpl.cannot_create_a_topic"));
    }

    QueueReceiverImpl createQueueReceiver(int consumerId, String destinationName, String messageSelector) throws JMSException {
        this.createMessageConsumer(consumerId, destinationName);
        DestinationImpl dest = SessionImpl.service.getDestination(destinationName);
        if (dest == null) {
            throw new JMSException(MessageFormat.format(resource.getString("queuesessionimpl.invalid_destination"), destinationName));
        }
        QueueReceiverImpl consumer = new QueueReceiverImpl(dest, this, consumerId, messageSelector);
        dest.register(consumer);
        return consumer;
    }

    void start() {
        super.start();
        Iterator iter = this.getConsumers();
        if (iter != null) {
            while (iter.hasNext()) {
                QueueReceiverImpl qr = (QueueReceiverImpl)iter.next();
                qr.start();
            }
        }
    }
}

