/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.client;

import com.sun.jms.MessageImpl;
import com.sun.jms.client.MessageConsumerImpl;
import com.sun.jms.client.QueueSessionImpl;
import com.sun.jms.util.JmsResourceBundle;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueReceiver;

public class QueueReceiverImpl
extends MessageConsumerImpl
implements QueueReceiver {
    Queue queue = null;
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.client.LocalStrings");

    QueueReceiverImpl(Queue queue, String messageSelector, QueueSessionImpl qSession) {
        super(queue, qSession, messageSelector);
        this.queue = queue;
    }

    public Queue getQueue() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("queuereceiverimpl.getqueue_on_closed_qr"));
        }
        return this.queue;
    }

    public void close() throws JMSException {
        super.close();
    }

    public String consumerTypeName() {
        return "QueueReceiver";
    }

    public Message receive(long timeout) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("queuereceiverimpl.receive_on_closed_qr"));
        }
        Message msg = super.receiveNoWait();
        if (msg == null) {
            msg = this.parentSession.receive(this.getConsumerID(), timeout);
            this.acknowledge((MessageImpl)msg);
        }
        return msg;
    }

    public Message receiveNoWait() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("queuereceiverimpl.receivenowait_on_closed_qr"));
        }
        return this.receive(-1L);
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        boolean hasMessageListener;
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("queuereceiverimpl.setmessagelistener_on_closed_qr"));
        }
        boolean hadMessageListener = this.getMessageListener() != null;
        super.setMessageListener(listener);
        boolean bl2 = hasMessageListener = this.getMessageListener() != null;
        if (hadMessageListener != hasMessageListener) {
            this.parentSession.setHasMessageListener(this.getConsumerID(), hasMessageListener);
        }
    }
}

