/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.client;

import com.sun.jms.JMSService;
import com.sun.jms.XidImpl;
import com.sun.jms.client.JMSXASessionImpl;
import com.sun.jms.client.SessionImpl;
import com.sun.jms.spi.xa.JMSXASession;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class JMSXAResource
implements XAResource {
    private JMSXASession xaSession = null;
    private Session session = null;
    private JMSService jmsService = null;
    private String resourceMgrId = null;
    static Logger logger = Log.getLogger(2);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.client.LocalStrings");

    public JMSXAResource(JMSXASession xaSession) {
        this.xaSession = xaSession;
        this.jmsService = ((JMSXASessionImpl)xaSession).getConnectionImpl().getJMSService();
        try {
            this.resourceMgrId = this.jmsService.getXaResourceMgrId();
        }
        catch (JMSException e10) {
            if (logger.isLogging(2)) {
                logger.warning(MessageFormat.format(resource.getString("jmsxaresource.could_not_get_xaresourcemgr"), e10.toString()));
            }
            this.resourceMgrId = "Default Resource Manager Id";
        }
        catch (RemoteException e11) {
            if (logger.isLogging(2)) {
                logger.warning(MessageFormat.format(resource.getString("jmsxaresource.could_not_get_xaresourcemgr"), e11.toString()));
            }
            this.resourceMgrId = "Default Resource Manager Id";
        }
    }

    public void start(Xid foreignXid, int flags) throws XAException {
        XidImpl xid = new XidImpl(foreignXid);
        try {
            this.associateToSession(xid, flags);
        }
        catch (JMSException e10) {
            logger.warning(e10);
        }
    }

    public void end(Xid foreignXid, int flags) throws XAException {
        XidImpl xid = new XidImpl(foreignXid);
        try {
            this.dissociateFromSession(xid, flags);
        }
        catch (JMSException e10) {
            logger.warning(e10);
        }
    }

    public void commit(Xid foregnXid, boolean onePhase) throws XAException {
        XidImpl xid = new XidImpl(foregnXid);
        try {
            this.jmsService.xaCommit(xid, onePhase);
        }
        catch (JMSException ej2) {
            logger.warning(ej2);
        }
        catch (RemoteException er2) {
            logger.warning(er2);
        }
    }

    public int prepare(Xid foregnXid) throws XAException {
        int result = 0;
        XidImpl xid = new XidImpl(foregnXid);
        try {
            result = this.jmsService.xaPrepare(xid);
        }
        catch (JMSException ej2) {
            logger.warning(ej2);
        }
        catch (RemoteException er2) {
            logger.warning(er2);
        }
        return result;
    }

    public void rollback(Xid foreignXid) throws XAException {
        XidImpl xid = new XidImpl(foreignXid);
        try {
            this.jmsService.xaRollback(xid);
        }
        catch (JMSException ej2) {
            logger.warning(ej2);
        }
        catch (RemoteException er2) {
            logger.warning(er2);
        }
    }

    public void forget(Xid foreignXid) throws XAException {
        XidImpl xid = new XidImpl(foreignXid);
        logger.warning(resource.getString("jmsxaresource.forget_not_implemented"));
    }

    public Xid[] recover(int flag) throws XAException {
        Xid[] result = null;
        try {
            result = this.jmsService.xaRecover(flag);
        }
        catch (JMSException ej2) {
            logger.warning(ej2);
        }
        catch (RemoteException er2) {
            logger.warning(er2);
        }
        return result;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        return this.getClass().isInstance(xares) ? this.isSameJMSRM((JMSXAResource)xares) : false;
    }

    public boolean isSameJMSRM(JMSXAResource xares) {
        return this.resourceMgrId.equals(xares.getResourceMgrId());
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    private void associateToSession(XidImpl xid, int flags) throws JMSException, XAException {
        ((SessionImpl)this.xaSession.getSession()).xaStart(xid, flags);
    }

    private void dissociateFromSession(XidImpl xid, int flags) throws JMSException, XAException {
        ((SessionImpl)this.xaSession.getSession()).xaEnd(xid, flags);
    }

    private String getResourceMgrId() {
        return this.resourceMgrId;
    }
}

