/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms;

import com.sun.jms.util.JMSProperties;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import java.text.MessageFormat;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JMSInitialContext {
    public static Logger logger = Log.getLogger(0);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.LocalStrings");
    private JMSProperties props = JMSProperties.getInstance();
    private InitialContext internalContext = null;
    private InitialContext externalContext = null;

    public JMSInitialContext() throws NamingException {
        try {
            Hashtable<String, String> environment = new Hashtable<String, String>();
            String contextFactory = this.props.getProperty("com.sun.jms.internal.java.naming.factory.initial");
            environment.put("java.naming.factory.initial", contextFactory);
            String providerURL = this.props.getProperty("com.sun.jms.internal.java.naming.provider.url");
            environment.put("java.naming.provider.url", providerURL);
            this.internalContext = new InitialContext(environment);
        }
        catch (NamingException e10) {
            logger.severe(MessageFormat.format(resource.getString("jmsinitialcontext.internal_jndi_failure"), e10.toString()));
            System.exit(-1);
        }
        try {
            this.externalContext = new InitialContext();
        }
        catch (NamingException e11) {
            logger.severe(MessageFormat.format(resource.getString("jmsinitialcontext.external_jndi_failure"), e11.toString()));
            System.exit(-1);
        }
    }

    public InitialContext getExternalContext() {
        return this.externalContext;
    }

    public InitialContext getInternalContext() {
        return this.internalContext;
    }
}

