/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web.elements;

import com.sun.enterprise.deployment.EjbAbstractDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import com.sun.enterprise.util.JarClassLoader;
import java.util.Iterator;
import java.util.Set;

public class WebEjbReferencesElement
extends WebTest
implements WebCheck {
    Result result = null;
    EjbReferenceDescriptor ejbReference;
    EjbAbstractDescriptor ejbDescriptor;

    public Result check(WebBundleDescriptor descriptor) {
        this.result = this.getInitializedResult();
        if (descriptor instanceof WebBundleDescriptor) {
            Set references = descriptor.getEjbReferenceDescriptors();
            Iterator iterator = references.iterator();
            if (iterator.hasNext()) {
                boolean oneFailed = false;
                while (iterator.hasNext()) {
                    this.ejbReference = (EjbReferenceDescriptor)iterator.next();
                    this.ejbDescriptor = this.ejbReference.getEjbDescriptor();
                    if (this.ejbDescriptor instanceof EjbDescriptor) {
                        if (!this.ejbReference.isLocal()) {
                            if (this.ejbDescriptor.getHomeClassName() == null || "".equals(this.ejbDescriptor.getHomeClassName()) || this.ejbDescriptor.getRemoteClassName() == null || "".equals(this.ejbDescriptor.getRemoteClassName())) continue;
                            oneFailed = this.commonToBothInterfaces(this.ejbDescriptor.getHomeClassName(), this.ejbDescriptor.getRemoteClassName(), descriptor);
                            continue;
                        }
                        if (oneFailed || this.ejbDescriptor.getLocalHomeClassName() == null || "".equals(this.ejbDescriptor.getLocalHomeClassName()) || this.ejbDescriptor.getLocalClassName() == null || "".equals(this.ejbDescriptor.getLocalClassName())) continue;
                        oneFailed = this.commonToBothInterfaces(this.ejbDescriptor.getLocalHomeClassName(), this.ejbDescriptor.getLocalClassName(), descriptor);
                        continue;
                    }
                    this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Not Applicable: [ {0} ] must be external reference to bean outside of [ {1} ].", new Object[]{this.ejbReference.getName(), Verifier.getArchiveFile(((WebBundleArchivist)descriptor.getArchivist()).getWebJarFile().getName()).getName()}));
                }
                if (oneFailed) {
                    this.result.setStatus(1);
                } else {
                    this.result.setStatus(0);
                }
            } else {
                this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable1", "There are no ejb references to other beans within this web archive [ {0} ]", new Object[]{descriptor.getName()}));
            }
            return this.result;
        }
        this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] not called with a web archive.", new Object[]{this.getClass()}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String home, String component, WebBundleDescriptor descriptor) {
        boolean foundBeanClassName = false;
        boolean foundHomeClassName = false;
        boolean foundRemoteClassName = false;
        boolean oneFailed = false;
        try {
            Context context = this.getVerifierContext();
            JarClassLoader jcl = context.getClassLoader();
            Class<?> c10 = jcl.loadClass(((EjbDescriptor)this.ejbDescriptor).getEjbClassName());
            foundBeanClassName = true;
            this.result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed1", "The referenced bean [ {0} ] exists and is loadable within [ {1} ].", new Object[]{((EjbDescriptor)this.ejbDescriptor).getEjbClassName(), Verifier.getArchiveFile(((WebBundleArchivist)descriptor.getArchivist()).getWebJarFile().getName()).getName()}));
            c10 = jcl.loadClass(home);
            foundHomeClassName = true;
            this.result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed2", "The referenced bean's home interface [ {0} ] exists and is loadable within [ {1} ].", new Object[]{home, Verifier.getArchiveFile(((WebBundleArchivist)descriptor.getArchivist()).getWebJarFile().getName()).getName()}));
            c10 = jcl.loadClass(component);
            foundRemoteClassName = true;
            this.result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed3", "The referenced bean's remote interface [ {0} ] exists and is loadable within [ {1} ].", new Object[]{component, Verifier.getArchiveFile(((WebBundleArchivist)descriptor.getArchivist()).getWebJarFile().getName()).getName()}));
            return oneFailed;
        }
        catch (ClassNotFoundException e10) {
            Verifier.debug(e10);
            if (!oneFailed) {
                oneFailed = true;
            }
            String classStr = "";
            if (!foundBeanClassName) {
                classStr = ((EjbDescriptor)this.ejbDescriptor).getEjbClassName();
            } else if (!foundHomeClassName) {
                classStr = home;
            } else if (!foundRemoteClassName) {
                classStr = component;
            }
            this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] class [ {1} ] cannot be found within this jar [ {2} ].", new Object[]{this.ejbReference.getName(), Verifier.getArchiveFile(((WebBundleArchivist)descriptor.getArchivist()).getWebJarFile().getName()).getName()}));
            return oneFailed;
        }
    }
}

