/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class FormErrorPage
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor.getLoginConfiguration() != null) {
            boolean foundIt = false;
            String formErrorPage = descriptor.getLoginConfiguration().getFormErrorPage();
            if (formErrorPage.length() > 0) {
                try {
                    ZipEntry ze;
                    JarFile jar = new JarFile(Verifier.getArchiveFile(((WebBundleArchivist)descriptor.getArchivist()).getWebJarFile().getName()));
                    if (formErrorPage.startsWith("/")) {
                        formErrorPage = formErrorPage.substring(1);
                    }
                    foundIt = (ze = jar.getEntry(formErrorPage)) != null;
                    jar.close();
                }
                catch (Exception ex2) {
                    foundIt = false;
                }
                if (foundIt) {
                    result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "The form-error-page [ {0} ] value defines the location in the web application where the error page that is displayed when login is not successful can be found within web application [ {1} ]", new Object[]{formErrorPage, descriptor.getName()}));
                } else {
                    result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: The form-error-page [ {0} ] value does not define the location in the web application where the error page that is displayed when login is not successful can be found within web application [ {1} ]", new Object[]{formErrorPage, descriptor.getName()}));
                }
            } else {
                result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no form-error-page elements within this web archive [ {0} ]", new Object[]{descriptor.getName()}));
            }
        } else {
            result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no form-error-page elements within this web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

