/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;

public class AuthMethod
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor.getLoginConfiguration() != null) {
            boolean foundIt = false;
            boolean na = false;
            String authMethod = descriptor.getLoginConfiguration().getAuthenticationMethod();
            if (authMethod.length() > 0) {
                foundIt = authMethod.equals("BASIC") || authMethod.equals("FORM") || authMethod.equals("CLIENT-CERT") || authMethod.equals("DIGEST");
            } else {
                na = true;
            }
            if (foundIt) {
                result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "The auth-method [ {0} ] is legal value within web application [ {1} ]", new Object[]{authMethod, descriptor.getName()}));
            } else if (na) {
                result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no auth-method elements within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
            } else {
                result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: The auth-method [ {0} ] is not legal value within web application [ {1} ].  It must be either [ {2} ], [ {3} ], [ {4} ] or [ {5} ].", new Object[]{authMethod, descriptor.getName(), "BASIC", "FORM", "CLIENT-CERT", "DIGEST"}));
            }
        } else {
            result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no auth-method elements within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

