/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session.stateless;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.util.JarClassLoader;
import java.lang.reflect.Method;

public class StatelessEjbCreateHome
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor instanceof EjbSessionDescriptor) {
            String stateType = ((EjbSessionDescriptor)descriptor).getSessionTypeString();
            if (EjbSessionDescriptor.STATELESS.equals(stateType)) {
                try {
                    Context context = this.getVerifierContext();
                    JarClassLoader jcl = context.getClassLoader();
                    Class<?> c10 = jcl.loadClass(descriptor.getEjbClassName());
                    Method m2 = null;
                    int foundThisManyTimes = 0;
                    do {
                        Method[] methods = c10.getDeclaredMethods();
                        int i2 = 0;
                        while (i2 < methods.length) {
                            if (methods[i2].getName().equals("ejbCreate")) {
                                if (foundThisManyTimes == 0) {
                                    m2 = methods[i2];
                                    ++foundThisManyTimes;
                                } else {
                                    ++foundThisManyTimes;
                                }
                            }
                            ++i2;
                        }
                    } while ((c10 = c10.getSuperclass()) != null && m2 == null);
                    if (m2 != null && foundThisManyTimes == 1) {
                        Class<?>[] cc2 = m2.getParameterTypes();
                        if (cc2.length > 0) {
                            result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: The ejbCreate method has one or more parameters \nwithin bean [ {0} ].  Stateless session are only allowed \nto have ejbCreate methods with no arguments.", new Object[]{descriptor.getEjbClassName()}));
                        } else {
                            result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "Valid: This bean's [ {0} ] ejbCreate method has no parameters.\n Stateless session beans can only have a ejbCreate method\n with no parameters.", new Object[]{descriptor.getEjbClassName()}));
                        }
                    } else if (m2 != null && foundThisManyTimes > 1) {
                        result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed2", "Error: [ {0} ] ejbCreate methods exists within bean [ {1} ].  The EJB class must have only one ejbCreate method for stateless session bean. ", new Object[]{new Integer(foundThisManyTimes), descriptor.getEjbClassName()}));
                    } else {
                        result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed3", "Error: No ejbCreate method exists within bean [ {0} ]", new Object[]{descriptor.getEjbClassName()}));
                    }
                }
                catch (ClassNotFoundException e10) {
                    Verifier.debug(e10);
                    result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Class [ {0} ] not found within bean [ {1} ]", new Object[]{descriptor.getEjbClassName(), descriptor.getName()}));
                }
                return result;
            }
            if (EjbSessionDescriptor.STATEFUL.equals(stateType)) {
                result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable1", "{0} expected {1} Session bean, but called with {2} Session bean.", new Object[]{this.getClass(), EjbSessionDescriptor.STATELESS, stateType}));
                return result;
            }
            result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed4", "Error: [ {0} ] is not valid stateType within bean [ {1} ].", new Object[]{stateType, descriptor.getName()}));
            return result;
        }
        result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Session", "Entity"}));
        return result;
    }
}

