/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session.stateless;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.util.JarClassLoader;
import java.lang.reflect.Method;

public class StatelessCreateOnlyOne
extends EjbTest
implements EjbCheck {
    Result result = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        if (descriptor instanceof EjbSessionDescriptor) {
            String stateType = ((EjbSessionDescriptor)descriptor).getSessionTypeString();
            if (EjbSessionDescriptor.STATELESS.equals(stateType)) {
                if (descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName())) {
                    this.commonToBothInterfaces(descriptor.getHomeClassName(), (EjbSessionDescriptor)descriptor);
                }
                if (descriptor.getLocalHomeClassName() != null && !"".equals(descriptor.getLocalHomeClassName())) {
                    this.commonToBothInterfaces(descriptor.getLocalHomeClassName(), (EjbSessionDescriptor)descriptor);
                }
                return this.result;
            }
            if (EjbSessionDescriptor.STATEFUL.equals(stateType)) {
                this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable1", "{0} expected {1} Session bean, but called with {2} Session bean.", new Object[]{this.getClass(), EjbSessionDescriptor.STATELESS, stateType}));
                return this.result;
            }
            this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed2", "Error: [ {0} ] is not valid stateType within bean [ {1} ].", new Object[]{stateType, descriptor.getName()}));
            return this.result;
        }
        this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Session", "Entity"}));
        return this.result;
    }

    private void commonToBothInterfaces(String home, EjbSessionDescriptor descriptor) {
        try {
            Context context = this.getVerifierContext();
            JarClassLoader jcl = context.getClassLoader();
            Class<?> c10 = jcl.loadClass(home);
            Method[] methods = c10.getDeclaredMethods();
            int foundThisManyTimes = 0;
            Method m2 = null;
            int i2 = 0;
            while (i2 < methods.length) {
                if (methods[i2].getName().equals("create")) {
                    if (foundThisManyTimes == 0) {
                        m2 = methods[i2];
                        ++foundThisManyTimes;
                    } else {
                        ++foundThisManyTimes;
                    }
                }
                ++i2;
            }
            if (m2 != null && foundThisManyTimes == 1) {
                this.result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "Valid: This bean [ {0} ] has defined only one create method.\n Stateless session beans can only have one create method.", new Object[]{home}));
            } else if (m2 != null && foundThisManyTimes > 1) {
                this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] Create methods exists within bean [ {1} ].  The home interface must have only one create method for stateless session bean.", new Object[]{new Integer(foundThisManyTimes), home}));
            } else {
                this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed1", "Error: No create method exist within bean [ {0} ]", new Object[]{home}));
            }
        }
        catch (ClassNotFoundException e10) {
            Verifier.debug(e10);
            this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Class [ {0} ] not found within bean [ {1} ]", new Object[]{home, descriptor.getName()}));
        }
    }
}

