/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.util.JarClassLoader;

public class SessionSynchronizationInterface
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor instanceof EjbSessionDescriptor) {
            String stateType = ((EjbSessionDescriptor)descriptor).getSessionTypeString();
            try {
                Context context = this.getVerifierContext();
                JarClassLoader jcl = context.getClassLoader();
                Class<?> c10 = jcl.loadClass(descriptor.getEjbClassName());
                boolean oneFound = false;
                block2: do {
                    Class<?>[] interfaces = c10.getInterfaces();
                    int i2 = 0;
                    while (i2 < interfaces.length) {
                        if (this.debug) {
                            System.out.println(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "Interface [ {0} ]", new Object[]{interfaces[i2].getName()}));
                        }
                        if (interfaces[i2].getName().equals("javax.ejb.SessionSynchronization")) {
                            oneFound = true;
                            if (EjbSessionDescriptor.STATELESS.equals(stateType)) {
                                result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] does not properly implement the SessionSynchronization interface.  SessionSynchronization interface must not be implemented by a stateless Session Bean. [ {1} ] is not a valid bean.", new Object[]{descriptor.getEjbClassName(), descriptor.getEjbClassName()}));
                                continue block2;
                            }
                            if (EjbSessionDescriptor.STATEFUL.equals(stateType)) {
                                String transactionType = descriptor.getTransactionType();
                                if (EjbDescriptor.CONTAINER_TRANSACTION_TYPE.equals(transactionType)) {
                                    result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] properly implements the SessionSynchronization interface.", new Object[]{descriptor.getEjbClassName()}));
                                    continue block2;
                                }
                                if (EjbDescriptor.BEAN_TRANSACTION_TYPE.equals(transactionType)) {
                                    result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed2", "Error: [ {0} ] does not properly implement the SessionSynchronization interface.  SessionSynchronization interface may be implemented only by a stateful Session Bean using container-managed transactions. [ {1} ] is not a valid bean.", new Object[]{descriptor.getEjbClassName(), descriptor.getEjbClassName()}));
                                    continue block2;
                                }
                            }
                        }
                        ++i2;
                    }
                } while ((c10 = c10.getSuperclass()) != null);
                if (!oneFound) {
                    result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable1", "Optional interface SessionSynchronization is not implemented by bean [ {0} ]", new Object[]{descriptor.getEjbClassName()}));
                }
            }
            catch (ClassNotFoundException e10) {
                Verifier.debug(e10);
                result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: [ {0} ] class not found.", new Object[]{descriptor.getEjbClassName()}));
            }
            return result;
        }
        result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Session", "Entity"}));
        return result;
    }
}

