/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.messagebean;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.messagebean.MessageBeanTest;
import java.util.Hashtable;

public class HasValidMethodDescriptor
extends MessageBeanTest {
    public Result check(EjbMessageBeanDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor.getTransactionType().equals(EjbDescriptor.CONTAINER_TRANSACTION_TYPE)) {
            Hashtable methods = descriptor.getMethodContainerTransactions();
            if (methods.size() > 1) {
                result.failed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.messagebean.HasValidMethodDescriptor.failed1", "Error : Message-driven bean [ {0} ] cannot define other methods than onMessage in the assembly-descriptor element", new Object[]{descriptor.getName()}));
                return result;
            }
            if (methods.size() == 0) {
                result.notApplicable(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.messagebean.HasValidMethodDescriptor.notApplicable1", "Message-driven bean [ {0} ] does not define any method", new Object[]{descriptor.getName()}));
                return result;
            }
            MethodDescriptor md = (MethodDescriptor)methods.keys().nextElement();
            if ("onMessage".equals(md.getName())) {
                String[] param = md.getParameterClassNames();
                if (param.length != 1 || !"javax.jms.Message".equals(param[0])) {
                    result.failed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.messagebean.HasValidMethodDescriptor.failed2", "Error : Message-driven bean [ {0} ] onMessage method definition in assembly-descriptor is incorrect", new Object[]{descriptor.getName()}));
                    return result;
                }
                ContainerTransaction transaction = (ContainerTransaction)methods.elements().nextElement();
                String ta = transaction.getTransactionAttribute();
                if (ContainerTransaction.REQUIRED.equals(ta) || ContainerTransaction.NOT_SUPPORTED.equals(ta)) {
                    result.passed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.messagebean.HasValidMethodDescriptor.passed", "Message-driven bean [ {0} ] onMessage method definition in assembly-descriptor is correct", new Object[]{descriptor.getName()}));
                } else {
                    result.passed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.messagebean.HasValidMethodDescriptor.failed3", "Error : Message-driven bean [ {0} ] onMessage transaction attribute must be Required or NotSupported", new Object[]{descriptor.getName()}));
                }
                return result;
            }
            result.failed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.messagebean.HasValidMethodDescriptor.failed1", "Error : Message-driven bean [ {0} ] cannot define other methods than onMessage in the assembly-descriptor element", new Object[]{descriptor.getName()}));
        } else {
            result.notApplicable(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.messagebean.HasValidMethodDescriptor.notApplicable2", "Message-driven bean [ {0} ] does not use container-managed transaction", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

