/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.findermethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.util.JarClassLoader;
import java.lang.reflect.Method;
import java.util.Arrays;

public class HomeInterfaceFindMethodMatch
extends EjbTest
implements EjbCheck {
    Result result = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        boolean oneFailed = false;
        if (descriptor instanceof EjbEntityDescriptor) {
            String persistence = ((EjbEntityDescriptor)descriptor).getPersistenceType();
            if (EjbEntityDescriptor.BEAN_PERSISTENCE.equals(persistence)) {
                if (descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName())) {
                    oneFailed = this.commonToBothInterfaces(descriptor.getHomeClassName(), descriptor);
                }
                if (!oneFailed && descriptor.getLocalHomeClassName() != null && !"".equals(descriptor.getLocalHomeClassName())) {
                    oneFailed = this.commonToBothInterfaces(descriptor.getLocalHomeClassName(), descriptor);
                }
                if (oneFailed) {
                    this.result.setStatus(1);
                } else {
                    this.result.setStatus(0);
                }
                return this.result;
            }
            this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Expected [ {0} ] managed persistence, but [ {1} ] bean has [ {2} ] managed persistence.", new Object[]{EjbEntityDescriptor.BEAN_PERSISTENCE, descriptor.getName(), persistence}));
            return this.result;
        }
        this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String home, EjbDescriptor descriptor) {
        boolean ejbFindMethodFound = false;
        boolean ejbFinderFound = false;
        boolean signaturesMatch = false;
        boolean oneFailed = false;
        int ejbFinderMethodLoopCounter = 0;
        try {
            Context context = this.getVerifierContext();
            JarClassLoader jcl = context.getClassLoader();
            Class<?> homeInterfaceClass = jcl.loadClass(home);
            Method[] homeInterfaceMethods = homeInterfaceClass.getDeclaredMethods();
            int i2 = 0;
            while (i2 < homeInterfaceMethods.length) {
                if (homeInterfaceMethods[i2].getName().startsWith("find")) {
                    ejbFinderFound = false;
                    signaturesMatch = false;
                    Class<?> EJBClass = jcl.loadClass(descriptor.getEjbClassName());
                    do {
                        Method[] ejbFinderMethods = EJBClass.getDeclaredMethods();
                        int z2 = 0;
                        while (z2 < ejbFinderMethods.length) {
                            if (ejbFinderMethods[z2].getName().startsWith("ejbFind") && homeInterfaceMethods[i2].getName().toUpperCase().equals(ejbFinderMethods[z2].getName().toUpperCase().substring(3))) {
                                Object[] ejbFinderMethodParameterTypes;
                                ejbFinderFound = true;
                                Object[] methodParameterTypes = homeInterfaceMethods[i2].getParameterTypes();
                                if (Arrays.equals(methodParameterTypes, ejbFinderMethodParameterTypes = ejbFinderMethods[z2].getParameterTypes())) {
                                    signaturesMatch = true;
                                    ejbFinderMethodLoopCounter = z2;
                                    break;
                                }
                            }
                            ++z2;
                        }
                        if (!ejbFinderFound || !signaturesMatch) continue;
                        this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{homeInterfaceClass.getName(), homeInterfaceMethods[i2].getName()}));
                        this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "The corresponding [ {0} ] method with matching parameters was found.", new Object[]{ejbFinderMethods[ejbFinderMethodLoopCounter].getName()}));
                        this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                    } while ((EJBClass = EJBClass.getSuperclass()) != null && (!ejbFinderFound || !signaturesMatch));
                    if (ejbFinderFound && !signaturesMatch) {
                        oneFailed = true;
                        this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{homeInterfaceClass.getName(), homeInterfaceMethods[i2].getName()}));
                        this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: A corresponding [ {0} ] method was found, but the parameters did not match.", new Object[]{"ejb" + homeInterfaceMethods[i2].getName().toUpperCase().substring(0, 1) + homeInterfaceMethods[i2].getName().substring(1)}));
                        this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                    } else if (!ejbFinderFound) {
                        oneFailed = true;
                        this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{homeInterfaceClass.getName(), homeInterfaceMethods[i2].getName()}));
                        this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed1", "Error: No corresponding ejbFind<METHOD>(...)  method was found."));
                        this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                    }
                }
                ++i2;
            }
            return oneFailed;
        }
        catch (ClassNotFoundException e10) {
            Verifier.debug(e10);
            this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home interface [ {0} ] or EJB Class [ {1} ] does not exist or is not loadable.", new Object[]{descriptor.getHomeClassName(), descriptor.getEjbClassName()}));
            return oneFailed;
        }
    }
}

