/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.ejbfindbyprimarykey;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.util.JarClassLoader;
import java.lang.reflect.Method;

public class EjbFindByPrimaryKeyException
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor instanceof EjbEntityDescriptor) {
            String persistentType = ((EjbEntityDescriptor)descriptor).getPersistenceType();
            if (EjbEntityDescriptor.BEAN_PERSISTENCE.equals(persistentType)) {
                boolean ejbFindByPrimaryKeyMethodFound = false;
                boolean throwsRemoteException = false;
                boolean oneFailed = false;
                int foundWarning = 0;
                try {
                    Context context = this.getVerifierContext();
                    JarClassLoader jcl = context.getClassLoader();
                    Class<?> EJBClass = jcl.loadClass(descriptor.getEjbClassName());
                    block2: do {
                        Method[] ejbFinderMethods = EJBClass.getDeclaredMethods();
                        int j2 = 0;
                        while (j2 < ejbFinderMethods.length) {
                            if (ejbFinderMethods[j2].getName().equals("ejbFindByPrimaryKey")) {
                                ejbFindByPrimaryKeyMethodFound = true;
                                Class<?>[] exceptions = ejbFinderMethods[j2].getExceptionTypes();
                                int z2 = 0;
                                while (z2 < exceptions.length) {
                                    if (exceptions[z2].getName().equals("java.rmi.RemoteException")) {
                                        throwsRemoteException = true;
                                        break;
                                    }
                                    ++z2;
                                }
                                if (ejbFindByPrimaryKeyMethodFound && !throwsRemoteException) {
                                    result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] Finder Method [ {1} ]", new Object[]{EJBClass.getName(), ejbFinderMethods[j2].getName()}));
                                    result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] declares [ {1} ] method, which properly does not throw java.rmi.RemoteException", new Object[]{EJBClass.getName(), ejbFinderMethods[j2].getName()}));
                                    result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                                    continue block2;
                                }
                                if (!ejbFindByPrimaryKeyMethodFound || !throwsRemoteException) continue block2;
                                result.addWarningDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] Finder Method [ {1} ]", new Object[]{EJBClass.getName(), ejbFinderMethods[j2].getName()}));
                                result.addWarningDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".warning", "Warning: Compatibility Note:\n An [ {0} ] method was found, but\n EJB 1.0 allowed the ejbFindByPrimaryKey method to throw \n the java.rmi.RemoteException to indicate a non-application\n exception. This practice is deprecated in EJB 1.1\n ---an EJB 1.1 compliant enterprise bean should\n throw the javax.ejb.EJBException or another \n RuntimeException to indicate non-application exceptions\n to the Container. ", new Object[]{ejbFinderMethods[j2].getName()}));
                                result.addWarningDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                                ++foundWarning;
                                continue block2;
                            }
                            ++j2;
                        }
                    } while ((EJBClass = EJBClass.getSuperclass()) != null && !ejbFindByPrimaryKeyMethodFound);
                    if (!ejbFindByPrimaryKeyMethodFound) {
                        oneFailed = true;
                        result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug3", "For EJB Class [ {0} ]", new Object[]{descriptor.getEjbClassName()}));
                        result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: No ejbFindByPrimaryKey method was found in bean class."));
                        result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                    }
                }
                catch (ClassNotFoundException e10) {
                    Verifier.debug(e10);
                    result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: EJB Class [ {0} ] does not exist or is not loadable.", new Object[]{descriptor.getEjbClassName()}));
                    oneFailed = true;
                }
                if (oneFailed) {
                    result.setStatus(1);
                } else if (foundWarning > 0) {
                    result.setStatus(2);
                } else {
                    result.setStatus(0);
                }
            } else {
                result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Expected persistence type [ {0} ], but bean [ {1} ] has persistence type [ {2} ]", new Object[]{EjbEntityDescriptor.BEAN_PERSISTENCE, descriptor.getName(), persistentType}));
            }
            return result;
        }
        result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return result;
    }
}

