/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbAbstractDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbUtils;
import com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CmpFieldTest;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Set;

public class DependentValueClassModifiers
extends CmpFieldTest {
    protected boolean runIndividualCmpFieldTest(Descriptor entity, Descriptor persistentField, Class c10, Result result) {
        String fieldName = persistentField.getName();
        String getMethodName = "get" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        Method getMethod = VerifierTest.getMethod(c10, getMethodName, null);
        if (getMethod != null) {
            Class<?> returnType = getMethod.getReturnType();
            if (returnType.isArray()) {
                returnType = returnType.getComponentType();
            }
            if (returnType.isPrimitive()) {
                result.addGoodDetails(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.DependentValueClassModifiers.notApplicable", "Field [ {0} ] is not a dependent value class reference", new Object[]{fieldName}));
                return true;
            }
            EjbBundleDescriptor bundle = ((EjbDescriptor)entity).getEjbBundleDescriptor();
            if (this.isValidInterface(returnType, bundle.getEjbs(), MethodDescriptor.EJB_REMOTE) || this.isValidInterface(returnType, bundle.getEjbs(), MethodDescriptor.EJB_LOCAL)) {
                result.addGoodDetails(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.DependentValueClassModifiers.notApplicable", "Field [ {0} ] is not a dependent value class reference", new Object[]{fieldName}));
                return true;
            }
            int modifiers = returnType.getModifiers();
            if (Modifier.isPublic(modifiers) && !Modifier.isAbstract(modifiers) && EjbUtils.isValidSerializableType(returnType)) {
                result.addGoodDetails(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.DependentValueClassModifiers.passed", "Dependent value class [ {0} ] reference by cmp field [ {1} ] is public, not abstract and serializable", new Object[]{returnType.getName(), fieldName}));
                return true;
            }
            result.addErrorDetails(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.DependentValueClassModifiers.failed", "Dependent value class [ {0} ] reference by cmp field [ {1} ] is either not public or abstract or not serializable", new Object[]{returnType.getName(), fieldName}));
            return false;
        }
        result.addErrorDetails(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.isAccessorDeclared.failed2", "Error : Cannot find accessor [ {0} ] method for [ {1} ] field ", new Object[]{getMethodName, fieldName}));
        return false;
    }

    private boolean isValidInterface(Class fieldType, Set entities, String interfaceType) {
        EjbAbstractDescriptor entity;
        if (entities == null) {
            return false;
        }
        Iterator iterator = entities.iterator();
        if (interfaceType.equals(MethodDescriptor.EJB_REMOTE)) {
            while (iterator.hasNext()) {
                entity = (EjbAbstractDescriptor)iterator.next();
                if (!fieldType.getName().equals(entity.getHomeClassName()) && !fieldType.getName().equals(entity.getRemoteClassName())) continue;
                return true;
            }
        }
        if (interfaceType.equals(MethodDescriptor.EJB_LOCAL)) {
            while (iterator.hasNext()) {
                entity = (EjbAbstractDescriptor)iterator.next();
                if (!fieldType.getName().equals(entity.getLocalHomeClassName()) && !fieldType.getName().equals(entity.getLocalClassName())) continue;
                return true;
            }
        }
        return false;
    }
}

