/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.MethodUtils;
import com.sun.enterprise.util.JarClassLoader;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;

public class TransactionDemarcationHomeInterface
extends EjbTest
implements EjbCheck {
    static String[] EJBObjectMethods = new String[]{"getHomeHandle", "getEJBMetaData"};
    Result result = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        boolean oneFailed = false;
        try {
            if (descriptor instanceof EjbEntityDescriptor) {
                if (descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName())) {
                    oneFailed = this.commonToBothInterfaces(descriptor.getHomeClassName(), descriptor);
                }
                if (!oneFailed && descriptor.getLocalHomeClassName() != null && !"".equals(descriptor.getLocalHomeClassName())) {
                    oneFailed = this.commonToBothInterfaces(descriptor.getLocalHomeClassName(), descriptor);
                }
                if (oneFailed) {
                    this.result.setStatus(1);
                } else {
                    this.result.setStatus(0);
                }
                return this.result;
            }
            this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "{0} expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
            return this.result;
        }
        catch (Throwable t2) {
            this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException1", "Error: Home interface does not contain class [ {0} ] within bean [ {1} ]", new Object[]{t2.getMessage(), descriptor.getName()}));
            return this.result;
        }
    }

    private boolean commonToBothInterfaces(String home, EjbDescriptor descriptor) {
        boolean oneFailed = false;
        try {
            Arrays.sort(EJBObjectMethods);
            Context context = this.getVerifierContext();
            JarClassLoader jcl = context.getClassLoader();
            Class<?> c10 = jcl.loadClass(home);
            Method[] methods = c10.getDeclaredMethods();
            boolean lookForIt = false;
            int i2 = 0;
            while (i2 < methods.length) {
                if (Arrays.binarySearch(EJBObjectMethods, methods[i2].getName()) < 0) {
                    try {
                        ContainerTransaction containerTransaction = null;
                        boolean resolved = false;
                        if (!descriptor.getMethodContainerTransactions().isEmpty()) {
                            Enumeration ee2 = descriptor.getMethodContainerTransactions().keys();
                            while (ee2.hasMoreElements()) {
                                lookForIt = false;
                                MethodDescriptor methodDescriptor = (MethodDescriptor)ee2.nextElement();
                                lookForIt = methodDescriptor.getName().equals(MethodDescriptor.ALL_EJB_METHODS) ? (methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_HOME) ? true : (methodDescriptor.getEjbClassSymbol().equals("") ? true : (methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_LOCALHOME) ? true : (methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_REMOTE) ? false : (methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_LOCAL) ? false : false))))) : (methodDescriptor.getParameterClassNames() == null ? (methodDescriptor.getEjbClassSymbol().equals("") || methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_HOME) || methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_LOCALHOME)) && methods[i2].getName().equals(methodDescriptor.getName()) : (methodDescriptor.getEjbClassSymbol().equals("") || methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_HOME) || methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_LOCALHOME)) && methods[i2].getName().equals(methodDescriptor.getName()) && MethodUtils.stringArrayEquals(methodDescriptor.getParameterClassNames(), new MethodDescriptor(methods[i2], descriptor, jcl).getParameterClassNames()));
                                if (!lookForIt) continue;
                                containerTransaction = (ContainerTransaction)descriptor.getMethodContainerTransactions().get(methodDescriptor);
                                if (containerTransaction != null) {
                                    String transactionAttribute = containerTransaction.getTransactionAttribute();
                                    if (ContainerTransaction.NOT_SUPPORTED.equals(transactionAttribute) || ContainerTransaction.SUPPORTS.equals(transactionAttribute) || ContainerTransaction.REQUIRED.equals(transactionAttribute) || ContainerTransaction.REQUIRES_NEW.equals(transactionAttribute) || ContainerTransaction.MANDATORY.equals(transactionAttribute) || ContainerTransaction.NEVER.equals(transactionAttribute) || !transactionAttribute.equals("")) {
                                        this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "Valid: [ {0} ] TransactionAttribute [ {1} ] for method [ {2} ] is valid.   Transaction attributes must be specified for all methods except getEJBMetaData and getHomeHandle methods of home interface [ {3} ]", new Object[]{methods[i2].getName(), transactionAttribute, methodDescriptor.getName(), home}));
                                        resolved = true;
                                        break;
                                    }
                                    oneFailed = true;
                                    this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] TransactionAttribute [ {1} ] for method [ {2} ] is not valid.   Transaction attributes must be specified for all methods except getEJBMetaData and getHomeHandle methods of home interface [ {3} ]", new Object[]{methods[i2].getName(), transactionAttribute, methodDescriptor.getName(), home}));
                                    break;
                                }
                                oneFailed = true;
                                this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: TransactionAttribute is null for method [ {0} ]", new Object[]{methodDescriptor.getName()}));
                                break;
                            }
                            if (!resolved) {
                                oneFailed = true;
                                this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed1", "Error: Transaction attributes must be specified for the methods defined in the home interface [ {0} ].  Method [ {1} ] has no transaction attribute defined within this bean [ {2} ].", new Object[]{home, methods[i2].getName(), descriptor.getName()}));
                            }
                        } else {
                            oneFailed = true;
                            this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed2", "Error: There are no method container transactions within this bean [ {0} ].   Transaction attributes must be specified for the methods defined in the home interface [ {1} ].  Method [ {2} ] has no transaction attribute defined.", new Object[]{descriptor.getName(), home, methods[i2].getName()}));
                        }
                        if (oneFailed) {
                            return oneFailed;
                        }
                    }
                    catch (Exception e10) {
                        this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException1", "Error: Home interface [ {0} ] does not contain class [ {1} ] within bean [ {2} ]", new Object[]{home, e10.getMessage(), descriptor.getName()}));
                        oneFailed = true;
                        return oneFailed;
                    }
                }
                ++i2;
            }
            return oneFailed;
        }
        catch (ClassNotFoundException e11) {
            Verifier.debug(e11);
            this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException2", "Error: Home interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{home, descriptor.getName()}));
            oneFailed = true;
            return oneFailed;
        }
    }
}

