/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.elements;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.Iterator;

public class EjbRefTypeElement
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        boolean failed = false;
        if (!descriptor.getEjbReferenceDescriptors().isEmpty()) {
            Iterator itr = descriptor.getEjbReferenceDescriptors().iterator();
            while (itr.hasNext()) {
                EjbReferenceDescriptor nextEjbReference = (EjbReferenceDescriptor)itr.next();
                String ejbRefTypeStr = nextEjbReference.getEjbDescriptor().getType();
                if (ejbRefTypeStr.equals(EjbSessionDescriptor.TYPE) || ejbRefTypeStr.equals(EjbEntityDescriptor.TYPE)) continue;
                result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: ejb-ref-type [ {0} ] within \n bean [ {1} ] is not valid.  \n Must be [ {2} ] or [ {3} ]", new Object[]{ejbRefTypeStr, descriptor.getName(), EjbEntityDescriptor.TYPE, EjbSessionDescriptor.TYPE}));
                failed = true;
            }
        } else {
            result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no ejb references to other beans within this bean [ {0} ]", new Object[]{descriptor.getName()}));
            return result;
        }
        if (failed) {
            result.setStatus(1);
        } else {
            result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "All ejb-ref-type elements are valid.  They are all [ {0} ] or [ {1} ] within this bean [ {2} ]", new Object[]{EjbEntityDescriptor.TYPE, EjbSessionDescriptor.TYPE, descriptor.getName()}));
        }
        return result;
    }
}

