/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.businessmethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbUtils;
import com.sun.enterprise.util.JarClassLoader;
import java.lang.reflect.Method;

public class BusinessMethodException
extends EjbTest
implements EjbCheck {
    Result result = null;
    int foundWarning = 0;
    int foundAtLeastOne = 0;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
            boolean oneFailed = false;
            boolean remoteInterfaceType = false;
            if (descriptor.getRemoteClassName() != null && !"".equals(descriptor.getRemoteClassName())) {
                remoteInterfaceType = true;
                oneFailed = this.commonToBothInterfaces(remoteInterfaceType, descriptor.getRemoteClassName(), descriptor);
            }
            if (!oneFailed && descriptor.getLocalClassName() != null && !"".equals(descriptor.getLocalClassName())) {
                remoteInterfaceType = false;
                oneFailed = this.commonToBothInterfaces(remoteInterfaceType, descriptor.getLocalClassName(), descriptor);
            }
            if (oneFailed) {
                this.result.setStatus(1);
            } else if (this.foundAtLeastOne == 0) {
                this.result.setStatus(3);
            } else if (this.foundWarning > 0) {
                this.result.setStatus(2);
            } else {
                this.result.setStatus(0);
            }
            return this.result;
        }
        this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "{0} expected {1} bean or {2} bean, but called with {3}.", new Object[]{this.getClass(), "Session", "Entity", descriptor.getName()}));
        return this.result;
    }

    private boolean commonToBothInterfaces(boolean remoteInterfaceType, String remote, EjbDescriptor descriptor) {
        boolean oneFailed = false;
        try {
            Context context = this.getVerifierContext();
            JarClassLoader jcl = context.getClassLoader();
            Class<?> rc = jcl.loadClass(remote);
            boolean businessFound = false;
            boolean throwsRemoteException = false;
            Method[] remoteMethods = rc.getMethods();
            int h2 = 0;
            while (h2 < remoteMethods.length) {
                if (!remoteMethods[h2].getDeclaringClass().getName().equals("javax.ejb.EJBObject") && !remoteMethods[h2].getDeclaringClass().getName().equals("javax.ejb.EJBLocalObject")) {
                    businessFound = false;
                    throwsRemoteException = false;
                    Class<?> c10 = jcl.loadClass(descriptor.getEjbClassName());
                    do {
                        Method[] methods = c10.getDeclaredMethods();
                        int i2 = 0;
                        while (i2 < methods.length) {
                            if (methods[i2].getName().equals(remoteMethods[h2].getName())) {
                                ++this.foundAtLeastOne;
                                businessFound = true;
                                Class[] exceptions = methods[i2].getExceptionTypes();
                                if (remoteInterfaceType && EjbUtils.isValidRemoteException(exceptions)) {
                                    throwsRemoteException = true;
                                }
                                if (businessFound && !throwsRemoteException) {
                                    this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] business Method [ {1} ]", new Object[]{c10.getName(), methods[i2].getName()}));
                                    this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] properly does not throw java.rmi.RemoteException from business method [ {1} ].", new Object[]{c10.getName(), methods[i2].getName()}));
                                    this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                                } else if (businessFound && throwsRemoteException) {
                                    this.result.addWarningDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] business Method [ {1} ]", new Object[]{c10.getName(), methods[i2].getName()}));
                                    this.result.addWarningDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".warning", "Warning: Compatibility Note:\n A public business method [ {0} ] was found, but\n EJB 1.0 allowed the business methods to throw the \n java.rmi.RemoteException to indicate a non-application\n exception. This practice is deprecated in EJB 1.1\n ---an EJB 1.1 compliant enterprise bean should\n throw the javax.ejb.EJBException or another \n RuntimeException to indicate non-application exceptions\n to the Container. ", new Object[]{methods[i2].getName()}));
                                    this.result.addWarningDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                                    ++this.foundWarning;
                                }
                            }
                            ++i2;
                        }
                    } while ((c10 = c10.getSuperclass()) != null && !businessFound);
                }
                ++h2;
            }
            if (this.foundAtLeastOne == 0) {
                this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable1", " [ {0} ] does not declare any business methods. ", new Object[]{descriptor.getEjbClassName()}));
            }
            return oneFailed;
        }
        catch (Exception e10) {
            e10.printStackTrace();
            Verifier.debug(e10);
            oneFailed = true;
            this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Remote interface [ {0} ] or bean class [ {1} ] does not exist or is not loadable within bean [ {2} ].", new Object[]{remote, descriptor.getEjbClassName(), descriptor.getName()}));
            return oneFailed;
        }
    }
}

