/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CheckConfigPropertyType
extends ConnectorTest
implements ConnectorCheck {
    private static Class[] allowedTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = CheckConfigPropertyType.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = CheckConfigPropertyType.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Integer == null ? (class$java$lang$Integer = CheckConfigPropertyType.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Double == null ? (class$java$lang$Double = CheckConfigPropertyType.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$Byte == null ? (class$java$lang$Byte = CheckConfigPropertyType.class$("java.lang.Byte")) : class$java$lang$Byte, class$java$lang$Short == null ? (class$java$lang$Short = CheckConfigPropertyType.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$Long == null ? (class$java$lang$Long = CheckConfigPropertyType.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Float == null ? (class$java$lang$Float = CheckConfigPropertyType.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Character == null ? (class$java$lang$Character = CheckConfigPropertyType.class$("java.lang.Character")) : class$java$lang$Character};
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Character;

    public Result check(ConnectorDescriptor descriptor) {
        boolean oneFailed = false;
        Result result = this.getInitializedResult();
        Set properties = descriptor.getConfigProperties();
        Iterator iterator = properties.iterator();
        HashSet hs = new HashSet();
        while (iterator.hasNext()) {
            EnvironmentProperty ep2 = (EnvironmentProperty)iterator.next();
            String type = ep2.getType();
            if (type == null) {
                result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notdefined", "Error: The configuration property named [ {0} ] has no type ", new Object[]{ep2.getName()}));
                return result;
            }
            Class<?> typeClass = null;
            try {
                typeClass = Class.forName(type);
            }
            catch (Throwable t2) {
                result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".nonexist", "Error: The type [ {0} ] of the configuration property named [ {1} ] cannot be loaded", new Object[]{ep2.getType(), ep2.getName()}));
                return result;
            }
            boolean allowedType = false;
            int i2 = 0;
            while (i2 < allowedTypes.length) {
                if (allowedTypes[i2].equals(typeClass)) {
                    allowedType = true;
                    break;
                }
                ++i2;
            }
            if (allowedType) continue;
            oneFailed = true;
            result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: The type [ {0} ] for the configuration property named [ {1} ] is not allowed", new Object[]{ep2.getType(), ep2.getName()}));
            return result;
        }
        if (!oneFailed) {
            result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "Success: all properties have an allowed type"));
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

