/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.app;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.app.AppCheck;
import com.sun.enterprise.tools.verifier.tests.app.ApplicationTest;
import java.util.Iterator;

public class AppWebContext
extends ApplicationTest
implements AppCheck {
    public Result check(Application descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor.getWebBundleDescriptors().size() > 0) {
            boolean oneWarning = false;
            Iterator itr = descriptor.getWebBundleDescriptors().iterator();
            while (itr.hasNext()) {
                WebBundleDescriptor wbd = (WebBundleDescriptor)itr.next();
                if (wbd.getContextRoot().equals("")) {
                    if (!oneWarning) {
                        oneWarning = true;
                    }
                    result.addWarningDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".warning", "Warning: [ {0} ] has blank context root defined within application [ {1} ]", new Object[]{wbd.getName(), descriptor.getName()}));
                    continue;
                }
                result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] has context root defined as [ {1} ] within application[ {2} ].", new Object[]{wbd.getName(), wbd.getContextRoot(), descriptor.getName()}));
            }
            if (oneWarning) {
                result.setStatus(2);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no web components in application [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

