/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledControlButtonBox;
import java.awt.Color;
import java.awt.Container;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class UITitledTree
extends UITitledControlButtonBox {
    private Container viewParent = null;
    private JPanel blankPanel = null;
    private Color treeBackgroundColor = Color.white;

    public UITitledTree(String title, boolean showBorder) {
        super(title, showBorder);
    }

    public UITitledTree(String title, boolean showBorder, JTree tree) {
        super(title, showBorder);
        this.setTreeView(tree);
    }

    public void setTreeView(JTree tree) {
        super.setView(tree, true);
        this.treeBackgroundColor = tree.getBackground();
        tree.getSelectionModel().addTreeSelectionListener(this);
    }

    public JTree getTreeView() {
        return (JTree)this.getView();
    }

    public void setEnabled(boolean state) {
        JTree tree = this.getTreeView();
        if (tree != null) {
            tree.setBackground(state ? this.treeBackgroundColor : UITitledBox.DisabledBackgroundColor);
            if (this.clearWhenDisabled) {
                if (this.blankPanel == null) {
                    this.blankPanel = new JPanel();
                    this.blankPanel.setOpaque(true);
                    this.blankPanel.setBackground(UITitledBox.DisabledBackgroundColor);
                }
                if (state) {
                    if (this.viewParent != null) {
                        this.viewParent.remove(this.blankPanel);
                        this.viewParent.add(tree);
                        this.viewParent = null;
                    }
                } else if (this.viewParent == null) {
                    this.viewParent = tree.getParent();
                    this.viewParent.remove(tree);
                    this.viewParent.add(this.blankPanel);
                }
            }
        }
        super.setEnabled(state);
    }

    public void setButtonsEnabled(boolean state) {
        boolean hasSelection = !this.isSelectionEmpty();
        super.setButtonsEnabled(state, this.selectionControlList, state && hasSelection);
    }

    public TreeModel getModel() {
        return this.getTreeView().getModel();
    }

    public void setModel(TreeModel model) {
        this.getTreeView().setModel(model);
    }

    public boolean isSelectionEmpty() {
        return this.getTreeView().isSelectionEmpty();
    }

    public TreePath getSelectionPath() {
        return this.getTreeView().getSelectionPath();
    }

    public TreePath[] getSelectionPaths() {
        return this.getTreeView().getSelectionPaths();
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.getTreeView().addTreeSelectionListener(listener);
    }

    public void setSelectionMode(int selectionMode) {
        TreeSelectionModel selModel = this.getTreeView().getSelectionModel();
        if (selModel == null) {
            selModel = new DefaultTreeSelectionModel();
            this.getTreeView().setSelectionModel(selModel);
        }
        selModel.setSelectionMode(selectionMode);
    }
}

