/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import java.awt.Component;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class UITitledHTMLText
extends UITitledBox {
    public static final String HEADER_1 = "h1";
    public static final String HEADER_2 = "h2";
    public static final String HEADER_3 = "h3";
    public static final String HEADER_4 = "h4";
    private boolean makeScrollable = false;
    private JEditorPane editorPane = null;
    private JScrollPane scrollPane = null;

    public UITitledHTMLText(String title, boolean showBorder) {
        super(title, showBorder);
        this.setReadOnly(true);
        this.editorPane = new PrivateEditorPane();
        if (this.makeScrollable) {
            this.scrollPane = new JScrollPane(this.editorPane);
            this.scrollPane.setBorder(null);
            this.add((Component)this.scrollPane, this.getGBConstraints());
        } else {
            this.add((Component)this.editorPane, this.getGBConstraints());
        }
    }

    public UITitledHTMLText(String title) {
        this(title, false);
    }

    public JEditorPane getEditorPane() {
        return this.editorPane;
    }

    public void adjustPreferredSize() {
        if (this.scrollPane != null) {
            this.scrollPane.setPreferredSize(this.editorPane.getPreferredSize());
        }
    }

    public void setText(String text, String wrapTag) {
        String html = null;
        if (wrapTag != null) {
            StringBuffer sb = new StringBuffer("<html><body>");
            if (!wrapTag.equals("")) {
                if (wrapTag.startsWith("<")) {
                    sb.append(wrapTag);
                    sb.append(text);
                } else {
                    sb.append("<").append(wrapTag).append(">");
                    sb.append(text);
                    sb.append("</").append(wrapTag).append(">");
                }
            } else {
                sb.append(text);
            }
            sb.append("</body></html>");
            html = sb.toString();
        } else {
            html = text;
        }
        this.setText(html);
    }

    public void setText(String text) {
        this.editorPane.setText(text);
    }

    public String getText() {
        return this.editorPane.getText();
    }

    public void setEnabled(boolean state) {
    }

    public String toString() {
        return this.editorPane.toString();
    }

    class PrivateEditorPane
    extends JEditorPane {
        public PrivateEditorPane() {
            super("text/html", "");
            this.setBackground(UIManager.getColor("Panel.background"));
            this.setEditable(false);
        }

        public boolean getScrollableTracksViewportHeight() {
            return true;
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }
    }
}

