/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.Roles;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.tools.deployment.ui.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.descriptor.RolesDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public abstract class UIRoleRefsTable
extends UITitledTable {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$utils$UIRoleRefsTable == null ? (class$com$sun$enterprise$tools$deployment$ui$utils$UIRoleRefsTable = UIRoleRefsTable.class$("com.sun.enterprise.tools.deployment.ui.utils.UIRoleRefsTable")) : class$com$sun$enterprise$tools$deployment$ui$utils$UIRoleRefsTable);
    private static String ROLE_TABLE_TITLE = localStrings.getLocalString("ui.uirolerefstable.role_table_title", "Role names referenced in code");
    private static String EDIT_BUTTON = localStrings.getLocalString("ui.uirolerefstable.edit_button", "Edit Roles");
    private static String TYPE_TOOLTIP = localStrings.getLocalString("ui.uirolerefstable.type_tooltip", "Click to edit role name");
    private static String CODED_NAME = localStrings.getLocalString("ui.uirolerefstable.codedname", "Coded name");
    private static String ROLE_NAME = localStrings.getLocalString("ui.uirolerefstable.rolename", "Role name");
    private static final String EDIT_ROLES = localStrings.getLocalString("ui.uirolerefstable.edit_roles", "Edit Roles...");
    private String fileNameType = null;
    private String editRolesItemTitle = null;
    private Thread editRoles_defered = null;
    private JButton pbEditRoles = null;
    private boolean selectBlankName = false;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$utils$UIRoleRefsTable;

    private static String EDIT_ROLES(String v0) {
        return localStrings.getLocalString("ui.uirolerefstable.edit_roles_in_file", "Edit Roles in {0} File...", new Object[]{v0});
    }

    public UIRoleRefsTable() {
        this(true, null);
    }

    public UIRoleRefsTable(boolean showBorder, String fileType) {
        super(ROLE_TABLE_TITLE, showBorder);
        this.fileNameType = fileType;
        this.editRolesItemTitle = this.fileNameType == null ? EDIT_ROLES : UIRoleRefsTable.EDIT_ROLES(this.fileNameType);
        this.editRoles_defered = new Thread(){

            public void run() {
                UIRoleRefsTable.this.editRolesAction();
            }
        };
        RoleRefsTable table = new RoleRefsTable();
        this.setTableView(table);
        ActionListener actions = new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                String cmd = ae2.getActionCommand();
                if (cmd.equals("add")) {
                    UIRoleRefsTable.this.addRoleRefAction();
                } else if (cmd.equals("delete")) {
                    UIRoleRefsTable.this.deleteRoleRefAction();
                } else if (cmd.equals("edit")) {
                    UIRoleRefsTable.this.editRolesAction();
                } else {
                    UIUtils.printImplementationError("UIRoleRefsTable.<ActionListener>", "Unknown action-command: " + cmd);
                }
            }
        };
        UIButton addPB = UIButton.createAddButton(actions);
        this.addControlButton(addPB);
        UIButton delPB = UIButton.createDeleteButton(actions);
        this.addSelectionEnabledButton(delPB);
        this.pbEditRoles = new UIButton(EDIT_BUTTON, "edit", actions);
        this.addControlButton(this.pbEditRoles);
    }

    private RoleRefsTable getRoleRefsTable() {
        return (RoleRefsTable)this.getTableView();
    }

    private RoleRefsTableModel getRoleRefsModel() {
        return (RoleRefsTableModel)this.getModel();
    }

    public abstract Collection getRoleReferences();

    public abstract void addRoleReference(RoleReference var1);

    public abstract void removeRoleReference(RoleReference var1);

    public abstract Roles getRolesDescriptor();

    public abstract void roleReferenceChanged(RoleReference var1);

    public void refresh() {
        boolean enableEditRoles = !(this.getRolesDescriptor() instanceof EjbBundleDescriptor) && !(this.getRolesDescriptor() instanceof WebBundleDescriptor);
        this.pbEditRoles.setVisible(enableEditRoles);
        this.updateTableData(this.getRoleReferences());
        this.getRoleRefsTable().updateRolesCombo(enableEditRoles);
        this.getRoleRefsTable().sizeColumnsToFit(0);
        if (this.selectBlankName) {
            int x2 = this.getRoleRefsModel().getNamedRoleReference("");
            if (x2 >= 0) {
                this.getSelectionModel().setSelectionInterval(x2, x2);
                this.getRoleRefsTable().getColumnSelectionModel().setSelectionInterval(0, 0);
            }
            this.selectBlankName = false;
        }
    }

    private void addRoleRefAction() {
        RoleReference rr = new RoleReference("", "");
        rr.setValue("");
        this.selectBlankName = true;
        this.addRoleReference(rr);
    }

    private void deleteRoleRefAction() {
        int index = this.getRoleRefsTable().getSelectedRow();
        if (index >= 0) {
            int n2 = JOptionPane.showConfirmDialog(this, localStrings.getLocalString("ui.uirolerefstable.oktodeleterole", "Are you sure you want to delete selected role?"), localStrings.getLocalString("ui.uirolerefstable.deleterole", "Delete role"), 0);
            if (n2 == 0) {
                this.removeRoleReference((RoleReference)this.getRoleRefsModel().getRowObject(index));
            }
        } else {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("ui.uirolerefstable.pleaseselectitem", "You must first select a role from list"));
        }
    }

    private void editRolesAction() {
        RolesDialog rolesDialog = RolesDialog.newRolesDialog(this);
        rolesDialog.showDialog((Descriptor)((Object)this.getRolesDescriptor()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class RoleRefsTableModel
    extends InspectorTableModel {
        public RoleRefsTableModel() {
            super(new String[]{CODED_NAME, ROLE_NAME, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
            this.setDataOrdering(1);
        }

        public Object getObjectValue(Object obj, int col) {
            String value = null;
            RoleReference rr = (RoleReference)obj;
            switch (col) {
                case 0: {
                    value = rr.getName();
                    break;
                }
                case 1: {
                    value = rr.getValue();
                    break;
                }
                case 2: {
                    value = rr.getDescription();
                    break;
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            if (!(obj instanceof RoleReference)) {
                return;
            }
            RoleReference rr = (RoleReference)obj;
            String v2 = value.toString().trim();
            switch (col) {
                case 0: {
                    rr.setName(v2);
                    UIRoleRefsTable.this.roleReferenceChanged(rr);
                    break;
                }
                case 1: {
                    if (v2.equals(UIRoleRefsTable.this.editRolesItemTitle)) {
                        EventQueue.invokeLater(UIRoleRefsTable.this.editRoles_defered);
                        break;
                    }
                    rr.setValue(v2);
                    UIRoleRefsTable.this.roleReferenceChanged(rr);
                    break;
                }
                case 2: {
                    rr.setDescription(v2);
                    break;
                }
            }
        }

        public int getNamedRoleReference(String name) {
            Iterator itr = this.getData().iterator();
            int i2 = 0;
            while (itr.hasNext()) {
                String nextName = ((RoleReference)itr.next()).getName();
                if (name.equals(nextName)) {
                    return i2;
                }
                ++i2;
            }
            return -1;
        }
    }

    private class RoleRefsTable
    extends InspectorTable {
        private JComboBox typeCellEditor = new JComboBox();

        public RoleRefsTable() {
            this.setModel(new RoleRefsTableModel());
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
            this.setHandleDescriptionUpdates(true);
            TableColumn rolesCol = this.getColumnModel().getColumn(1);
            rolesCol.setCellEditor(new DefaultCellEditor(this.typeCellEditor));
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setToolTipText(TYPE_TOOLTIP);
            rolesCol.setCellRenderer(renderer);
        }

        public void updateRolesCombo(boolean addEditRoles) {
            Roles rolesDesc = UIRoleRefsTable.this.getRolesDescriptor();
            Set rolesSet = rolesDesc != null ? rolesDesc.getRoles() : null;
            this.typeCellEditor.removeAllItems();
            if (rolesSet != null) {
                Iterator i2 = rolesSet.iterator();
                while (i2.hasNext()) {
                    this.typeCellEditor.addItem(((Role)i2.next()).getName());
                }
            }
            if (addEditRoles) {
                this.typeCellEditor.addItem(UIRoleRefsTable.this.editRolesItemTitle);
            }
        }
    }
}

