/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.deployment.JspDescriptorImpl;
import com.sun.enterprise.deployment.Project;
import com.sun.enterprise.deployment.ServletDescriptorImpl;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.deployment.main.ProjectImpl;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIActionDispatcher;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIClassPackage;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIContextMenu;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTree;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class UIJarPackager
extends JPanel {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$utils$UIJarPackager == null ? (class$com$sun$enterprise$tools$deployment$ui$utils$UIJarPackager = UIJarPackager.class$("com.sun.enterprise.tools.deployment.ui.utils.UIJarPackager")) : class$com$sun$enterprise$tools$deployment$ui$utils$UIJarPackager);
    private static final String ADD_BUTTON = localStrings.getLocalString("ui.uijarpackager.add_button", "Add");
    private static final String REMOVE_BUTTON = localStrings.getLocalString("ui.uijarpackager.remove_button", "Remove");
    private static final String CLICK_TO_REMOVE = localStrings.getLocalString("ui.uijarpackager.remove.click_to_remove", "Click to remove items");
    private static final String NOTHING_SELECTED = localStrings.getLocalString("ui.uijarpackager.remove.nothing_selected", "Nothing selected to remove");
    private static final String NON_REMOVABLE = localStrings.getLocalString("ui.uijarpackager.remove.non_deletable", "Selection contains non-removable items");
    private static final String OPT_YES = localStrings.getLocalString("ui.uijarpackager.opt.yes", "Yes");
    private static final String OPT_YES_TO_ALL = localStrings.getLocalString("ui.uijarpackager.opt.yes_to_all", "Yes to All");
    private static final String OPT_NO = localStrings.getLocalString("ui.uijarpackager.opt.no", "No");
    private static final String POPUP_REFRESH_DIRS = localStrings.getLocalString("ui.uijarpackager.popup.refresh_dirs", "Refresh Selected Directories");
    private static final String POPUP_GOTO_DIR = localStrings.getLocalString("ui.uijarpackager.popup.goto_dir", "Goto Selected Directory");
    private static final String NONDEL_BUNDLE_CONTENT = localStrings.getLocalString("ui.uijarpackager.nondel.bundle_content", "Selected file is part of the parent bundle");
    private static final String NONDEL_EJB_REFERENCE = localStrings.getLocalString("ui.uijarpackager.nondel.ejb_ref", "Selected class/file is referenced by an EJB");
    private static final String NONDEL_SERVLET_REFERENCE = localStrings.getLocalString("ui.uijarpackager.nondel.servlet_ref", "Selected class/file is reference by a Servlet");
    private static final String NONDEL_JSP_REFERENCE = localStrings.getLocalString("ui.uijarpackager.nondel.jsp_ref", "Selected file is reference by a JSP");
    private static final String NONDEL_APPCLIENT_REFERENCE = localStrings.getLocalString("ui.uijarpackager.nondel.appclient_ref", "Selected file is reference by an Application Client");
    private static final String NONDEL_RESADAPT_REFERENCE = localStrings.getLocalString("ui.uijarpackager.nondel.resadapt_ref", "Selected file is reference by a Resource Adapter");
    private static final String NONDEL_ICON_REFERENCE = localStrings.getLocalString("ui.uijarpackager.nondel.icon_ref", "Selected file is reference by a desciptor icon");
    private static final String NONDEL_FIXED_XML = localStrings.getLocalString("ui.uijarpackager.nondel.fixed_xml", "Selected item is a fixed XML file");
    private static final String NONDEL_FIXED_NODE = localStrings.getLocalString("ui.uijarpackager.nondel.fixed_node", "Selected item is a fixed tree node");
    private static final String CUSTOM_URL_TITLE = localStrings.getLocalString("ui.uijarpackager.custom_url.title", "Add URL Pattern");
    private static final String CUSTOM_URL_LABEL = localStrings.getLocalString("ui.uijarpackager.custom_url.label", "URL Pattern");
    private static final String ADD_CUSTOM_URL_PATTERN = localStrings.getLocalString("ui.uijarpackager.custom_url.add", "Add URL Pattern");
    private static String helpSetMapID1 = "JarPackager";
    private static String helpSetMapID2 = "WebResContents";
    public static final String WEB_WAR = "webwar";
    public static final String EJB_JAR = "ejbjar";
    public static final String RESADPT_RAR = "conrar";
    public static final String WEB_RES = "webres";
    public static final String APP_CLIENT = "appcli";
    private String pkgrType = "ejbjar";
    private static final String NAME_WEB_WAR = localStrings.getLocalString("ui.uijarpackager.dftname.web_war", "<Web Bundle>");
    private static final String NAME_EJB_JAR = localStrings.getLocalString("ui.uijarpackager.dftname.ejb_jar", "<EJB Bundle>");
    private static final String NAME_WEB_RES = localStrings.getLocalString("ui.uijarpackager.dftname.web_res", "<Web Resource Collection>");
    private static final String NAME_APP_CLIENT = localStrings.getLocalString("ui.uijarpackager.dftname.app_client", "<Application Client>");
    private static final String NAME_RESADPT_RAR = localStrings.getLocalString("ui.uijarpackager.dftname.resadpt_rar", "<Resource Adaptor>");
    public static final int BUNDLE_TYPE_ALL = 0;
    public static final int BUNDLE_TYPE_CLASS = 1;
    public static final int BUNDLE_TYPE_NON_CLASS = 2;
    private static final String ArchSeparator = "/";
    private static final char ArchSeparatorChar = '/';
    private static final String FileSeparator = File.separator;
    private static final char FileSeparatorChar = File.separatorChar;
    private static final boolean IsDosFileSeparator = FileSeparatorChar == '\\';
    private static final String CLASSES = "classes";
    private static final String LIB = "lib";
    private static final String META_INF = "META-INF";
    private static final String WEB_INF = "WEB-INF";
    private static final String WEB_INF_ = "WEB-INF/";
    private static final String WEB_INF_CLASSES = "WEB-INF/classes";
    private static final String WEB_INF_CLASSES_ = "WEB-INF/classes/";
    private static final String WEB_INF_LIB = "WEB-INF/lib";
    private static final String WEB_INF_LIB_ = "WEB-INF/lib/";
    private static final String XML_APP_CLIENT = "application-client.xml";
    private static final String XML_EJB_JAR = "ejb-jar.xml";
    private static final String XML_WEB = "web.xml";
    private static final String XML_RAR = "ra.xml";
    private static final String MANIFEST_MF = "MANIFEST.MF";
    private static final String DOT_JAR = ".jar";
    private static final String DOT_CLASS = ".class";
    private static final String DOT_JSP = ".jsp";
    private static final String DOT_TLD = ".tld";
    private static final DataFlavor DRAG_FLAVOR = new DataFlavor(class$java$lang$String == null ? (class$java$lang$String = UIJarPackager.class$("java.lang.String")) : class$java$lang$String, "SourceType");
    private static final DataFlavor[] DRAG_FLAVOR_LIST = new DataFlavor[]{DRAG_FLAVOR};
    private static final String SOURCE_TREE = "SOURCE";
    private static final String DESTINATION_TREE = "DESTINATION";
    private static final String SRC_TREE_ROOT_NAME = "$SourceTreeRoot$";
    private static final String DEST_TREE_ROOT_NAME = "$DestinationTreeRoot$";
    private static DefaultMutableTreeNode EMPTY_NODE = null;
    private static boolean _staticInit = false;
    private TreePath[] selections;
    private UITitledComboBox sysRootsCombo = null;
    private UITitledBox srcTreeBox;
    private SourceTree srcTree;
    private SourceTreeView srcTreeView;
    private UITitledBox destTreeBox;
    private DestinationTree destTree;
    private DestinationTreeView destTreeView;
    private JButton btnAddUrl = null;
    private JButton btnAdd = null;
    private JButton btnRemove = null;
    private boolean btnRemoveEnabled = false;
    private char btnRemoveMnemonic;
    private Component ownerComp = null;
    private UIDialog dialogWin = null;
    private boolean isOk = false;
    private String dragInitiator = null;
    private TreePath[] dragSelections = null;
    private boolean finalRelease = false;
    private Vector cachedStartingDirectories = null;
    private Vector removedContents = new Vector();
    private int _selChangeRecursion = 0;
    private static JLabel BLANK_LABEL = new JLabel();
    private static Comparator archiveComparator = null;
    private static Comparator nodeComparator = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$utils$UIJarPackager;
    static /* synthetic */ Class class$java$lang$String;

    private static String TITLE_OTHER(String v0) {
        return localStrings.getLocalString("ui.uijarpackager.title_other", "Edit Contents of {0}", new Object[]{v0});
    }

    private static String TITLE_WEB_RES(String v0) {
        return localStrings.getLocalString("ui.uijarpackager.title_webres", "Edit Contents of Web Resource Collection {0}", new Object[]{v0});
    }

    private static String STARTING_DIR_TITLE(String v0) {
        return localStrings.getLocalString("ui.uijarpackager.starting_directory", "Starting Directory: {0}", new Object[]{v0});
    }

    private static String SRC_BOX_TITLE(String v0) {
        return localStrings.getLocalString("ui.uijarpackager.srcbox", "Available Files: {0}", new Object[]{v0});
    }

    private static String DEST_BOX_TITLE(String v0) {
        return localStrings.getLocalString("ui.uijarpackager.destbox", "Contents of {0}", new Object[]{v0});
    }

    private static String WEB_RES_DEST_BOX_TITLE(String v0) {
        return localStrings.getLocalString("ui.uijarpackager.contents_of_webrescoll", "Contents of Web Resource Collection: {0}", new Object[]{v0});
    }

    private static String CONTENTS_OF(String v0) {
        return localStrings.getLocalString("ui.uijarpackager.contents_of", "Contents of {0}", new Object[]{v0});
    }

    private static String ERR_CANNOT_MOVE_COPY(Object v0) {
        return localStrings.getLocalString("ui.uijarpackager.cannot_move_here", "You cannot move/copy node ''{0}'' here.", new Object[]{v0.toString()});
    }

    private static String ERR_PACKAGE_DIR(Object v0) {
        return localStrings.getLocalString("ui.uijarpackager.invalid_class_package_directory", "The class ''{0}'' must exist in a directory structure which corresponds to its package name", new Object[]{v0.toString()});
    }

    private static String ERR_CORRUPT_CLASSFILE(Object v0) {
        return localStrings.getLocalString("ui.uijarpackager.corrupt_class_file", "Invalid/corrupted class file found\n {0}", new Object[]{v0.toString()});
    }

    public String getHelpID() {
        return this.isTypeWebRes() ? helpSetMapID2 : helpSetMapID1;
    }

    private void setPackagerType(String type) {
        this.pkgrType = type;
    }

    private String getPackagerType() {
        return this.pkgrType;
    }

    private boolean isTypeWebWar() {
        return this.pkgrType.equals(WEB_WAR);
    }

    private boolean isTypeEjbJar() {
        return this.pkgrType.equals(EJB_JAR);
    }

    private boolean isTypeWebRes() {
        return this.pkgrType.equals(WEB_RES);
    }

    private boolean isTypeAppCli() {
        return this.pkgrType.equals(APP_CLIENT);
    }

    private boolean isTypeResRar() {
        return this.pkgrType.equals(RESADPT_RAR);
    }

    private static String DefaultTypeName(String type) {
        String name = "?";
        if (type.equals(WEB_WAR)) {
            name = NAME_WEB_WAR;
        } else if (type.equals(EJB_JAR)) {
            name = NAME_EJB_JAR;
        } else if (type.equals(WEB_RES)) {
            name = NAME_WEB_RES;
        } else if (type.equals(APP_CLIENT)) {
            name = NAME_APP_CLIENT;
        } else if (type.equals(RESADPT_RAR)) {
            name = NAME_RESADPT_RAR;
        }
        return name;
    }

    public static UIJarPackager newBrowser(Component comp, String ftype) {
        if (!_staticInit) {
            _staticInit = true;
            EMPTY_NODE = new DefaultMutableTreeNode();
        }
        if (UIConfig.testMode()) {
            comp = DT.getApplicationFrame();
            UIUtils.debugPrintln("Parenting to main app window");
        }
        return new UIJarPackager(comp, ftype);
    }

    private UIJarPackager(Component comp, String ftype) {
        this.ownerComp = comp;
        this._initLayout(ftype);
    }

    private void _initLayout(String ftype) {
        GridBagConstraints c10 = new GridBagConstraints();
        UIJarPackager contentPane = this;
        contentPane.setPreferredSize(new Dimension(450, 600));
        contentPane.setLayout(new GridBagLayout());
        this.setPackagerType(ftype != null && !ftype.equals("") ? ftype : EJB_JAR);
        ActionListener buttonActions = new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                Object btn = ae2.getSource();
                String cmd = ae2.getActionCommand();
                if (cmd.equals("add")) {
                    UIJarPackager.this.addAction();
                } else if (cmd.equals("remove")) {
                    UIJarPackager.this.removeAction();
                } else if (cmd.equals("ok")) {
                    UIJarPackager.this.okAction();
                } else if (cmd.equals("cancel")) {
                    UIJarPackager.this.cancelAction();
                } else if (cmd.equals("addurl") && UIJarPackager.this.isTypeWebRes()) {
                    UIJarPackager.this.destTree.addCustomUrlPattern();
                } else {
                    UIUtils.printImplementationError("Unknown command: " + cmd);
                }
            }
        };
        if (!this.isTypeWebRes()) {
            UITitledBox startingBox = new UITitledBox(UIJarPackager.STARTING_DIR_TITLE(""), false);
            c10.gridx = 0;
            c10.gridy = 0;
            c10.weightx = 0.5;
            c10.weighty = 0.0;
            c10.gridwidth = 1;
            c10.gridheight = 1;
            c10.insets = new Insets(5, 5, 0, 5);
            c10.fill = 2;
            contentPane.add((Component)startingBox, c10);
            GridBagConstraints gbc = startingBox.getGBConstraintsCopy();
            this.sysRootsCombo = new UITitledComboBox(null, false);
            this.sysRootsCombo.setEditable(true);
            this.sysRootsCombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae2) {
                    UITitledComboBox cb2 = (UITitledComboBox)ae2.getSource();
                    if (cb2.isSetSelectionUpdate()) {
                        return;
                    }
                    String sel = (String)cb2.getSelectedItem();
                    if (sel == null) {
                        return;
                    }
                    CustomFile selFile = new CustomFile(sel, true);
                    if (selFile.exists() && selFile.isDirectory()) {
                        String p2 = selFile.getPath();
                        if (!p2.endsWith(FileSeparator)) {
                            p2 = p2 + FileSeparator;
                        }
                        cb2.setSelectedItem(p2);
                        UIJarPackager.this.addStartingDirectory(selFile);
                        UIJarPackager.this.refreshSourceTree();
                        UIJarPackager.this.expandSourceTreeRoot();
                    }
                }
            });
            this.sysRootsCombo.setSelectedIndex(-1);
            JTextField sysRootEditor = this.sysRootsCombo.getEditorTextField();
            sysRootEditor.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent ke) {
                }

                public void keyTyped(KeyEvent ke) {
                }

                public void keyPressed(KeyEvent ke) {
                    if (ke.getKeyCode() == 27) {
                        UIJarPackager.this.completeFilePath(UIJarPackager.this.sysRootsCombo);
                    }
                }
            });
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 0.5;
            gbc.weighty = 0.0;
            gbc.fill = 2;
            startingBox.add((Component)this.sysRootsCombo, gbc);
            Icon upFolderIcon = UIManager.getIcon("FileChooser.upFolderIcon");
            JButton dotdot = new JButton(upFolderIcon);
            dotdot.setMargin(new Insets(0, 0, 0, 0));
            dotdot.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae2) {
                    UITitledComboBox cb2 = UIJarPackager.this.sysRootsCombo;
                    String sel = (String)cb2.getSelectedItem();
                    if (sel == null) {
                        return;
                    }
                    int e10 = sel.length() - (sel.endsWith(FileSeparator) ? 2 : 1);
                    if (e10 < 0) {
                        return;
                    }
                    int p2 = sel.lastIndexOf(FileSeparator, e10);
                    if (p2 < 0) {
                        return;
                    }
                    String newDir = sel.substring(0, p2 + 1);
                    CustomFile newDirFile = new CustomFile(newDir, true);
                    if (newDirFile.exists() && newDirFile.isDirectory()) {
                        CustomFile oldDirFile = new CustomFile(sel, true);
                        UIJarPackager.this.removeStartingDirectory(oldDirFile);
                        cb2.setSelectedItem(newDir);
                        UIJarPackager.this.addStartingDirectory(newDirFile);
                        UIJarPackager.this.refreshSourceTree();
                    }
                }
            });
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            startingBox.add((Component)dotdot, gbc);
        }
        this.srcTreeBox = new UITitledBox("<changed-below>", false);
        c10.gridx = 0;
        c10.gridy = 1;
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        contentPane.add((Component)this.srcTreeBox, c10);
        this.srcTreeBox.addWithGBConstraints(this.getSrcTreeView());
        UITitledControlButtonBox buttonsPanel = new UITitledControlButtonBox(null, false);
        c10.gridx = 0;
        c10.gridy = 2;
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(0, 5, 0, 0);
        c10.anchor = 13;
        c10.fill = 2;
        contentPane.add((Component)buttonsPanel, c10);
        buttonsPanel.getGBConstraints().anchor = 13;
        buttonsPanel.setControlButtonLocation(15);
        if (this.isTypeWebRes()) {
            this.btnAddUrl = new UIButton(ADD_CUSTOM_URL_PATTERN, "addurl", buttonActions);
            buttonsPanel.addControlButton(this.btnAddUrl);
        }
        this.btnAdd = new UIButton(ADD_BUTTON, "add", buttonActions);
        buttonsPanel.addControlButton(this.btnAdd);
        this.btnAdd.setEnabled(false);
        this.btnRemove = new UIButton(REMOVE_BUTTON, "remove", buttonActions);
        this.btnRemoveMnemonic = this.btnRemove.getText().charAt(0);
        this.btnRemove.setToolTipText(NOTHING_SELECTED);
        buttonsPanel.addControlButton(this.btnRemove);
        this.btnRemoveEnabled = false;
        this.btnRemove.setEnabled(false);
        this.destTreeBox = new UITitledBox("<changed-later>", false);
        c10.gridx = 0;
        c10.gridy = 3;
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        contentPane.add((Component)this.destTreeBox, c10);
        this.destTreeBox.addWithGBConstraints(this.getDestTreeView());
        UITitledControlButtonBox btnsPnl = new UITitledControlButtonBox(null, false);
        c10.gridx = 0;
        c10.gridy = 4;
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(0, 5, 5, 0);
        c10.anchor = 13;
        c10.fill = 2;
        contentPane.add((Component)btnsPnl, c10);
        btnsPnl.getGBConstraints().anchor = 13;
        btnsPnl.setControlButtonLocation(15);
        UIButton btnOk = UIButton.createOkButton(buttonActions);
        btnsPnl.addControlButton(btnOk);
        UIButton btnCancel = UIButton.createCancelButton(buttonActions);
        btnsPnl.addControlButton(btnCancel);
        UIHelpButton btnHelp = new UIHelpButton(this.getHelpID());
        btnsPnl.addControlButton(btnHelp);
    }

    private void completeFilePath(UITitledComboBox cb2) {
        String val = cb2.getText();
        int p2 = val.lastIndexOf(FileSeparator);
        String lastPath = p2 >= 0 ? val.substring(0, p2 + 1) : val;
        String name = val.substring(lastPath.length());
        CustomFile lastPathFile = new CustomFile(lastPath, true);
        if (!lastPathFile.exists()) {
            return;
        }
        String[] list = lastPathFile.list();
        if (list == null) {
            return;
        }
        if (name.equals("") && list.length == 1) {
            cb2.setText(lastPath + list[0] + FileSeparator);
            return;
        }
        int j2 = 0;
        int i2 = 0;
        while (i2 < list.length) {
            if (UIJarPackager.StrFileEquals(list[i2], name)) {
                return;
            }
            if (UIJarPackager.StrFileStartsWith(list[i2], name)) {
                if (j2 != i2) {
                    list[j2] = list[i2];
                }
                ++j2;
            }
            ++i2;
        }
        if (j2 == 0) {
            return;
        }
        if (j2 == 1) {
            cb2.setText(lastPath + list[0] + FileSeparator);
            return;
        }
        StringBuffer sb = new StringBuffer(list[0]);
        int i3 = 1;
        while (i3 < j2) {
            int c10 = name.length();
            int len1 = list[i3].length();
            int len2 = sb.length();
            while (c10 < len1 && c10 < len2 && list[i3].charAt(c10) == sb.charAt(c10)) {
                ++c10;
            }
            sb.setLength(c10);
            ++i3;
        }
        if (!UIJarPackager.StrFileEquals(name, sb.toString())) {
            cb2.setText(lastPath + sb.toString());
        }
    }

    protected Vector getStartingDirectories(boolean reload) {
        if (this.cachedStartingDirectories == null || reload) {
            this.cachedStartingDirectories = UIConfig._getStartingDirectories(null, null);
        }
        return this.cachedStartingDirectories;
    }

    protected void addStartingDirectory(File dir) {
        UIConfig._addStartingDirectory(dir, this.getStartingDirectories(false));
    }

    protected void removeStartingDirectory(File dir) {
        UIConfig._removeStartingDirectory(dir, this.getStartingDirectories(false));
    }

    protected File[] getDefaultSystemRoots() {
        boolean isSysFile = false;
        File[] dirs = this.getStartingDirectories(false).toArray(new File[0]);
        if (dirs.length == 0) {
            dirs = File.listRoots();
            isSysFile = true;
        }
        File[] cfDirs = new CustomFile[dirs.length];
        int i2 = 0;
        while (i2 < dirs.length) {
            File file = cfDirs[i2] = dirs[i2] instanceof CustomFile ? (CustomFile)dirs[i2] : new CustomFile(dirs[i2]);
            if (isSysFile) {
                ((CustomFile)cfDirs[i2]).setIsSystemRoot(true);
            }
            ++i2;
        }
        return cfDirs;
    }

    protected void saveStartingDirectories() {
        UIConfig.setStartingDirectories(this.getStartingDirectories(false));
        UIConfig.saveConfig();
    }

    public void setSource(Object d10) {
        this.getSrcTreeView().setTreeViewSource(d10);
    }

    public void setSource(Object d10, String name) {
        this.getSrcTreeView().setTreeViewSource(d10);
        this.getSrcTreeView().setName(name);
    }

    public void setDestination(Object d10) {
        this.getDestTreeView().setTreeViewSource(d10);
    }

    public void setDestination(Object d10, String name) {
        this.getDestTreeView().setTreeViewSource(d10);
        this.getDestTreeView().setName(name);
    }

    public void setAlternateDestination(Object d10) {
        this.getDestTreeView().setTreeViewAltSource(d10);
    }

    public boolean showBrowser() {
        this.isOk = false;
        this.clearRemovedContents();
        this.getStartingDirectories(true);
        String srcName = this.getSrcTreeView().getName();
        if (this.isTypeWebRes()) {
            this.srcTreeBox.setTitle(UIJarPackager.CONTENTS_OF(srcName));
        } else {
            this.srcTreeBox.setTitle(UIJarPackager.SRC_BOX_TITLE(srcName));
        }
        String dstName = this.getDestTreeView().getName();
        String dstTitle = this.isTypeWebRes() ? UIJarPackager.WEB_RES_DEST_BOX_TITLE(dstName) : UIJarPackager.DEST_BOX_TITLE(dstName);
        this.destTreeBox.setTitle(dstTitle);
        this.refreshSourceTree();
        this.destTreeView.buildView(null);
        if (this.dialogWin == null) {
            this.dialogWin = UIDialog.newDialog(this.ownerComp, true);
            this.dialogWin.setContentPane(this);
            this.dialogWin.pack();
            this.dialogWin.centerOnScreen();
        }
        String ttlName = this.getDestTreeView().getName();
        this.dialogWin.setTitle(this.isTypeWebRes() ? UIJarPackager.TITLE_WEB_RES(ttlName) : UIJarPackager.TITLE_OTHER(ttlName));
        this.dialogWin.show();
        UIUtils.debugPrintln((this.isOk ? "OK" : "CANCEL") + " selected");
        return this.isOk;
    }

    private void refreshSourceTree() {
        if (this.srcTreeView.hasTreeViewSource()) {
            this.srcTreeView.buildView(null);
        } else {
            String sysRoot = (String)this.sysRootsCombo.getSelectedItem();
            if (sysRoot != null && sysRoot.equals("")) {
                sysRoot = null;
            }
            Vector<String> dv2 = new Vector<String>();
            File[] dirs = this.getDefaultSystemRoots();
            int i2 = 0;
            while (i2 < dirs.length) {
                String dirName = dirs[i2].toString();
                dv2.add(dirName);
                if (sysRoot == null) {
                    sysRoot = dirName;
                }
                ++i2;
            }
            this.sysRootsCombo.setModel(dv2);
            this.sysRootsCombo.setSelectedItem(sysRoot);
            sysRoot = (String)this.sysRootsCombo.getSelectedItem();
            CustomFile sysRootFile = sysRoot != null && !sysRoot.equals("") ? new CustomFile(sysRoot, true) : null;
            this.srcTreeView.buildView(sysRootFile);
        }
    }

    private void expandSourceTreeRoot() {
        CustomTreeNode child;
        CustomTreeNode root = this.getSrcTreeView().getRootNode();
        CustomTreeNode customTreeNode = child = root.getChildCount() > 0 ? (CustomTreeNode)root.getChildAt(0) : null;
        if (child != null && child.isDirectory() && child.getChildCount() == 0) {
            SourceTree st = (SourceTree)this.getSrcTreeView().getTree();
            st.expandPath(new TreePath(child.getPath()));
            st.grabFocus();
        }
    }

    public FileContentsDescriptor getClassDescriptor() {
        return this.getClassDescriptor(false);
    }

    public FileContentsDescriptor getClassDescriptor(boolean includeAlternate) {
        if (!this.isOk) {
            UIUtils.printImplementationError("Shouldn't be calling this method!");
        }
        CustomFileContentsDescriptor fcd = new CustomFileContentsDescriptor();
        if (this.isOk && this.isTypeWebWar()) {
            this.getNodeContents(true, fcd, this.getDestClassesNode(), includeAlternate);
            this.getNodeContents(true, fcd, this.getDestLibNode(), includeAlternate);
            if (includeAlternate) {
                UIJarPackager._addAlternateLibJar(fcd, this.getDestTreeView().getTreeViewAltSource());
            }
        }
        return fcd;
    }

    public FileContentsDescriptor getContentsDescriptor() {
        return this.getContentsDescriptor(false);
    }

    public FileContentsDescriptor getContentsDescriptor(boolean includeAlternate) {
        CustomFileContentsDescriptor fcd = new CustomFileContentsDescriptor();
        if (this.isOk) {
            this.getNodeContents(false, fcd, this.getDestTreeRoot(), includeAlternate);
            if (includeAlternate) {
                UIJarPackager._addAlternateLibJar(fcd, this.getDestTreeView().getTreeViewAltSource());
            }
        } else {
            UIUtils.printImplementationError("Shouldn't be calling this method!");
        }
        return fcd;
    }

    public Set getUrlPatternContents() {
        if (!this.isOk || !this.isTypeWebRes()) {
            UIUtils.printImplementationError("Shouldn't be calling this method!");
            return null;
        }
        HashSet<String> s2 = new HashSet<String>();
        FileContentsDescriptor fcd = new FileContentsDescriptor();
        this.getNodeContents(false, fcd, this.getDestTreeRoot(), false);
        Iterator i2 = fcd.getFilesSet().iterator();
        while (i2.hasNext()) {
            File f2 = (File)i2.next();
            String n2 = f2.getPath();
            if (f2.isDirectory()) {
                if (!n2.endsWith(FileSeparator)) {
                    n2 = n2 + FileSeparator;
                }
                n2 = n2 + "*";
            }
            s2.add(UIJarPackager.ToArchSep(n2));
        }
        return s2;
    }

    private void clearRemovedContents() {
        this.removedContents.clear();
    }

    public Vector getRemovedContents() {
        return this.removedContents;
    }

    private void addRemovedContent(Vector fileList) {
        Enumeration e10 = fileList.elements();
        while (e10.hasMoreElements()) {
            this.addRemovedContent((CustomTreeNode)e10.nextElement());
        }
    }

    private void addRemovedContent(CustomTreeNode node) {
        String archKey = node.getArchiveKey(false);
        File delFile = new File(UIJarPackager.ToFileSep(archKey));
        if (this.removedContents.indexOf(delFile) < 0) {
            this.removedContents.add(delFile);
        }
    }

    private void okAction() {
        this.isOk = true;
        this.saveStartingDirectories();
        this.dialogWin.hide();
    }

    private void cancelAction() {
        this.isOk = false;
        this.dialogWin.hide();
    }

    private void removeAction() {
        if (!this.btnRemoveEnabled) {
            return;
        }
        TreePath[] selectedPaths = this.destTree.getSelectionPaths();
        if (selectedPaths.length <= 0) {
            return;
        }
        boolean action = UIOptionPane.showConfirmDialog(this, localStrings.getLocalString("ui.uijarpackager.deleteconfirmation", "Do you want to delete selected file(s)?"));
        if (!action) {
            return;
        }
        int i2 = 0;
        while (i2 < selectedPaths.length) {
            CustomTreeNode delNode = (CustomTreeNode)selectedPaths[i2].getLastPathComponent();
            if (delNode.isDeletable()) {
                Vector list = this.getDestTreeView().removeChildNode(null, delNode);
                this.addRemovedContent(list);
            } else {
                UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.uijarpackager.cannot_delete", "You can not delete {0} Node.", new Object[]{delNode}));
            }
            ++i2;
        }
    }

    private void addAction() {
        this._addDestTreePath(this.srcTree.getSelectionPaths(), null, false);
    }

    private void _addDestTreePath(TreePath[] selectedPaths, CustomTreeNode destRoot, boolean isLocal) {
        if (selectedPaths == null || selectedPaths.length <= 0) {
            return;
        }
        if (destRoot == null || this.isTypeWebRes()) {
            destRoot = this.getDestTreeRoot();
        } else if (destRoot.isFile()) {
            destRoot = (CustomTreeNode)destRoot.getParent();
        }
        Vector addedNodes = new Vector();
        DefaultTreeModel model = this.getDestTreeModel();
        this.getDestTreeView().checkOkToOverwrite(null);
        int i2 = 0;
        while (i2 < selectedPaths.length) {
            CustomTreeNode srcNode = (CustomTreeNode)selectedPaths[i2].getLastPathComponent();
            if (this.isTypeWebRes()) {
                this._addWebResToDestTree(srcNode, addedNodes);
            } else if (isLocal) {
                if (srcNode.isDirectory()) {
                    Vector<CustomTreeNode> fileNodes = new Vector<CustomTreeNode>();
                    Enumeration<TreeNode> srcEnum = srcNode.breadthFirstEnumeration();
                    while (srcEnum.hasMoreElements()) {
                        CustomTreeNode subNode = (CustomTreeNode)srcEnum.nextElement();
                        if (!subNode.isFile()) continue;
                        fileNodes.add(subNode);
                    }
                    String srcKey = srcNode.getArchiveKey();
                    String srcPath = srcKey.indexOf(ArchSeparator) >= 0 ? srcKey.substring(0, srcKey.lastIndexOf(ArchSeparator)) : "";
                    Enumeration e10 = fileNodes.elements();
                    while (e10.hasMoreElements()) {
                        CustomTreeNode subNode = (CustomTreeNode)e10.nextElement();
                        String relKey = subNode.getArchiveKey().substring(srcPath.length());
                        String relPath = relKey.indexOf(ArchSeparator) >= 0 ? relKey.substring(0, relKey.lastIndexOf(ArchSeparator)) : "";
                        this.pasteGivenNode(true, addedNodes, destRoot, subNode, relPath);
                    }
                } else {
                    this.pasteGivenNode(true, addedNodes, destRoot, srcNode, "");
                }
            } else {
                CustomFile tobeAdded = new CustomFile(srcNode.getFile());
                tobeAdded.setArchiveKey(null);
                CustomTreeNode childNode = new CustomTreeNode(tobeAdded);
                this.pasteGivenNode(false, addedNodes, destRoot, childNode, "");
            }
            ++i2;
        }
        this.btnAdd.setEnabled(false);
        this.srcTree.clearSelection();
        this.destTree.clearSelection();
        Enumeration ane = addedNodes.elements();
        while (ane.hasMoreElements()) {
            CustomTreeNode node = (CustomTreeNode)ane.nextElement();
            this.destTree.addSelectionPath(new TreePath(node.getPath()));
        }
        this._selectionChanged(this.destTree);
    }

    private void _addWebResToDestTree(CustomTreeNode node, Vector addedNodes) {
        if (node.isFile()) {
            String dirPath = node.getFileParent();
            CustomTreeNode parent = this.getDestTreeView().makeDirStructure(UIJarPackager.TokenizePath(dirPath));
            CustomTreeNode child = new CustomTreeNode(node);
            this.getDestTreeView().addChildNode(parent, child);
            if (addedNodes != null) {
                addedNodes.add(node);
            }
        } else {
            Enumeration<TreeNode> e10 = node.children();
            while (e10.hasMoreElements()) {
                CustomTreeNode subNode = (CustomTreeNode)e10.nextElement();
                this._addWebResToDestTree(subNode, addedNodes);
            }
        }
    }

    private void droppingAction(DropTargetDropEvent dtde, String initiator, TreePath[] dragSel) {
        TreePath[] selectedPaths = null;
        CustomTreeNode newParent = null;
        CustomTreeNode oldParent = null;
        DefaultTreeModel model = this.getDestTreeModel();
        Transferable tr = dtde.getTransferable();
        if (!dtde.isLocalTransfer()) {
            UIUtils.debugPrintln("REJECT - not within same JVM");
            dtde.rejectDrop();
            return;
        }
        Point loc = dtde.getLocation();
        TreePath destinationPath = this.destTree.getPathForLocation(loc.x, loc.y);
        Object xferData = null;
        try {
            if (!tr.isDataFlavorSupported(DRAG_FLAVOR)) {
                UIUtils.debugPrintln("REJECT - Unsupported data flavor");
                dtde.rejectDrop();
                return;
            }
            xferData = tr.getTransferData(DRAG_FLAVOR);
            if (!xferData.equals(initiator)) {
                UIUtils.printImplementationError("Unexpected drag initiator");
                dtde.rejectDrop();
                return;
            }
        }
        catch (Exception ufe) {
            UIUtils.debugPrintln("REJECT - Unsupported data flavor(2)");
            dtde.rejectDrop();
            return;
        }
        boolean isLocal = xferData.toString().equals(DESTINATION_TREE);
        CustomTreeNode treeRoot = this.getDestTreeRoot();
        Vector<TreePath> validPaths = new Vector<TreePath>();
        if (isLocal) {
            if (this.isTypeWebRes()) {
                UIUtils.debugPrintln("REJECT - Drag within WebRes not allowed");
                dtde.rejectDrop();
                return;
            }
            selectedPaths = dragSel;
            if (selectedPaths == null) {
                UIUtils.debugPrintln("REJECT - Nothing selected");
                dtde.rejectDrop();
                return;
            }
            if (destinationPath == null) {
                destinationPath = new TreePath(treeRoot);
            }
            if ((newParent = (CustomTreeNode)destinationPath.getLastPathComponent()).isFile()) {
                newParent = (CustomTreeNode)newParent.getParent();
                destinationPath = new TreePath(newParent.getPath());
            }
            int i2 = 0;
            while (i2 < selectedPaths.length) {
                if (selectedPaths[i2] == null) {
                    UIUtils.debugPrintln("NULL selection?!?!?!");
                } else {
                    CustomTreeNode nodeToTransfer = (CustomTreeNode)selectedPaths[i2].getLastPathComponent();
                    oldParent = (CustomTreeNode)nodeToTransfer.getParent();
                    if (!destinationPath.equals(selectedPaths[i2])) {
                        if (destinationPath.equals(selectedPaths[i2].getParentPath())) {
                            String opn = oldParent != null ? oldParent.getFilePath() : "?";
                        } else {
                            String msg;
                            if (!nodeToTransfer.isDeletable()) {
                                msg = localStrings.getLocalString("ui.uijarpackager.cannot_move", "You can not move {0} Node!", new Object[]{nodeToTransfer});
                                UIUtils.debugPrintln("REJECT - Error: " + msg);
                                dtde.rejectDrop();
                                this.deferredErrorDialog(msg);
                                return;
                            }
                            if (destinationPath.toString().indexOf(selectedPaths[i2].toString()) >= 0) {
                                msg = localStrings.getLocalString("ui.uijarpackager.parentcannotbemovedtochild", "Parent can not be moved to child.");
                                UIUtils.debugPrintln("REJECT - Error: " + msg);
                                dtde.rejectDrop();
                                this.deferredErrorDialog(msg);
                                return;
                            }
                            if (!this.finalRelease) {
                                if (!nodeToTransfer.getFileExists()) {
                                    UIUtils.debugPrintln("REJECT - Location of original file unknown (1)");
                                    dtde.rejectDrop();
                                    this.deferredErrorDialog(UIJarPackager.ERR_CANNOT_MOVE_COPY(nodeToTransfer));
                                    return;
                                }
                                if (!this.newPathExists(newParent, nodeToTransfer)) {
                                    UIUtils.debugPrintln("REJECT - New path does not exist on underlying OS (1)");
                                    dtde.rejectDrop();
                                    this.deferredErrorDialog(UIJarPackager.ERR_CANNOT_MOVE_COPY(nodeToTransfer));
                                    return;
                                }
                            }
                            validPaths.add(selectedPaths[i2]);
                        }
                    }
                }
                ++i2;
            }
            dtde.acceptDrop(2);
            dtde.getDropTargetContext().dropComplete(true);
        } else {
            selectedPaths = dragSel;
            if (selectedPaths == null) {
                UIUtils.debugPrintln("REJECT - Nothing selected");
                dtde.rejectDrop();
                return;
            }
            CustomTreeNode customTreeNode = newParent = destinationPath != null ? (CustomTreeNode)destinationPath.getLastPathComponent() : treeRoot;
            if (newParent == null) {
                UIUtils.debugPrintln("REJECT - No Destination to accept Drop");
                dtde.rejectDrop();
                return;
            }
            if (newParent.isFile()) {
                newParent = (CustomTreeNode)newParent.getParent();
            }
            int i3 = 0;
            while (i3 < selectedPaths.length) {
                CustomTreeNode nodeToTransfer = (CustomTreeNode)selectedPaths[i3].getLastPathComponent();
                if (this.isTypeWebRes()) {
                    validPaths.add(selectedPaths[i3]);
                } else {
                    CustomTreeNode existingNode = UIJarPackager.getChildNode(newParent, nodeToTransfer);
                    if (existingNode != null && !existingNode.isDeletable() && !existingNode.isReferenced()) {
                        UIUtils.debugPrintln("REJECT - Cannot overwrite node");
                        dtde.rejectDrop();
                        this.deferredErrorDialog(localStrings.getLocalString("ui.uijarpackager.cannot_overwrite", "You can not overwrite {0} node!", new Object[]{nodeToTransfer.getNodeName()}));
                        return;
                    }
                    if (!this.finalRelease && newParent != treeRoot) {
                        if (!nodeToTransfer.getFileExists()) {
                            UIUtils.debugPrintln("REJECT - Location of original file unknown (2)");
                            dtde.rejectDrop();
                            this.deferredErrorDialog(UIJarPackager.ERR_CANNOT_MOVE_COPY(nodeToTransfer));
                            return;
                        }
                        if (!this.newPathExists(newParent, nodeToTransfer)) {
                            UIUtils.debugPrintln("REJECT - New path does not exist on underlying OS (2)");
                            dtde.rejectDrop();
                            this.deferredErrorDialog(UIJarPackager.ERR_CANNOT_MOVE_COPY(nodeToTransfer));
                            return;
                        }
                    }
                    validPaths.add(selectedPaths[i3]);
                }
                ++i3;
            }
            dtde.acceptDrop(2);
            dtde.getDropTargetContext().dropComplete(true);
        }
        EventQueue.invokeLater(new UIActionDispatcher((Object)this, "_transferFiles", new Object[]{validPaths, newParent, new Boolean(isLocal)}));
    }

    public void _transferFiles(Vector validPaths, CustomTreeNode newParent, Boolean _isLocal) {
        TreePath[] selPaths = validPaths.toArray(new TreePath[0]);
        this._addDestTreePath(selPaths, newParent, _isLocal);
    }

    private void deferredErrorDialog(String msg) {
        EventQueue.invokeLater(new UIActionDispatcher((Object)this, "_deferredErrorDialog", new Object[]{msg}));
    }

    public void _deferredErrorDialog(String msg) {
        UIOptionPane.showErrorDialog(this, msg);
    }

    public static void printFileContentsDescriptor(FileContentsDescriptor fcd, String title) {
        UIJarPackager.printFileContentsDescriptor(fcd, title, null);
    }

    public static void printFileContentsDescriptor(FileContentsDescriptor fcd, String title, String only) {
        UIUtils.debugPrintln("Printing FileContentDescriptor contents ...");
        if (fcd == null || fcd.getFilesSet().isEmpty()) {
            return;
        }
        UIUtils.println("\n=== FileContentDescriptor: " + (title != null ? title : ""));
        Enumeration e10 = fcd.getFiles();
        while (e10.hasMoreElements()) {
            File f2 = (File)e10.nextElement();
            File d10 = fcd.getDirectoryFor(f2);
            if (only != null && f2.toString().indexOf(only) < 0) continue;
            UIUtils.println("  FCD: File=" + f2.toString() + ", \tDir=" + d10.toString());
        }
        UIUtils.println("");
    }

    public static void printArchiveHash(Hashtable hash, String title) {
        UIUtils.debugPrintln("Printing Hashtable contents ...");
        if (hash == null || hash.isEmpty()) {
            return;
        }
        UIUtils.println("\n=== Hashtable contents: " + (title != null ? title : ""));
        Enumeration e10 = hash.keys();
        while (e10.hasMoreElements()) {
            Object k2 = e10.nextElement();
            String kt = k2 instanceof String ? "" : "(" + k2.getClass().getName() + ")";
            Object v2 = hash.get(k2);
            String vt = v2 instanceof File ? "" : "(" + v2.getClass().getName() + ")";
            UIUtils.println("  Hashtable: Key" + kt + "=" + k2.toString() + ", \t" + "Val" + vt + "=" + v2.toString());
        }
        UIUtils.println("");
    }

    public static void printFileList(Vector fileList, String title) {
        UIUtils.debugPrintln("Printing FileList contents ...");
        if (fileList == null || fileList.isEmpty()) {
            return;
        }
        UIUtils.println("\n=== FileList: " + (title != null ? title : ""));
        Enumeration e10 = fileList.elements();
        while (e10.hasMoreElements()) {
            Object f2 = e10.nextElement();
            if (f2 instanceof File) {
                UIUtils.println("  List: File=" + ((File)f2).getPath());
                continue;
            }
            if (f2 instanceof String) {
                UIUtils.println("  List: Arch=" + f2.toString());
                continue;
            }
            UIUtils.println("  List: " + f2.getClass().getName() + "=" + f2.toString());
        }
        UIUtils.println("");
    }

    public static boolean validateArchiveHash(Hashtable hash) {
        if (hash != null) {
            Enumeration e10 = hash.keys();
            while (e10.hasMoreElements()) {
                Object k2 = e10.nextElement();
                if (!(k2 instanceof String)) {
                    UIUtils.debugImplementationError("Key contains non-String types: " + k2.getClass().getName());
                    return false;
                }
                Object v2 = hash.get(k2);
                if (v2 instanceof File) continue;
                UIUtils.debugImplementationError("Value contains non-File types: " + v2.getClass().getName());
                return false;
            }
        }
        return true;
    }

    private FileContentsDescriptor getNodeContents(boolean classContent, FileContentsDescriptor fcd, CustomTreeNode node, boolean includeAlternate) {
        if (fcd == null) {
            fcd = new FileContentsDescriptor();
        }
        this._loadContents(classContent, fcd, node, includeAlternate);
        return fcd;
    }

    private FileContentsDescriptor _loadContents(boolean classContent, FileContentsDescriptor fcd, CustomTreeNode node, boolean includeAlternate) {
        Hashtable filesAltMap = this.destTreeView.getAltContentFiles();
        Enumeration<TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            CustomTreeNode child = (CustomTreeNode)enumeration.nextElement();
            if (child.isLeaf() && !child.isDirectory()) {
                if (child.isFixedNode()) continue;
                String archKey = child.getArchiveKey(false);
                if (this.isTypeWebRes()) {
                    String fileName = FileSeparator + UIJarPackager.ToFileSep(archKey);
                    CustomFile file = new CustomFile(fileName, false);
                    fcd.add(file, new File(""));
                    continue;
                }
                String archKeyNormal = UIJarPackager._normalizeArchiveName(archKey);
                String rootDirString = child.getFileRootPath();
                if (rootDirString.equals("")) {
                    if (!includeAlternate || filesAltMap == null || !filesAltMap.containsKey(archKey)) continue;
                    fcd.add(new File(UIJarPackager.ToFileSep(archKeyNormal)), new File(""));
                    continue;
                }
                fcd.add(new File(UIJarPackager.ToFileSep(archKeyNormal)), new File(UIJarPackager.ToFileSep(rootDirString)));
                continue;
            }
            if (!this.isTypeWebWar()) {
                this._loadContents(classContent, fcd, child, includeAlternate);
                continue;
            }
            if (child == this.getDestClassesNode() || child == this.getDestLibNode()) continue;
            this._loadContents(classContent, fcd, child, includeAlternate);
        }
        return fcd;
    }

    private static String _normalizeArchiveName(String name) {
        if (name == null) {
            return null;
        }
        if ((name = UIJarPackager.ToArchSep(name)).startsWith(WEB_INF)) {
            if (name.equals(WEB_INF_CLASSES)) {
                name = "";
            } else if (name.startsWith(WEB_INF_CLASSES_)) {
                name = name.substring(WEB_INF_CLASSES_.length());
            } else if (name.equals(WEB_INF_LIB)) {
                name = "";
            } else if (name.startsWith(WEB_INF_LIB_)) {
                name = name.substring(WEB_INF_LIB_.length());
            } else if (name.equals(WEB_INF)) {
                name = "";
            } else if (name.startsWith(WEB_INF_)) {
                name = name.substring(WEB_INF_.length());
            }
        }
        if (name.endsWith(ArchSeparator)) {
            name = name.substring(0, name.length() - ArchSeparator.length());
        }
        return name;
    }

    private void scrollTreeView(Point pt) {
        JViewport viewPort = (JViewport)this.destTree.getParent();
        TreePath path = this.destTree.getPathForLocation(pt.x, pt.y);
        CustomTreeNode node = (CustomTreeNode)path.getLastPathComponent();
        if (node == null) {
            return;
        }
        int level = node.getLevel();
        String nodeName = node.getNodeName();
        Dimension visibleSize = viewPort.getExtentSize();
        Point pos = viewPort.getViewPosition();
        Rectangle viewableRect = viewPort.getViewRect();
        Rectangle contentRect = null;
        int x1 = pos.x;
        int y1 = pos.y;
        int height = (int)viewableRect.getWidth();
        int width = (int)viewableRect.getHeight();
        int y2 = y1 + (int)this.destTreeView.getSize().getHeight();
        if (pt.y >= y2 - 7) {
            contentRect = new Rectangle(x1, ++y1, width, height);
            viewPort.scrollRectToVisible(contentRect);
        }
        if (pt.y - 2 <= y1 && pt.y > 5) {
            if (level == 1 && (nodeName.equals(META_INF) || nodeName.equals(WEB_INF))) {
                return;
            }
            viewPort.setViewPosition(new Point(pos.x, pos.y - 5));
            viewPort.setExtentSize(visibleSize);
        }
    }

    private void pasteGivenNode(boolean isLocal, Vector addedNodes, CustomTreeNode dropParent, CustomTreeNode nodeToPaste, String localPath) {
        if (!nodeToPaste.getFileExists()) {
            UIUtils.debugPrintln("File does not exist on system: " + nodeToPaste.getFilePath());
            return;
        }
        if (nodeToPaste.isFile()) {
            CustomTreeNode subNode;
            CustomTreeNode parent;
            boolean parseClasses = !isLocal;
            boolean destIsWebInf = false;
            String filename = nodeToPaste.getFileName();
            CustomTreeNode topFixedNode = this.getDestTreeView().getParentFixedNode(dropParent);
            if (this.isTypeWebWar()) {
                TreeNode[] tn = dropParent.getPath();
                CustomTreeNode webInf = this.getDestWebInfNode();
                boolean bl2 = destIsWebInf = tn.length >= 2 && (tn[0] == webInf || tn[1] == webInf);
                if (destIsWebInf || UIJarPackager.StrFileEndsWith(filename, DOT_TLD)) {
                    parseClasses = true;
                }
            }
            if (parseClasses && this.isTypeWebWar() && UIJarPackager.StrFileEndsWith(filename, DOT_JAR)) {
                parent = topFixedNode == this.getDestLibNode() ? dropParent : this.getDestLibNode();
                subNode = this.getDestTreeView().makeDirStructure(parent, UIJarPackager.TokenizePath(localPath));
                this.getDestTreeView().addChildNode(subNode, nodeToPaste);
            } else if (parseClasses && this.isTypeWebWar() && UIJarPackager.StrFileEndsWith(filename, DOT_TLD)) {
                parent = topFixedNode == this.getDestWebInfNode() ? dropParent : this.getDestWebInfNode();
                subNode = this.getDestTreeView().makeDirStructure(parent, UIJarPackager.TokenizePath(localPath));
                this.getDestTreeView().addChildNode(subNode, nodeToPaste);
            } else if (!this.isTypeWebRes() && UIJarPackager.StrFileEndsWith(filename, DOT_CLASS)) {
                String className = this.getFullClassName(nodeToPaste.getFile(), true);
                if (className == null) {
                    UIOptionPane.showWarningDialog(this, UIJarPackager.ERR_CORRUPT_CLASSFILE(nodeToPaste.getFile().getPath()));
                    return;
                }
                String parentDir = nodeToPaste.getFileParent();
                if (!this.finalRelease) {
                    String classFilePath;
                    String childPath = nodeToPaste.getFilePath();
                    if (UIJarPackager.StrFileEndsWith(childPath, classFilePath = className.replace('.', FileSeparatorChar) + DOT_CLASS)) {
                        parentDir = childPath.substring(0, childPath.length() - classFilePath.length());
                    } else {
                        UIOptionPane.showWarningDialog(this, UIJarPackager.ERR_PACKAGE_DIR(className));
                        return;
                    }
                }
                String packageName = className.indexOf(46) > 0 ? className.substring(0, className.lastIndexOf(46)) : "";
                CustomTreeNode fixedNode = parseClasses ? this.getDestClassesNode() : topFixedNode;
                CustomTreeNode subNode2 = this.getDestTreeView().makeDirStructure(fixedNode, UIJarPackager.TokenizePackage(packageName));
                this.getDestTreeView().addChildNode(subNode2, nodeToPaste);
            } else {
                if (destIsWebInf) {
                    UIOptionPane.showWarningDialog(this, UIJarPackager.ERR_CANNOT_MOVE_COPY(nodeToPaste));
                    return;
                }
                CustomTreeNode subNode3 = this.getDestTreeView().makeDirStructure(dropParent, UIJarPackager.TokenizePath(localPath));
                this.getDestTreeView().addChildNode(subNode3, nodeToPaste);
            }
            addedNodes.add(nodeToPaste);
            return;
        }
        if (isLocal) {
            UIUtils.printImplementationError("This method shold not be called with a 'local' dir");
        }
        Vector<Serializable> fileSet = new Vector<Serializable>();
        Vector<Serializable> dirSet = new Vector<Serializable>();
        if (isLocal) {
            Enumeration<TreeNode> e10 = nodeToPaste.children();
            while (e10.hasMoreElements()) {
                CustomTreeNode child = (CustomTreeNode)e10.nextElement();
                if (child.isFile()) {
                    fileSet.add(child);
                    continue;
                }
                dirSet.add(child);
            }
        } else {
            Vector nodes = nodeToPaste.getFile().getDirContents();
            if (nodes != null) {
                Enumeration e11 = nodes.elements();
                while (e11.hasMoreElements()) {
                    CustomFile child = (CustomFile)e11.nextElement();
                    if (child.isFile()) {
                        fileSet.add(child);
                        continue;
                    }
                    dirSet.add(child);
                }
            }
        }
        Comparator sort = UIJarPackager.getNodeComparator();
        Collections.sort(fileSet, sort);
        Collections.sort(dirSet, sort);
        localPath = localPath + nodeToPaste.getFileName() + ArchSeparator;
        Object[] dirs = dirSet.toArray();
        int i2 = 0;
        while (i2 < dirs.length) {
            CustomTreeNode dirNode = dirs[i2] instanceof CustomTreeNode ? (CustomTreeNode)dirs[i2] : new CustomTreeNode((CustomFile)dirs[i2]);
            this.pasteGivenNode(isLocal, addedNodes, dropParent, dirNode, localPath);
            ++i2;
        }
        Object[] leaves = fileSet.toArray();
        int i3 = 0;
        while (i3 < leaves.length) {
            CustomTreeNode fileNode = leaves[i3] instanceof CustomTreeNode ? (CustomTreeNode)leaves[i3] : new CustomTreeNode((CustomFile)leaves[i3]);
            this.pasteGivenNode(isLocal, addedNodes, dropParent, fileNode, localPath);
            ++i3;
        }
    }

    private void readDescriptor(PackagerTreeView pkgTreeView) {
        DestinationTreeView dtView = pkgTreeView instanceof DestinationTreeView ? (DestinationTreeView)pkgTreeView : null;
        Hashtable filesMap = pkgTreeView.getContentFiles();
        if (filesMap == null) {
            return;
        }
        Hashtable filesAltMap = pkgTreeView.getAltContentFiles();
        Vector archKeysSet = new Vector();
        Enumeration fileMapKeyEnum = filesMap.keys();
        while (fileMapKeyEnum.hasMoreElements()) {
            archKeysSet.add(fileMapKeyEnum.nextElement());
        }
        Comparator archKeySort = UIJarPackager.getArchiveComparator();
        Collections.sort(archKeysSet, archKeySort);
        Enumeration enumeration = archKeysSet.elements();
        while (enumeration.hasMoreElements()) {
            Object nextKey = enumeration.nextElement();
            Object nextVal = filesMap.get(nextKey);
            String archFile = nextKey.toString();
            if (archFile.endsWith(ArchSeparator)) continue;
            String archPath = archFile.indexOf(47) >= 0 ? archFile.substring(0, archFile.lastIndexOf(47)) : "";
            String archFile_ = this.isTypeWebWar() || this.isTypeWebRes() ? UIJarPackager._normalizeArchiveName(archFile) : archFile;
            String archFileLocal = UIJarPackager.ToFileSep(archFile_);
            String diskFile = null;
            CustomFile diskChild = null;
            if (this.isTypeWebRes()) {
                diskFile = UIJarPackager.ToFileSep(archFile);
                diskChild = new CustomFile(diskFile, false);
            } else {
                diskFile = nextVal.toString();
                diskChild = new CustomFile(diskFile, true);
            }
            diskChild.setArchiveKey(archFile);
            String diskChildName = diskChild.getName();
            if (diskChildName.equals(MANIFEST_MF)) continue;
            String relativePath = null;
            if (diskChild.isAbsolute()) {
                if (UIJarPackager.StrFileEndsWith(diskFile, archFileLocal)) {
                    relativePath = diskFile.substring(0, diskFile.length() - archFileLocal.length());
                } else {
                    relativePath = "";
                    UIUtils.debugPrintln("Relative file '" + archFileLocal + "' not found in '" + diskFile + "'");
                }
            } else {
                relativePath = archFile.equals(diskFile) && !archFile.equals(archFile_) ? "" : "";
            }
            if (filesAltMap != null && filesAltMap.containsKey(nextKey)) {
                diskChild.setDeletable(NONDEL_BUNDLE_CONTENT);
            } else if (dtView != null) {
                String reason = UIJarPackager._isItemReferenced(archFile_, dtView.getBundleDescriptor());
                diskChild.setDeletable(reason);
                diskChild.setReferenced(reason != null);
            } else {
                diskChild.setDeletable(true);
            }
            String fullName = archPath;
            if (!this.finalRelease && UIJarPackager.StrFileEndsWith(diskChildName, DOT_CLASS)) {
                String className = this.getFullClassName(diskChild, false);
                if (className == null) {
                    String fn = diskChild.getName();
                    className = fn.substring(0, fn.lastIndexOf(46));
                }
                String classPackage = className.indexOf(46) >= 0 ? className.substring(0, className.lastIndexOf(46)) : "";
                String packagePath = classPackage.replace('.', '/');
                if (archFile.equals(diskChildName)) {
                    fullName = packagePath;
                } else if (!UIJarPackager.StrFileEndsWith(fullName, packagePath)) {
                    fullName = fullName + ArchSeparator + packagePath;
                }
            }
            CustomTreeNode rootNode = pkgTreeView.getRootNode();
            CustomTreeNode parentNode = pkgTreeView.makeDirStructure(rootNode, UIJarPackager.TokenizePath(archPath));
            CustomTreeNode diskChildNode = new CustomTreeNode(diskChild);
            pkgTreeView.addChildNode(parentNode, diskChildNode);
        }
        if (dtView != null) {
            CustomTreeNode node;
            if (this.isTypeEjbJar()) {
                node = UIJarPackager.getChildNode(dtView.fixedMetaInfNode, XML_EJB_JAR);
                if (node == null) {
                    node = new CustomTreeNode(new CustomFile(XML_EJB_JAR, false));
                    pkgTreeView.addChildNode(dtView.fixedMetaInfNode, node);
                }
                node.getFile().setDeletable(NONDEL_FIXED_XML);
                node.setFixedNode(true);
            } else if (this.isTypeWebWar()) {
                node = UIJarPackager.getChildNode(dtView.fixedWebInfNode, XML_WEB);
                if (node == null) {
                    node = new CustomTreeNode(new CustomFile(XML_WEB, false));
                    pkgTreeView.addChildNode(dtView.fixedWebInfNode, node);
                }
                node.getFile().setDeletable(NONDEL_FIXED_XML);
                node.setFixedNode(true);
            } else if (this.isTypeAppCli()) {
                node = UIJarPackager.getChildNode(dtView.fixedMetaInfNode, XML_APP_CLIENT);
                if (node == null) {
                    node = new CustomTreeNode(new CustomFile(XML_APP_CLIENT, false));
                    pkgTreeView.addChildNode(dtView.fixedMetaInfNode, node);
                }
                node.getFile().setDeletable(NONDEL_FIXED_XML);
                node.setFixedNode(true);
            } else if (this.isTypeResRar()) {
                node = UIJarPackager.getChildNode(dtView.fixedMetaInfNode, XML_RAR);
                if (node == null) {
                    node = new CustomTreeNode(new CustomFile(XML_RAR, false));
                    pkgTreeView.addChildNode(dtView.fixedMetaInfNode, node);
                }
                node.getFile().setDeletable(NONDEL_FIXED_XML);
                node.setFixedNode(true);
            }
        }
    }

    private String getFullClassName(CustomFile child, boolean shouldExist) {
        String fullName = child.getName();
        if (!UIJarPackager.StrFileEndsWith(fullName, DOT_CLASS)) {
            return fullName;
        }
        try {
            String className = new UIClassPackage(child).getClassName();
            return !className.equals("") ? className : fullName;
        }
        catch (FileNotFoundException fnfe) {
            if (shouldExist) {
                UIUtils.println("Class file not found: " + child.getPath());
            }
        }
        catch (Throwable e10) {
            UIUtils.println("Possible corrupted class file: " + child.getPath());
            return null;
        }
        String classArch = child.getArchivePath();
        if (classArch.startsWith(WEB_INF_CLASSES_)) {
            classArch = classArch.substring(WEB_INF_CLASSES_.length());
        }
        String className = classArch.substring(0, classArch.lastIndexOf(46));
        return UIJarPackager.ToClassSep(className);
    }

    private static String _isItemReferenced(String nameFile, BundleDescriptor bundleDesc) {
        boolean isClass = UIJarPackager.StrFileEndsWith(nameFile, DOT_CLASS);
        boolean isJsp = UIJarPackager.StrFileEndsWith(nameFile, DOT_JSP);
        String name = null;
        if (isClass) {
            name = nameFile.substring(0, nameFile.length() - DOT_CLASS.length());
            if (name.startsWith(WEB_INF_CLASSES_)) {
                name = name.substring(WEB_INF_CLASSES_.length());
            }
            name = UIJarPackager.ToClassSep(name);
        } else {
            name = UIJarPackager.ToArchSep(nameFile);
        }
        if (bundleDesc instanceof EjbBundleDescriptor) {
            Iterator ejbs = ((EjbBundleDescriptor)bundleDesc).getEjbs().iterator();
            while (ejbs.hasNext()) {
                EjbDescriptor ejbd = (EjbDescriptor)ejbs.next();
                if (ejbd == null) continue;
                if (isClass) {
                    if (!UIJarPackager.StrClassEquals(ejbd.getEjbClassName(), name) && !UIJarPackager.StrClassEquals(ejbd.getHomeClassName(), name) && !UIJarPackager.StrClassEquals(ejbd.getRemoteClassName(), name)) continue;
                    return NONDEL_EJB_REFERENCE;
                }
                if (!UIJarPackager.StrFileEquals(ejbd.getSmallIconUri(), name) && !UIJarPackager.StrFileEquals(ejbd.getLargeIconUri(), name)) continue;
                return NONDEL_ICON_REFERENCE;
            }
        } else if (bundleDesc instanceof WebBundleDescriptor) {
            Iterator webs = ((WebBundleDescriptor)bundleDesc).getWebComponentDescriptorsSet().iterator();
            while (webs.hasNext()) {
                Descriptor wd = (Descriptor)webs.next();
                if (wd == null) continue;
                if (isClass) {
                    if (!(wd instanceof ServletDescriptorImpl) || !UIJarPackager.StrClassEquals(((ServletDescriptorImpl)wd).getClassName(), name)) continue;
                    return NONDEL_SERVLET_REFERENCE;
                }
                if (isJsp) {
                    if (!(wd instanceof JspDescriptorImpl)) continue;
                    String jsp = ((JspDescriptorImpl)wd).getJspFileName();
                    if (jsp.startsWith(ArchSeparator)) {
                        jsp = jsp.substring(ArchSeparator.length());
                    }
                    if (!jsp.equals(name)) continue;
                    return NONDEL_JSP_REFERENCE;
                }
                if (!UIJarPackager.StrFileEquals(wd.getSmallIconUri(), name) && !UIJarPackager.StrFileEquals(wd.getLargeIconUri(), name)) continue;
                return NONDEL_ICON_REFERENCE;
            }
        } else if (bundleDesc instanceof ConnectorDescriptor) {
            ConnectorDescriptor cd2 = (ConnectorDescriptor)bundleDesc;
            if (isClass) {
                if (UIJarPackager.StrClassEquals(cd2.getConnectionFactoryInterface(), name)) {
                    return NONDEL_RESADAPT_REFERENCE;
                }
                if (UIJarPackager.StrClassEquals(cd2.getConnectionFactoryImpl(), name)) {
                    return NONDEL_RESADAPT_REFERENCE;
                }
                if (UIJarPackager.StrClassEquals(cd2.getConnectionInterface(), name)) {
                    return NONDEL_RESADAPT_REFERENCE;
                }
                if (UIJarPackager.StrClassEquals(cd2.getConnectionImpl(), name)) {
                    return NONDEL_RESADAPT_REFERENCE;
                }
                if (UIJarPackager.StrClassEquals(cd2.getManagedConnectionFactoryImpl(), name)) {
                    return NONDEL_RESADAPT_REFERENCE;
                }
            }
        } else if (bundleDesc instanceof ApplicationClientDescriptor) {
            ApplicationClientDescriptor acd = (ApplicationClientDescriptor)bundleDesc;
            if (isClass) {
                if (UIJarPackager.StrClassEquals(acd.getMainClassName(), name)) {
                    return NONDEL_APPCLIENT_REFERENCE;
                }
                if (UIJarPackager.StrClassEquals(acd.getCallbackHandler(), name)) {
                    return NONDEL_APPCLIENT_REFERENCE;
                }
            }
        } else {
            UIUtils.debugPrintln("No BundleDescriptor specified");
        }
        if (bundleDesc != null && (UIJarPackager.StrFileEquals(bundleDesc.getSmallIconUri(), name) || UIJarPackager.StrFileEquals(bundleDesc.getLargeIconUri(), name))) {
            return NONDEL_ICON_REFERENCE;
        }
        return null;
    }

    private boolean newPathExists(CustomTreeNode newParent, CustomTreeNode node) {
        boolean match;
        String parFileKey = UIJarPackager.ToFileSep(newParent.getArchiveKey(true));
        if (!parFileKey.equals("")) {
            parFileKey = FileSeparator + parFileKey;
        }
        String nodeFileKey = parFileKey + FileSeparator + node.getFileName();
        String nodeFilePath = node.getFilePath();
        if (!nodeFilePath.startsWith(FileSeparator)) {
            nodeFilePath = FileSeparator + nodeFilePath;
        }
        if (!(match = UIJarPackager.StrFileEndsWith(nodeFilePath, nodeFileKey))) {
            UIUtils.debugPrintln("Mismatch: " + nodeFilePath + " => " + nodeFileKey);
        }
        return match;
    }

    private void expandNode(CustomTreeNode node) {
        CustomTreeNode parent;
        CustomTreeNode customTreeNode = parent = node != null ? (CustomTreeNode)node.getParent() : null;
        if (parent != null) {
            this.destTree.expandPath(new TreePath(parent.getPath()));
            this.destTree.scrollPathToVisible(new TreePath(node.getPath()));
        }
    }

    private DefaultTreeModel getDestTreeModel() {
        return (DefaultTreeModel)this.destTree.getModel();
    }

    private CustomTreeNode getDestTreeRoot() {
        return (CustomTreeNode)this.getDestTreeModel().getRoot();
    }

    private CustomTreeNode getDestClassesNode() {
        return this.isTypeWebWar() ? this.destTreeView.fixedClassesNode : this.getDestRootNode();
    }

    private CustomTreeNode getDestLibNode() {
        return this.destTreeView.fixedLibNode;
    }

    private CustomTreeNode getDestWebInfNode() {
        return this.destTreeView.fixedWebInfNode;
    }

    private CustomTreeNode getDestMetaInfNode() {
        return this.destTreeView.fixedMetaInfNode;
    }

    private CustomTreeNode getDestRootNode() {
        return this.destTreeView.fixedRootNode;
    }

    private void _selectionChanged(JTree tree) {
        if (this._selChangeRecursion > 0) {
            return;
        }
        ++this._selChangeRecursion;
        JTree srcTree = this.getSrcTreeView().getTree();
        JTree dstTree = this.getDestTreeView().getTree();
        if (tree == dstTree) {
            if (this.dragInitiator == null) {
                srcTree.clearSelection();
                this.btnAdd.setEnabled(false);
                TreePath[] dstPath = dstTree.getSelectionPaths();
                if (dstPath != null) {
                    boolean canDel = false;
                    String reason = null;
                    int i2 = 0;
                    while (i2 < dstPath.length) {
                        CustomTreeNode node = (CustomTreeNode)dstPath[i2].getLastPathComponent();
                        if (node.isDeletable()) {
                            canDel = true;
                            reason = CLICK_TO_REMOVE;
                            break;
                        }
                        reason = reason == null ? node.getFile().getNonDeletableReason() : NON_REMOVABLE;
                        ++i2;
                    }
                    this.btnRemoveEnabled = canDel;
                    this.btnRemove.setEnabled(canDel);
                    this.btnRemove.setMnemonic(canDel ? this.btnRemoveMnemonic : (char)'\u0000');
                    this.btnRemove.setToolTipText(reason != null ? reason : NON_REMOVABLE);
                } else {
                    this.btnRemoveEnabled = false;
                    this.btnRemove.setEnabled(false);
                    this.btnRemove.setMnemonic(0);
                    this.btnRemove.setToolTipText(NOTHING_SELECTED);
                }
            }
        } else if (tree instanceof SourceTree) {
            dstTree.clearSelection();
            this.btnAdd.setEnabled(srcTree.getSelectionPath() != null);
            this.btnRemoveEnabled = false;
            this.btnRemove.setEnabled(false);
            this.btnRemove.setMnemonic(0);
            this.btnRemove.setToolTipText(NOTHING_SELECTED);
        }
        --this._selChangeRecursion;
    }

    public PackagerTreeViewInterface getDestinationTreeView() {
        DestinationTreeView dtv = new DestinationTreeView(new DestinationTree(false));
        dtv.setClearWhenDisabled(true);
        return dtv;
    }

    private DestinationTreeView getDestTreeView() {
        if (this.destTreeView == null) {
            this.destTreeView = new DestinationTreeView(null);
            this.destTree = (DestinationTree)this.destTreeView.getTree();
            this.destTree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent tse) {
                    UIJarPackager.this._selectionChanged((JTree)tse.getSource());
                }
            });
            this.destTree.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    if (!UIJarPackager.this.isTypeWebRes() && evt.getKeyCode() == 127) {
                        UIJarPackager.this.removeAction();
                    }
                }
            });
            this.destTree.getInputMap().put(KeyStroke.getKeyStroke(88, 2), "cutAction");
            this.destTree.getInputMap().put(KeyStroke.getKeyStroke(86, 2), "pasteAction");
            this.destTree.getActionMap().put("cutAction", new AbstractAction(){

                public void actionPerformed(ActionEvent evt) {
                }
            });
            this.destTree.getActionMap().put("pasteAction", new AbstractAction(){

                public void actionPerformed(ActionEvent evt) {
                }
            });
        }
        return this.destTreeView;
    }

    private SourceTreeView getSrcTreeView() {
        if (this.srcTreeView == null) {
            this.srcTreeView = new SourceTreeView(null);
            this.srcTree = (SourceTree)this.srcTreeView.getTree();
            this.srcTree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent tse) {
                    SourceTree tree = (SourceTree)tse.getSource();
                    CustomTreeNode node = (CustomTreeNode)tree.getLastSelectedPathComponent();
                    if (node != null) {
                        if (node.isDirectory() && node.getChildCount() == 0) {
                            tree.makeNode(node);
                        }
                        tree.grabFocus();
                    }
                    UIJarPackager.this._selectionChanged(tree);
                }
            });
            this.srcTree.addTreeWillExpandListener(new TreeWillExpandListener(){

                public void treeWillExpand(TreeExpansionEvent tee) {
                    boolean alwaysRefreshDir = true;
                    SourceTree tree = (SourceTree)tee.getSource();
                    CustomTreeNode node = (CustomTreeNode)tee.getPath().getLastPathComponent();
                    if (node != null) {
                        if (alwaysRefreshDir) {
                            tree.makeNode(node);
                        } else if (node.isDirectory() && node.getChildCount() == 0) {
                            tree.makeNode(node);
                        }
                        tree.grabFocus();
                    }
                }

                public void treeWillCollapse(TreeExpansionEvent tee) {
                }
            });
            this.srcTree.getInputMap().put(KeyStroke.getKeyStroke(67, 2), "copyAction");
            this.srcTree.getActionMap().put("copyAction", new AbstractAction(){

                public void actionPerformed(ActionEvent evt) {
                }
            });
        }
        return this.srcTreeView;
    }

    private static CustomTreeNode getChildNode(CustomTreeNode parent, CustomTreeNode child) {
        return UIJarPackager.getChildNode(parent, child.getNodeName());
    }

    private static CustomTreeNode getChildNode(CustomTreeNode parent, String givenChildName) {
        Enumeration<TreeNode> children = parent.children();
        while (children.hasMoreElements()) {
            CustomTreeNode node = (CustomTreeNode)children.nextElement();
            if (!UIJarPackager.StrFileEquals(node.getNodeName(), givenChildName)) continue;
            return node;
        }
        return null;
    }

    public static FileContentsDescriptor getMergedFileContentDescriptor(Object src, Object alt) {
        return UIJarPackager.getMergedFileContentDescriptor(src, alt, 0);
    }

    public static FileContentsDescriptor getMergedFileContentDescriptor(Object src, Object alt, int classOnly) {
        CustomFileContentsDescriptor fcd = new CustomFileContentsDescriptor();
        Hashtable hash = UIJarPackager._getMergedContentHashtable(src, alt, classOnly);
        if (hash == null) {
            UIUtils.debugPrintln("Contents is empty! (" + classOnly + ")");
            return fcd;
        }
        Enumeration e10 = hash.keys();
        while (e10.hasMoreElements()) {
            String keyStr = null;
            Object key = e10.nextElement();
            if (!(key instanceof String)) {
                UIUtils.debugImplementationError("Key is not a String: " + key.getClass().getName());
                keyStr = UIJarPackager.ToArchSep(key.toString());
            } else {
                keyStr = key.toString();
                if (IsDosFileSeparator && keyStr.indexOf(FileSeparator) >= 0) {
                    UIUtils.debugImplementationError("Unexpected FileSeparator in key: " + keyStr);
                    keyStr = UIJarPackager.ToArchSep(keyStr);
                }
            }
            String entry = UIJarPackager._normalizeArchiveName(keyStr);
            String file = UIJarPackager._normalizeArchiveName(hash.get(key).toString());
            if (UIJarPackager.StrFileEndsWith(file, entry)) {
                String n2 = file.substring(0, file.length() - entry.length());
                fcd.add(new File(UIJarPackager.ToFileSep(entry)), new File(UIJarPackager.ToFileSep(n2)));
                continue;
            }
            UIUtils.debugPrintln("No substring! " + entry + " => " + file);
        }
        UIJarPackager._addAlternateLibJar(fcd, alt);
        return fcd;
    }

    private static void _addAlternateLibJar(CustomFileContentsDescriptor fcd, Object altSrc) {
        if (altSrc instanceof BundleDescriptor) {
            Archivist arch;
            BundleDescriptor bd2 = (BundleDescriptor)altSrc;
            if (bd2.getApplication() != null) {
                try {
                    ClassLoader cl2 = bd2.getApplication().getApplicationArchivist().getClassLoader();
                    fcd.setBundleClassLoader(cl2);
                    return;
                }
                catch (Throwable t2) {
                    UIUtils.debugPrintln("Unable to get app classloader: " + t2.toString());
                }
            }
            if ((arch = bd2.getArchivist()) instanceof EjbBundleArchivist) {
                File jarFile = null;
                try {
                    jarFile = ((EjbBundleArchivist)arch).getArchiveFile_();
                    UIUtils.debugPrintln("EJB Archive file: " + jarFile.toString());
                }
                catch (IOException ioe) {
                    UIUtils.debugPrintln("Unable to get EJB archive file");
                    jarFile = new File(UIJarPackager.ToFileSep(arch.getArchiveUri()));
                }
                fcd.addLibraryJar(jarFile);
                return;
            }
            File jarFile = new File(UIJarPackager.ToFileSep(arch.getArchiveUri()));
            UIUtils.debugPrintln("Default Archive file: " + jarFile.toString());
            fcd.addLibraryJar(jarFile);
        }
    }

    private static Hashtable _getMergedContentHashtable(Object src, Object alt, int classOnly) {
        Hashtable altHash;
        Hashtable hash = UIJarPackager._getContentHashtable(src, classOnly);
        if (hash == null) {
            hash = new Hashtable();
        }
        if ((altHash = UIJarPackager._getContentHashtable(alt, classOnly)) != null) {
            Enumeration keys = altHash.keys();
            while (keys.hasMoreElements()) {
                Object obj = keys.nextElement();
                if (hash.contains(obj)) continue;
                hash.put(obj, altHash.get(obj));
            }
        }
        return hash.isEmpty() ? null : hash;
    }

    private static Hashtable _getContentHashtable(Object content, int classOnly) {
        Hashtable hash = null;
        if (content != null) {
            if (content instanceof WebBundleDescriptor) {
                hash = UIJarPackager._getBundleContents((WebBundleDescriptor)content, classOnly);
            } else if (content instanceof BundleDescriptor) {
                hash = UIJarPackager._getBundleContents((BundleDescriptor)content, 0);
            } else if (content instanceof Hashtable) {
                hash = (Hashtable)content;
            } else if (content instanceof FileContentsDescriptor) {
                hash = UIJarPackager.getFileContentHashtable((FileContentsDescriptor)content);
            } else {
                UIUtils.printImplementationError("Unsupported data source: " + content.getClass().getName());
            }
        }
        return hash;
    }

    private static Hashtable _getBundleContents(BundleDescriptor desc, int classOnly) {
        if (desc == null) {
            UIUtils.printImplementationError("NULL BundleDescriptor");
            return null;
        }
        Archivist arch = desc.getArchivist();
        if (arch == null) {
            UIUtils.debugPrintln("Could not get archivist: " + desc.getName());
            return null;
        }
        ProjectImpl prj = (ProjectImpl)Project.getProject(arch);
        if (prj == null) {
            UIUtils.debugPrintln("Could not get Project: " + desc.getName());
            return null;
        }
        Hashtable<String, File> filesMap = prj.getArchiveContent(arch);
        if ((filesMap == null || filesMap.size() <= 0) && filesMap == null) {
            filesMap = new Hashtable<String, File>();
        }
        try {
            Vector entries = arch.getEntryNames();
            Enumeration enumeration = entries.elements();
            while (enumeration.hasMoreElements()) {
                String item = enumeration.nextElement().toString();
                if (filesMap.containsKey(item)) continue;
                filesMap.put(item, new File(UIJarPackager.ToFileSep(item)));
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (desc instanceof WebBundleDescriptor) {
            Hashtable newHash = new Hashtable();
            Enumeration ke = filesMap.keys();
            while (ke.hasMoreElements()) {
                Object key = ke.nextElement();
                String key_ = key.toString();
                Object val = filesMap.get(key);
                if (classOnly == 0) {
                    newHash.put(key_, val);
                    continue;
                }
                if (UIJarPackager.StrFileEndsWith(key_, DOT_CLASS)) {
                    if (classOnly != 1) continue;
                    newHash.put(key_, val);
                    continue;
                }
                if (classOnly != 2) continue;
                newHash.put(key_, val);
            }
            filesMap = newHash;
        }
        return filesMap.size() > 0 ? filesMap : null;
    }

    public static Vector convertFilesToArchive(Vector fileList) {
        Vector<String> archPaths = new Vector<String>();
        Enumeration e10 = fileList.elements();
        while (e10.hasMoreElements()) {
            Object f2 = e10.nextElement();
            if (f2 instanceof File) {
                archPaths.add(UIJarPackager.ToArchSep(((File)f2).getPath()));
                continue;
            }
            if (f2 instanceof String) {
                archPaths.add(UIJarPackager.ToArchSep((String)f2));
                continue;
            }
            UIUtils.debugImplementationError("Not a File: " + f2.getClass().getName());
        }
        return archPaths;
    }

    public static String ToClassSep(String n2) {
        return n2.indexOf(FileSeparator) >= 0 ? n2.replace(FileSeparatorChar, '.') : n2.replace('/', '.');
    }

    public static String ToFileSep(String n2) {
        return n2.replace('/', FileSeparatorChar);
    }

    public static String ToArchSep(String n2) {
        return n2.replace(FileSeparatorChar, '/');
    }

    private static String _checkFileSeparators(String fp) {
        if (IsDosFileSeparator && fp.length() > 0) {
            if (fp.indexOf(ArchSeparator) >= 0) {
                UIUtils.debugImplementationError("Invalid file separator char found - correcting ...");
                fp = UIJarPackager.ToFileSep(fp);
            }
            if (fp.charAt(1) == ':' && Character.isUpperCase(fp.charAt(0))) {
                fp = fp.substring(0, 1).toLowerCase() + fp.substring(1);
            }
            if (fp.endsWith(":")) {
                fp = fp + FileSeparator;
            }
        }
        if (fp.endsWith(FileSeparator)) {
            int s2 = fp.lastIndexOf(":") + 1;
            int e10 = fp.length() - 1;
            while (e10 > s2 && fp.charAt(e10) == FileSeparatorChar) {
                --e10;
            }
            fp = fp.substring(0, e10 + 1);
        }
        return fp;
    }

    private static boolean StrFileStartsWith(String target, String test) {
        if (target == null) {
            return false;
        }
        return !IsDosFileSeparator ? target.startsWith(test) : target.toLowerCase().startsWith(test.toLowerCase());
    }

    private static boolean StrFileEndsWith(String target, String test) {
        if (target == null) {
            return false;
        }
        return !IsDosFileSeparator ? target.endsWith(test) : target.toLowerCase().endsWith(test.toLowerCase());
    }

    private static boolean StrClassEquals(String target, String test) {
        return target == null ? false : target.equals(test);
    }

    private static boolean StrFileEquals(String target, String test) {
        if (target == null) {
            return false;
        }
        return !IsDosFileSeparator ? target.equals(test) : target.equalsIgnoreCase(test);
    }

    private static Enumeration TokenizePath(String path) {
        String sep = IsDosFileSeparator ? ArchSeparator + FileSeparator : ArchSeparator;
        return new StringTokenizer(path, sep);
    }

    private static Enumeration TokenizePackage(String pkg) {
        return new StringTokenizer(pkg, ".");
    }

    private static int countChars(String s2, char c10) {
        char[] ch2 = s2.toCharArray();
        int count = 0;
        int i2 = 0;
        while (i2 < ch2.length) {
            if (ch2[i2] == c10) {
                ++count;
            }
            ++i2;
        }
        return count;
    }

    private static Comparator getArchiveComparator() {
        if (archiveComparator == null) {
            archiveComparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    int c22;
                    String s1 = o1.toString();
                    String s2 = o2.toString();
                    int c12 = UIJarPackager.countChars(s1, '/');
                    return c12 != (c22 = UIJarPackager.countChars(s2, '/')) ? c22 - c12 : s1.compareTo(s2);
                }

                public boolean equals(Object o2) {
                    return super.equals(o2);
                }
            };
        }
        return archiveComparator;
    }

    private static Comparator getNodeComparator() {
        if (nodeComparator == null) {
            nodeComparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    return o1.toString().compareTo(o2.toString());
                }

                public boolean equals(Object o2) {
                    return super.equals(o2);
                }
            };
        }
        return nodeComparator;
    }

    public static Hashtable getFileContentHashtable(FileContentsDescriptor fcd) {
        if (fcd == null) {
            return null;
        }
        Hashtable<String, File> filesMap = new Hashtable<String, File>();
        Enumeration e10 = fcd.getFiles();
        while (e10.hasMoreElements()) {
            File f2 = (File)e10.nextElement();
            String key = f2.toString();
            File full = fcd.getFullFileFor(f2);
            filesMap.put(UIJarPackager.ToArchSep(key), full);
        }
        return filesMap.size() > 0 ? filesMap : null;
    }

    public static Vector getClassNames(FileContentsDescriptor fcd) {
        Vector<String> classList = new Vector<String>();
        Enumeration e10 = fcd.getFiles();
        while (e10.hasMoreElements()) {
            File f2 = (File)e10.nextElement();
            String fn = f2.toString();
            if (UIJarPackager.StrFileEndsWith(fn, DOT_CLASS)) {
                classList.add(FileUtil.classNameFromFile(f2));
                continue;
            }
            if (!UIJarPackager.StrFileEndsWith(fn, DOT_JAR)) continue;
            try {
                JarFile jar = new JarFile(fcd.getFullFileFor(f2).toString());
                Enumeration<JarEntry> j2 = jar.entries();
                while (j2.hasMoreElements()) {
                    JarEntry je = j2.nextElement();
                    if (!UIJarPackager.StrFileEndsWith(je.getName(), DOT_CLASS)) continue;
                    classList.add(FileUtil.classNameFromEntryName(je.getName()));
                }
            }
            catch (IOException ioe) {
                UIUtils.println("UIJarPackager.getClassNames: (" + fn + ") " + ioe.toString());
            }
        }
        return classList;
    }

    public static void main(String[] args) {
        JFrame frm = new JFrame();
        frm.getContentPane().setLayout(new BorderLayout());
        UIJarPackager jp = new UIJarPackager(frm, WEB_WAR);
        jp.getClassDescriptor();
        jp.getContentsDescriptor();
        ((Component)frm).setSize(500, 400);
        frm.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e10) {
                System.exit(0);
            }
        });
        ((Component)frm).setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ TreePath[] access$2502(UIJarPackager x0, TreePath[] x1) {
        x0.dragSelections = x1;
        return x1;
    }

    private static class CustomJarClassLoader
    extends JarClassLoader {
        private ClassLoader parent = null;

        public CustomJarClassLoader(ClassLoader parent) {
            this.parent = parent;
        }

        /*
         * WARNING - void declaration
         */
        public Class findClass(String name) throws ClassNotFoundException {
            if (this.parent != null) {
                try {
                    void cnfe;
                    Class<?> c10 = this.parent.loadClass(name);
                    return cnfe;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return super.findClass(name);
        }

        public URL findResource(String name) {
            URL url = this.parent != null ? this.parent.getResource(name) : null;
            return url == null ? super.findResource(name) : null;
        }
    }

    private static class CustomFileContentsDescriptor
    extends FileContentsDescriptor {
        private ClassLoader bundleClassLoader = null;

        public void setBundleClassLoader(ClassLoader cl2) {
            this.bundleClassLoader = cl2;
        }

        protected JarClassLoader getClassLoaderInstance() {
            return new CustomJarClassLoader(this.bundleClassLoader);
        }
    }

    private class TreeViewCellRenderer
    extends DefaultTreeCellRenderer {
        private boolean isDestView = false;
        private Color nonDelColor = null;

        public TreeViewCellRenderer(boolean isDest) {
            this.isDestView = isDest;
            if (this.isDestView) {
                this.nonDelColor = UIConfig.getConfigColor("ui.contentsEditor.nonDeletableColor", null);
            }
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof CustomTreeNode) {
                CustomTreeNode tn = (CustomTreeNode)value;
                JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
                label.setIcon(this.getIconForDescriptor(tn.getFile(), expanded));
                if (this.isDestView && this.nonDelColor != null) {
                    label.setForeground(tn.isDeletable() ? Color.black : this.nonDelColor);
                }
                return label;
            }
            return BLANK_LABEL;
        }

        private Icon getIconForDescriptor(File fileNode, boolean expanded) {
            Icon icon = null;
            icon = fileNode.isDirectory() ? (expanded ? this.getOpenIcon() : this.getClosedIcon()) : this.getLeafIcon();
            return icon;
        }
    }

    private class CustomTreeNode
    extends DefaultMutableTreeNode {
        private String nodeName = null;
        private boolean isRootNode = false;
        private boolean isFixedNode = false;
        private boolean isSystemRootNode = false;
        private String lastParentArchiveKey = null;

        public CustomTreeNode(String nodeName, CustomFile file) {
            super(file);
            this.nodeName = nodeName;
            this.setAllowsChildren(file.isDirectory());
        }

        public CustomTreeNode(CustomFile file) {
            this(null, file);
        }

        public CustomTreeNode(CustomTreeNode ttn) {
            this(ttn.getFile());
            this.nodeName = ttn.nodeName;
            this.isRootNode = ttn.isRootNode;
            this.isFixedNode = ttn.isFixedNode;
            this.isSystemRootNode = ttn.isSystemRootNode;
            this.lastParentArchiveKey = ttn.lastParentArchiveKey;
        }

        public void setIsSystemRootNode(boolean f2) {
            this.isSystemRootNode = f2;
        }

        public void setParent(MutableTreeNode newParent) {
            if (newParent == null) {
                CustomTreeNode oldParent = (CustomTreeNode)this.getParent();
                if (oldParent != null) {
                    this.lastParentArchiveKey = oldParent.getArchiveKey(false);
                }
            } else {
                this.lastParentArchiveKey = null;
                if (!this.isRootNode()) {
                    String pk = ((CustomTreeNode)newParent).getArchiveKey(false);
                    String ak2 = (pk.equals("") ? pk : pk + UIJarPackager.ArchSeparator) + this.getName();
                    this.getFile().setArchiveKey(ak2);
                } else {
                    this.getFile().setArchiveKey(null);
                }
            }
            super.setParent(newParent);
        }

        public void setRootNode(boolean flag) {
            this.isRootNode = flag;
        }

        public boolean isRootNode() {
            return this.isRootNode;
        }

        public void setFixedNode(boolean flag) {
            this.isFixedNode = flag;
        }

        public boolean isFixedNode() {
            return this.isFixedNode;
        }

        public boolean isLeaf() {
            return !this.getAllowsChildren();
        }

        public void add(MutableTreeNode newChild) {
            UIUtils.printImplementationError("use 'addChild(...)' instead");
            this.addChild(newChild);
        }

        public void addChild(MutableTreeNode newChild) {
            this.setAllowsChildren(true);
            super.add(newChild);
        }

        public boolean containsNode(CustomTreeNode node) {
            return UIJarPackager.getChildNode(this, node) != null;
        }

        public CustomFile getFile() {
            return (CustomFile)this.getUserObject();
        }

        public boolean isDirectory() {
            return this.isSystemRootNode ? true : this.getFile().isDirectory();
        }

        public boolean isFile() {
            return this.getFile().isFile();
        }

        public boolean isReferenced() {
            return this.getFile().isReferenced();
        }

        public boolean isDeletable() {
            if (!this.getFile().isDeletable()) {
                return false;
            }
            Enumeration<TreeNode> e10 = this.children();
            while (e10.hasMoreElements()) {
                CustomTreeNode child = (CustomTreeNode)e10.nextElement();
                if (child.isDeletable()) continue;
                return false;
            }
            return true;
        }

        public boolean getFileExists() {
            return this.getFile().exists();
        }

        public String getFileName() {
            return this.getFile().getName();
        }

        public String getFilePath() {
            return this.getFile().getPath();
        }

        public String getArchivePath() {
            return this.getFile().getArchivePath();
        }

        public String getFileParent() {
            return this.getFile().getParent();
        }

        public String[] getFileList() {
            return this.getFile().list();
        }

        private StringBuffer _getArchiveKey(StringBuffer sb) {
            if (sb == null) {
                sb = new StringBuffer();
            }
            if (this.isRootNode()) {
                return sb;
            }
            CustomTreeNode parent = (CustomTreeNode)this.getParent();
            if (parent != null) {
                if (!parent.isRootNode()) {
                    parent._getArchiveKey(sb);
                    sb.append(UIJarPackager.ArchSeparator);
                }
                sb.append(this.getName());
                return sb;
            }
            if (this.getFile().getArchiveKey(false) != null) {
                sb.append(this.getFile().getArchiveKey(false));
                return sb;
            }
            if (this.lastParentArchiveKey != null) {
                UIUtils.debugPrintln("Using 'lastParentArchiveKey' : " + this.lastParentArchiveKey);
                sb.append(this.lastParentArchiveKey);
                sb.append(UIJarPackager.ArchSeparator);
                sb.append(this.getName());
                return sb;
            }
            UIUtils.debugPrintln("Can't determine ArchiveKey for " + this.getName());
            sb.append(this.getName());
            return sb;
        }

        public String getArchiveKey(boolean normalize) {
            String archKey = null;
            archKey = this.getFile().getArchiveKey(false);
            if (archKey == null) {
                archKey = this._getArchiveKey(null).toString();
            }
            return normalize ? UIJarPackager._normalizeArchiveName(archKey) : archKey;
        }

        public String getArchiveKey() {
            return this.getArchiveKey(true);
        }

        public String getFileRootPath() {
            String root = null;
            String key = UIJarPackager.ToFileSep(this.getArchiveKey(true));
            String path = this.getFilePath();
            if (UIJarPackager.StrFileEquals(path, key)) {
                return "";
            }
            if (UIJarPackager.StrFileEndsWith(path, key)) {
                root = path.substring(0, path.length() - key.length());
                while (root.endsWith(FileSeparator)) {
                    root = root.substring(0, root.length() - 1);
                }
            }
            if (root == null) {
                UIUtils.printImplementationError("Archive key is not a subset of file path\nKey  = " + key + "\n" + "Path = " + path);
                return "";
            }
            return root;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CustomTreeNode) {
                return UIJarPackager.StrFileEquals(obj.toString(), this.toString());
            }
            if (obj instanceof CustomFile) {
                UIUtils.debugImplementationError("Should not compare against a CustomFile!!");
                CustomFile cf2 = (CustomFile)obj;
                boolean isequal = this.isSystemRootNode ? UIJarPackager.StrFileEquals(cf2.getPath(), this.getFilePath()) : UIJarPackager.StrFileEquals(cf2.getName(), this.getFileName());
                return isequal;
            }
            return false;
        }

        public String getNodeName() {
            if (this.nodeName != null) {
                return this.nodeName;
            }
            if (this.isSystemRootNode) {
                return this.getFilePath();
            }
            return this.getFileName();
        }

        public String toString() {
            return this.getNodeName();
        }

        public String getName() {
            return this.getNodeName();
        }
    }

    private class CustomFile
    extends File {
        private int isDir = -1;
        private boolean isReferenced = false;
        private boolean isDeletable = true;
        private String nonDeletableReason = null;
        private boolean isSystemRoot = false;
        private boolean isSystemFile = true;
        private boolean isFloppy = false;
        private String archiveKey = null;

        public CustomFile(File file) {
            super(UIJarPackager._checkFileSeparators(file.getPath()));
            if (file instanceof CustomFile) {
                CustomFile cf2 = (CustomFile)file;
                this.isDir = cf2.isDir;
                this.isDeletable = cf2.isDeletable;
                this.nonDeletableReason = cf2.nonDeletableReason;
                this.isSystemRoot = cf2.isSystemRoot;
                this.isSystemFile = cf2.isSystemFile;
                this.isFloppy = cf2.isFloppy;
                this.archiveKey = cf2.archiveKey;
            }
        }

        public CustomFile(String path, boolean isSystemFile) {
            super(UIJarPackager._checkFileSeparators(path));
            this.isSystemFile = isSystemFile;
            if (IsDosFileSeparator) {
                boolean bl2 = this.isFloppy = UIJarPackager.StrFileStartsWith(path, "a:") || UIJarPackager.StrFileStartsWith(path, "b:");
            }
            if (this.isSystemFile && (path.equals(UIJarPackager.ArchSeparator) || path.endsWith(":\\"))) {
                this.setIsSystemRoot(true);
            }
            String fp = this.getPath();
            if (this.isSystemFile && !fp.startsWith(UIJarPackager.WEB_INF) && fp.indexOf(UIJarPackager.WEB_INF) >= 0) {
                UIUtils.debugImplementationError("Filename contains WEB-INF: " + fp);
            }
        }

        public CustomFile(String path) {
            this(path, true);
        }

        public void setArchiveKey(String key) {
            this.archiveKey = key;
        }

        public String getArchiveKey(boolean normalize) {
            return normalize ? UIJarPackager._normalizeArchiveName(this.archiveKey) : this.archiveKey;
        }

        public String getArchiveKey() {
            return this.getArchiveKey(true);
        }

        public String getParent() {
            String p2 = super.getParent();
            return p2 != null ? p2 : "";
        }

        public void setReferenced(boolean referenced) {
            this.isReferenced = referenced;
            if (this.isReferenced && this.isDeletable()) {
                this.setDeletable(false);
            }
        }

        public boolean isReferenced() {
            return this.isReferenced;
        }

        public void setDeletable(boolean value) {
            this.isDeletable = value;
            this.nonDeletableReason = null;
        }

        public void setDeletable(boolean value, String reason) {
            this.setDeletable(value);
            this.nonDeletableReason = reason;
        }

        public void setDeletable(String reason) {
            this.setDeletable(reason == null, reason);
        }

        public boolean isDeletable() {
            return this.isDeletable;
        }

        public String getNonDeletableReason() {
            return this.nonDeletableReason;
        }

        public boolean isSystemRoot() {
            return this.isSystemRoot;
        }

        public void setIsSystemRoot(boolean f2) {
            this.isSystemRoot = f2;
            if (this.isSystemRoot) {
                this.setIsDirectory(true);
            }
        }

        public void setIsDirectory(boolean value) {
            this.isDir = value ? 1 : 0;
        }

        public boolean isDirectory() {
            if (this.isDir < 0) {
                this.isDir = this.isSystemFile && super.isDirectory() ? 1 : 0;
            }
            return this.isDir > 0;
        }

        public boolean isFile() {
            return !this.isDirectory();
        }

        public boolean isFloppy() {
            return this.isFloppy;
        }

        public boolean exists() {
            if (this.isSystemRoot) {
                return true;
            }
            if (this.isSystemFile) {
                return super.exists();
            }
            return true;
        }

        public boolean isAbsolute() {
            if (this.isSystemRoot) {
                return true;
            }
            if (this.isSystemFile) {
                return super.isAbsolute();
            }
            return false;
        }

        public String[] list() {
            String[] lst = null;
            if (this.isSystemFile && this.isDirectory() && (lst = super.list()) == null) {
                lst = new String[]{};
            }
            return lst;
        }

        public Vector getDirContents() {
            String[] c10 = this.list();
            if (c10 != null) {
                Vector<CustomFile> contents = new Vector<CustomFile>();
                int i2 = 0;
                while (i2 < c10.length) {
                    CustomFile child = new CustomFile(this.getPath() + FileSeparator + c10[i2], true);
                    contents.add(child);
                    ++i2;
                }
                return contents;
            }
            return null;
        }

        public String getArchivePath() {
            return UIJarPackager.ToArchSep(this.getPath());
        }

        public boolean equals(Object obj) {
            if (obj instanceof CustomFile) {
                return super.equals(obj);
            }
            if (obj instanceof CustomTreeNode) {
                return this.equals(((CustomTreeNode)obj).getFile());
            }
            return super.equals(obj);
        }
    }

    private class SourceTreeView
    extends PackagerTreeView {
        private SourceTree tree;
        public File lastSysRoot = null;

        public SourceTreeView(SourceTree rootTree) {
            CustomFile file = new CustomFile(UIJarPackager.SRC_TREE_ROOT_NAME, false);
            file.setIsDirectory(true);
            file.setDeletable(NONDEL_FIXED_NODE);
            this.fixedRootNode = new CustomTreeNode(file);
            this.fixedRootNode.setRootNode(true);
            this.fixedRootNode.setFixedNode(true);
            this.tree = rootTree != null ? rootTree : new SourceTree();
            this.tree.setModel(new DefaultTreeModel(this.fixedRootNode));
            this.tree.setRootVisible(false);
            this.tree.setShowsRootHandles(true);
            this.tree.setCellRenderer(new TreeViewCellRenderer(false));
            this.tree.getSelectionModel().setSelectionMode(4);
            this.tree.setTreeView(this);
            this.setTreeView(this.tree);
            this.setLayout(new BorderLayout());
            JPanel mainPanel = new JPanel();
            mainPanel.setBorder(new LineBorder(Color.black, 0));
            mainPanel.setLayout(new BorderLayout());
            mainPanel.add(new JScrollPane(this.tree));
            this.add(mainPanel);
        }

        public JTree getTree() {
            return this.tree;
        }

        public void buildView(CustomFile sysRoot) {
            if (!this.hasTreeViewSource() && !UIJarPackager.this.isTypeWebRes()) {
                File[] systemRoots;
                File[] fileArray;
                if (this.lastSysRoot == null && sysRoot != null || this.lastSysRoot != null && sysRoot == null || this.lastSysRoot != null && !UIJarPackager.StrFileEquals(this.lastSysRoot.getPath(), sysRoot.getPath())) {
                    this.lastSysRoot = sysRoot;
                    this.getRootNode().removeAllChildren();
                    this.getRootTreeModel().reload();
                }
                if (sysRoot != null) {
                    CustomFile[] customFileArray = new CustomFile[1];
                    fileArray = customFileArray;
                    customFileArray[0] = sysRoot;
                } else {
                    fileArray = systemRoots = UIJarPackager.this.getDefaultSystemRoots();
                }
                if (systemRoots != null && systemRoots.length > 0) {
                    int i2 = 0;
                    while (i2 < systemRoots.length) {
                        CustomFile f2 = (CustomFile)systemRoots[i2];
                        CustomTreeNode sysRootNode = new CustomTreeNode(f2);
                        sysRootNode.setIsSystemRootNode(true);
                        this.addChildNode(this.getRootNode(), sysRootNode);
                        ++i2;
                    }
                } else {
                    UIUtils.println("There are no root directories on System.");
                }
            } else if (this.hasTreeViewSource()) {
                this.getRootNode().removeAllChildren();
                this.getRootTreeModel().reload();
                UIJarPackager.this.readDescriptor(this);
            }
        }
    }

    private class SourceTree
    extends JTree
    implements DragGestureListener,
    DragSourceListener,
    Transferable {
        private SourceTreeView treeView = null;
        private DragSource dragSource = null;

        public SourceTree() {
            this.setEditable(false);
            this.dragSource = DragSource.getDefaultDragSource();
            DragGestureRecognizer dgr = this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
            if (!UIJarPackager.this.isTypeWebRes()) {
                UIContextMenu ctxMenu = new UIContextMenu(this);
                ctxMenu.addItem(POPUP_REFRESH_DIRS, "refreshSelectedNodes");
                if (UIUtils.debugMode()) {
                    ctxMenu.addItem(POPUP_GOTO_DIR, "gotoSelectedNode");
                }
            }
        }

        public void setTreeView(SourceTreeView tv) {
            this.treeView = tv;
        }

        public SourceTreeView getTreeView() {
            return this.treeView;
        }

        public void gotoSelectedNode() {
            CustomTreeNode node;
            TreePath[] sel = this.getSelectionPaths();
            if (sel != null && sel.length > 0 && (node = (CustomTreeNode)sel[0].getLastPathComponent()).isDirectory()) {
                UITitledComboBox cb2 = UIJarPackager.this.sysRootsCombo;
                CustomFile fdir = node.getFile();
                cb2.setSelectedItem(fdir.getPath());
                UIJarPackager.this.addStartingDirectory(fdir);
                UIJarPackager.this.refreshSourceTree();
            }
        }

        public void refreshSelectedNodes() {
            TreePath[] sel = this.getSelectionPaths();
            if (sel != null) {
                int i2 = 0;
                while (i2 < sel.length) {
                    CustomTreeNode node;
                    if (UIJarPackager.this.srcTree.isExpanded(sel[i2]) && (node = (CustomTreeNode)sel[i2].getLastPathComponent()).isDirectory()) {
                        this.makeNode(node);
                    }
                    ++i2;
                }
            }
        }

        public void makeNode(CustomTreeNode currentNode) {
            SourceTreeView stv = this.getTreeView();
            String[] subFiles = currentNode.getFileList();
            if (subFiles != null) {
                SortedSet<CustomFile> fileSet = Collections.synchronizedSortedSet(new TreeSet());
                SortedSet<CustomFile> dirSet = Collections.synchronizedSortedSet(new TreeSet());
                int i2 = 0;
                while (i2 < subFiles.length) {
                    CustomFile child = new CustomFile(currentNode.getFilePath() + FileSeparator + subFiles[i2], true);
                    if (child != null && ((File)child).exists()) {
                        if (((File)child).isFile()) {
                            fileSet.add(child);
                        } else {
                            dirSet.add(child);
                        }
                    }
                    ++i2;
                }
                Vector<TreeNode> childList = new Vector<TreeNode>();
                Enumeration<TreeNode> ce2 = currentNode.children();
                while (ce2.hasMoreElements()) {
                    childList.add(ce2.nextElement());
                }
                Object[] dirs = dirSet.toArray();
                int i3 = 0;
                while (i3 < dirs.length) {
                    CustomFile dirObj = (CustomFile)dirs[i3];
                    CustomTreeNode existingNode = UIJarPackager.getChildNode(currentNode, dirObj.getName());
                    if (existingNode == null) {
                        CustomTreeNode childDirNode = new CustomTreeNode(dirObj);
                        stv.addChildNode(currentNode, childDirNode);
                    } else {
                        childList.remove(dirObj);
                    }
                    ++i3;
                }
                Object[] files = fileSet.toArray();
                int i4 = 0;
                while (i4 < files.length) {
                    CustomFile fileObj = (CustomFile)files[i4];
                    CustomTreeNode existingNode = UIJarPackager.getChildNode(currentNode, fileObj.getName());
                    if (existingNode == null) {
                        CustomTreeNode childFileNode = new CustomTreeNode(fileObj);
                        stv.addChildNode(currentNode, childFileNode);
                    } else {
                        childList.remove(fileObj);
                    }
                    ++i4;
                }
                Enumeration e10 = childList.elements();
                while (e10.hasMoreElements()) {
                    CustomTreeNode oldNode = (CustomTreeNode)e10.nextElement();
                    stv.removeChildNode(currentNode, oldNode);
                }
            }
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (flavor.equals(DRAG_FLAVOR)) {
                return UIJarPackager.SOURCE_TREE;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        public DataFlavor[] getTransferDataFlavors() {
            return DRAG_FLAVOR_LIST;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            int i2 = 0;
            int n2 = DRAG_FLAVOR_LIST.length;
            while (i2 < n2) {
                if (flavor.equals(DRAG_FLAVOR_LIST[i2])) {
                    return true;
                }
                ++i2;
            }
            return false;
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
            TreePath[] sel;
            InputEvent ie = dge.getTriggerEvent();
            if ((ie.getModifiers() & 4) == 0 && (sel = this.getSelectionPaths()) != null) {
                UIJarPackager.this.dragInitiator = UIJarPackager.SOURCE_TREE;
                UIJarPackager.access$2502(UIJarPackager.this, sel);
                this.dragSource.startDrag(dge, DragSource.DefaultCopyDrop, this, this);
            }
        }

        public void dragDropEnd(DragSourceDropEvent evt) {
            UIJarPackager.this.dragInitiator = null;
            UIJarPackager.access$2502(UIJarPackager.this, null);
        }

        public void dragEnter(DragSourceDragEvent evt) {
        }

        public void dragOver(DragSourceDragEvent evt) {
        }

        public void dropActionChanged(DragSourceDragEvent evt) {
        }

        public void dragExit(DragSourceEvent evt) {
        }
    }

    private class DestinationTreeView
    extends PackagerTreeView {
        private DestinationTree tree = null;
        private CustomTreeNode fixedWebInfNode = null;
        private CustomTreeNode fixedMetaInfNode = null;
        private CustomTreeNode fixedClassesNode = null;
        private CustomTreeNode fixedLibNode = null;
        private CustomTreeNode fixedXMLFileNode = null;
        private boolean defaultOverwriteAll = false;

        public DestinationTreeView(DestinationTree rootTree) {
            CustomFile file = new CustomFile(UIJarPackager.DEST_TREE_ROOT_NAME, false);
            file.setIsDirectory(true);
            file.setDeletable(NONDEL_FIXED_NODE);
            this.fixedRootNode = new CustomTreeNode(file);
            this.fixedRootNode.setRootNode(true);
            this.fixedRootNode.setFixedNode(true);
            this.tree = rootTree != null ? rootTree : new DestinationTree(true);
            this.tree.setModel(new DefaultTreeModel(this.fixedRootNode));
            this.tree.setRootVisible(false);
            this.tree.setShowsRootHandles(true);
            this.tree.setCellRenderer(new TreeViewCellRenderer(true));
            this.tree.getSelectionModel().setSelectionMode(4);
            this.tree.setTreeView(this);
            this.setTreeView(this.tree);
            if (UIJarPackager.this.isTypeEjbJar()) {
                file = new CustomFile(UIJarPackager.META_INF, false);
                file.setIsDirectory(true);
                file.setDeletable(NONDEL_FIXED_NODE);
                this.fixedMetaInfNode = new CustomTreeNode(file);
                this.fixedMetaInfNode.setFixedNode(true);
            } else if (UIJarPackager.this.isTypeWebWar()) {
                file = new CustomFile(UIJarPackager.WEB_INF, false);
                file.setIsDirectory(true);
                file.setDeletable(NONDEL_FIXED_NODE);
                this.fixedWebInfNode = new CustomTreeNode(file);
                this.fixedWebInfNode.setFixedNode(true);
                file = new CustomFile(UIJarPackager.CLASSES, false);
                file.setIsDirectory(true);
                file.setDeletable(NONDEL_FIXED_NODE);
                this.fixedClassesNode = new CustomTreeNode(file);
                this.fixedClassesNode.setFixedNode(true);
                file = new CustomFile(UIJarPackager.LIB, false);
                file.setIsDirectory(true);
                file.setDeletable(NONDEL_FIXED_NODE);
                this.fixedLibNode = new CustomTreeNode(file);
                this.fixedLibNode.setFixedNode(true);
            } else if (UIJarPackager.this.isTypeAppCli()) {
                file = new CustomFile(UIJarPackager.META_INF, false);
                file.setIsDirectory(true);
                file.setDeletable(NONDEL_FIXED_NODE);
                this.fixedMetaInfNode = new CustomTreeNode(file);
                this.fixedMetaInfNode.setFixedNode(true);
            } else if (UIJarPackager.this.isTypeResRar()) {
                file = new CustomFile(UIJarPackager.META_INF, false);
                file.setIsDirectory(true);
                file.setDeletable(NONDEL_FIXED_NODE);
                this.fixedMetaInfNode = new CustomTreeNode(file);
                this.fixedMetaInfNode.setFixedNode(true);
            }
            this.setLayout(new BorderLayout());
            JPanel mainPanel = new JPanel();
            mainPanel.setBorder(new LineBorder(Color.black, 0));
            mainPanel.setLayout(new BorderLayout());
            mainPanel.add(new JScrollPane(this.tree));
            this.add(mainPanel);
        }

        public JTree getTree() {
            return this.tree;
        }

        public String getName() {
            String n2 = super.getName();
            return !n2.equals("") ? n2 : UIJarPackager.DefaultTypeName(UIJarPackager.this.getPackagerType());
        }

        public void buildView(CustomFile dummy) {
            this.resetRootNode();
            UIJarPackager.this.readDescriptor(this);
        }

        public void printWebInfParent(String msg) {
            CustomTreeNode pnode = this.fixedWebInfNode != null ? (CustomTreeNode)this.fixedWebInfNode.getParent() : null;
            String pname = pnode != null ? pnode.getName() : "<null>";
            UIUtils.debugPrintln(msg + ") WEB-INF parent name => " + pname);
        }

        private void resetRootNode() {
            DefaultMutableTreeNode newRoot;
            DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
            this.fixedRootNode.removeAllChildren();
            DefaultMutableTreeNode defaultMutableTreeNode = newRoot = this.hasTreeViewSource() ? this.fixedRootNode : EMPTY_NODE;
            if (newRoot != (TreeNode)treeModel.getRoot()) {
                treeModel.setRoot(newRoot);
            }
            if (UIJarPackager.this.isTypeEjbJar()) {
                this.fixedMetaInfNode.removeAllChildren();
                if (this.hasTreeViewSource()) {
                    this.addChildNode(this.fixedRootNode, this.fixedMetaInfNode);
                }
            } else if (UIJarPackager.this.isTypeWebWar()) {
                this.fixedWebInfNode.removeAllChildren();
                if (this.hasTreeViewSource()) {
                    this.addChildNode(this.fixedRootNode, this.fixedWebInfNode);
                }
                this.fixedClassesNode.removeAllChildren();
                if (this.hasTreeViewSource()) {
                    this.addChildNode(this.fixedWebInfNode, this.fixedClassesNode);
                }
                this.fixedLibNode.removeAllChildren();
                if (this.hasTreeViewSource()) {
                    this.addChildNode(this.fixedWebInfNode, this.fixedLibNode);
                }
            } else if (UIJarPackager.this.isTypeAppCli()) {
                this.fixedMetaInfNode.removeAllChildren();
                if (this.hasTreeViewSource()) {
                    this.addChildNode(this.fixedRootNode, this.fixedMetaInfNode);
                }
            } else if (UIJarPackager.this.isTypeResRar()) {
                this.fixedMetaInfNode.removeAllChildren();
                if (this.hasTreeViewSource()) {
                    this.addChildNode(this.fixedRootNode, this.fixedMetaInfNode);
                }
            }
            if (this.fixedXMLFileNode != null) {
                this.fixedXMLFileNode.removeAllChildren();
            }
            treeModel.reload();
        }

        public void addChildNode(CustomTreeNode parent, CustomTreeNode child) {
            if (this.tree.isInternal()) {
                CustomTreeNode node;
                if (child.isFile() && (node = UIJarPackager.getChildNode(parent, child)) != null) {
                    if (node == child) {
                        return;
                    }
                    if (node.isDirectory() || child.isDirectory()) {
                        if (!node.isDirectory()) {
                            node.getFile().setIsDirectory(true);
                            node.getFile().setArchiveKey(null);
                        }
                        return;
                    }
                    if (this.checkOkToOverwrite(node)) {
                        child.getFile().setDeletable(node.getFile().getNonDeletableReason());
                        child.getFile().setReferenced(node.isReferenced());
                        Vector list = this.removeChildNode(parent, node, false);
                        UIJarPackager.this.addRemovedContent(list);
                    } else {
                        return;
                    }
                }
                if (child.getParent() != null) {
                    Vector list = this.removeChildNode(null, child, false);
                    UIJarPackager.this.addRemovedContent(list);
                }
            }
            super.addChildNode(parent, child);
        }

        public CustomTreeNode getParentFixedNode(CustomTreeNode node) {
            TreeNode[] tn = node.getPath();
            int i2 = tn.length - 1;
            while (i2 >= 0) {
                CustomTreeNode testNode = (CustomTreeNode)tn[i2];
                if (testNode.isFixedNode()) {
                    return testNode;
                }
                --i2;
            }
            UIUtils.debugPrintln("Node has no fixed parent: " + node.toString());
            return null;
        }

        private boolean checkOkToOverwrite(CustomTreeNode node) {
            if (node == null) {
                this.defaultOverwriteAll = false;
                return false;
            }
            if (this.defaultOverwriteAll) {
                return true;
            }
            String[] options = new String[]{OPT_YES, OPT_YES_TO_ALL, OPT_NO};
            int selection = UIOptionPane.showConfirmDialog((Component)this, localStrings.getLocalString("ui.uijarpackager.already_exists", "{0} already exists.\nDo you wish to overwrite?", new Object[]{node.toString()}), options);
            if (options[selection].equals(OPT_YES_TO_ALL)) {
                this.defaultOverwriteAll = true;
                return true;
            }
            return options[selection].equals(OPT_YES);
        }
    }

    private class CustomURLDialog
    extends UIDialog {
        private String customUrlHelpID = "AddUrlPattern";
        private UITitledTextField urlTextField = null;
        private boolean urlOK = false;

        private CustomURLDialog(Component ownerComp) {
            super(UIUtils.getAncestorDialog(ownerComp), true);
            this.initDialog();
        }

        private void initDialog() {
            this.setWindowClosingAction(null);
            this.setTitle(CUSTOM_URL_TITLE);
            super.dialogInit();
            ((JPanel)this.getContentPane()).setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
            this.getContentPane().setLayout(new BorderLayout());
            this.urlTextField = new UITitledTextField(CUSTOM_URL_LABEL, false);
            this.getContentPane().add((Component)this.urlTextField, "North");
            UITitledControlButtonBox buttonsPanel = new UITitledControlButtonBox(null, false);
            buttonsPanel.setControlButtonLocation(15);
            this.getContentPane().add((Component)buttonsPanel, "South");
            UIButton okBtn = UIButton.createOkButton(new ActionListener(this){
                private final /* synthetic */ CustomURLDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae2) {
                    CustomURLDialog.access$3002(this.this$1, true);
                    this.this$1.hide();
                }
            });
            buttonsPanel.addControlButton(okBtn);
            okBtn.makeDefaultButton(true);
            UIButton canBtn = UIButton.createCancelButton(new ActionListener(this){
                private final /* synthetic */ CustomURLDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae2) {
                    CustomURLDialog.access$3002(this.this$1, false);
                    this.this$1.hide();
                }
            });
            buttonsPanel.addControlButton(canBtn);
            UIButton hlpBtn = UIButton.createHelpButton(this.customUrlHelpID);
            buttonsPanel.addControlButton(hlpBtn);
            this.pack();
            Window win = this.getOwner();
            int x2 = win.getBounds().x + super.getBounds().width / 3;
            int y2 = win.getBounds().y + super.getBounds().height / 3;
            ((Component)this).setBounds(x2, y2, super.getBounds().width + 80, super.getBounds().height);
            this.setLocationRelativeTo(UIJarPackager.this.destTree);
        }

        public void setUrl(String url) {
            if (url == null) {
                url = "";
            }
            this.urlTextField.setText(url.startsWith(UIJarPackager.ArchSeparator) ? url : UIJarPackager.ArchSeparator + url);
        }

        public String getUrl() {
            String url = UIJarPackager.ToArchSep(this.urlTextField.getText());
            if (!url.startsWith(UIJarPackager.ArchSeparator)) {
                url = UIJarPackager.ArchSeparator + url;
            }
            return url;
        }

        public void show() {
            this.urlOK = false;
            super.show();
        }

        public boolean isOk() {
            return this.urlOK;
        }

        static /* synthetic */ boolean access$3002(CustomURLDialog x0, boolean x1) {
            x0.urlOK = x1;
            return x0.urlOK;
        }
    }

    private class DestinationTree
    extends JTree
    implements DragGestureListener,
    DropTargetListener,
    DragSourceListener,
    Transferable {
        private DestinationTreeView treeView = null;
        private DragSource dragSource = null;
        private boolean isInternal = true;
        private CustomURLDialog customUrlDialog = null;

        public DestinationTree(boolean isInternal) {
            this.setEditable(false);
            this.isInternal = isInternal;
            if (this.isInternal) {
                this.dragSource = DragSource.getDefaultDragSource();
                DragGestureRecognizer dgr = this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
                new DropTarget(this, this);
                if (UIJarPackager.this.isTypeWebRes() || UIUtils.debugMode()) {
                    UIContextMenu ctxMenu = new UIContextMenu(this);
                    if (UIJarPackager.this.isTypeWebRes()) {
                        ctxMenu.addItem(ADD_CUSTOM_URL_PATTERN, "addCustomUrlPattern");
                    }
                    if (UIUtils.debugMode()) {
                        ctxMenu.addItem("Node Info", "printNodeInfo");
                    }
                }
            }
        }

        public void setTreeView(DestinationTreeView tv) {
            this.treeView = tv;
        }

        public DestinationTreeView getTreeView() {
            return this.treeView;
        }

        public boolean isInternal() {
            return this.isInternal;
        }

        public void printNodeInfo() {
            TreePath[] sel = this.getSelectionPaths();
            if (sel != null) {
                int i2 = 0;
                while (i2 < sel.length) {
                    CustomTreeNode node = (CustomTreeNode)sel[i2].getLastPathComponent();
                    UIUtils.debugPrintln("\n  Name         = " + node.toString() + " [fixed == " + node.isFixedNode() + "]\n" + "  FilePath     = " + node.getFilePath() + " [exists == " + node.getFileExists() + "]\n" + "  FileRootPath = " + node.getFileRootPath() + "\n" + "  ArchiveKey   = " + node.getArchiveKey(false) + "\n" + "");
                    ++i2;
                }
            }
        }

        public void addCustomUrlPattern() {
            String dftUrl = null;
            TreePath[] sel = this.getSelectionPaths();
            if (sel != null && sel.length > 0) {
                CustomTreeNode node = (CustomTreeNode)sel[0].getLastPathComponent();
                if (node.isDirectory()) {
                    dftUrl = node.getArchiveKey(false);
                } else {
                    CustomTreeNode parent = (CustomTreeNode)node.getParent();
                    String string = dftUrl = parent != null ? parent.getArchiveKey(false) : node.getArchiveKey();
                }
                if (!dftUrl.endsWith(UIJarPackager.ArchSeparator)) {
                    dftUrl = dftUrl + UIJarPackager.ArchSeparator;
                }
            }
            if (this.customUrlDialog == null) {
                this.customUrlDialog = new CustomURLDialog(this);
            }
            this.customUrlDialog.setUrl(dftUrl);
            this.customUrlDialog.show();
            if (this.customUrlDialog.isOk()) {
                String url = this.customUrlDialog.getUrl();
                CustomTreeNode urlNode = new CustomTreeNode(new CustomFile(UIJarPackager.ToFileSep(url)));
                UIJarPackager.this._addWebResToDestTree(urlNode, null);
            }
        }

        public void expandPath(TreePath tp, boolean scrollToVisible) {
            super.expandPath(tp);
            if (scrollToVisible) {
                this.scrollPathToVisible(tp);
            }
        }

        public void scrollPathToVisible(TreePath tp) {
            Rectangle rect = this.getPathBounds(tp);
            if (rect != null) {
                this.scrollRectToVisible(rect);
            }
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (flavor.equals(DRAG_FLAVOR)) {
                return UIJarPackager.DESTINATION_TREE;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        public DataFlavor[] getTransferDataFlavors() {
            return DRAG_FLAVOR_LIST;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            int i2 = 0;
            int n2 = DRAG_FLAVOR_LIST.length;
            while (i2 < n2) {
                if (flavor.equals(DRAG_FLAVOR_LIST[i2])) {
                    return true;
                }
                ++i2;
            }
            return false;
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
            InputEvent ie = dge.getTriggerEvent();
            if ((ie.getModifiers() & 4) == 0) {
                TreePath[] sel = this.getSelectionPaths();
                if (!UIJarPackager.this.isTypeWebRes() && sel != null) {
                    UIJarPackager.this.dragInitiator = UIJarPackager.DESTINATION_TREE;
                    UIJarPackager.access$2502(UIJarPackager.this, sel);
                    this.dragSource.startDrag(dge, DragSource.DefaultMoveDrop, this, this);
                }
            }
        }

        public void dragDropEnd(DragSourceDropEvent evt) {
            UIJarPackager.this.dragInitiator = null;
            UIJarPackager.access$2502(UIJarPackager.this, null);
        }

        public void dragEnter(DragSourceDragEvent evt) {
        }

        public void dragOver(DragSourceDragEvent evt) {
        }

        public void dropActionChanged(DragSourceDragEvent evt) {
        }

        public void dragExit(DragSourceEvent evt) {
        }

        public void drop(DropTargetDropEvent de2) {
            UIJarPackager.this.droppingAction(de2, UIJarPackager.this.dragInitiator, UIJarPackager.this.dragSelections);
        }

        public void dragOver(DropTargetDragEvent evt) {
            Point loc = evt.getLocation();
            TreePath destinationPath = this.getPathForLocation(loc.x, loc.y);
            if (destinationPath != null) {
                this.setSelectionPath(destinationPath);
                UIJarPackager.this.scrollTreeView(loc);
            }
        }

        public void dragEnter(DropTargetDragEvent evt) {
        }

        public void dragExit(DropTargetEvent evt) {
        }

        public void dropActionChanged(DropTargetDragEvent evt) {
        }
    }

    private abstract class PackagerTreeView
    extends UITitledTree
    implements PackagerTreeViewInterface {
        private Object fileContents = null;
        private Object fileAltContents = null;
        private Hashtable fileAltHash = null;
        private String treeName = null;
        protected CustomTreeNode fixedRootNode = null;

        public PackagerTreeView() {
            super((String)null, false);
        }

        public Object getTreeViewSource() {
            return this.fileContents;
        }

        public void setTreeViewSource(Object d10) {
            this.setTreeViewAltSource(null);
            if (d10 == null) {
                this.fileContents = null;
                this.setName(null);
            } else if (d10 instanceof BundleDescriptor) {
                this.fileContents = d10;
                this.setName(((BundleDescriptor)d10).getName());
            } else if (d10 instanceof FileContentsDescriptor) {
                this.fileContents = d10;
                this.setName(null);
            } else if (d10 instanceof Hashtable) {
                this.fileContents = d10;
                this.setName(null);
            } else if (d10 instanceof Enumeration || d10 instanceof Vector) {
                Enumeration e10 = d10 instanceof Enumeration ? (Enumeration)d10 : ((Vector)d10).elements();
                Hashtable<String, File> filesMap = new Hashtable<String, File>();
                while (e10.hasMoreElements()) {
                    String key = e10.nextElement().toString();
                    if (key.startsWith(UIJarPackager.ArchSeparator)) {
                        key = key.substring(UIJarPackager.ArchSeparator.length());
                    }
                    filesMap.put(key, new File(UIJarPackager.ToFileSep(key)));
                }
                this.fileContents = filesMap;
                this.setName(null);
            } else {
                UIUtils.printImplementationError("Unsupported treeView source: " + d10.getClass().getName());
            }
        }

        public Object getTreeViewAltSource() {
            return this.fileAltContents;
        }

        public void setTreeViewAltSource(Object d10) {
            this.fileAltHash = null;
            if (d10 == null) {
                this.fileAltContents = null;
            } else if (d10 instanceof BundleDescriptor) {
                this.fileAltContents = d10;
            } else if (d10 instanceof FileContentsDescriptor) {
                this.fileAltContents = d10;
            } else if (d10 instanceof Hashtable) {
                this.fileAltContents = d10;
            } else if (d10 instanceof Enumeration) {
                Hashtable<String, File> filesMap = new Hashtable<String, File>();
                Enumeration e10 = (Enumeration)d10;
                while (e10.hasMoreElements()) {
                    String key = e10.nextElement().toString();
                    if (key.startsWith(UIJarPackager.ArchSeparator)) {
                        key = key.substring(UIJarPackager.ArchSeparator.length());
                    }
                    filesMap.put(key, new File(UIJarPackager.ToFileSep(key)));
                }
                this.fileAltContents = filesMap;
            } else {
                UIUtils.printImplementationError("Unsupported treeView alternate source: " + d10.getClass().getName());
            }
        }

        public boolean hasTreeViewSource() {
            return this.fileContents != null;
        }

        public boolean hasTreeViewAltSource() {
            return this.fileAltContents != null;
        }

        public BundleDescriptor getBundleDescriptor() {
            return this.fileContents instanceof BundleDescriptor ? (BundleDescriptor)this.fileContents : null;
        }

        public BundleDescriptor getAltBundleDescriptor() {
            return this.fileAltContents instanceof BundleDescriptor ? (BundleDescriptor)this.fileAltContents : null;
        }

        public String getBundleArchivePath() {
            BundleDescriptor bd2 = this.getBundleDescriptor();
            Archivist arch = bd2 != null ? bd2.getArchivist() : null;
            return arch != null ? arch.getArchiveUri() : null;
        }

        public void setName(String name) {
            this.treeName = name;
        }

        public String getName() {
            return this.treeName != null ? this.treeName : "";
        }

        public CustomTreeNode getRootNode() {
            return this.fixedRootNode;
        }

        public DefaultTreeModel getRootTreeModel() {
            return (DefaultTreeModel)this.getTree().getModel();
        }

        public void addChildNode(CustomTreeNode parent, CustomTreeNode child) {
            if (!parent.containsNode(child)) {
                if (child.isFile() && child.getParent() != null) {
                    UIUtils.printImplementationError("child has a parent " + child.getFilePath());
                }
                parent.setAllowsChildren(true);
                this.getRootTreeModel().insertNodeInto(child, parent, parent.getChildCount());
            }
        }

        public Vector removeChildNode(CustomTreeNode parent, CustomTreeNode child) {
            return this.removeChildNode(parent, child, true);
        }

        public Vector removeChildNode(CustomTreeNode parent, CustomTreeNode child, boolean checkDeletable) {
            Vector<CustomTreeNode> removedFiles = new Vector<CustomTreeNode>();
            DefaultTreeModel model = this.getRootTreeModel();
            if (parent == null) {
                parent = (CustomTreeNode)child.getParent();
            }
            if (parent != null && parent.containsNode(child)) {
                Vector<TreeNode> delList = new Vector<TreeNode>();
                Enumeration<TreeNode> g2 = child.depthFirstEnumeration();
                while (g2.hasMoreElements()) {
                    delList.add(g2.nextElement());
                }
                Enumeration e10 = delList.elements();
                while (e10.hasMoreElements()) {
                    CustomTreeNode node = (CustomTreeNode)e10.nextElement();
                    if (checkDeletable && !node.isDeletable()) continue;
                    model.removeNodeFromParent(node);
                    if (!node.getFile().isFile()) continue;
                    removedFiles.add(node);
                }
            }
            return removedFiles;
        }

        public CustomTreeNode makeDirStructure(Enumeration dirEnum) {
            return this.makeDirStructure(this.getRootNode(), dirEnum);
        }

        public CustomTreeNode makeDirStructure(CustomTreeNode parentNode, Enumeration dirEnum) {
            CustomTreeNode childNode = null;
            if (parentNode == null) {
                parentNode = this.getRootNode();
            }
            String nextDirName = null;
            while (dirEnum.hasMoreElements()) {
                String dir = (String)dirEnum.nextElement();
                if (dir.equals("")) continue;
                nextDirName = dir;
                break;
            }
            if (nextDirName != null) {
                CustomTreeNode node = UIJarPackager.getChildNode(parentNode, nextDirName);
                if (node == null) {
                    String newDir = parentNode.isFixedNode() ? nextDirName : parentNode.getFilePath() + FileSeparator + nextDirName;
                    CustomFile dirFile = new CustomFile(newDir, false);
                    dirFile.setIsDirectory(true);
                    node = new CustomTreeNode(dirFile);
                    this.addChildNode(parentNode, node);
                } else if (!node.isDirectory()) {
                    UIUtils.debugPrintln("'" + node.getFileName() + "' found, but is not a dir.");
                    node.getFile().setIsDirectory(true);
                    node.getFile().setArchiveKey(null);
                }
                childNode = this.makeDirStructure(node, dirEnum);
            } else {
                childNode = parentNode;
            }
            return childNode;
        }

        public Hashtable getContentFiles() {
            Hashtable altHash;
            Hashtable hash = UIJarPackager._getContentHashtable(this.fileContents, 0);
            if (hash == null) {
                hash = new Hashtable();
            }
            if ((altHash = this.getAltContentFiles()) != null) {
                Enumeration keys = altHash.keys();
                while (keys.hasMoreElements()) {
                    Object obj = keys.nextElement();
                    if (hash.contains(obj)) continue;
                    hash.put(obj, altHash.get(obj));
                }
            }
            return hash.isEmpty() ? null : hash;
        }

        public Hashtable getAltContentFiles() {
            if (this.fileAltHash == null && this.fileAltContents != null) {
                this.fileAltHash = UIJarPackager._getContentHashtable(this.fileAltContents, 0);
            }
            return this.fileAltHash;
        }

        public abstract JTree getTree();

        public abstract void buildView(CustomFile var1);

        public void updateTreeView(Object src, Object alt) {
            this.setTreeViewSource(src);
            this.setTreeViewAltSource(alt);
            this.buildView(null);
            this.getTree().repaint();
        }

        public void updateTreeView(Object src) {
            this.updateTreeView(src, null);
        }
    }

    public static interface PackagerTreeViewInterface {
        public Object getTreeViewSource();

        public void setTreeViewSource(Object var1);

        public boolean hasTreeViewSource();

        public Object getTreeViewAltSource();

        public void setTreeViewAltSource(Object var1);

        public void setName(String var1);

        public String getName();

        public CustomTreeNode getRootNode();

        public JTree getTree();

        public void updateTreeView(Object var1);

        public void updateTreeView(Object var1, Object var2);
    }
}

