/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.MenuItem;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.net.URL;
import javax.help.CSH;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.Map;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class UIHelp {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$utils$UIHelp == null ? (class$com$sun$enterprise$tools$deployment$ui$utils$UIHelp = UIHelp.class$("com.sun.enterprise.tools.deployment.ui.utils.UIHelp")) : class$com$sun$enterprise$tools$deployment$ui$utils$UIHelp);
    private static final String HELP_SET_NAME = "Help";
    private static UIHelp helpInstance = null;
    private HelpSet mainHelpSet = null;
    private HelpBroker mainHelpBroker = null;
    private _DisplayHelpFromFocus displayHelpFromFocus = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$utils$UIHelp;

    private static String CANT_LOAD_HELPSET(String v0) {
        return localStrings.getLocalString("ui.uihelp.cant_init_helpset", "Unable to initialize HelpSet ''{0}''.", new Object[]{v0});
    }

    private UIHelp() {
        try {
            ClassLoader cl2 = (class$com$sun$enterprise$tools$deployment$ui$utils$UIHelp == null ? (class$com$sun$enterprise$tools$deployment$ui$utils$UIHelp = UIHelp.class$("com.sun.enterprise.tools.deployment.ui.utils.UIHelp")) : class$com$sun$enterprise$tools$deployment$ui$utils$UIHelp).getClassLoader();
            URL url = HelpSet.findHelpSet((ClassLoader)cl2, (String)HELP_SET_NAME);
            if (url != null) {
                this.mainHelpSet = new HelpSet(cl2, url);
            }
        }
        catch (Exception ex2) {
            this.mainHelpSet = null;
        }
        if (this.mainHelpSet != null) {
            this.mainHelpBroker = this.mainHelpSet.createHelpBroker();
            if (this.mainHelpBroker != null) {
                Thread t2 = new Thread(){

                    public void run() {
                        UIHelp.this.mainHelpBroker.initPresentation();
                    }
                };
                t2.setPriority(1);
                t2.start();
            }
        }
        if (this.mainHelpSet == null || this.mainHelpBroker == null) {
            UIUtils.println(UIHelp.CANT_LOAD_HELPSET(HELP_SET_NAME));
        }
    }

    public UIHelp getInstance() {
        if (helpInstance == null) {
            helpInstance = new UIHelp();
        }
        return helpInstance;
    }

    public void enableHelpOnButton(Component comp, String helpId) {
        if (this.mainHelpBroker != null) {
            this.mainHelpBroker.enableHelpOnButton(comp, helpId, this.mainHelpSet);
        }
    }

    public void enableHelpOnButton(MenuItem comp, String helpId) {
        if (this.mainHelpBroker != null) {
            this.mainHelpBroker.enableHelpOnButton(comp, helpId, this.mainHelpSet);
        }
    }

    public void enableHelpKey(Component comp, String id) {
        if (id == null) {
            UIUtils.printImplementationError("UIHelp.enableHelpKey", "Null help-id specified");
        }
        CSH.setHelpIDString((Component)comp, (String)id);
        if (this.mainHelpSet != null) {
            CSH.setHelpSet((Component)comp, (HelpSet)this.mainHelpSet);
        }
        if (comp instanceof JComponent) {
            JComponent root = (JComponent)comp;
            if (this.displayHelpFromFocus == null) {
                this.displayHelpFromFocus = new _DisplayHelpFromFocus(this.mainHelpBroker);
            }
            root.registerKeyboardAction(this.displayHelpFromFocus, KeyStroke.getKeyStroke(156, 0), 2);
            root.registerKeyboardAction(this.displayHelpFromFocus, KeyStroke.getKeyStroke(112, 0), 2);
        } else {
            comp.addKeyListener((KeyListener)this.mainHelpBroker);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class _DisplayHelpFromFocus
    implements ActionListener {
        private HelpBroker hb = null;

        public _DisplayHelpFromFocus(HelpBroker hb) {
            if (hb == null) {
                UIUtils.printImplementationError("UIHelp._DisplayHelpFromFocus", "Null help-broker specified");
            }
            this.hb = hb;
        }

        public void actionPerformed(ActionEvent e10) {
            Component src = (Component)e10.getSource();
            try {
                Window owner = (Window)SwingUtilities.getAncestorOfClass(Class.forName("java.awt.Window"), src);
                if (this.hb instanceof DefaultHelpBroker) {
                    ((DefaultHelpBroker)this.hb).setActivationWindow(owner);
                }
            }
            catch (ClassNotFoundException ex2) {
                // empty catch block
            }
            Component comp = SwingUtilities.findFocusOwner(src);
            if (comp == null) {
                comp = src;
            }
            if (comp instanceof JTabbedPane) {
                comp = ((JTabbedPane)comp).getSelectedComponent();
            }
            String helpID = CSH.getHelpIDString((Component)comp);
            HelpSet hs = CSH.getHelpSet((Component)comp);
            if (hs == null) {
                hs = this.hb.getHelpSet();
            }
            try {
                Map.ID id = Map.ID.create((String)helpID, (HelpSet)hs);
                if (id == null) {
                    id = hs.getHomeID();
                }
                this.hb.setCurrentID(id);
                this.hb.setDisplayed(true);
            }
            catch (Exception e22) {
                // empty catch block
            }
        }
    }
}

