/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfigProperties;
import java.awt.Color;
import java.io.File;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class UIConfig {
    private static final String ARRAY = "[]";
    private static final String BOOL = "boolean";
    private static final String INT = "int";
    private static final String COLOR = "Color";
    private static final String STRING = "String";
    private static final String STRINGa = "String[]";
    private static final String PUBLIC = "public";
    private static final String PRIVATE = "private";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    public static final String BUGFIX = "bugfix.";
    public static final String DEBUG_MODE = "ui.debugMode";
    public static final String TEST_MODE = "ui.testMode";
    public static final String PRINT_CONFIG_KEYS = "ui.printDefaultConfigKeys";
    public static final String NON_DELETABLE_COLOR = "ui.contentsEditor.nonDeletableColor";
    public static final String LOG_EXCEPTIONS = "ui.logExceptions";
    public static final String DEFAULT_DIR = "ui.defaultDirectory";
    public static final String TEMP_DIR = "ui.tempDirectory";
    public static final String MAX_STARTING_DIRECTORIES = "ui.maxStartingDirectories";
    public static final String STARTING_DIRECTORIES = "ui.startingDirectories";
    public static final String SKIP_APPLICATION_RESTORE = "ui.startup.skipApplicationRestore";
    public static final String SKIP_STAND_ALONE_RESTORE = "ui.startup.skipStandAloneRestore";
    public static final String SKIP_SERVER_RESTORE = "ui.startup.skipServerRestore";
    public static final String DISABLE_BUSY_CURSOR = "ui.startup.disableBusyCursor";
    public static final String USE_SERVER_WATCHDOG = "ui.useAddServerWatchdog";
    public static final String USE_CONNECTOR_DISPLAY_NAME = "ui.deploy.connectors.useDisplayName";
    public static final String SAVE_ON_DEPLOY = "ui.deploy.saveOnDeploy";
    public static final String SKIP_WIZARD_INTRO_ = "ui.wizard.skipIntro_";
    private static final String[] BoolValues = new String[]{"false", "true"};
    private static final String[] ColorValues = new String[]{"black", "blue", "cyan", "darkGray", "gray", "green", "lightGray", "magenta", "orange", "pink", "red", "white", "yellow", "#"};
    private static final Key[] cfgKeys = new Key[]{new Key("ui.defaultDirectory", "String", "public", null, ""), new Key("ui.tempDirectory", "String", "public", null, ""), new Key("ui.logExceptions", "int", "public", new String[]{"none", "console", "file"}, "none"), new Key("ui.maxStartingDirectories", "int", "public", null, "7"), new Key("ui.startingDirectories", "String[]", "public", null, ""), new Key("ui.startup.skipApplicationRestore", "boolean", "public", BoolValues, "false"), new Key("ui.startup.skipStandAloneRestore", "boolean", "public", BoolValues, "false"), new Key("ui.startup.skipServerRestore", "boolean", "public", BoolValues, "false"), new Key("ui.startup.disableBusyCursor", "boolean", "public", BoolValues, "false"), new Key("ui.deploy.saveOnDeploy", "int", "public", new String[]{"never", "always", "confirm"}, "confirm"), new Key("ui.wizard.skipIntro_", "boolean", "public", BoolValues, "false"), new Key("ui.contentsEditor.nonDeletableColor", "Color", "public", ColorValues, ""), new Key("ui.debugMode", "boolean", "private", BoolValues, "false"), new Key("ui.testMode", "boolean", "private", BoolValues, "false"), new Key("ui.printDefaultConfigKeys", "boolean", "private", BoolValues, "false"), new Key("ui.useAddServerWatchdog", "boolean", "private", BoolValues, "false"), new Key("ui.deploy.connectors.useDisplayName", "boolean", "private", BoolValues, "false")};
    private static boolean isDebugMode = false;
    private static boolean isTestMode = false;
    private static File defaultDirectory = null;
    private static File tempDirectory = null;
    private static Vector startingDirectories = null;
    private static String CONFIG_FILENAME = "deploytool.conf";
    private static UIConfigProperties configProps = new UIConfigProperties();

    public static String getKeyDefaultValue(String key) {
        Key kr = UIConfig._getKey(key);
        return kr != null ? kr.defaultValue : null;
    }

    public static boolean getKeyDefaultBoolean(String key) {
        String dftVal = UIConfig.getKeyDefaultValue(key);
        return dftVal != null ? Boolean.getBoolean(dftVal) : false;
    }

    public static int getKeyDefaultInteger(String key) {
        String dftVal = UIConfig.getKeyDefaultValue(key);
        if (dftVal != null) {
            try {
                return Integer.parseInt(dftVal);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 0;
    }

    public static String[] getKeyValidValues(String key) {
        Key kr = UIConfig._getKey(key);
        return kr != null ? kr.validValues : null;
    }

    public static int getKeyValueIndex(String key, String val) {
        String[] list = UIConfig.getKeyValidValues(key);
        if (list != null) {
            int v2 = 0;
            while (v2 < list.length) {
                if (list[v2].equalsIgnoreCase(val)) {
                    UIUtils.debugPrintln("Key: " + key + " = " + val + " (" + v2 + ")");
                    return v2;
                }
                ++v2;
            }
        }
        return -1;
    }

    public static void printDefaultConfigKeys(boolean includePrivate) {
        UIUtils.println("\nDefined Deploytool configuration properties:");
        int i2 = 0;
        while (i2 < cfgKeys.length) {
            String scope = UIConfig.cfgKeys[i2].scope;
            if (includePrivate || !scope.equals(PRIVATE)) {
                String key = UIConfig.cfgKeys[i2].key;
                String type = UIConfig.cfgKeys[i2].type;
                String dft = UIConfig.cfgKeys[i2].defaultValue;
                if (key.endsWith("_")) {
                    key = key + "*";
                }
                if (dft.equals("")) {
                    dft = type.endsWith(ARRAY) ? "( ? )" : "?";
                }
                UIUtils.println("  " + scope + " " + type + " " + key + " = " + dft);
            }
            ++i2;
        }
        UIUtils.println("");
    }

    private static Key _getKey(String key) {
        int i2 = 0;
        while (i2 < cfgKeys.length) {
            if (UIConfig.cfgKeys[i2].key.equalsIgnoreCase(key)) {
                return cfgKeys[i2];
            }
            ++i2;
        }
        return null;
    }

    public static boolean debugMode() {
        return isDebugMode;
    }

    private static void _initRuntimeDebugMode() {
        if (!isDebugMode) {
            isDebugMode = UIConfig.getConfigBoolean(DEBUG_MODE) || UIConfig.getConfigBoolean(DEBUG_MODE.toLowerCase()) || Boolean.getBoolean(DEBUG_MODE) || Boolean.getBoolean(DEBUG_MODE.toLowerCase());
        }
    }

    public static boolean testMode() {
        return isTestMode;
    }

    private static void _initRuntimeTestMode() {
        if (!isTestMode) {
            isTestMode = UIConfig.getConfigBoolean(TEST_MODE) || UIConfig.getConfigBoolean(TEST_MODE.toLowerCase());
        }
    }

    public static boolean bugfix(String bugId) {
        return UIConfig.getConfigBoolean(BUGFIX + bugId);
    }

    public static File getDefaultDirectory() {
        if (defaultDirectory == null && (defaultDirectory = UIConfig.getConfigFile(DEFAULT_DIR, null)) == null) {
            String key = DEFAULT_DIR.toLowerCase();
            defaultDirectory = UIConfig.getConfigFile(key, null);
            if (defaultDirectory != null) {
                UIConfig.removeConfigKey(key);
                UIConfig.setConfigFile(DEFAULT_DIR, defaultDirectory);
            } else {
                String dftdir = System.getProperties().getProperty("user.home", "");
                File dftdirFile = new File(dftdir);
                if (dftdirFile.exists()) {
                    defaultDirectory = dftdirFile;
                }
            }
        }
        return defaultDirectory;
    }

    public static void setDefaultDirectory(File tmpdir) {
        defaultDirectory = tmpdir;
        UIConfig.setConfigFile(DEFAULT_DIR, defaultDirectory);
    }

    public static File getTempDirectory() {
        if (tempDirectory == null && (tempDirectory = UIConfig.getConfigFile(TEMP_DIR, null)) == null) {
            String key = TEMP_DIR.toLowerCase();
            tempDirectory = UIConfig.getConfigFile(key, null);
            if (tempDirectory != null) {
                UIConfig.removeConfigKey(key);
                UIConfig.setConfigFile(TEMP_DIR, tempDirectory);
            } else {
                String tmpdir = System.getProperties().getProperty("java.io.tmpdir", "/tmp");
                File tmpdirFile = new File(tmpdir);
                if (tmpdirFile.exists()) {
                    tempDirectory = tmpdirFile;
                }
            }
        }
        return tempDirectory;
    }

    public static void setTempDirectory(File tmpdir) {
        tempDirectory = tmpdir;
        UIConfig.setConfigFile(TEMP_DIR, tempDirectory);
    }

    public static Vector _getStartingDirectories(File defaultDir, Vector cacheList) {
        if (cacheList == null) {
            String[] dirs;
            int max = UIConfig.getMaxStartingDirectories();
            if (max > (dirs = UIConfig.getConfigArray(STARTING_DIRECTORIES)).length) {
                max = dirs.length;
            }
            cacheList = new Vector<File>();
            int i2 = 0;
            while (i2 < max) {
                cacheList.add(new File(dirs[i2]));
                ++i2;
            }
        }
        if (cacheList.size() <= 0 && defaultDir != null) {
            cacheList.add(defaultDir);
        }
        return cacheList;
    }

    public static Vector getStartingDirectories(File defaultDir) {
        if (startingDirectories == null) {
            startingDirectories = UIConfig._getStartingDirectories(defaultDir, null);
        }
        return startingDirectories;
    }

    public static Vector getStartingDirectories() {
        return UIConfig.getStartingDirectories(UIConfig.getDefaultDirectory());
    }

    public static File getStartingDirectory() {
        Object f2 = UIConfig.getStartingDirectories().elementAt(0);
        return f2 instanceof File ? (File)f2 : new File(f2.toString());
    }

    public static Vector _setStartingDirectories(Vector dirs) {
        int max = UIConfig.getMaxStartingDirectories();
        Vector<File> sd = new Vector<File>();
        Enumeration e10 = dirs.elements();
        int i2 = 0;
        while (e10.hasMoreElements() && i2 < max) {
            Object obj = e10.nextElement();
            if (obj instanceof String) {
                sd.add(new File(obj.toString()));
            } else if (obj instanceof File) {
                sd.add((File)obj);
            } else {
                UIUtils.printImplementationError("Not a String/File: " + obj.getClass().getName());
            }
            ++i2;
        }
        return sd;
    }

    public static Vector setStartingDirectories(Vector dirs) {
        startingDirectories = UIConfig._setStartingDirectories(dirs);
        UIConfig.setConfigArray(STARTING_DIRECTORIES, startingDirectories);
        return startingDirectories;
    }

    public static boolean _addStartingDirectory(File dir, Vector cacheList) {
        if (dir != null) {
            if (cacheList == null) {
                UIUtils.printImplementationError("cached starting dirs is 'null'");
                return false;
            }
            cacheList.remove(dir);
            cacheList.insertElementAt(dir, 0);
            if (cacheList.size() > UIConfig.getMaxStartingDirectories()) {
                int ndx = cacheList.size() - 1;
                cacheList.removeElementAt(ndx);
            }
            return true;
        }
        return false;
    }

    public static boolean addStartingDirectory(File dir) {
        if (startingDirectories == null) {
            startingDirectories = UIConfig._getStartingDirectories(UIConfig.getDefaultDirectory(), null);
        }
        if (UIConfig._addStartingDirectory(dir, startingDirectories)) {
            UIConfig.setConfigArray(STARTING_DIRECTORIES, startingDirectories);
            return true;
        }
        return false;
    }

    public static boolean _removeStartingDirectory(File dir, Vector cacheList) {
        if (dir != null) {
            if (cacheList == null) {
                UIUtils.printImplementationError("cached starting dirs is 'null'");
                return false;
            }
            return cacheList.remove(dir);
        }
        return false;
    }

    public static boolean removeStartingDirectory(File dir) {
        if (startingDirectories == null) {
            startingDirectories = UIConfig._getStartingDirectories(UIConfig.getDefaultDirectory(), null);
        }
        if (UIConfig._removeStartingDirectory(dir, startingDirectories)) {
            UIConfig.setConfigArray(STARTING_DIRECTORIES, startingDirectories);
            return true;
        }
        return false;
    }

    public static int getMaxStartingDirectories() {
        return UIConfig.getConfigInteger(MAX_STARTING_DIRECTORIES);
    }

    public static void setMaxStartingDirectories(int max) {
        UIConfig.setConfigInteger(MAX_STARTING_DIRECTORIES, max);
    }

    public static boolean loadConfig(File homeDir) {
        boolean loaded = false;
        File cfgFile = new File(homeDir, CONFIG_FILENAME);
        configProps.setConfigFile(cfgFile);
        if (cfgFile.exists()) {
            try {
                configProps.loadFile();
                loaded = true;
                UIConfig._configInit();
            }
            catch (Throwable t2) {
                UIConfig.println("[Load] " + cfgFile.toString() + " - " + t2.toString());
                loaded = false;
            }
        }
        return loaded;
    }

    protected static void _configInit() {
        UIConfig._initRuntimeDebugMode();
        UIConfig._initRuntimeTestMode();
        if (UIConfig.getConfigBoolean(PRINT_CONFIG_KEYS)) {
            UIConfig.printDefaultConfigKeys(true);
        }
    }

    public static void removeConfigKey(String key) {
        configProps.removeKey(key);
    }

    public static String getConfigValue(String key, String dftVal) {
        return configProps.getProperty(key, dftVal);
    }

    public static String getConfigValue(String key) {
        return UIConfig.getConfigValue(key, UIConfig.getKeyDefaultValue(key));
    }

    public static void setConfigValue(String key, String value) {
        if (value != null) {
            configProps.setProperty(key, value);
        } else {
            UIConfig.removeConfigKey(key);
        }
    }

    public static String[] getConfigArray(String key, String[] dftVal) {
        String v2 = configProps.getProperty(key, null);
        return v2 != null ? UIConfig.stringToArray(v2) : dftVal;
    }

    public static String[] getConfigArray(String key) {
        return UIConfig.getConfigArray(key, new String[0]);
    }

    public static void setConfigArray(String key, Object[] value) {
        if (value != null) {
            configProps.setProperty(key, UIConfig.arrayToString(value));
        } else {
            UIConfig.removeConfigKey(key);
        }
    }

    public static void setConfigArray(String key, List value) {
        Object[] list = value != null ? value.toArray() : null;
        UIConfig.setConfigArray(key, list);
    }

    public static boolean getConfigBoolean(String key, boolean dftVal) {
        return UIConfig.getConfigValue(key, dftVal ? TRUE : FALSE).equalsIgnoreCase(TRUE);
    }

    public static boolean getConfigBoolean(String key) {
        return UIConfig.getConfigBoolean(key, UIConfig.getKeyDefaultBoolean(key));
    }

    public static void setConfigBoolean(String key, boolean value) {
        UIConfig.setConfigValue(key, value ? TRUE : FALSE);
    }

    /*
     * Unable to fully structure code
     */
    public static int getConfigInteger(String key, int dftVal) {
        num = UIConfig.getConfigValue(key, null);
        if (num == null || num.equals("")) {
            return dftVal;
        }
        try {
            return Integer.parseInt(num);
        }
        catch (NumberFormatException nfe) {
            len = num.length();
            p = num.charAt(0) == '-' ? 1 : 0;
            ** while (p < len && Character.isDigit((char)num.charAt((int)p)))
        }
lbl-1000:
        // 1 sources

        {
            ++p;
            continue;
        }
lbl12:
        // 1 sources

        try {
            return Integer.parseInt(num.substring(0, p));
        }
        catch (NumberFormatException nfe) {
            kv = UIConfig.getKeyValueIndex(key, num);
            if (kv >= 0) {
                return kv;
            }
            return dftVal;
        }
    }

    public static int getConfigInteger(String key) {
        return UIConfig.getConfigInteger(key, UIConfig.getKeyDefaultInteger(key));
    }

    public static void setConfigInteger(String key, int value) {
        UIConfig.setConfigValue(key, String.valueOf(value));
    }

    public static File getConfigFile(String key, File dftVal) {
        String fileName = UIConfig.getConfigValue(key, null);
        return fileName != null ? new File(fileName) : dftVal;
    }

    public static File getConfigFile(String key) {
        return UIConfig.getConfigFile(key, null);
    }

    public static void setConfigFile(String key, File value) {
        if (value != null) {
            UIConfig.setConfigValue(key, value.getAbsolutePath());
        } else {
            UIConfig.removeConfigKey(key);
        }
    }

    public static Color getConfigColor(String key, Color dftVal) {
        Color rtnColor = dftVal;
        String cn2 = UIConfig.getConfigValue(key, null);
        if (cn2 == null) {
            return rtnColor;
        }
        if (cn2.startsWith("#")) {
            try {
                int colorVal = Integer.decode(cn2);
                rtnColor = new Color(colorVal);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            return rtnColor;
        }
        if (cn2.equalsIgnoreCase("black")) {
            rtnColor = Color.black;
        } else if (cn2.equalsIgnoreCase("blue")) {
            rtnColor = Color.blue;
        } else if (cn2.equalsIgnoreCase("cyan")) {
            rtnColor = Color.cyan;
        } else if (cn2.equalsIgnoreCase("darkGray")) {
            rtnColor = Color.darkGray;
        } else if (cn2.equalsIgnoreCase("gray")) {
            rtnColor = Color.gray;
        } else if (cn2.equalsIgnoreCase("green")) {
            rtnColor = Color.green;
        } else if (cn2.equalsIgnoreCase("lightGray")) {
            rtnColor = Color.lightGray;
        } else if (cn2.equalsIgnoreCase("magenta")) {
            rtnColor = Color.magenta;
        } else if (cn2.equalsIgnoreCase("orange")) {
            rtnColor = Color.orange;
        } else if (cn2.equalsIgnoreCase("pink")) {
            rtnColor = Color.pink;
        } else if (cn2.equalsIgnoreCase("red")) {
            rtnColor = Color.red;
        } else if (cn2.equalsIgnoreCase("white")) {
            rtnColor = Color.white;
        } else if (cn2.equalsIgnoreCase("yellow")) {
            rtnColor = Color.yellow;
        }
        return rtnColor;
    }

    public static Color getConfigColor(String key) {
        return UIConfig.getConfigColor(key, null);
    }

    public static void setConfigColor(String key, Color value) {
        if (value == null) {
            UIConfig.removeConfigKey(key);
            return;
        }
        String colorName = null;
        if (value.equals(Color.black)) {
            colorName = "black";
        } else if (value.equals(Color.blue)) {
            colorName = "blue";
        } else if (value.equals(Color.cyan)) {
            colorName = "cyan";
        } else if (value.equals(Color.darkGray)) {
            colorName = "darkGray";
        } else if (value.equals(Color.gray)) {
            colorName = "gray";
        } else if (value.equals(Color.green)) {
            colorName = "green";
        } else if (value.equals(Color.lightGray)) {
            colorName = "lightGray";
        } else if (value.equals(Color.magenta)) {
            colorName = "magenta";
        } else if (value.equals(Color.orange)) {
            colorName = "orange";
        } else if (value.equals(Color.pink)) {
            colorName = "pink";
        } else if (value.equals(Color.red)) {
            colorName = "red";
        } else if (value.equals(Color.white)) {
            colorName = "white";
        } else if (value.equals(Color.yellow)) {
            colorName = "yellow";
        }
        if (colorName != null) {
            UIConfig.setConfigValue(key, colorName);
            return;
        }
        String hex = Integer.toHexString(0x1000000 + value.getRGB());
        hex = hex.substring(hex.length() - 6);
        UIConfig.setConfigValue(key, "#" + hex);
    }

    public static String[] stringToArray(String value) {
        String v2 = value.trim();
        if (!v2.startsWith("(") || !v2.endsWith(")")) {
            return new String[]{v2};
        }
        Vector<String> list = new Vector<String>();
        boolean quoted = false;
        StringBuffer sb = new StringBuffer();
        v2 = v2.substring(1, v2.length() - 1) + " ";
        char[] chr = v2.toCharArray();
        int i2 = 0;
        while (i2 < chr.length) {
            if (!quoted && Character.isWhitespace(chr[i2])) {
                if (sb.length() > 0) {
                    list.add(sb.toString());
                    sb.setLength(0);
                }
            } else if (chr[i2] == '\\') {
                sb.append(chr[i2]);
            } else if (chr[i2] == '\"') {
                if (quoted) {
                    if (sb.length() > 0) {
                        list.add(sb.toString());
                        sb.setLength(0);
                    }
                    quoted = false;
                } else if (sb.length() > 0) {
                    sb.append(chr[i2]);
                } else {
                    quoted = true;
                }
            } else {
                sb.append(chr[i2]);
            }
            ++i2;
        }
        return list.toArray(new String[0]);
    }

    public static String arrayToString(Object[] v2) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int i2 = 0;
        while (i2 < v2.length) {
            String s2 = v2[i2].toString();
            boolean q2 = false;
            if (i2 > 0) {
                sb.append(" ");
            }
            if (s2.indexOf("\"") >= 0) {
                StringBuffer vsb = new StringBuffer();
                char[] chr = s2.toCharArray();
                int c10 = 0;
                while (c10 < chr.length) {
                    if (chr[c10] == '\"') {
                        vsb.append("\\");
                    }
                    vsb.append(chr[c10]);
                    ++c10;
                }
                s2 = vsb.toString();
                q2 = true;
            } else if (s2.indexOf(" ") >= 0 || s2.indexOf("\t") >= 0) {
                q2 = true;
            }
            if (q2) {
                sb.append("\"");
            }
            sb.append(s2);
            if (q2) {
                sb.append("\"");
            }
            ++i2;
        }
        sb.append(")");
        return sb.toString();
    }

    public static boolean saveConfig() {
        boolean saved = false;
        try {
            configProps.save("DeployTool UI Runtime Config");
            saved = true;
        }
        catch (Throwable t2) {
            UIConfig.println("[Save] " + configProps.toString() + " - " + t2.toString());
            saved = false;
        }
        return saved;
    }

    public static void println(String msg) {
        UIUtils.println("Config: " + msg);
    }

    public static void main(String[] argv) {
        String x2 = "(/home/test1 /home/\"test2 \"/home/test 3\")";
        Object[] s2 = UIConfig.stringToArray(x2);
        int i2 = 0;
        while (i2 < s2.length) {
            UIUtils.println(i2 + "] " + (String)s2[i2]);
            ++i2;
        }
        String ss = UIConfig.arrayToString(s2);
        UIUtils.println("\nstring] " + ss);
        System.exit(0);
    }

    private static class Key {
        public String key = null;
        public String type = null;
        public String defaultValue = null;
        public String[] validValues = null;
        public String scope = null;

        public Key(String key, String type, String scope, String[] validValues, String defaultValue) {
            this.key = key;
            this.type = type;
            this.defaultValue = defaultValue;
            this.validValues = validValues;
            this.scope = scope;
        }
    }
}

