/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.rescfg;

import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.sharedpassword.SharedPasswordRealm;
import com.sun.enterprise.tools.deployment.ui.DeployToolActions;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.rescfg.ConfInstlDlgUsersPnl;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

class GroupsDialog
extends UIDialog {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$rescfg$GroupsDialog == null ? (class$com$sun$enterprise$tools$deployment$ui$rescfg$GroupsDialog = GroupsDialog.class$("com.sun.enterprise.tools.deployment.ui.rescfg.GroupsDialog")) : class$com$sun$enterprise$tools$deployment$ui$rescfg$GroupsDialog);
    private static String TITLE = localStrings.getLocalString("ui.groupsdialog.title", "Groups");
    private static String GROUPS = localStrings.getLocalString("ui.groupsdialog.groups", "Groups");
    private static String ADD = localStrings.getLocalString("ui.configurationdialog.add", "Add");
    private static String REMOVE = localStrings.getLocalString("ui.configurationdialog.remove", "Remove...");
    private static String OK = localStrings.getLocalString("ui.configurationdialog.ok", "OK");
    private static String CANCEL = localStrings.getLocalString("ui.configurationdialog.cancel", "Cancel");
    private static String HELP = localStrings.getLocalString("ui.configurationdialog.help", "Help...");
    private static String helpSetMapID = "EditGroups";
    private GroupsTable groupsTable;
    private GroupsTableModel grpsTableModel;
    private Vector grpsToBeDeleted = null;
    private Vector grpsToBeAdded = null;
    private boolean isChanged = false;
    private boolean debug = false;
    private boolean restartSrvr = false;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$rescfg$GroupsDialog;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public GroupsDialog(Dialog parent) {
        super(parent, true);
        this.initDialog(parent);
    }

    private void initDialog(Dialog parent) {
        this.setTitle(TITLE);
        this.setWindowClosingAction(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                GroupsDialog.this.cancelAction();
            }
        });
        GridBagConstraints c10 = new GridBagConstraints();
        this.getContentPane().setLayout(new GridBagLayout());
        UITitledTable groupsPanel = new UITitledTable(null, false);
        c10.gridx = 0;
        c10.gridy = 0;
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        this.getContentPane().add((Component)groupsPanel, c10);
        this.grpsTableModel = new GroupsTableModel();
        this.groupsTable = new GroupsTable(this.grpsTableModel);
        groupsPanel.getGBConstraints().weighty = 0.85;
        groupsPanel.setTableView(this.groupsTable);
        JButton addButton = new JButton(ADD);
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                GroupsDialog.this.addAction();
            }
        });
        groupsPanel.addControlButton(addButton);
        JButton removeButton = new JButton(REMOVE);
        removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                GroupsDialog.this.removeAction();
            }
        });
        groupsPanel.addSelectionEnabledButton(removeButton);
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.anchor = 13;
        c10.fill = 2;
        c10.insets = new Insets(0, 5, 5, 5);
        this.getContentPane().add((Component)this.getButtonsPanel(), c10);
        this.refresh();
        Rectangle b10 = parent.getBounds();
        b10.x += 50;
        b10.y += 50;
        b10.width = 350;
        b10.height = 350;
        ((Component)this).setBounds(b10);
        this.setVisible(true);
    }

    public JPanel getButtonsPanel() {
        UITitledControlButtonBox buttonsPanel = new UITitledControlButtonBox(null, false);
        buttonsPanel.setControlButtonLocation(15);
        JButton btnOK = new JButton(OK);
        btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                GroupsDialog.this.okAction();
            }
        });
        buttonsPanel.getGBConstraints().anchor = 13;
        buttonsPanel.addControlButton(btnOK);
        JButton btnCancel = new JButton(CANCEL);
        btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                GroupsDialog.this.cancelAction();
            }
        });
        buttonsPanel.addControlButton(btnCancel);
        JButton btnHelp = new JButton(HELP);
        btnHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
            }
        });
        buttonsPanel.addControlButton(btnHelp);
        DeployToolActions.enableHelpOnButton(btnHelp, helpSetMapID);
        return buttonsPanel;
    }

    public void refresh() {
        this.getGroupsTableModel().deleteAllGroups();
        this.getGroupsTableModel().fireTableDataChanged();
        this.restartSrvr = false;
        this.grpsToBeDeleted = new Vector();
        this.grpsToBeAdded = new Vector();
        SharedPasswordRealm deftRealm = ConfInstlDlgUsersPnl.getDefaultRealm();
        Enumeration groups = null;
        Vector originalGrps = new Vector();
        if (deftRealm != null) {
            try {
                ((Realm)deftRealm).refresh();
                groups = ((Realm)deftRealm).getGroupNames();
            }
            catch (BadRealmException e10) {
                System.out.println("Exception: There was a problem while getting Groups");
                e10.printStackTrace();
            }
        }
        while (groups.hasMoreElements()) {
            originalGrps.addElement(groups.nextElement());
        }
        if (originalGrps.size() > 0) {
            this.getGroupsTableModel().addAllGroups(originalGrps);
            this.getGroupsTableModel().fireTableDataChanged();
        }
    }

    private void okAction() {
        if (this.isDirty()) {
            this.save();
        }
        this.setVisible(false);
    }

    private void cancelAction() {
        this.setVisible(false);
    }

    private void addAction() {
        GroupsTableModel model = (GroupsTableModel)this.groupsTable.getModel();
        model.addGroup("");
        model.fireTableDataChanged();
    }

    private void removeAction() {
        int n2;
        GroupsTableModel model = (GroupsTableModel)this.groupsTable.getModel();
        ListSelectionModel sm = this.groupsTable.getSelectionModel();
        int minIndex = sm.getMinSelectionIndex();
        int maxIndex = sm.getMaxSelectionIndex();
        if (minIndex >= 0 && (n2 = JOptionPane.showConfirmDialog(this, localStrings.getLocalString("ui.groupsdialog.removegroupconfirmation", "Are you sure you want to delete selected Group(s)?"), "Delete Groups", 0)) == 0) {
            Vector<Object> v2 = new Vector<Object>();
            int i2 = minIndex;
            while (i2 <= maxIndex) {
                v2.addElement(model.getGroup(i2));
                ++i2;
            }
            model.deleteGroups(v2);
            model.fireTableDataChanged();
            int j2 = 0;
            while (j2 < v2.size()) {
                String name = (String)v2.elementAt(j2);
                if (!this.grpsToBeDeleted.contains(name)) {
                    this.grpsToBeDeleted.addElement(name);
                }
                ++j2;
            }
            this.setDirty(true);
        }
    }

    private void save() {
        try {
            SharedPasswordRealm r2 = ConfInstlDlgUsersPnl.getDefaultRealm();
            String group = "";
            int i2 = 0;
            while (i2 < this.grpsToBeDeleted.size()) {
                group = (String)this.grpsToBeDeleted.elementAt(i2);
                r2.removeGroup(group.trim());
                ++i2;
            }
            int j2 = 0;
            while (j2 < this.grpsToBeAdded.size()) {
                group = (String)this.grpsToBeAdded.elementAt(j2);
                r2.addGroup(group.trim());
                this.restartSrvr = true;
                ++j2;
            }
        }
        catch (Exception e10) {
            System.out.println("Exception: There was a problem while saving Groups");
            e10.printStackTrace();
        }
    }

    public void valueModified(String oldName, String newName) {
        if (!this.grpsToBeDeleted.contains(oldName)) {
            this.grpsToBeDeleted.addElement(oldName);
        }
        if (!this.grpsToBeAdded.contains(newName)) {
            this.grpsToBeAdded.addElement(newName);
        }
        this.setDirty(true);
    }

    private GroupsTableModel getGroupsTableModel() {
        return this.grpsTableModel;
    }

    private void setDirty(boolean value) {
        this.isChanged = value;
    }

    private boolean isDirty() {
        return this.isChanged;
    }

    public boolean isRestartSrvr() {
        return this.restartSrvr;
    }

    private Frame getFrame() {
        return (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = GroupsDialog.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, this);
    }

    public static void main(String[] args) {
        UIDialog frm = UIDialog.newDialog(null, false);
        frm.getContentPane().setLayout(new BorderLayout());
        new GroupsDialog(frm);
        ((Component)frm).setSize(500, 300);
        frm.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e10) {
                System.exit(0);
            }
        });
        frm.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ String access$400() {
        return GROUPS;
    }

    class GroupsTableModel
    extends AbstractTableModel {
        List list = Collections.synchronizedList(new ArrayList());
        String[] columnNames = new String[]{GroupsDialog.access$400()};

        GroupsTableModel() {
        }

        public void addGroup(Object group) {
            this.list.add(group);
        }

        public void addAllGroups(Collection groups) {
            this.list.addAll(groups);
        }

        public void deleteGroup(int index) {
            this.list.remove(index);
        }

        public void deleteGroups(Collection groups) {
            this.list.removeAll(groups);
        }

        public void deleteAllGroups() {
            this.list.clear();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.list.size();
        }

        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public Object getValueAt(int row, int col) {
            String value = (String)this.list.get(row);
            return value;
        }

        public Object getGroup(int index) {
            if (index < 0 || index >= this.getRowCount()) {
                return null;
            }
            return this.list.get(index);
        }

        public void setValueAt(Object value, int row, int col) {
            String oldName = (String)this.list.get(row);
            String newName = (String)value;
            if (col == 0 && !oldName.equals(newName)) {
                if (!this.list.contains(newName)) {
                    this.list.set(row, newName);
                    GroupsDialog.this.valueModified(oldName, newName);
                } else {
                    JOptionPane.showMessageDialog(GroupsDialog.this.getFrame(), localStrings.getLocalString("ui.groupsdialog.grpalreadypresnet", "Group already exist!"), "Warning Message", 2);
                    this.list.set(row, oldName);
                }
            }
        }
    }

    class GroupsTable
    extends InspectorTable {
        public GroupsTable(GroupsTableModel model) {
            super(model);
            this.setSelectionMode(1);
        }
    }
}

