/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.rescfg;

import com.sun.enterprise.repository.ResourceAdmin;
import com.sun.enterprise.repository.ResourceAdminImpl;
import com.sun.enterprise.tools.deployment.ui.DeployToolActions;
import com.sun.enterprise.tools.deployment.ui.rescfg.ConfInstlDlgConnFactPnl;
import com.sun.enterprise.tools.deployment.ui.rescfg.ConfInstlDlgDestinationsPnl;
import com.sun.enterprise.tools.deployment.ui.rescfg.ConfInstlDlgStandardPnl;
import com.sun.enterprise.tools.deployment.ui.rescfg.ConfInstlDlgUsersPnl;
import com.sun.enterprise.tools.deployment.ui.rescfg.ConfInstlDlgXAPnl;
import com.sun.enterprise.tools.deployment.ui.utils.UICardPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIIcons;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledControlButtonBox;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class ConfigurationDialog
extends UIDialog {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$rescfg$ConfigurationDialog == null ? (class$com$sun$enterprise$tools$deployment$ui$rescfg$ConfigurationDialog = ConfigurationDialog.class$("com.sun.enterprise.tools.deployment.ui.rescfg.ConfigurationDialog")) : class$com$sun$enterprise$tools$deployment$ui$rescfg$ConfigurationDialog);
    private static String TITLE = localStrings.getLocalString("ui.configurationdialog.title", "Configure Installtion");
    private static String OK = localStrings.getLocalString("ui.configurationdialog.ok", "OK");
    private static String CANCEL = localStrings.getLocalString("ui.configurationdialog.cancel", "Cancel");
    private static String HELP = localStrings.getLocalString("ui.configurationdialog.help", "Help...");
    private static String helpSetMapID = "ICConfig";
    public static final String J2EESRVR = "J2EE Server";
    public static final String GENERAL = "General";
    public static final String ADVANCED = "Advanced";
    public static final String USERS = "Users";
    public static final String DATASRC = "Data Sources";
    public static final String STANDARD = "Standard";
    public static final String XA = "XA";
    public static final String JMS = "JMS";
    public static final String CNXFACT = "Connection Factories";
    public static final String DESTINATIONS = "Destinations";
    public static final String BLANK = "Blank";
    private JTree configTree = new JTree();
    private ConfigurationTreeView treeView;
    private UICardPanel workArea;
    private Frame parent;
    private JButton btnHelp;
    private ConfInstlDlgUsersPnl usersPanel;
    private ConfInstlDlgStandardPnl standardPanel;
    private ConfInstlDlgXAPnl xaPanel;
    private ConfInstlDlgConnFactPnl connFactPanel;
    private ConfInstlDlgDestinationsPnl destinationsPanel;
    private String selection = "Blank";
    private String restartMsg = "";
    private static ResourceAdmin resourceAdmin = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$rescfg$ConfigurationDialog;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public String getHelpID() {
        if (this.selection.equals(J2EESRVR)) {
            return "ICServer";
        }
        if (this.selection.equals(USERS)) {
            return "ICUsers";
        }
        if (this.selection.equals(DATASRC)) {
            return "ICDataSource";
        }
        if (this.selection.equals(STANDARD)) {
            return "ICStandard";
        }
        if (this.selection.equals(XA)) {
            return "ICXA";
        }
        if (this.selection.equals(JMS)) {
            return "ICJMS";
        }
        if (this.selection.equals(CNXFACT)) {
            return "ICCF";
        }
        if (this.selection.equals(DESTINATIONS)) {
            return "ICDest";
        }
        return helpSetMapID;
    }

    public ConfigurationDialog(Frame parent, String selection) {
        super(parent, true);
        this.parent = parent;
        this.setWindowClosingAction(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                ConfigurationDialog.this.cancelAction();
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", this.getWorkspacePanel());
        this.getContentPane().add("South", this.getButtonsPanel());
        this.setTitle(TITLE);
        ((Component)this).setBounds(parent.getBounds().x + 100, parent.getBounds().y + 100, 700, 550);
        this.refresh(selection);
        this.setVisible(true);
    }

    public ConfigurationDialog(Frame parent) {
        this(parent, null);
    }

    public JComponent getWorkspacePanel() {
        JPanel workspacePanel = new JPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        workspacePanel.setLayout(new GridBagLayout());
        this.treeView = this.getConfigurationTreeView();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.3;
        gbc.weighty = 0.5;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 1;
        workspacePanel.add((Component)this.treeView, gbc);
        this.workArea = new UICardPanel();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.7;
        gbc.weighty = 0.5;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 1;
        workspacePanel.add((Component)this.workArea, gbc);
        this.workArea.addCard(new JPanel(), BLANK);
        return workspacePanel;
    }

    public JPanel getButtonsPanel() {
        UITitledControlButtonBox buttonsPanel = new UITitledControlButtonBox(null, false);
        buttonsPanel.setControlButtonLocation(15);
        JButton btnOK = new JButton(OK);
        btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ConfigurationDialog.this.okAction();
            }
        });
        buttonsPanel.getGBConstraints().anchor = 13;
        buttonsPanel.addControlButton(btnOK);
        JButton btnCancel = new JButton(CANCEL);
        btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                ConfigurationDialog.this.cancelAction();
            }
        });
        buttonsPanel.addControlButton(btnCancel);
        this.btnHelp = new JButton(HELP);
        buttonsPanel.addControlButton(this.btnHelp);
        DeployToolActions.enableHelpOnButton(this.btnHelp, this.getHelpID());
        return buttonsPanel;
    }

    public void refresh(String selection, ResourceAdmin resAdmin) {
        resourceAdmin = resAdmin == null ? new ResourceAdminImpl() : resAdmin;
        this.selection = selection != null && !selection.equals("") ? selection : BLANK;
        this.restartMsg = "";
        this.treeView.expandAllNodes();
        this.refreshAllNodes();
        this.setGivenNode(selection);
    }

    public void refresh(String selection) {
        this.refresh(selection, null);
    }

    private void okAction() {
        this.saveChanges();
    }

    private void cancelAction() {
        this.setVisible(false);
    }

    private void saveChanges() {
        if (this.usersPanel != null) {
            this.usersPanel.saveData();
            if (this.usersPanel.isSrvrRestart()) {
                this.restartMsg = this.restartMsg + "U";
            }
        }
        if (this.standardPanel != null) {
            this.standardPanel.saveData();
        }
        if (this.xaPanel != null) {
            if (this.xaPanel.checkForDuplicateProps()) {
                this.setGivenNode(XA);
                return;
            }
            this.xaPanel.saveData();
            if (this.xaPanel.isSrvrRestart()) {
                this.restartMsg = this.restartMsg + "X";
            }
        }
        if (this.connFactPanel != null) {
            this.connFactPanel.saveData();
            if (this.connFactPanel.isSrvrRestart()) {
                this.restartMsg = this.restartMsg + "C";
            }
        }
        if (this.destinationsPanel != null) {
            this.destinationsPanel.saveData();
        }
        if (!this.restartMsg.equals("")) {
            String msg = localStrings.getLocalString("ui.configurationdialog.restartserver", "Changes in following settings will take effect after restarting the J2EE server.\n");
            if (this.restartMsg.indexOf(71) >= 0) {
                msg = msg + "                General\n";
            }
            if (this.restartMsg.indexOf(65) >= 0) {
                msg = msg + "                Advanced\n";
            }
            if (this.restartMsg.indexOf(85) >= 0) {
                msg = msg + "                Users\n";
            }
            if (this.restartMsg.indexOf(88) >= 0) {
                msg = msg + "                XA Datasources\n";
            }
            if (this.restartMsg.indexOf(67) >= 0) {
                msg = msg + "                Connection Factories";
            }
            JOptionPane.showMessageDialog(this.getFrame(), msg, "Message Dialog", 2);
        }
        this.setVisible(false);
    }

    private void refreshAllNodes() {
        if (this.usersPanel != null) {
            this.usersPanel.refresh();
        }
        if (this.standardPanel != null) {
            this.standardPanel.refresh();
        }
        if (this.xaPanel != null) {
            this.xaPanel.refresh();
        }
        if (this.connFactPanel != null) {
            this.connFactPanel.refresh();
        }
        if (this.destinationsPanel != null) {
            this.destinationsPanel.refresh();
        }
    }

    private void setGivenNode(String nodeName) {
        DefaultMutableTreeNode node = this.treeView.getNodeByName(nodeName);
        if (node != null) {
            this.configTree.setSelectionPath(new TreePath(node.getPath()));
        } else {
            this.configTree.setSelectionRow(-1);
        }
    }

    public static ResourceAdmin getResourceAdmin() {
        if (resourceAdmin == null) {
            resourceAdmin = new ResourceAdminImpl();
        }
        return resourceAdmin;
    }

    private ConfigurationTreeView getConfigurationTreeView() {
        if (this.treeView == null) {
            this.treeView = new ConfigurationTreeView(this.configTree);
            this.configTree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent tse) {
                    JTree srcTree = (JTree)tse.getSource();
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)srcTree.getLastSelectedPathComponent();
                    if (node == null) {
                        ConfigurationDialog.this.workArea.showCard(ConfigurationDialog.BLANK);
                        ConfigurationDialog.this.selection = ConfigurationDialog.BLANK;
                        DeployToolActions.enableHelpOnButton(ConfigurationDialog.this.btnHelp, ConfigurationDialog.this.getHelpID());
                        return;
                    }
                    String nodeName = (String)node.getUserObject();
                    if (ConfigurationDialog.this.xaPanel != null && !ConfigurationDialog.this.selection.equals(nodeName) && ConfigurationDialog.this.selection.equals(ConfigurationDialog.XA)) {
                        if (ConfigurationDialog.this.xaPanel.checkForDuplicateProps()) {
                            ConfigurationDialog.this.setGivenNode(ConfigurationDialog.this.selection);
                        } else {
                            ConfigurationDialog.this.selection = nodeName;
                        }
                    } else {
                        ConfigurationDialog.this.selection = nodeName;
                    }
                    DeployToolActions.enableHelpOnButton(ConfigurationDialog.this.btnHelp, ConfigurationDialog.this.getHelpID());
                    if (ConfigurationDialog.this.selection.equals(ConfigurationDialog.USERS)) {
                        if (ConfigurationDialog.this.usersPanel == null) {
                            ConfigurationDialog.this.usersPanel = new ConfInstlDlgUsersPnl();
                            ConfigurationDialog.this.workArea.addCard(ConfigurationDialog.this.usersPanel, ConfigurationDialog.USERS);
                        }
                        ConfigurationDialog.this.workArea.showCard(ConfigurationDialog.USERS);
                    } else if (ConfigurationDialog.this.selection.equals(ConfigurationDialog.STANDARD)) {
                        if (ConfigurationDialog.this.standardPanel == null) {
                            ConfigurationDialog.this.standardPanel = new ConfInstlDlgStandardPnl();
                            ConfigurationDialog.this.workArea.addCard(ConfigurationDialog.this.standardPanel, ConfigurationDialog.STANDARD);
                        }
                        ConfigurationDialog.this.workArea.showCard(ConfigurationDialog.STANDARD);
                    } else if (ConfigurationDialog.this.selection.equals(ConfigurationDialog.XA)) {
                        if (ConfigurationDialog.this.xaPanel == null) {
                            ConfigurationDialog.this.xaPanel = new ConfInstlDlgXAPnl();
                            ConfigurationDialog.this.workArea.addCard(ConfigurationDialog.this.xaPanel, ConfigurationDialog.XA);
                        }
                        ConfigurationDialog.this.workArea.showCard(ConfigurationDialog.XA);
                    } else if (ConfigurationDialog.this.selection.equals(ConfigurationDialog.CNXFACT)) {
                        if (ConfigurationDialog.this.connFactPanel == null) {
                            ConfigurationDialog.this.connFactPanel = new ConfInstlDlgConnFactPnl();
                            ConfigurationDialog.this.workArea.addCard(ConfigurationDialog.this.connFactPanel, ConfigurationDialog.CNXFACT);
                        }
                        ConfigurationDialog.this.workArea.showCard(ConfigurationDialog.CNXFACT);
                    } else if (ConfigurationDialog.this.selection.equals(ConfigurationDialog.DESTINATIONS)) {
                        if (ConfigurationDialog.this.destinationsPanel == null) {
                            ConfigurationDialog.this.destinationsPanel = new ConfInstlDlgDestinationsPnl();
                            ConfigurationDialog.this.workArea.addCard(ConfigurationDialog.this.destinationsPanel, ConfigurationDialog.DESTINATIONS);
                        }
                        ConfigurationDialog.this.workArea.showCard(ConfigurationDialog.DESTINATIONS);
                    } else {
                        ConfigurationDialog.this.workArea.showCard(ConfigurationDialog.BLANK);
                    }
                }
            });
        }
        this.treeView.setPreferredSize(this.treeView.getMaximumSize());
        return this.treeView;
    }

    private Frame getFrame() {
        return (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = ConfigurationDialog.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, this);
    }

    public String toString() {
        return localStrings.getLocalString("ui.configurationdialog.name", "Configure Installation Dialog");
    }

    public static void main(String[] args) {
        JFrame frm = new JFrame();
        frm.getContentPane().setLayout(new BorderLayout());
        new ConfigurationDialog((Frame)frm, null);
        ((Component)frm).setSize(500, 400);
        frm.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e10) {
                System.exit(0);
            }
        });
        ((Component)frm).setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class RootTreeCellRenderer
    extends DefaultTreeCellRenderer {
        RootTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Color textColor = Color.black;
            JLabel defaultRenderingLabel = (JLabel)super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode tn = (DefaultMutableTreeNode)value;
                Object obj = tn.getUserObject();
                ImageIcon icon = this.getIconForDescriptor(obj);
                defaultRenderingLabel.setIcon(icon);
            }
            return defaultRenderingLabel;
        }

        public ImageIcon getIconForDescriptor(Object node) {
            ImageIcon icon = null;
            icon = node.equals("J2EEServer") || node.equals(ConfigurationDialog.JMS) ? UIIcons.getDefaultIcon() : (node.equals(ConfigurationDialog.DATASRC) ? UIIcons.getDefaultIcon() : UIIcons.getDefaultIcon());
            if (icon == null) {
                icon = UIIcons.getDefaultIcon();
            }
            return icon;
        }
    }

    class ConfigurationTreeView
    extends JPanel {
        private JTree tree;
        private DefaultMutableTreeNode fixedRootNode;
        private DefaultMutableTreeNode j2eeServerNode;
        private DefaultMutableTreeNode dataSourcesNode;
        private DefaultMutableTreeNode jmsNode;
        Hashtable nodeTable;

        public ConfigurationTreeView(JTree rootTree) {
            this.tree = rootTree;
            this.nodeTable = new Hashtable();
            this.createFixedNodes();
            this.tree.setModel(new DefaultTreeModel(this.fixedRootNode));
            this.tree.setRootVisible(false);
            this.tree.setShowsRootHandles(true);
            this.setLayout(new BorderLayout());
            JPanel mainPanel = new JPanel();
            mainPanel.setBorder(new LineBorder(Color.black, 0));
            mainPanel.setLayout(new BorderLayout());
            mainPanel.add(new JScrollPane(this.tree));
            this.add(mainPanel);
            TreeSelectionModel selectionModel = this.tree.getSelectionModel();
            selectionModel.setSelectionMode(1);
            this.tree.setSelectionModel(selectionModel);
        }

        public void createFixedNodes() {
            this.fixedRootNode = new DefaultMutableTreeNode("Root", true);
            DefaultMutableTreeNode node = null;
            this.j2eeServerNode = new DefaultMutableTreeNode(ConfigurationDialog.J2EESRVR, true);
            this.fixedRootNode.add(this.j2eeServerNode);
            node = new DefaultMutableTreeNode(ConfigurationDialog.GENERAL, false);
            this.nodeTable.put(ConfigurationDialog.GENERAL, node);
            node = new DefaultMutableTreeNode(ConfigurationDialog.ADVANCED, false);
            this.nodeTable.put(ConfigurationDialog.ADVANCED, node);
            node = new DefaultMutableTreeNode(ConfigurationDialog.USERS, false);
            this.j2eeServerNode.add(node);
            this.nodeTable.put(ConfigurationDialog.USERS, node);
            this.dataSourcesNode = new DefaultMutableTreeNode(ConfigurationDialog.DATASRC, true);
            this.fixedRootNode.add(this.dataSourcesNode);
            node = new DefaultMutableTreeNode(ConfigurationDialog.STANDARD, false);
            this.dataSourcesNode.add(node);
            this.nodeTable.put(ConfigurationDialog.STANDARD, node);
            node = new DefaultMutableTreeNode(ConfigurationDialog.XA, false);
            this.dataSourcesNode.add(node);
            this.nodeTable.put(ConfigurationDialog.XA, node);
            this.jmsNode = new DefaultMutableTreeNode(ConfigurationDialog.JMS, true);
            this.fixedRootNode.add(this.jmsNode);
            node = new DefaultMutableTreeNode(ConfigurationDialog.CNXFACT, false);
            this.jmsNode.add(node);
            this.nodeTable.put(ConfigurationDialog.CNXFACT, node);
            node = new DefaultMutableTreeNode(ConfigurationDialog.DESTINATIONS, false);
            this.jmsNode.add(node);
            this.nodeTable.put(ConfigurationDialog.DESTINATIONS, node);
        }

        public DefaultMutableTreeNode getNodeByName(String key) {
            if (key == null || key.equals("")) {
                return null;
            }
            return (DefaultMutableTreeNode)this.nodeTable.get(key);
        }

        public void expandAllNodes() {
            this.tree.expandPath(new TreePath(this.j2eeServerNode.getPath()));
            this.tree.expandPath(new TreePath(this.dataSourcesNode.getPath()));
            this.tree.expandPath(new TreePath(this.jmsNode.getPath()));
        }
    }
}

