/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.rescfg;

import com.sun.enterprise.repository.J2EEResourceBase;
import com.sun.enterprise.repository.J2EEResourceException;
import com.sun.enterprise.repository.JdbcDriver;
import com.sun.enterprise.repository.JdbcResource;
import com.sun.enterprise.repository.ResourceAdmin;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.rescfg.ConfigurationDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;

public class ConfInstlDlgStandardPnl
extends JPanel {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$rescfg$ConfInstlDlgStandardPnl == null ? (class$com$sun$enterprise$tools$deployment$ui$rescfg$ConfInstlDlgStandardPnl = ConfInstlDlgStandardPnl.class$("com.sun.enterprise.tools.deployment.ui.rescfg.ConfInstlDlgStandardPnl")) : class$com$sun$enterprise$tools$deployment$ui$rescfg$ConfInstlDlgStandardPnl);
    private static String JDBC_DRIVER_BOX = localStrings.getLocalString("ui.confInstldlgstandardpnl.jdbcdriversbox", "JDBC Drivers");
    private static String DRIVER_CLASS = localStrings.getLocalString("ui.confInstldlgstandardpnl.driverclass", "Driver Class");
    private static String DATASOURCES_BOX = localStrings.getLocalString("ui.confInstldlgstandardpnl.datasourcesbox", "Datasources");
    private static String JNDI_NAME = localStrings.getLocalString("ui.confInstldlgstandardpnl.jndiname", "JNDI Name");
    private static String JDBC_URL = localStrings.getLocalString("ui.confInstldlgstandardpnl.jdbcurl", "JDBC URL");
    private static String ADD = localStrings.getLocalString("ui.configurationdialog.add", "Add");
    private static String REMOVE = localStrings.getLocalString("ui.configurationdialog.remove", "Remove...");
    public static final String DRIVER = "driver";
    public static final String DATASRC = "datasrc";
    private JdbcDriverTable jdbcDriverTable;
    private JdbcDriverTableModel jdbcDriverTableModel;
    private DatasourcesTable datasourcesTable;
    private DatasourcesTableModel datasourcesTableModel;
    private Vector drvrToBeDltd = null;
    private Vector datasrcToBeDltd = null;
    private Vector originalDrvrRes = null;
    private Vector originalDatasrcRes = null;
    private boolean isChanged = false;
    private boolean debug = false;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$rescfg$ConfInstlDlgStandardPnl;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public ConfInstlDlgStandardPnl() {
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        UITitledTable jdbcPanel = new UITitledTable(JDBC_DRIVER_BOX, true);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        gbc.insets = new Insets(5, 5, 5, 50);
        gbc.fill = 1;
        this.add((Component)jdbcPanel, gbc);
        this.jdbcDriverTable = new JdbcDriverTable(new JdbcDriverTableModel());
        jdbcPanel.setTableView(this.jdbcDriverTable);
        JButton jdbcAddBtn = new JButton(ADD);
        jdbcAddBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ConfInstlDlgStandardPnl.this.addJdbcDriver(e10);
            }
        });
        jdbcPanel.addControlButton(jdbcAddBtn);
        JButton jdbcRemoveBtn = new JButton(REMOVE);
        jdbcRemoveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ConfInstlDlgStandardPnl.this.removeJdbcDriver(e10);
            }
        });
        jdbcPanel.addSelectionEnabledButton(jdbcRemoveBtn);
        UITitledBox datasourcesBox = new UITitledBox(DATASOURCES_BOX, true);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 1;
        this.add((Component)datasourcesBox, gbc);
        UITitledTable datasourcesPanel = new UITitledTable(null, false);
        datasourcesBox.addWithGBConstraints(datasourcesPanel);
        this.datasourcesTable = new DatasourcesTable(new DatasourcesTableModel());
        datasourcesPanel.setTableView(this.datasourcesTable);
        this.datasourcesTable.setDataSrcColumnsSize();
        this.adjustDatasourcesTableColumnSizes();
        JButton datasourcesAddBtn = new JButton(ADD);
        datasourcesAddBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ConfInstlDlgStandardPnl.this.addDatasource(e10);
            }
        });
        datasourcesPanel.setControlButtonLocation(15);
        datasourcesPanel.setControlButtonAnchor(13);
        datasourcesPanel.addControlButton(datasourcesAddBtn);
        JButton datasourcesRemoveBtn = new JButton(REMOVE);
        datasourcesRemoveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ConfInstlDlgStandardPnl.this.removeDatasource(e10);
            }
        });
        datasourcesPanel.addSelectionEnabledButton(datasourcesRemoveBtn);
        this.refresh();
    }

    public void refresh() {
        this.getJdbcTableModel().deleteAllJdbcDrivers();
        this.getDatasourceTableModel().deleteAllDatasources();
        this.getJdbcTableModel().fireTableDataChanged();
        this.getDatasourceTableModel().fireTableDataChanged();
        this.originalDrvrRes = new Vector();
        this.originalDatasrcRes = new Vector();
        this.drvrToBeDltd = new Vector();
        this.datasrcToBeDltd = new Vector();
        ResourceAdmin resAdmin = ConfigurationDialog.getResourceAdmin();
        try {
            Set drivers = resAdmin.getResources(5);
            Set dataSrs = resAdmin.getResources(3);
            Iterator itr = drivers.iterator();
            while (itr.hasNext()) {
                String resourceName;
                JdbcDriver resource = (JdbcDriver)itr.next();
                if (resource == null || (resourceName = resource.getName()) == null || resourceName.equals("")) continue;
                this.getJdbcTableModel().addJdbcDriver(resourceName);
                this.originalDrvrRes.add(resourceName);
            }
            Iterator itr2 = dataSrs.iterator();
            while (itr2.hasNext()) {
                String resourceName;
                JdbcResource resource = (JdbcResource)itr2.next();
                if (resource == null || (resourceName = resource.getName()) == null || resourceName.equals("")) continue;
                DatasourceObject obj = new DatasourceObject(resource.getName(), resource.getUrl());
                this.getDatasourceTableModel().addDatasource(obj);
                this.originalDatasrcRes.add(resourceName);
            }
            this.getJdbcTableModel().fireTableDataChanged();
            this.getDatasourceTableModel().fireTableDataChanged();
        }
        catch (J2EEResourceException e10) {
            System.out.println("J2EEResourceException: There was a problem while getting resources");
            e10.printStackTrace();
        }
    }

    public void addJdbcDriver(ActionEvent evt) {
        int index = this.getJdbcTableModel().findRowWithValue(0, 0, "");
        if (index > 0) {
            return;
        }
        this.getJdbcTableModel().addJdbcDriver("");
        this.getJdbcTableModel().fireTableDataChanged();
    }

    public void removeJdbcDriver(ActionEvent evt) {
        int n2;
        ListSelectionModel sm = this.jdbcDriverTable.getSelectionModel();
        int minIndex = sm.getMinSelectionIndex();
        int maxIndex = sm.getMaxSelectionIndex();
        if (minIndex >= 0 && (n2 = JOptionPane.showConfirmDialog(this.getFrame(), localStrings.getLocalString("ui.confInstldlgstandardpnl.removejdbcdriversconfirmation", "Are you sure you want to delete selected JDBC Driver(s)?"), "Delete JDBC Drivers", 0)) == 0) {
            Vector<String> v2 = new Vector<String>();
            while (minIndex <= maxIndex) {
                String driverName = (String)this.getJdbcTableModel().getValueAt(minIndex, 0);
                v2.add(driverName);
                ++minIndex;
            }
            this.getJdbcTableModel().deleteJdbcDrivers(v2);
            this.drvrToBeDltd.addAll(v2);
            this.getJdbcTableModel().fireTableDataChanged();
            this.setDirty(true);
        }
    }

    public void addDatasource(ActionEvent evt) {
        int index = this.getDatasourceTableModel().findRowWithValue(0, 0, "");
        if (index > 0) {
            return;
        }
        this.getDatasourceTableModel().addDatasource(new DatasourceObject("", ""));
        this.getDatasourceTableModel().fireTableDataChanged();
    }

    public void removeDatasource(ActionEvent evt) {
        int n2;
        ListSelectionModel sm = this.datasourcesTable.getSelectionModel();
        int minIndex = sm.getMinSelectionIndex();
        int maxIndex = sm.getMaxSelectionIndex();
        if (minIndex >= 0 && (n2 = JOptionPane.showConfirmDialog(this.getFrame(), localStrings.getLocalString("ui.confInstldlgstandardpnl.removedatasourcesconfirmation", "Are you sure you want to delete selected Datasource(s)?"), "Delete Datasources", 0)) == 0) {
            Vector<DatasourceObject> objs = new Vector<DatasourceObject>();
            Vector<String> names = new Vector<String>();
            while (minIndex <= maxIndex) {
                DatasourceObject obj = this.getDatasourceTableModel().getDatasourceAt(minIndex);
                objs.add(obj);
                names.add(obj.getName());
                ++minIndex;
            }
            this.getDatasourceTableModel().deleteDatasources(objs);
            this.datasrcToBeDltd.addAll(names);
            this.getDatasourceTableModel().fireTableDataChanged();
            this.setDirty(true);
        }
    }

    public void adjustDatasourcesTableColumnSizes() {
        TableColumn column = null;
        int columnWidth = this.datasourcesTable.getPreferredSize().width;
        int i2 = 0;
        while (i2 < this.datasourcesTable.getModel().getColumnCount()) {
            column = this.datasourcesTable.getColumnModel().getColumn(i2);
            if (i2 == 0) {
                columnWidth = this.datasourcesTable.getPreferredSize().width;
            } else if (i2 == 1) {
                columnWidth = this.datasourcesTable.getPreferredSize().width;
            }
            if (i2 < 1) {
                column.setMinWidth(columnWidth / 4);
                column.setPreferredWidth(columnWidth * 3 / 4);
            }
            ++i2;
        }
    }

    public void addToDelResource(String name, String type) {
        if (type.equals(DRIVER)) {
            this.drvrToBeDltd.add(name);
        } else {
            this.datasrcToBeDltd.add(name);
        }
        this.setDirty(true);
    }

    private DatasourcesTableModel getDatasourceTableModel() {
        return (DatasourcesTableModel)this.datasourcesTable.getModel();
    }

    private JdbcDriverTableModel getJdbcTableModel() {
        return (JdbcDriverTableModel)this.jdbcDriverTable.getModel();
    }

    private void setDirty(boolean value) {
        this.isChanged = value;
    }

    private boolean isDirty() {
        return this.isChanged;
    }

    private Frame getFrame() {
        return (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = ConfInstlDlgStandardPnl.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, this);
    }

    public void saveData() {
        if (this.isDirty()) {
            ResourceAdmin resAdmin = ConfigurationDialog.getResourceAdmin();
            try {
                Hashtable<String, Object> resources = new Hashtable<String, Object>();
                J2EEResourceBase resource = null;
                Enumeration keys = null;
                String resName = "";
                int noOfDrivers = this.getJdbcTableModel().getRowCount();
                int i2 = 0;
                while (i2 < noOfDrivers) {
                    resName = (String)this.getJdbcTableModel().getValueAt(i2, 0);
                    resources.put(resName, DRIVER);
                    ++i2;
                }
                if (this.debug) {
                    System.out.println("\n\n Removing del/modfied DRIVERS:");
                }
                int i3 = 0;
                while (i3 < this.drvrToBeDltd.size()) {
                    resName = (String)this.drvrToBeDltd.elementAt(i3);
                    if (!resName.equals("") && this.originalDrvrRes.contains(resName)) {
                        resAdmin.removeResource(resName, 5);
                        this.originalDrvrRes.remove(resName);
                        if (this.debug) {
                            System.out.println("     deleted Res :" + resName);
                        }
                    }
                    ++i3;
                }
                if (this.debug) {
                    System.out.println("\n\n Add New DRIVERS:");
                }
                keys = resources.keys();
                while (keys.hasMoreElements()) {
                    resName = (String)keys.nextElement();
                    if (resName.equals("") || this.originalDrvrRes.contains(resName)) continue;
                    resource = new JdbcDriver(resName);
                    resAdmin.addResource(resource);
                    if (!this.debug) continue;
                    System.out.println("     Added Res :" + resName);
                }
                DatasourceObject obj = null;
                resources.clear();
                int noOfDataSrc = this.getDatasourceTableModel().getRowCount();
                int i4 = 0;
                while (i4 < noOfDataSrc) {
                    resName = (String)this.getDatasourceTableModel().getValueAt(i4, 0);
                    obj = this.getDatasourceTableModel().getDatasourceAt(i4);
                    resources.put(resName, obj);
                    ++i4;
                }
                if (this.debug) {
                    System.out.println("\n\n Removing del/modfied DATASOURCES :");
                }
                int i5 = 0;
                while (i5 < this.datasrcToBeDltd.size()) {
                    resName = (String)this.datasrcToBeDltd.elementAt(i5);
                    if (!resName.equals("") && this.originalDatasrcRes.contains(resName)) {
                        resAdmin.removeResource(resName, 3);
                        this.originalDatasrcRes.remove(resName);
                        if (this.debug) {
                            System.out.println("     deleted Res :" + resName);
                        }
                    }
                    ++i5;
                }
                if (this.debug) {
                    System.out.println("\n\n Add New DATASOURCES :");
                }
                String url = "";
                keys = resources.keys();
                while (keys.hasMoreElements()) {
                    resName = (String)keys.nextElement();
                    if (resName.equals("") || this.originalDatasrcRes.contains(resName)) continue;
                    resource = new JdbcResource(resName);
                    Object o2 = resources.get(resName);
                    obj = (DatasourceObject)resources.get(resName);
                    url = obj.getUrl();
                    if (url.equals("")) continue;
                    ((JdbcResource)resource).setUrl(url);
                    resAdmin.addResource(resource);
                    if (!this.debug) continue;
                    System.out.println("     Added Res :" + resName);
                }
            }
            catch (J2EEResourceException e10) {
                System.out.println("J2EEResourceException: There was a problem while saving resources");
                e10.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        JFrame frm = new JFrame();
        frm.getContentPane().setLayout(new BorderLayout());
        frm.getContentPane().add(new ConfInstlDlgStandardPnl());
        ((Component)frm).setSize(400, 350);
        frm.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e10) {
                System.exit(0);
            }
        });
        ((Component)frm).setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class DatasourcesTableModel
    extends InspectorTableModel {
        public DatasourcesTableModel(String[] columnNames) {
            super(columnNames);
        }

        public DatasourcesTableModel() {
            this(new String[]{JNDI_NAME, JDBC_URL});
        }

        public void addDatasource(Object datasource) {
            super.getData().add(datasource);
        }

        public void deleteDatasource(int index) {
            super.getData().remove(index);
        }

        public void deleteDatasources(Collection all) {
            super.getData().removeAll(all);
        }

        public void deleteAllDatasources() {
            super.getData().clear();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return super.getData().size();
        }

        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public DatasourceObject getDatasourceAt(int index) {
            if (index < 0 || index >= this.getRowCount()) {
                return null;
            }
            return (DatasourceObject)super.getRowObject(index);
        }

        public Object getValueAt(int row, int col) {
            String value = "";
            DatasourceObject obj = (DatasourceObject)super.getRowObject(row);
            switch (col) {
                case 0: {
                    value = obj.getName();
                    break;
                }
                case 1: {
                    value = obj.getUrl();
                    break;
                }
            }
            return value;
        }

        public void setValueAt(Object value, int row, int col) {
            DatasourceObject obj = (DatasourceObject)super.getRowObject(row);
            Object originalValue = this.getValueAt(row, col);
            String oldName = obj.getName();
            switch (col) {
                case 0: {
                    obj.setName((String)value);
                    break;
                }
                case 1: {
                    obj.setUrl((String)value);
                    break;
                }
            }
            if (!originalValue.equals(value)) {
                ConfInstlDlgStandardPnl.this.addToDelResource(oldName, ConfInstlDlgStandardPnl.DATASRC);
            }
        }

        public Object getObjectValue(Object obj, int col) {
            return null;
        }

        public void setObjectValue(Object obj, int col, Object value) {
        }
    }

    class DatasourcesTable
    extends InspectorTable {
        public DatasourcesTable(DatasourcesTableModel model) {
            super(model);
            this.setSelectionMode(1);
        }

        public void setDataSrcColumnsSize() {
            TableColumn aColumn = this.getColumnModel().getColumn(0);
            int size = this.getWidth() / 4;
            aColumn.setPreferredWidth(size);
        }
    }

    class JdbcDriverTableModel
    extends InspectorTableModel {
        public JdbcDriverTableModel(String[] columnNames) {
            super(columnNames);
        }

        public JdbcDriverTableModel() {
            this(new String[]{DRIVER_CLASS});
        }

        public void addJdbcDriver(Object jdbcDriver) {
            super.getData().add(jdbcDriver);
        }

        public void deleteJdbcDriver(int index) {
            super.getData().remove(index);
        }

        public void deleteJdbcDrivers(Collection all) {
            super.getData().removeAll(all);
        }

        public void deleteAllJdbcDrivers() {
            super.getData().clear();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return super.getData().size();
        }

        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public Object getValueAt(int row, int col) {
            Object obj = super.getRowObject(row);
            return obj;
        }

        public void setValueAt(Object value, int row, int col) {
            Object originalValue = this.getValueAt(row, col);
            switch (col) {
                case 0: {
                    super.getData().set(row, value);
                    break;
                }
            }
            if (!originalValue.equals(value)) {
                ConfInstlDlgStandardPnl.this.addToDelResource((String)originalValue, ConfInstlDlgStandardPnl.DRIVER);
            }
        }

        public Object getObjectValue(Object obj, int col) {
            return null;
        }

        public void setObjectValue(Object obj, int col, Object value) {
        }
    }

    class JdbcDriverTable
    extends InspectorTable {
        public JdbcDriverTable(JdbcDriverTableModel model) {
            super(model);
            this.setSelectionMode(1);
        }
    }

    class DatasourceObject {
        private String jndiName;
        private String jdbcUrl;

        public DatasourceObject(String n2, String u2) {
            this.jndiName = n2;
            this.jdbcUrl = u2;
        }

        public String getName() {
            return this.jndiName;
        }

        public void setName(String n2) {
            this.jndiName = n2;
        }

        public String getUrl() {
            return this.jdbcUrl;
        }

        public void setUrl(String u2) {
            this.jdbcUrl = u2;
        }
    }
}

