/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.rescfg;

import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.sharedpassword.SharedPasswordRealm;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.rescfg.ConfInstlDlgUsersPnl;
import com.sun.enterprise.tools.deployment.ui.rescfg.GroupsDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledList;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledPasswordField;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class AddUserDialog
extends UIDialog {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$rescfg$AddUserDialog == null ? (class$com$sun$enterprise$tools$deployment$ui$rescfg$AddUserDialog = AddUserDialog.class$("com.sun.enterprise.tools.deployment.ui.rescfg.AddUserDialog")) : class$com$sun$enterprise$tools$deployment$ui$rescfg$AddUserDialog);
    private static final String TITLE = localStrings.getLocalString("ui.adduserdialog.title", "Add User");
    private static final String UESR_NAME = localStrings.getLocalString("ui.adduserdialog.username", "User Name:");
    private static final String PASSWD = localStrings.getLocalString("ui.adduserdialog.password", "Password:");
    private static final String GROUP_TITLE = localStrings.getLocalString("ui.adduserdialog.group_membership", "Group Membership");
    private static final String AVLBLE_GROUPS = localStrings.getLocalString("ui.adduserdialog.available_groups", "Available Groups:");
    private static final String GROUPS = localStrings.getLocalString("ui.adduserdialog.groups", "Groups");
    private static final String ADD = localStrings.getLocalString("ui.adduserdialog.add", "Add >");
    private static final String REMOVE = localStrings.getLocalString("ui.adduserdialog.remove", "< Remove");
    private static final String EDIT_GROUPS = localStrings.getLocalString("ui.adduserdialog.edit_groups", "Edit Groups...");
    private static String helpSetMapID = "AddUser";
    private UITitledTextField userNameField = null;
    private UITitledPasswordField passwordField = null;
    private UITitledList avlableGrpList = null;
    private UITitledList groupsUserList = null;
    private JButton delButton = null;
    private JButton addButton = null;
    private GroupsDialog groupsDialog = null;
    private Vector users = new Vector();
    private boolean restartSrvr = false;
    private boolean isOk = false;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$rescfg$AddUserDialog;

    private static String GROUPS_FOR_USER(String v0) {
        return localStrings.getLocalString("ui.adduserdialog.groups_for_user", "Groups for {0}", new Object[]{v0});
    }

    public AddUserDialog(Frame parent) {
        super(parent, true);
        this.initDialog(parent);
    }

    private void initDialog(Frame parent) {
        this.setTitle(TITLE);
        this.setWindowClosingAction(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                if (AddUserDialog.this.groupsDialog != null && AddUserDialog.this.groupsDialog.isRestartSrvr()) {
                    AddUserDialog.this.restartSrvr = true;
                }
                AddUserDialog.this.cancelAction();
            }
        });
        GridBagConstraints c10 = new GridBagConstraints();
        Container content = this.getContentPane();
        content.setLayout(new GridBagLayout());
        this.userNameField = new UITitledTextField(UESR_NAME, false);
        c10.gridx = 0;
        c10.gridy = 0;
        c10.weightx = 0.5;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 0, 0);
        c10.anchor = 13;
        c10.fill = 2;
        content.add((Component)this.userNameField, c10);
        this.userNameField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                AddUserDialog.this.setUserGroupsTitle();
            }
        });
        this.passwordField = new UITitledPasswordField(PASSWD, false);
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        content.add((Component)this.passwordField, c10);
        UITitledBox box = new UITitledBox(GROUP_TITLE, true);
        c10.gridx = 0;
        c10.gridy = 2;
        c10.gridwidth = 2;
        c10.gridheight = 1;
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.insets = new Insets(5, 5, 0, 5);
        c10.fill = 1;
        content.add((Component)box, c10);
        GridBagConstraints gbc = box.getGBConstraints();
        this.avlableGrpList = new UITitledList(AVLBLE_GROUPS, false);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.4;
        gbc.weighty = 0.5;
        gbc.insets = new Insets(5, 3, 3, 3);
        gbc.fill = 1;
        box.addWithGBConstraints(this.avlableGrpList);
        this.avlableGrpList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e10) {
                if (e10.getValueIsAdjusting()) {
                    return;
                }
                AddUserDialog.this.addButton.setEnabled(true);
            }
        });
        JPanel buttons = new JPanel();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.fill = 0;
        box.addWithGBConstraints(buttons);
        buttons.setLayout(new GridBagLayout());
        GridBagConstraints bc2 = new GridBagConstraints();
        bc2.weightx = 0.0;
        bc2.weighty = 0.0;
        bc2.gridx = 0;
        bc2.gridy = -1;
        bc2.insets = new Insets(5, 0, 0, 0);
        bc2.fill = 2;
        bc2.anchor = 10;
        Insets margin = new Insets(3, 5, 3, 5);
        this.addButton = new JButton(ADD);
        this.addButton.setMargin(margin);
        buttons.add((Component)this.addButton, bc2);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddUserDialog.this.addAction();
            }
        });
        this.addButton.setEnabled(false);
        this.delButton = new JButton(REMOVE);
        this.delButton.setMargin(margin);
        buttons.add((Component)this.delButton, bc2);
        this.delButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddUserDialog.this.deleteAction();
            }
        });
        this.delButton.setEnabled(false);
        this.groupsUserList = new UITitledList(GROUPS, false);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.6;
        gbc.weighty = 0.5;
        gbc.insets = new Insets(5, 3, 3, 3);
        gbc.fill = 1;
        box.addWithGBConstraints(this.groupsUserList);
        this.groupsUserList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e10) {
                AddUserDialog.this.delButton.setEnabled(true);
            }
        });
        JButton editButton = new JButton(EDIT_GROUPS);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.fill = 0;
        gbc.anchor = 13;
        box.addWithGBConstraints(editButton);
        editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddUserDialog.this.editGroupAction();
            }
        });
        c10.gridx = 1;
        c10.gridy = 3;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        gbc.insets = new Insets(5, 15, 5, 5);
        c10.anchor = 13;
        c10.fill = 2;
        content.add((Component)this.getButtonsPanel(), c10);
        Rectangle b10 = parent.getBounds();
        b10.x += 250;
        b10.y += 150;
        b10.width = 500;
        b10.height = 400;
        ((Component)this).setBounds(b10);
    }

    private JPanel getButtonsPanel() {
        UITitledControlButtonBox buttonsPanel = new UITitledControlButtonBox(null, false);
        buttonsPanel.setControlButtonLocation(101);
        UIButton btnOK = UIButton.createOkButton(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                AddUserDialog.this.okAction();
            }
        });
        buttonsPanel.addControlButton(btnOK);
        UIButton btnCancel = UIButton.createCancelButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                AddUserDialog.this.cancelAction();
            }
        });
        buttonsPanel.addControlButton(btnCancel);
        UIButton aplBtn = UIButton.createApplyButton(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                AddUserDialog.this.applyAction();
            }
        });
        buttonsPanel.addControlButton(aplBtn);
        buttonsPanel.addControlButton(new UIHelpButton(helpSetMapID));
        return buttonsPanel;
    }

    public void show() {
        this.refresh();
        super.show();
    }

    private void refresh() {
        this.users.clear();
        this.userNameField.setText("");
        this.passwordField.setText("");
        this.restartSrvr = false;
        this.setUserGroupsTitle();
        this.refreshAvlGrpList();
        this.groupsUserList.clear();
    }

    private void addAction() {
        Object[] list = this.avlableGrpList.getSelectedValues();
        int i2 = 0;
        while (i2 < list.length) {
            if (!this.groupsUserList.containsListItem(list[i2])) {
                this.groupsUserList.addListItem(list[i2]);
            }
            ++i2;
        }
        this.avlableGrpList.setSelectedIndex(-1);
        this.addButton.setEnabled(false);
    }

    private void deleteAction() {
        Object[] items = this.groupsUserList.getSelectedValues();
        if (items == null || items.length == 0) {
            return;
        }
        boolean n2 = UIOptionPane.showConfirmDialog(this, localStrings.getLocalString("ui.adduserdialog.confirm_remove_groups", "Are you sure you want to remove selected Group(s)?"));
        if (!n2) {
            return;
        }
        this.groupsUserList.removeListItems(items);
        this.groupsUserList.setSelectedIndex(-1);
        this.delButton.setEnabled(false);
    }

    private void editGroupAction() {
        if (this.groupsDialog == null) {
            this.groupsDialog = new GroupsDialog(this);
        } else {
            this.groupsDialog.refresh();
            this.groupsDialog.setVisible(true);
        }
        if (this.groupsDialog.isRestartSrvr()) {
            this.refreshAvlGrpList();
            this.restartSrvr = true;
        }
    }

    private void refreshAvlGrpList() {
        SharedPasswordRealm deftRealm = ConfInstlDlgUsersPnl.getDefaultRealm();
        Enumeration groups = null;
        if (deftRealm != null) {
            try {
                deftRealm.refresh();
                groups = deftRealm.getGroupNames();
            }
            catch (BadRealmException e10) {
                UIUtils.println("Exception: There was a problem while getting Groups");
                e10.printStackTrace();
            }
        }
        if (groups != null) {
            this.avlableGrpList.clear();
            while (groups.hasMoreElements()) {
                Object g2 = groups.nextElement();
                this.avlableGrpList.addListItem(g2);
            }
        }
    }

    private void setUserGroupsTitle() {
        String user = this.userNameField.getText();
        this.groupsUserList.setTitle(user.equals("") ? GROUPS : AddUserDialog.GROUPS_FOR_USER(user));
    }

    public Vector getNewUsers() {
        return this.isOk ? this.users : null;
    }

    private boolean applyAction() {
        String userNm = this.userNameField.getText();
        String passwd = this.passwordField.getText();
        if (!userNm.equals("")) {
            Vector<String> user = new Vector<String>();
            StringBuffer groups = new StringBuffer();
            Vector userGroups = this.groupsUserList.getListData();
            if (userGroups.size() == 0) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.adduserdialog.associate_group", "Please associate group(s) with the user"));
                return false;
            }
            Enumeration e10 = userGroups.elements();
            while (e10.hasMoreElements()) {
                if (groups.length() > 0) {
                    groups.append(",");
                }
                groups.append(e10.nextElement().toString());
            }
            user.add(userNm);
            user.add(passwd);
            user.add(groups.toString());
            this.users.add(user);
            this.userNameField.setText("");
            this.passwordField.setText("");
            this.groupsUserList.clear();
            this.setUserGroupsTitle();
        }
        return true;
    }

    private void okAction() {
        if (this.applyAction()) {
            this.isOk = true;
            this.setVisible(false);
        }
    }

    private void cancelAction() {
        this.isOk = false;
        this.setVisible(false);
    }

    public boolean isRestartSrvr() {
        return this.restartSrvr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

