/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.AuthorizationConstraintImpl;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.LoginConfigurationImpl;
import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.UserDataConstraintImpl;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptorImpl;
import com.sun.enterprise.deployment.WebResourceCollectionImpl;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.descriptor.WebAppRolePicker;
import com.sun.enterprise.tools.deployment.ui.utils.UIActionDispatcher;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIJarPackager;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledList;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WebAppSecurityInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppSecurityInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppSecurityInspector = WebAppSecurityInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.WebAppSecurityInspector")) : class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppSecurityInspector);
    private static final String AUTH_METHOD_SETTINGS_TITLE = localStrings.getLocalString("ui.webappsecurityinspector.auth_method_settings.title", "User Authentication Settings");
    private static final String AUTH_METHOD_SETTINGS_TOOLTIP = localStrings.getLocalString("ui.webappsecurityinspector.auth_method_settings.tooltip", "User Authentication Settings");
    private static final String AUTH_SETTINGS_REALM_NAME = localStrings.getLocalString("ui.webappsecurityinspector.auth_method_realm_name", "Realm Name:");
    private static final String AUTH_SETTINGS_LOGIN_PAGE = localStrings.getLocalString("ui.webappsecurityinspector.auth_method_login_page", "Login Page:");
    private static final String AUTH_SETTINGS_ERROR_PAGE = localStrings.getLocalString("ui.webappsecurityinspector.auth_method_error_page", "Error Page:");
    private static final String AUTH_METHOD = localStrings.getLocalString("ui.webappsecurityinspector.auth_method", "User Authentication Method:");
    private static final String AUTH_METH_NONE = localStrings.getLocalString("ui.webappsecurityinspector.auth_meth_none", "None");
    private static final String AUTH_METH_BASIC = localStrings.getLocalString("ui.webappsecurityinspector.auth_meth_basic", "Basic");
    private static final String AUTH_METH_CLIENT_CERT = localStrings.getLocalString("ui.webappsecurityinspector.auth_meth_client_cert", "Client Certificate");
    private static final String AUTH_METH_FORM = localStrings.getLocalString("ui.webappsecurityinspector.auth_meth_form_based", "Form Based");
    private static final String AUTH_METHOD_SETTINGS_BUTTON = localStrings.getLocalString("ui.webappsecurityinspector.auth_method_settings_button", "Settings...");
    private static final String SECURITY_CONSTRAINTS = localStrings.getLocalString("ui.webappsecurityinspector.security_constraints", "Security constraints");
    private static final String RU_SURE_DEL_SEC_CONSTRAINT = localStrings.getLocalString("ui.webappsecurityinspector.ok_to_delete_security", "Are you sure you want to delete selected security constraint?");
    private static final String DEL_SEC_CONSTRAINT = localStrings.getLocalString("ui.webappsecurityinspector.delete_security", "Delete Security Constraint");
    private static final String FIRST_SELECT_SEC_CONSTRAINT = localStrings.getLocalString("ui.webappsecurityinspector.please_select_security", "You must first select a security constraint from list");
    private static final String WEB_RESOURCE_COLLECTION = localStrings.getLocalString("ui.webappsecurityinspector.webresourcecollections", "Web Resource Collections");
    private static final String NETWORK_SECURITY_REQ = localStrings.getLocalString("ui.webappsecurityinspector.network_security_requirement", "Network Security Requirement:");
    private static final String AUTHORIZED_ROLES = localStrings.getLocalString("ui.webappsecurityinspector.authorizedroles", "Authorized Roles");
    private static final String EDIT_ROLES = localStrings.getLocalString("ui.webappsecurityinspector.edit_roles_button", "Edit Roles");
    private static String OKTODEL_WEBRES = localStrings.getLocalString("ui.webappsecurityinspector.oktodelete_webrescoll_msg", "Are you sure you want to delete selected web resource collection?");
    private static String DELETE_WEBRES = localStrings.getLocalString("ui.webappsecurityinspector.oktodelete_webrescoll_title", "Delete web resource collection");
    private static String URL_PATTERNS = localStrings.getLocalString("ui.webappsecurityinspector.urlpatterns", "URL patterns");
    private static String OKTODEL_URLPATTERN = localStrings.getLocalString("ui.webappsecurityinspector.oktodelete_urlpattern_msg", "Are you sure you want to delete selected URL pattern?");
    private static String DELETE_URLPATTERN = localStrings.getLocalString("ui.webappsecurityinspector.oktodelete_urlpattern_title", "Delete URL Pattern");
    private static final String TABNAME = localStrings.getLocalString("ui.webappsecurityinspector.tabname", "Security");
    private static final String SECURITY_CONSTRAINT_KEY = "SecurityConstraint";
    private static final String WEB_COLLECTION_KEY = "WRCollection";
    private static final String GET_METHOD = "GET";
    private static final String POST_METHOD = "POST";
    private static String AuthMethNONE = "NONE";
    private static String AuthMethBASIC = "BASIC";
    private static String AuthMethFORM = "FORM";
    private static String AuthMethCLIENT = "CLIENT-CERT";
    private static final String[] AuthMethodType = new String[]{AuthMethNONE, AuthMethBASIC, AuthMethCLIENT, AuthMethFORM};
    private static final String[] AuthMethodText = new String[]{AUTH_METH_NONE, AUTH_METH_BASIC, AUTH_METH_CLIENT_CERT, AUTH_METH_FORM};
    private static String wizardHelpID = "Security";
    private static String deployHelpID = "Security";
    private WebBundleDescriptor descriptor = null;
    private UITitledTable secConstraintTablePane = null;
    private UITitledComboBox authMethodCombo = null;
    private JButton authMethodSettings = null;
    private LoginConfigurationImpl lastLoginConfig = null;
    private UITitledComboBox xportGuaranteeCombo = null;
    private UITitledTable webResCollectionsTable = null;
    private UITitledList authConstraintsList = null;
    private JCheckBox cbGetMethod = null;
    private JCheckBox cbPostMethod = null;
    private UITitledControlButtonBox urlPatternPanel = null;
    private JPanel urlTree = null;
    private UIJarPackager jarPackager = null;
    private Vector webWizardContents = null;
    String[] transportChoices = UserDataConstraintImpl.getTransportGuaranteeChoices();
    private WebAppRolePicker rolePickerDialog = null;
    private static String authSettingsHelpSetMapID = "WWAuthSettings";
    private AuthMethodSettingsDialog authMethodDialog = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppSecurityInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$WebBundleDescriptor;

    private static final String AUTH_SETTINGS_DETAILS(String v0) {
        return localStrings.getLocalString("ui.webappsecurityinspector.auth_method_settings.details", "Details [{0}]", new Object[]{v0});
    }

    private static String EDIT_ROLES_FOR(String v0) {
        return localStrings.getLocalString("ui.webappsecurityinspector.edit_roles_for", "Edit Roles for {0}", new Object[]{v0});
    }

    private static String AuthText2Type(String text) {
        if (text != null) {
            int i2 = 0;
            while (i2 < AuthMethodText.length) {
                if (text.equals(AuthMethodText[i2])) {
                    return AuthMethodType[i2];
                }
                ++i2;
            }
        }
        return AuthMethNONE;
    }

    private static String AuthType2Text(String type) {
        if (type != null) {
            int i2 = 0;
            while (i2 < AuthMethodType.length) {
                if (type.equals(AuthMethodType[i2])) {
                    return AuthMethodText[i2];
                }
                ++i2;
            }
        }
        return AUTH_METH_NONE;
    }

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new WebAppSecurityInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$deployment$WebBundleDescriptor == null ? (class$com$sun$enterprise$deployment$WebBundleDescriptor = WebAppSecurityInspector.class$("com.sun.enterprise.deployment.WebBundleDescriptor")) : class$com$sun$enterprise$deployment$WebBundleDescriptor;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WebBundleDescriptor ? (WebBundleDescriptor)desc : (desc instanceof WebComponentDescriptorImpl ? ((WebComponentDescriptorImpl)desc).getWebBundleDescriptor() : null);
            this.secConstraintTablePane.clearTableData();
            this.webResCollectionsTable.clearTableData();
        }
    }

    private WebAppSecurityInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c10 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.authMethodCombo = new UITitledComboBox(AUTH_METHOD, false);
        this.authMethodCombo.setModel(AuthMethodText);
        this.authMethodCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                String lastAuthMeth;
                String authMeth;
                UITitledComboBox cb2 = WebAppSecurityInspector.this.authMethodCombo;
                if (cb2.isSetSelectionUpdate()) {
                    return;
                }
                String selMeth = WebAppSecurityInspector.AuthText2Type((String)cb2.getSelectedItem());
                LoginConfigurationImpl loginConfig = (LoginConfigurationImpl)WebAppSecurityInspector.this.descriptor.getLoginConfiguration();
                String string = authMeth = loginConfig != null ? loginConfig.getAuthenticationMethod() : AuthMethNONE;
                if (authMeth.equals(selMeth)) {
                    return;
                }
                String string2 = lastAuthMeth = WebAppSecurityInspector.this.lastLoginConfig != null ? WebAppSecurityInspector.this.lastLoginConfig.getAuthenticationMethod() : AuthMethNONE;
                if (selMeth.equals(lastAuthMeth)) {
                    loginConfig = WebAppSecurityInspector.this.lastLoginConfig;
                } else if (selMeth.equals(AuthMethNONE)) {
                    loginConfig = null;
                } else {
                    loginConfig = new LoginConfigurationImpl();
                    loginConfig.setAuthenticationMethod(selMeth);
                }
                WebAppSecurityInspector.this.descriptor.setLoginConfiguration(loginConfig);
            }
        });
        c10.weightx = 0.4;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 2;
        this.add((Component)this.authMethodCombo, c10);
        this.authMethodSettings = new JButton(AUTH_METHOD_SETTINGS_BUTTON);
        this.authMethodSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebAppSecurityInspector.this.showAuthMethSettings();
            }
        });
        GridBagConstraints gbc = this.authMethodCombo.getGBConstraintsCopy();
        gbc.weightx = 0.0;
        gbc.gridx = -1;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 5, 0, 0);
        gbc.fill = 0;
        this.authMethodCombo.add((Component)this.authMethodSettings, gbc);
        c10.weightx = 0.6;
        c10.weighty = 0.0;
        c10.gridx = 1;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(0, 0, 0, 0);
        c10.fill = 2;
        this.add((Component)new JPanel(), c10);
        UITitledBox secConstraintsPanel = new UITitledBox(SECURITY_CONSTRAINTS, true);
        c10.weightx = 1.0;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 2;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        this.add((Component)secConstraintsPanel, c10);
        GridBagConstraints secGBC = secConstraintsPanel.getGBConstraints();
        double w_top = 0.15;
        double w_left = 0.78;
        this.secConstraintTablePane = new UITitledTable(null, false);
        this.secConstraintTablePane.setTableView(new SecurityConstraintsTable(new SecurityConstraintsTableModel()));
        this.secConstraintTablePane.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e10) {
                if (e10.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e10.getSource();
                WebAppSecurityInspector.this.showSecurityConstraint(lsm.getMinSelectionIndex());
            }
        });
        secGBC.weightx = w_left;
        secGBC.weighty = w_top;
        secGBC.gridx = 0;
        secGBC.gridy = 0;
        secGBC.gridwidth = 1;
        secGBC.gridheight = 1;
        secGBC.insets = new Insets(0, 0, 5, 5);
        secGBC.fill = 1;
        secConstraintsPanel.add((Component)this.secConstraintTablePane, secGBC);
        UIButton addSecConstPB = UIButton.createAddButton(new UIActionDispatcher((Object)this, "_addSecurityConst"), false);
        this.secConstraintTablePane.addControlButton(addSecConstPB);
        UIButton delSecConstPB = UIButton.createDeleteButton(new UIActionDispatcher((Object)this, "_delSecurityConst"), true);
        this.secConstraintTablePane.addSelectionEnabledButton(delSecConstPB);
        JPanel filler = new JPanel();
        secGBC.weightx = 1.0 - w_left;
        secGBC.weighty = w_top;
        secGBC.gridx = 1;
        secGBC.gridy = 0;
        secGBC.gridwidth = 1;
        secGBC.gridheight = 1;
        secGBC.insets = new Insets(0, 0, 0, 5);
        secGBC.fill = 1;
        secConstraintsPanel.add((Component)filler, secGBC);
        UITitledBox weResPanel = new UITitledBox(WEB_RESOURCE_COLLECTION, true);
        secGBC.weightx = w_left;
        secGBC.weighty = 1.0 - w_top;
        secGBC.gridx = 0;
        secGBC.gridy = 1;
        secGBC.gridwidth = 1;
        secGBC.gridheight = 1;
        secGBC.insets = new Insets(0, 0, 0, 5);
        secGBC.fill = 1;
        secConstraintsPanel.add((Component)weResPanel, secGBC);
        this.webResCollectionsTable = new UITitledTable(null, false);
        this.webResCollectionsTable.setTableView(new WebResourceCollectionsTable(new WebResourceCollectionsTableModel()));
        this.webResCollectionsTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e10) {
                if (e10.getValueIsAdjusting()) {
                    return;
                }
                WebAppSecurityInspector.this.refreshWebResCollection();
            }
        });
        weResPanel.getGBConstraints().weighty = 0.35;
        weResPanel.addWithGBConstraints(this.webResCollectionsTable);
        this.webResCollectionsTable.setControlButtonLocation(202);
        this.secConstraintTablePane.addComponentToSelectionEnabledList(this.webResCollectionsTable);
        UIButton webResAddPB = UIButton.createAddButton(new UIActionDispatcher((Object)this, "_addWebResCollection"));
        webResAddPB.setEnabled(false);
        this.webResCollectionsTable.addControlButton(webResAddPB);
        UIButton webResDelPB = UIButton.createDeleteButton(new UIActionDispatcher((Object)this, "_delWebResCollection"), true);
        webResDelPB.setEnabled(false);
        this.webResCollectionsTable.addSelectionEnabledButton(webResDelPB);
        this.jarPackager = UIJarPackager.newBrowser(this, "webres");
        this.urlTree = (JPanel)((Object)this.jarPackager.getDestinationTreeView());
        this.urlPatternPanel = new UITitledControlButtonBox(null, false);
        this.urlPatternPanel.setView(this.urlTree);
        weResPanel.getGBConstraints().weighty = 0.65;
        weResPanel.getGBConstraints().insets.top = 7;
        weResPanel.addWithGBConstraints(this.urlPatternPanel);
        this.webResCollectionsTable.addComponentToSelectionEnabledList(this.urlPatternPanel);
        this.urlPatternPanel.addControlSpacer();
        this.cbGetMethod = new JCheckBox(GET_METHOD);
        this.cbGetMethod.addActionListener(new UIActionDispatcher((Object)this, "_setHttpMethod"));
        this.urlPatternPanel.addControlComponent(this.cbGetMethod);
        this.cbPostMethod = new JCheckBox(POST_METHOD);
        this.cbPostMethod.addActionListener(new UIActionDispatcher((Object)this, "_setHttpMethod"));
        this.urlPatternPanel.addControlComponent(this.cbPostMethod);
        this.urlPatternPanel.addControlSpacer();
        UIButton webResEditPB = UIButton.createEditButton(new UIActionDispatcher((Object)this, "_editWebResCollection"), true);
        webResEditPB.setEnabled(false);
        this.urlPatternPanel.addControlButton(webResEditPB);
        this.webResCollectionsTable.addComponentToSelectionEnabledList(webResEditPB);
        UITitledBox reqAuthBox = new UITitledBox(null, false);
        secGBC.weightx = 1.0 - w_left;
        secGBC.weighty = 1.0 - w_top;
        secGBC.gridx = 1;
        secGBC.gridy = 1;
        secGBC.gridwidth = 1;
        secGBC.gridheight = 1;
        secGBC.insets = new Insets(0, 0, 0, 0);
        secGBC.fill = 1;
        secConstraintsPanel.add((Component)reqAuthBox, secGBC);
        this.secConstraintTablePane.addComponentToSelectionEnabledList(reqAuthBox);
        reqAuthBox.setEnabled(false);
        GridBagConstraints raGbc = reqAuthBox.getGBConstraintsCopy();
        this.xportGuaranteeCombo = new UITitledComboBox(NETWORK_SECURITY_REQ, false);
        this.xportGuaranteeCombo.setModel(this.transportChoices);
        this.xportGuaranteeCombo.setEnabled(false);
        this.xportGuaranteeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                UITitledComboBox cb2 = WebAppSecurityInspector.this.xportGuaranteeCombo;
                WebAppSecurityInspector.this.handleTransportGuaranteeSelection(!cb2.isSetSelectionUpdate());
            }
        });
        raGbc.weighty = 0.0;
        raGbc.fill = 2;
        reqAuthBox.add((Component)this.xportGuaranteeCombo, raGbc);
        this.authConstraintsList = new UITitledList(AUTHORIZED_ROLES, true);
        this.authConstraintsList.setListView(new JList());
        this.authConstraintsList.getListView().setSelectionBackground(Color.white);
        this.authConstraintsList.getListView().setCellRenderer(new SecurityListCellRenderer());
        this.authConstraintsList.setControlButtonLocation(101);
        UIButton authConstEditPB = UIButton.createEditButton(new UIActionDispatcher((Object)this, "_editAuthConst"), true);
        this.authConstraintsList.addControlButton(authConstEditPB);
        raGbc.weighty = 0.5;
        raGbc.fill = 1;
        raGbc.insets.top = 7;
        reqAuthBox.add((Component)this.authConstraintsList, raGbc);
    }

    public void refresh() {
        if (this.descriptor == null) {
            return;
        }
        LoginConfigurationImpl loginConfig = (LoginConfigurationImpl)this.descriptor.getLoginConfiguration();
        String authMeth = loginConfig != null ? loginConfig.getAuthenticationMethod() : AuthMethNONE;
        this.authMethodCombo.setSelectedItem(WebAppSecurityInspector.AuthType2Text(authMeth));
        if (authMeth.equals(AuthMethFORM) || authMeth.equals(AuthMethBASIC)) {
            this.authMethodSettings.setEnabled(true);
        } else {
            this.authMethodSettings.setEnabled(false);
        }
        Vector<Descriptor> secVec = new Vector<Descriptor>();
        HashSet<Descriptor> secSet = new HashSet<Descriptor>();
        Enumeration secEnum = this.descriptor.getSecurityConstraints();
        while (secEnum.hasMoreElements()) {
            Descriptor d10 = (Descriptor)secEnum.nextElement();
            if (d10.getName().equals("")) {
                secVec.add(d10);
                continue;
            }
            secSet.add(d10);
        }
        if (secVec.size() > 0) {
            Enumeration e10 = secVec.elements();
            while (e10.hasMoreElements()) {
                Descriptor d11 = (Descriptor)e10.nextElement();
                String n2 = Descriptor.createUniqueNameAmongstNamedDescriptors(SECURITY_CONSTRAINT_KEY, secSet);
                d11.setName(n2);
                secSet.add(d11);
            }
        }
        this.secConstraintTablePane.updateTableData(secSet);
        this.showSecurityConstraint(this.getSelectedSecurityConstraint());
        this.refreshWebResCollection();
    }

    private void refreshWebResCollection() {
        WebResourceCollectionImpl w2 = this.getSelectedWebResCollection();
        if (w2 == null) {
            this.cbGetMethod.setSelected(false);
            this.cbPostMethod.setSelected(false);
            ((UIJarPackager.PackagerTreeViewInterface)((Object)this.urlTree)).updateTreeView(null);
            this.urlTree.setEnabled(false);
        } else {
            boolean gm = false;
            boolean pm = false;
            Enumeration m2 = w2.getHttpMethods();
            while (m2.hasMoreElements()) {
                String meth = (String)m2.nextElement();
                if (GET_METHOD.equals(meth)) {
                    gm = true;
                }
                if (!POST_METHOD.equals(meth)) continue;
                pm = true;
            }
            this.cbGetMethod.setSelected(gm);
            this.cbPostMethod.setSelected(pm);
            this.urlTree.setEnabled(true);
            ((UIJarPackager.PackagerTreeViewInterface)((Object)this.urlTree)).updateTreeView(w2.getUrlPatterns());
        }
    }

    private WebResourceCollectionImpl getSelectedWebResCollection() {
        Object sel = this.webResCollectionsTable.getSelectedRowObject();
        return (WebResourceCollectionImpl)sel;
    }

    public void _setHttpMethod() {
        WebResourceCollectionImpl w2 = this.getSelectedWebResCollection();
        if (this.cbGetMethod.isSelected()) {
            w2.addHttpMethod(GET_METHOD);
        } else {
            w2.removeHttpMethod(GET_METHOD);
        }
        if (this.cbPostMethod.isSelected()) {
            w2.addHttpMethod(POST_METHOD);
        } else {
            w2.removeHttpMethod(POST_METHOD);
        }
    }

    public void _addWebResCollection() {
        SecurityConstraintImpl sc = this.getSelectedSecurityConstraint();
        if (sc == null) {
            return;
        }
        WebResourceCollectionImpl wrc = new WebResourceCollectionImpl();
        HashSet w2 = new HashSet();
        Enumeration e10 = sc.getWebResourceCollections();
        while (e10.hasMoreElements()) {
            w2.add(e10.nextElement());
        }
        String n2 = Descriptor.createUniqueNameAmongstNamedDescriptors(WEB_COLLECTION_KEY, w2);
        wrc.setName(n2);
        sc.addWebResourceCollection(wrc);
        w2.add(wrc);
        this.webResCollectionsTable.selectRowWithValueOnUpdate(0, n2);
        this.webResCollectionsTable.updateTableData(w2);
        this.invokeRefresh();
    }

    public void _delWebResCollection() {
        Object[] list = this.webResCollectionsTable.confirmDeleteSelection(null, null);
        if (list != null) {
            SecurityConstraintImpl sc = this.getSelectedSecurityConstraint();
            int i2 = 0;
            while (i2 < list.length) {
                WebResourceCollectionImpl ref = (WebResourceCollectionImpl)list[i2];
                sc.removeWebResourceCollection(ref);
                ++i2;
            }
            this.descriptor.changed();
            this.invokeRefresh();
        }
    }

    public void setWizardContents(Vector contents) {
        this.webWizardContents = contents;
    }

    SecurityConstraintImpl getSelectedSecurityConstraint() {
        SecurityConstraintImpl secConst = null;
        ListSelectionModel lsm = this.secConstraintTablePane.getSelectionModel();
        int minIndex = lsm.getMinSelectionIndex();
        if (minIndex >= 0) {
            secConst = ((SecurityConstraintsTableModel)this.secConstraintTablePane.getModel()).getRow(minIndex);
        }
        return secConst;
    }

    private void showSecurityConstraint(int index) {
        SecurityConstraintImpl securityConstraint = null;
        if (index != -1) {
            securityConstraint = ((SecurityConstraintsTableModel)this.secConstraintTablePane.getModel()).getRow(index);
        }
        this.showSecurityConstraint(securityConstraint);
    }

    private void showSecurityConstraint(SecurityConstraintImpl securityConstraint) {
        if (securityConstraint != null) {
            UserDataConstraintImpl userDataConstraint = (UserDataConstraintImpl)securityConstraint.getUserDataConstraint();
            if (userDataConstraint != null) {
                String type = userDataConstraint.getTransportGuarantee();
                this.xportGuaranteeCombo.setSelectedItem(type);
            } else {
                userDataConstraint = new UserDataConstraintImpl();
                userDataConstraint.setTransportGuarantee("NONE");
                securityConstraint.setUserDataConstraint(userDataConstraint);
                this.xportGuaranteeCombo.setSelectedItem("NONE");
            }
            AuthorizationConstraintImpl aci = (AuthorizationConstraintImpl)securityConstraint.getAuthorizationConstraint();
            DefaultListModel<SecurityRoleDescriptor> dlm = new DefaultListModel<SecurityRoleDescriptor>();
            if (aci != null) {
                Enumeration e10 = aci.getSecurityRoles();
                while (e10.hasMoreElements()) {
                    SecurityRoleDescriptor srd = (SecurityRoleDescriptor)e10.nextElement();
                    dlm.addElement(srd);
                }
            }
            this.authConstraintsList.setModel(dlm);
            this.webResCollectionsTable.updateTableData(securityConstraint.getWebResourceCollections());
        } else {
            this.authConstraintsList.setModel(new DefaultListModel());
            this.webResCollectionsTable.clearTableData();
            this.xportGuaranteeCombo.setSelectedItem("NONE");
        }
    }

    public void _editWebResCollection() {
        WebResourceCollectionImpl w2 = this.getSelectedWebResCollection();
        if (w2 == null) {
            return;
        }
        if (this.isWizardMode()) {
            this.jarPackager.setSource(this.webWizardContents);
        } else {
            this.jarPackager.setSource(this.descriptor);
        }
        this.jarPackager.setDestination(w2.getUrlPatterns());
        if (!this.jarPackager.showBrowser()) {
            return;
        }
        w2.setUrlPatterns(this.jarPackager.getUrlPatternContents());
        this.invokeRefresh();
    }

    public void _editAuthConst() {
        SecurityConstraintImpl sc = this.getSelectedSecurityConstraint();
        if (sc != null) {
            if (this.rolePickerDialog == null) {
                this.rolePickerDialog = new WebAppRolePicker(this.getMyParentFrame());
            }
            this.rolePickerDialog.setSecurityConstraintDescriptors(this.descriptor, sc);
            this.rolePickerDialog.setLocationRelativeTo(this);
            this.rolePickerDialog.show();
            this.invokeRefresh();
        }
    }

    public void _addSecurityConst() {
        SecurityConstraintImpl sc = new SecurityConstraintImpl();
        HashSet s2 = new HashSet();
        Enumeration e10 = this.descriptor.getSecurityConstraints();
        while (e10.hasMoreElements()) {
            s2.add(e10.nextElement());
        }
        String n2 = Descriptor.createUniqueNameAmongstNamedDescriptors(SECURITY_CONSTRAINT_KEY, s2);
        sc.setName(n2);
        this.descriptor.addSecurityConstraint(sc);
        s2.add(sc);
        this.secConstraintTablePane.selectRowWithValueOnUpdate(0, n2);
        this.secConstraintTablePane.updateTableData(s2);
        this.invokeRefresh();
    }

    public void _delSecurityConst() {
        if (this.descriptor == null) {
            return;
        }
        Object[] list = this.secConstraintTablePane.confirmDeleteSelection(null, null);
        if (list != null) {
            int i2 = 0;
            while (i2 < list.length) {
                SecurityConstraintImpl ref = (SecurityConstraintImpl)list[i2];
                this.descriptor.removeSecurityConstraint(ref);
                ++i2;
            }
        }
        this.invokeRefresh();
    }

    private void handleTransportGuaranteeSelection(boolean doUpdate) {
        UserDataConstraintImpl userDataConst;
        SecurityConstraintImpl secConst;
        if (doUpdate && (secConst = this.getSelectedSecurityConstraint()) != null && (userDataConst = (UserDataConstraintImpl)secConst.getUserDataConstraint()) != null) {
            String type = (String)this.xportGuaranteeCombo.getSelectedItem();
            userDataConst.setTransportGuarantee(type);
            this.descriptor.changed();
        }
    }

    public static void main(String[] args) {
        final WebAppSecurityInspector ei2 = new WebAppSecurityInspector("WizardMode");
        JFrame f2 = new JFrame();
        ((Component)f2).setBounds(10, 10, 400, 400);
        f2.getContentPane().add(ei2);
        f2.show();
        final WebBundleDescriptor wbd = new WebBundleDescriptor();
        wbd.addRole(new Role("danny"));
        wbd.addRole(new Role("matti"));
        wbd.addNotificationListener(new NotificationListener(){

            public void notification(NotificationEvent ae2) {
                ei2.setDescriptor(wbd);
            }
        });
        ei2.setDescriptor(wbd);
    }

    private void showAuthMethSettings() {
        this.authMethodDialog = null;
        if (this.authMethodDialog == null) {
            Window win = this.getMyParentWindow();
            if (win instanceof Dialog) {
                this.authMethodDialog = new AuthMethodSettingsDialog((Dialog)win);
            } else if (win instanceof Frame) {
                this.authMethodDialog = new AuthMethodSettingsDialog((Frame)win);
            } else {
                UIUtils.debugPrintln("Didn't find a parent window, using 'null'.");
                this.authMethodDialog = new AuthMethodSettingsDialog((Frame)null);
            }
        }
        this.authMethodDialog.setLoginConfiguration((LoginConfigurationImpl)this.descriptor.getLoginConfiguration());
        this.authMethodDialog.show();
        if (this.authMethodDialog.userSelectedOK()) {
            this.lastLoginConfig = this.authMethodDialog.getLoginConfiguration();
            this.descriptor.setLoginConfiguration(this.lastLoginConfig);
        }
        this.authMethodDialog = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class WebResourceCollectionsTableModel
    extends InspectorTableModel {
        public WebResourceCollectionsTableModel() {
            super(new String[]{""});
        }

        public Object getObjectValue(Object obj, int col) {
            WebResourceCollectionImpl ref = (WebResourceCollectionImpl)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getName();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            WebResourceCollectionImpl ref = (WebResourceCollectionImpl)obj;
            switch (col) {
                case 0: {
                    ref.setName(value.toString());
                }
            }
        }
    }

    private class WebResourceCollectionsTable
    extends InspectorTable {
        public WebResourceCollectionsTable(WebResourceCollectionsTableModel model) {
            super(model);
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
        }
    }

    private class AuthMethodSettingsDialog
    extends UIDialog {
        private String authLoginMethod = null;
        private UITitledBox detailsPanel = null;
        private UITitledComboBox realmName = null;
        private UITitledComboBox loginPage = null;
        private UITitledComboBox errorPage = null;
        private boolean okSelected = false;

        public AuthMethodSettingsDialog(Frame frame) {
            super(frame, true);
            this._initLayout();
        }

        public AuthMethodSettingsDialog(Dialog dialog) {
            super(dialog, true);
            this._initLayout();
        }

        private void _initLayout() {
            this.setTitle(AUTH_METHOD_SETTINGS_TITLE);
            this.setWindowClosingAction(new ActionListener(this){
                private final /* synthetic */ AuthMethodSettingsDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent we) {
                    this.this$1.cancelAction();
                }
            });
            UITitledBox contentPane = new UITitledBox(null, false);
            contentPane.setToolTipText(AUTH_METHOD_SETTINGS_TOOLTIP);
            contentPane.getGBConstraints().insets = new Insets(5, 5, 5, 5);
            this.detailsPanel = new UITitledBox(WebAppSecurityInspector.AUTH_SETTINGS_DETAILS(""), true);
            contentPane.addWithGBConstraints(this.detailsPanel);
            GridBagConstraints gbc = this.detailsPanel.getGBConstraints();
            gbc.weighty = 0.0;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 4, 2, 4);
            this.realmName = new UITitledComboBox(AUTH_SETTINGS_REALM_NAME, false);
            this.realmName.setModel(new Object[]{"Default", "Certificate"});
            this.detailsPanel.addWithGBConstraints(this.realmName);
            Vector contentFiles = WebAppSecurityInspector.this.getArchiveContents();
            Vector<String> contents = new Vector<String>();
            contents.add("");
            Enumeration contentEnum = contentFiles.elements();
            while (contentEnum.hasMoreElements()) {
                String v2 = contentEnum.nextElement().toString();
                if (v2.startsWith("META-INF") || v2.startsWith("WEB-INF")) continue;
                contents.add(v2.startsWith("/") ? v2 : "/" + v2);
            }
            this.loginPage = new UITitledComboBox(AUTH_SETTINGS_LOGIN_PAGE, false);
            this.loginPage.setModel(contents);
            this.loginPage.setEditable(true);
            this.detailsPanel.addWithGBConstraints(this.loginPage);
            this.errorPage = new UITitledComboBox(AUTH_SETTINGS_ERROR_PAGE, false);
            this.errorPage.setModel(contents);
            this.detailsPanel.addWithGBConstraints(this.errorPage);
            UITitledControlButtonBox dialogPane = new UITitledControlButtonBox(null, false);
            dialogPane.setControlButtonLocation(101);
            dialogPane.setView(contentPane);
            UIButton okPB = UIButton.createOkButton(new ActionListener(this){
                private final /* synthetic */ AuthMethodSettingsDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e10) {
                    this.this$1.okAction();
                }
            });
            dialogPane.addControlButton(okPB);
            UIButton canPB = UIButton.createCancelButton(new ActionListener(this){
                private final /* synthetic */ AuthMethodSettingsDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e10) {
                    this.this$1.cancelAction();
                }
            });
            dialogPane.addControlButton(canPB);
            UIHelpButton helpPB = new UIHelpButton(authSettingsHelpSetMapID);
            dialogPane.addControlButton(helpPB);
            this.setContentPane(dialogPane);
            ((Component)this).setBounds(0, 0, 380, 245);
            this.setLocationRelativeTo(WebAppSecurityInspector.this);
            this.setLoginConfiguration(null);
        }

        public void setLoginConfiguration(LoginConfigurationImpl loginConfig) {
            if (loginConfig == null) {
                this.authLoginMethod = AuthMethNONE;
                this._setValue(this.realmName, null);
                this._setValue(this.loginPage, null);
                this._setValue(this.errorPage, null);
            } else {
                this.authLoginMethod = loginConfig.getAuthenticationMethod();
                if (this.authLoginMethod.equals(AuthMethFORM)) {
                    this._setValue(this.realmName, loginConfig.getRealmName());
                    this._setValue(this.loginPage, loginConfig.getFormLoginPage());
                    this._setValue(this.errorPage, loginConfig.getFormErrorPage());
                } else if (this.authLoginMethod.equals(AuthMethBASIC)) {
                    this._setValue(this.realmName, loginConfig.getRealmName());
                    this._setValue(this.loginPage, null);
                    this._setValue(this.errorPage, null);
                } else {
                    this._setValue(this.realmName, null);
                    this._setValue(this.loginPage, null);
                    this._setValue(this.errorPage, null);
                }
            }
            this.detailsPanel.setTitle(WebAppSecurityInspector.AUTH_SETTINGS_DETAILS(WebAppSecurityInspector.AuthType2Text(this.authLoginMethod)));
        }

        public LoginConfigurationImpl getLoginConfiguration() {
            if (this.authLoginMethod.equals(AuthMethNONE)) {
                return null;
            }
            LoginConfigurationImpl loginConfig = new LoginConfigurationImpl();
            loginConfig.setAuthenticationMethod(this.authLoginMethod);
            if (this.realmName.isEnabled()) {
                loginConfig.setRealmName(this.realmName.getText());
            }
            if (this.loginPage.isEnabled()) {
                String loginUrl = this.loginPage.getText();
                if (!loginUrl.startsWith("/")) {
                    loginUrl = "/" + loginUrl;
                }
                loginConfig.setFormLoginPage(loginUrl);
            }
            if (this.errorPage.isEnabled()) {
                loginConfig.setFormErrorPage(this.errorPage.getText());
            }
            return loginConfig;
        }

        private void _setValue(UITitledBox t2, String v2) {
            t2.setEnabled(v2 != null);
            if (t2 instanceof UITitledComboBox) {
                ((UITitledComboBox)t2).setText(v2);
            } else if (t2 instanceof UITitledTextField) {
                ((UITitledTextField)t2).setText(v2);
            }
        }

        public void okAction() {
            this.okSelected = true;
            this.setVisible(false);
        }

        public void cancelAction() {
            this.okSelected = false;
            this.setVisible(false);
        }

        public boolean userSelectedOK() {
            return this.okSelected;
        }
    }

    private class SecurityConstraintsTableModel
    extends InspectorTableModel {
        public SecurityConstraintsTableModel() {
            super(new String[]{""});
            this.setDataOrdering(1);
        }

        public SecurityConstraintImpl getRow(int index) {
            return (SecurityConstraintImpl)this.getRowObject(index);
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public Object getObjectValue(Object obj, int col) {
            SecurityConstraintImpl ref = (SecurityConstraintImpl)obj;
            return ref.getName();
        }

        public void setObjectValue(Object obj, int col, Object value) {
            SecurityConstraintImpl ref = (SecurityConstraintImpl)obj;
            ref.setName((String)value);
        }
    }

    class SecurityConstraintsTable
    extends InspectorTable {
        public SecurityConstraintsTable(SecurityConstraintsTableModel model) {
            super(model);
            this.setSelectionMode(0);
        }
    }

    private class SecurityListCellRenderer
    extends DefaultListCellRenderer {
        private SecurityListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
            } else {
                this.setText(value == null ? "" : ((SecurityRoleDescriptor)value).getName());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : DefaultListCellRenderer.noFocusBorder);
            return this;
        }
    }
}

