/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.tools.deployment.ui.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.table.TableCellEditor;

public class EnvironmentInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$EnvironmentInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$descriptor$EnvironmentInspector = EnvironmentInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.EnvironmentInspector")) : class$com$sun$enterprise$tools$deployment$ui$descriptor$EnvironmentInspector);
    private static final String TABLE_TOOLTIP = localStrings.getLocalString("ui.environmentinspector.table.tooltip", "Table of environment entries");
    private static final String TABLE_TITLE = localStrings.getLocalString("ui.environmentinspector.table.title", "Environment entries referenced in code");
    private static final String TABLE_CODED_ENTRY = localStrings.getLocalString("ui.environmentinspector.table.coded_entry", "Coded Entry");
    private static final String TABLE_TYPE = localStrings.getLocalString("ui.environmentinspector.table.type", "Type");
    private static final String TABLE_VALUE = localStrings.getLocalString("ui.environmentinspector.table.value", "Value");
    private static final String TABNAME = localStrings.getLocalString("ui.environmentinspector.tabname", "Env.Entries");
    private static String wizardHelpID = "Env";
    private static String deployHelpID = "Env";
    private WritableJndiNameEnvironment descriptor;
    private static final String JAVA_LANG = "java.lang.";
    private EnvironmentEntriesTable environmentEntriesTable = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$EnvironmentInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$WritableJndiNameEnvironment;
    static /* synthetic */ Class class$java$lang$String;

    private static String ILLEGAL_VALUE(String v0) {
        return localStrings.getLocalString("ui.environmentinspector.table.illegal_type", "{0} is not a legal value for this environment entry type", new Object[]{v0});
    }

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new EnvironmentInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$deployment$WritableJndiNameEnvironment == null ? (class$com$sun$enterprise$deployment$WritableJndiNameEnvironment = EnvironmentInspector.class$("com.sun.enterprise.deployment.WritableJndiNameEnvironment")) : class$com$sun$enterprise$deployment$WritableJndiNameEnvironment;
    }

    public Descriptor getDescriptor() {
        return (Descriptor)((Object)this.descriptor);
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WritableJndiNameEnvironment ? (WritableJndiNameEnvironment)((Object)desc) : null;
            this.environmentEntriesTable.clearTableData();
        }
    }

    private EnvironmentInspector(String mode) {
        this.initializeLayout();
        this.setInspectorMode(mode);
    }

    private void initializeLayout() {
        GridBagConstraints c10 = new GridBagConstraints();
        GridBagLayout gb1 = new GridBagLayout();
        this.setLayout(gb1);
        UITitledTable environmentEntriesPanel = new UITitledTable(TABLE_TITLE, true);
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        gb1.setConstraints(environmentEntriesPanel, c10);
        this.add(environmentEntriesPanel);
        this.environmentEntriesTable = new EnvironmentEntriesTable(new EnvironmentEntriesTableModel());
        environmentEntriesPanel.getGBConstraints().weighty = 0.85;
        environmentEntriesPanel.setTableView(this.environmentEntriesTable);
        UIButton addPB = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                EnvironmentInspector.this.addEnvironmentPropertyAction();
            }
        });
        environmentEntriesPanel.addControlButton(addPB);
        UIButton delPB = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                EnvironmentInspector.this.removeEnvironmentPropertyAction();
            }
        }, true);
        environmentEntriesPanel.addSelectionEnabledButton(delPB);
    }

    private void addEnvironmentPropertyAction() {
        if (this.environmentEntriesTable.getRowWithValue(0, "") == null) {
            this.descriptor.addEnvironmentProperty(new EnvironmentProperty("", "", "", (class$java$lang$String == null ? (class$java$lang$String = EnvironmentInspector.class$("java.lang.String")) : class$java$lang$String).getName()));
        }
        this.environmentEntriesTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    private void removeEnvironmentPropertyAction() {
        Object[] list = this.environmentEntriesTable.confirmDeleteSelection(null, null);
        if (list != null) {
            int i2 = 0;
            while (i2 < list.length) {
                EnvironmentProperty ref = (EnvironmentProperty)list[i2];
                this.descriptor.removeEnvironmentProperty(ref);
                ++i2;
            }
        }
        this.invokeRefresh();
    }

    public void refresh() {
        if (this.descriptor != null) {
            this.environmentEntriesTable.updateTableData(this.descriptor.getEnvironmentProperties());
        }
    }

    public static void main(String[] args) {
        final EnvironmentInspector ei2 = new EnvironmentInspector("WizardMode");
        JFrame f2 = new JFrame();
        ((Component)f2).setBounds(10, 10, 300, 300);
        f2.getContentPane().add(ei2);
        f2.show();
        final EjbSessionDescriptor descriptor = new EjbSessionDescriptor();
        descriptor.addNotificationListener(new NotificationListener(){

            public void notification(NotificationEvent ne) {
                ei2.setDescriptor(descriptor);
            }
        });
        ei2.setDescriptor(descriptor);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class EnvironmentEntriesTableModel
    extends InspectorTableModel {
        public EnvironmentEntriesTableModel() {
            super(new String[]{TABLE_CODED_ENTRY, TABLE_TYPE, TABLE_VALUE, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
        }

        public EnvironmentProperty getRow(int index) {
            return (EnvironmentProperty)this.getRowObject(index);
        }

        public Object getObjectValue(Object obj, int col) {
            EnvironmentProperty ref = (EnvironmentProperty)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getName();
                    break;
                }
                case 1: {
                    value = ref.getType().startsWith(EnvironmentInspector.JAVA_LANG) ? ref.getType().substring(EnvironmentInspector.JAVA_LANG.length()) : ref.getType();
                    break;
                }
                case 2: {
                    value = ref.getValue();
                    break;
                }
                case 3: {
                    value = ref.getDescription();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            EnvironmentProperty ref = (EnvironmentProperty)obj;
            if (ref == null) {
                return;
            }
            String valStr = value.toString();
            switch (col) {
                case 0: {
                    ref.setName(valStr);
                    break;
                }
                case 1: {
                    if (!valStr.startsWith(EnvironmentInspector.JAVA_LANG)) {
                        valStr = EnvironmentInspector.JAVA_LANG + valStr;
                    }
                    if (valStr.equals(ref.getType())) break;
                    ref.setType(valStr);
                    this.setObjectValue(obj, 2, "");
                    break;
                }
                case 2: {
                    try {
                        ref.setValue(super.validatePrimitiveValue(ref.getType(), valStr));
                    }
                    catch (IllegalArgumentException iae) {
                        UIOptionPane.showErrorDialog(null, EnvironmentInspector.ILLEGAL_VALUE(valStr));
                    }
                    break;
                }
                case 3: {
                    ref.setDescription(valStr);
                }
            }
            ((Descriptor)((Object)EnvironmentInspector.this.descriptor)).changed();
        }
    }

    private class EnvironmentEntriesTable
    extends InspectorTable {
        public EnvironmentEntriesTable(EnvironmentEntriesTableModel model) {
            super(model);
            this.setToolTipText(TABLE_TOOLTIP);
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
            this.setHandleDescriptionUpdates(true);
        }

        public TableCellEditor getCellEditor(int row, int col) {
            TableCellEditor rtn = null;
            switch (col) {
                case 1: {
                    rtn = super.getPrimitiveTypesEditor();
                    break;
                }
                case 2: {
                    EnvironmentProperty ref = (EnvironmentProperty)this.getRowObject(row);
                    rtn = super.getPrimitiveValueEditor(ref.getType());
                    break;
                }
                default: {
                    rtn = super.getCellEditor(row, col);
                }
            }
            return rtn;
        }
    }
}

