/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbAbstractDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbExternalDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.tools.deployment.ui.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIRadioButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class EjbRefsInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbRefsInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbRefsInspector = EjbRefsInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.EjbRefsInspector")) : class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbRefsInspector);
    private static String EJB_REFS_IN_CODE = localStrings.getLocalString("ui.ejbrefsinspector.table.title", "EJB's Referenced in Code");
    private static final String ADD_BUTTON = localStrings.getLocalString("ui.ejbrefsinspector.table.add_button", "Add");
    private static final String DELETE_BUTTON = localStrings.getLocalString("ui.ejbrefsinspector.table.delete_button", "Delete...");
    private static final String DEPLOY_SETTINGS = localStrings.getLocalString("ui.ejbrefsinspector.deployment_settings", "Deployment Settings");
    private static final String USE_SSL = localStrings.getLocalString("ui.ejbrefsinspector.use_ssl", "Use SSL");
    private static final String TABLE_TOOLTIP = localStrings.getLocalString("ui.ejbrefsinspector.table.tooltip", "Table of EJB References");
    private static final String TABLE_RENDERER_TOOLTIP = localStrings.getLocalString("ui.ejbrefsinspector.table.type.tooltip", "Click to Edit EJB Type");
    private static final String TABLE_CODED_NAME = localStrings.getLocalString("ui.ejbrefsinspector.table.coded_name", "Coded Name");
    private static final String TABLE_TYPE = localStrings.getLocalString("ui.ejbrefsinspector.table.type", "Type");
    private static final String TABLE_INTERFACES = localStrings.getLocalString("ui.ejbrefsinspector.table.interfaces", "Interfaces");
    private static final String TABLE_HOME_INTERFACE = localStrings.getLocalString("ui.ejbrefsinspector.table.home_interface", "Home Interface");
    private static final String TABLE_HOME = localStrings.getLocalString("ui.ejbrefsinspector.table.home", "Home");
    private static final String TABLE_REMOTE_INTERFACE = localStrings.getLocalString("ui.ejbrefsinspector.table.remote_interface", "Local/Remote Interface");
    private static final String TABLE_REMOTE = localStrings.getLocalString("ui.ejbrefsinspector.table.remote", "Remote");
    private static final String INTERFACE_LOCAL = localStrings.getLocalString("ui.ejbrefsinspector.table.local", "Local");
    private static final String INTERFACE_REMOTE = localStrings.getLocalString("ui.ejbrefsinspector.table.remote", "Remote");
    private static final String BEAN_NAME = localStrings.getLocalString("ui.ejbrefsinspector.enterprise_bean_name", "Enterprise Bean Name");
    private static final String JNDI_NAME = localStrings.getLocalString("ui.ejbrefsinspector.jndi_name", "JNDI Name:");
    private static final String TABNAME = localStrings.getLocalString("ui.ejbrefsinspector.tabname", "EJB Ref's");
    private static String wizardHelpID = "EJBRef";
    private static String deployHelpID = "EJBRef";
    private WritableJndiNameEnvironment descriptor = null;
    private EjbRefsTable ejbRefsTable;
    private JButton addPB;
    private JButton delPB;
    private UITitledComboBox linkNameText = null;
    private UITitledComboBox jndiNameText = null;
    private UIRadioButtonBox deploySettingsRB = null;
    private String[] ejbTypes = new String[]{"Session", "Entity"};
    private String[] interfaceTypes = new String[]{INTERFACE_LOCAL, INTERFACE_REMOTE};
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbRefsInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$WritableJndiNameEnvironment;

    private static String DEPLOY_SETTINGS_FOR(String v0) {
        return localStrings.getLocalString("ui.ejbrefsinspector.deployment_settings_for", "Deployment Settings for {0}", new Object[]{v0});
    }

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new EjbRefsInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isWizardMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$deployment$WritableJndiNameEnvironment == null ? (class$com$sun$enterprise$deployment$WritableJndiNameEnvironment = EjbRefsInspector.class$("com.sun.enterprise.deployment.WritableJndiNameEnvironment")) : class$com$sun$enterprise$deployment$WritableJndiNameEnvironment;
    }

    public Descriptor getDescriptor() {
        return (Descriptor)((Object)this.descriptor);
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WritableJndiNameEnvironment ? (WritableJndiNameEnvironment)((Object)desc) : null;
            this.ejbRefsTable.clearTableData();
            this.resetRefresh();
        }
    }

    private EjbRefsInspector(String mode) {
        this.initializeLayout();
        this.setInspectorMode(mode);
    }

    private void initializeLayout() {
        GridBagConstraints c10 = new GridBagConstraints();
        GridBagLayout gb1 = new GridBagLayout();
        this.setLayout(gb1);
        UITitledBox titledBox = new UITitledBox(EJB_REFS_IN_CODE, true);
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        this.add((Component)titledBox, c10);
        UITitledTable ejbRefsPanel = new UITitledTable(null, false);
        titledBox.addWithGBConstraints(ejbRefsPanel);
        this.ejbRefsTable = new EjbRefsTable(new EjbRefsTableModel());
        this.ejbRefsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e10) {
                if (e10.getValueIsAdjusting()) {
                    return;
                }
                EjbRefsInspector.this.showSelectedEjbRef();
            }
        });
        this.ejbRefsTable.setAutoResizeMode(4);
        ejbRefsPanel.getGBConstraints().weighty = 0.85;
        ejbRefsPanel.setTableView(this.ejbRefsTable);
        this.addPB = new JButton(ADD_BUTTON);
        this.addPB.setMnemonic('A');
        this.addPB.setActionCommand("Add");
        this.addPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                EjbRefsInspector.this.addEjbRefAction();
            }
        });
        ejbRefsPanel.addControlButton(this.addPB);
        this.delPB = new JButton(DELETE_BUTTON);
        this.delPB.setMnemonic('D');
        this.delPB.setActionCommand("Delete");
        this.delPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                EjbRefsInspector.this.deleteEjbRefAction();
            }
        });
        ejbRefsPanel.addSelectionEnabledButton(this.delPB);
        this.deploySettingsRB = new UIRadioButtonBox(DEPLOY_SETTINGS, true);
        GridBagConstraints gbc = titledBox.getGBConstraints();
        gbc.weighty = 0.0;
        gbc.insets.top = 5;
        gbc.insets.right = 85;
        titledBox.addWithGBConstraints(this.deploySettingsRB);
        this.deploySettingsRB.addItem(BEAN_NAME);
        this.linkNameText = new UITitledComboBox(null, false);
        this.linkNameText.setEditable(true);
        this.linkNameText.setClearWhenDisabled(true);
        this.linkNameText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                EjbReferenceDescriptor ref = EjbRefsInspector.convertEjbReference(EjbRefsInspector.this.getSelectedEjbReference());
                if (ref != null) {
                    ref.setLinkName(EjbRefsInspector.this.linkNameText.getText());
                    if (EjbRefsInspector.this.descriptor != null) {
                        ((Descriptor)((Object)EjbRefsInspector.this.descriptor)).changed();
                    }
                    EjbRefsInspector.this.invokeRefresh();
                }
            }
        });
        gbc = this.deploySettingsRB.getGBConstraintsCopy();
        gbc.insets.left += 18;
        gbc.insets.bottom = 0;
        this.deploySettingsRB.add((Component)this.linkNameText, gbc);
        this.deploySettingsRB.addSelectionEnabledComponent(this.linkNameText, null);
        this.deploySettingsRB.addItem(JNDI_NAME);
        this.jndiNameText = new UITitledComboBox(null, false);
        this.jndiNameText.setEditable(true);
        this.jndiNameText.setClearWhenDisabled(true);
        this.jndiNameText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                EjbReferenceDescriptor ref = EjbRefsInspector.convertEjbReference(EjbRefsInspector.this.getSelectedEjbReference());
                if (ref != null) {
                    ref.setJndiName(EjbRefsInspector.this.jndiNameText.getText());
                    if (EjbRefsInspector.this.descriptor != null) {
                        ((Descriptor)((Object)EjbRefsInspector.this.descriptor)).changed();
                    }
                    EjbRefsInspector.this.invokeRefresh();
                }
            }
        });
        gbc = this.deploySettingsRB.getGBConstraintsCopy();
        gbc.insets.left += 18;
        gbc.insets.bottom = 0;
        this.deploySettingsRB.add((Component)this.jndiNameText, gbc);
        this.deploySettingsRB.addSelectionEnabledComponent(this.jndiNameText, null);
        this.showSelectedEjbRef();
    }

    private Vector getPossibleEjbLinkNames() {
        Vector<String> ejbLinkNames = new Vector<String>();
        Application app = null;
        if (this.descriptor instanceof EjbDescriptor) {
            EjbDescriptor ed2 = (EjbDescriptor)this.descriptor;
            app = ed2.getApplication();
        } else if (this.descriptor instanceof WebBundleDescriptor) {
            WebBundleDescriptor wbd = (WebBundleDescriptor)this.descriptor;
            app = wbd.getApplication();
        }
        if (app != null) {
            Vector ejbList = app.getEjbDescriptors();
            Iterator itr = ((AbstractList)ejbList).iterator();
            while (itr.hasNext()) {
                EjbDescriptor ejb = (EjbDescriptor)itr.next();
                ejbLinkNames.addElement(ejb.getEjbBundleDescriptor().getArchivist().getArchiveUri() + "#" + ejb.getName());
            }
        }
        return ejbLinkNames;
    }

    private Vector getPossibleEjbJndiNames() {
        Vector<String> ejbJndiNames = new Vector<String>();
        Application app = null;
        if (this.descriptor instanceof EjbDescriptor) {
            EjbDescriptor d10 = (EjbDescriptor)this.descriptor;
            app = d10.getApplication();
        } else if (this.descriptor instanceof WebBundleDescriptor) {
            WebBundleDescriptor wbd = (WebBundleDescriptor)this.descriptor;
            app = wbd.getApplication();
        }
        if (app != null) {
            Vector ejbList = app.getEjbDescriptors();
            Iterator itr = ((AbstractList)ejbList).iterator();
            while (itr.hasNext()) {
                EjbDescriptor ejb = (EjbDescriptor)itr.next();
                ejbJndiNames.addElement(ejb.getJndiName());
            }
        }
        return ejbJndiNames;
    }

    public void refresh() {
        this.ejbRefsTable.updateTableData(this.descriptor.getEjbReferenceDescriptors());
        this.showSelectedEjbRef();
    }

    private void showSelectedEjbRef() {
        String jndiName;
        EjbReferenceDescriptor ejbRef = this.getSelectedEjbReference();
        if (ejbRef == null) {
            this.deploySettingsRB.setTitle(DEPLOY_SETTINGS);
            this.deploySettingsRB.setEnabled(false);
            return;
        }
        this.deploySettingsRB.setEnabled(true);
        this.deploySettingsRB.setTitle(EjbRefsInspector.DEPLOY_SETTINGS_FOR(ejbRef.getName()));
        String linkName = EjbRefsInspector._getBeanName(ejbRef);
        if (linkName == null) {
            linkName = "";
        }
        if ((jndiName = EjbRefsInspector.getEjbReferenceJndiName(ejbRef)) == null) {
            jndiName = "";
        }
        this.deploySettingsRB.setItemEnabled(BEAN_NAME, true);
        this.deploySettingsRB.setItemEnabled(JNDI_NAME, !ejbRef.isLocal());
        if (ejbRef.isLocal() || jndiName.equals("")) {
            this.deploySettingsRB.setSelectedItem(BEAN_NAME);
        } else if (linkName.equals("") && !jndiName.equals("")) {
            this.deploySettingsRB.setSelectedItem(JNDI_NAME);
        } else if (super.isFirstRefresh()) {
            if (!linkName.equals("")) {
                this.deploySettingsRB.setSelectedItem(BEAN_NAME);
            } else {
                this.deploySettingsRB.setSelectedItem(JNDI_NAME);
            }
        } else if (this.deploySettingsRB.getSelectedIndex() < 0) {
            this.deploySettingsRB.setSelectedItem(BEAN_NAME);
        }
        Vector ejbLinkNames = this.getPossibleEjbLinkNames();
        if (!linkName.equals("") && !ejbLinkNames.contains(linkName)) {
            ejbLinkNames.add(linkName);
        }
        this.linkNameText.setModel(ejbLinkNames);
        this.linkNameText.setSelectedItem(linkName);
        Vector ejbJndiNames = this.getPossibleEjbJndiNames();
        if (!jndiName.equals("") && !ejbJndiNames.contains(jndiName)) {
            ejbJndiNames.add(jndiName);
        }
        this.jndiNameText.setModel(ejbJndiNames);
        this.jndiNameText.setSelectedItem(jndiName);
    }

    private BundleDescriptor _getBundleDescriptor(EjbReferenceDescriptor ref) {
        BundleDescriptor bd2 = null;
        EjbAbstractDescriptor ead = ref.getEjbDescriptor();
        if (ead instanceof EjbDescriptor) {
            bd2 = ((EjbDescriptor)ead).getEjbBundleDescriptor();
        }
        if (bd2 == null) {
            bd2 = (WebBundleDescriptor)this.descriptor;
        }
        return bd2;
    }

    private EjbReferenceDescriptor getSelectedEjbReference() {
        return (EjbReferenceDescriptor)this.ejbRefsTable.getSelectedRowObject();
    }

    private void addEjbRefAction() {
        if (this.ejbRefsTable.getRowWithValue(0, "") == null) {
            EjbReferenceDescriptor ejbRef = new EjbReferenceDescriptor();
            Descriptor.setBoundsChecking(false);
            ejbRef.setName("");
            ejbRef.setType(this.ejbTypes[0]);
            ejbRef.setLocal(false);
            this.descriptor.addEjbReferenceDescriptor(ejbRef);
        }
        this.ejbRefsTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    private void deleteEjbRefAction() {
        Object[] list = this.ejbRefsTable.confirmDeleteSelection(null, null);
        if (list != null) {
            int i2 = 0;
            while (i2 < list.length) {
                EjbReferenceDescriptor ref = (EjbReferenceDescriptor)list[i2];
                this.descriptor.removeEjbReferenceDescriptor(ref);
                ++i2;
            }
        }
        this.invokeRefresh();
    }

    public static EjbReferenceDescriptor convertEjbReference(EjbReferenceDescriptor ref) {
        EjbAbstractDescriptor ejb = ref.getEjbDescriptor();
        if (!(ejb instanceof EjbExternalDescriptor)) {
            String jndiName;
            UIUtils.debugPrintln("Converting Ejb Reference ...");
            EjbExternalDescriptor newEjb = new EjbExternalDescriptor();
            newEjb.setType(ejb.getType());
            if (ref.isLocal()) {
                newEjb.setLocalHomeClassName(ejb.getLocalHomeClassName());
                newEjb.setLocalClassName(ejb.getLocalClassName());
            } else {
                newEjb.setHomeClassName(ejb.getHomeClassName());
                newEjb.setRemoteClassName(ejb.getRemoteClassName());
            }
            if (ref.isLinked()) {
                newEjb.setLinkName(EjbRefsInspector._getBeanName(ref));
            }
            if ((jndiName = EjbRefsInspector.getEjbReferenceJndiName(ref)) != null) {
                newEjb.setJndiName(jndiName);
            }
            ((EjbDescriptor)ejb).removeEjbReferencer(ref);
            ref.setEjbDescriptor(newEjb);
        }
        return ref;
    }

    public static String getEjbReferenceJndiName(EjbReferenceDescriptor ref) {
        EjbAbstractDescriptor ejb = ref.getEjbDescriptor();
        String jndiName = null;
        jndiName = ref.isLocal() ? ejb.getJndiName() : ejb.getJndiName();
        return jndiName;
    }

    private static String _getBeanName(EjbReferenceDescriptor ref) {
        return ref.isLinked() ? ref.getLinkName() : "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class EjbRefsTableModel
    extends InspectorTableModel {
        EjbRefsInspector inspector;

        public EjbRefsTableModel() {
            super(new String[]{TABLE_CODED_NAME, TABLE_TYPE, TABLE_INTERFACES, TABLE_HOME_INTERFACE, TABLE_REMOTE_INTERFACE, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
        }

        public EjbReferenceDescriptor getRow(int index) {
            return (EjbReferenceDescriptor)this.getRowObject(index);
        }

        public Object getObjectValue(Object obj, int col) {
            EjbReferenceDescriptor ref = (EjbReferenceDescriptor)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getName();
                    break;
                }
                case 1: {
                    value = ref.getType();
                    break;
                }
                case 2: {
                    value = ref.isLocal() ? INTERFACE_LOCAL : INTERFACE_REMOTE;
                    break;
                }
                case 3: {
                    value = ref.getHomeClassName();
                    if (value != null) break;
                    value = "";
                    break;
                }
                case 4: {
                    value = ref.getBeanClassName();
                    if (value != null) break;
                    value = "";
                    break;
                }
                case 5: {
                    value = ref.getDescription();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            EjbReferenceDescriptor ref = EjbRefsInspector.convertEjbReference((EjbReferenceDescriptor)obj);
            String valStr = value.toString();
            switch (col) {
                case 0: {
                    ref.setName(valStr);
                    return;
                }
                case 1: {
                    ref.setType(valStr);
                    break;
                }
                case 2: {
                    String homeClass = ref.getHomeClassName();
                    ref.setHomeClassName("");
                    String beanClass = ref.getBeanClassName();
                    ref.setBeanClassName("");
                    ref.setLocal(INTERFACE_LOCAL.equals(valStr));
                    ref.setHomeClassName(homeClass);
                    ref.setBeanClassName(beanClass);
                    break;
                }
                case 3: {
                    ref.setHomeClassName(valStr);
                    break;
                }
                case 4: {
                    ref.setBeanClassName(valStr);
                    break;
                }
                case 5: {
                    ref.setDescription(valStr);
                }
            }
            ((Descriptor)((Object)EjbRefsInspector.this.descriptor)).changed();
        }

        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return true;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 3: {
                    return true;
                }
                case 4: {
                    return true;
                }
                case 5: {
                    return true;
                }
            }
            return false;
        }
    }

    private class EjbRefsTable
    extends InspectorTable {
        int selectedRow = -1;

        public EjbRefsTable(EjbRefsTableModel model) {
            super(model);
            this.setToolTipText(TABLE_TOOLTIP);
            this.setSelectionMode(0);
            this.setHandleDescriptionUpdates(true);
            TableColumn typeCol = this.getColumnModel().getColumn(1);
            JComboBox<String> typeCB = new JComboBox<String>(EjbRefsInspector.this.ejbTypes);
            typeCol.setCellEditor(new DefaultCellEditor(typeCB));
            TableColumn intrfCol = this.getColumnModel().getColumn(2);
            JComboBox<String> intrfCB = new JComboBox<String>(EjbRefsInspector.this.interfaceTypes);
            intrfCol.setCellEditor(new DefaultCellEditor(intrfCB));
        }
    }
}

