/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.repository.ConnectorResource;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.ServerDescriptor;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.descriptor.ConnectionFactoryDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIIcons;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledControlButtonBox;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreeSelectionModel;

public class ServerResAdptInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$ServerResAdptInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$ServerResAdptInspector = ServerResAdptInspector.class$("com.sun.enterprise.tools.deployment.ui.ServerResAdptInspector")) : class$com$sun$enterprise$tools$deployment$ui$ServerResAdptInspector);
    private static final String TABNAME = localStrings.getLocalString("ui.serverresadptinspector.tabname", "Resource Adapters");
    private static final String BOX_TITLE = localStrings.getLocalString("ui.serverresadptinspector.connection_factories", "Deployed Connection Factories");
    private static final String NEW_BUTTON = localStrings.getLocalString("ui.serverresadptinspector.new_button", "New...");
    private static final String EDIT_BUTTON = localStrings.getLocalString("ui.serverresadptinspector.edit_button", "Edit...");
    private static final String DELETE_BUTTON = localStrings.getLocalString("ui.serverresadptinspector.delete_button", "Delete...");
    private static final String CONFIRMATION_DIALOG = localStrings.getLocalString("ui.serverresadptinspector.confirmation_dialog", "Confirmation Dialog");
    private static String wizardHelpID = "ResAdapt";
    private static String deployHelpID = "ResAdapt";
    ServerDescriptor descriptor = null;
    private static final String ROOT = "root";
    private static final String APP = "app";
    private static final String RAR = "rar";
    private static final String FACTORY = "factory";
    private JTree resourceAdptTree = new JTree();
    private ResourceAdptTreeView treeView = null;
    private DefaultMutableTreeNode selectedNode = null;
    private JButton btnEdit = null;
    private JButton btnDelete = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$ServerResAdptInspector;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$ServerDescriptor;

    private static String ERROR_DELETING(String v0, String v1) {
        return localStrings.getLocalString("ui.serverresadptinspector.error_while_deleting", "An error was encountered while deleting ''{0}''\n {1}", new Object[]{v0, v1});
    }

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new ServerResAdptInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$tools$deployment$ui$ServerDescriptor == null ? (class$com$sun$enterprise$tools$deployment$ui$ServerDescriptor = ServerResAdptInspector.class$("com.sun.enterprise.tools.deployment.ui.ServerDescriptor")) : class$com$sun$enterprise$tools$deployment$ui$ServerDescriptor;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor obj) {
        if (obj instanceof ServerDescriptor) {
            this.descriptor = (ServerDescriptor)obj;
            this.invokeRefresh();
        }
    }

    private ServerResAdptInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        this.setLayout(new BorderLayout());
        UITitledBox mainPanel = new UITitledBox(BOX_TITLE, true);
        this.add((Component)mainPanel, "Center");
        this.treeView = this.getResourceAdptTreeView();
        GridBagConstraints c10 = mainPanel.getGBConstraints();
        c10.weightx = 0.8;
        c10.weighty = 0.8;
        c10.insets = new Insets(5, 5, 5, 5);
        mainPanel.setGBConstraints(this.treeView, c10);
        mainPanel.addWithGBConstraints(this.treeView);
        UITitledControlButtonBox buttonsPanel = new UITitledControlButtonBox(null, false);
        buttonsPanel.setControlButtonLocation(13);
        c10.gridx = -1;
        c10.gridy = 0;
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.insets = new Insets(5, 5, 5, 5);
        mainPanel.setGBConstraints(buttonsPanel, c10);
        mainPanel.addWithGBConstraints(buttonsPanel);
        JButton btnNew = new JButton(NEW_BUTTON);
        btnNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ServerResAdptInspector.this.newAction();
            }
        });
        buttonsPanel.addControlButton(btnNew);
        this.btnEdit = new JButton(EDIT_BUTTON);
        this.btnEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ServerResAdptInspector.this.editAction();
            }
        });
        buttonsPanel.addControlButton(this.btnEdit);
        this.btnDelete = new JButton(DELETE_BUTTON);
        this.btnDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ServerResAdptInspector.this.deleteAction();
            }
        });
        buttonsPanel.addControlButton(this.btnDelete);
        this.enableButtons(false);
        this.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e10) {
                ServerResAdptInspector.this.resourceAdptTree.clearSelection();
                ServerResAdptInspector.this.enableButtons(false);
            }

            public void focusGained(FocusEvent e10) {
            }
        });
    }

    private void enableButtons(boolean state) {
        if (this.btnEdit != null) {
            this.btnEdit.setEnabled(state);
            this.btnDelete.setEnabled(state);
        }
    }

    private void newAction() {
        ConnectionFactoryDialog cfd = ConnectionFactoryDialog.showNewDialog(this);
        if (cfd.isOk()) {
            this.invokeRefresh();
        }
    }

    private void editAction() {
        DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)this.resourceAdptTree.getLastSelectedPathComponent();
        if (dmtn == null) {
            return;
        }
        Object obj = dmtn.getUserObject();
        if (!(obj instanceof ConnectorResource)) {
            return;
        }
        ConnectorResource cr2 = (ConnectorResource)obj;
        String factoryName = cr2.getName();
        ConnectionFactoryDialog cfd = ConnectionFactoryDialog.showEditDialog(this, factoryName);
        if (cfd.isOk()) {
            this.invokeRefresh();
        }
    }

    private void deleteAction() {
        DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)this.resourceAdptTree.getLastSelectedPathComponent();
        if (dmtn == null) {
            return;
        }
        Object obj = dmtn.getUserObject();
        if (!(obj instanceof ConnectorResource)) {
            return;
        }
        ConnectorResource cr2 = (ConnectorResource)obj;
        int action = JOptionPane.showConfirmDialog(this, localStrings.getLocalString("ui.serverresadptinspector.delete_confirmation", "Do you want to delete selected connection factory(s)?"), CONFIRMATION_DIALOG, 0);
        if (action == 0) {
            try {
                ConnectionFactoryDialog.removeConnectorResource(cr2.getName());
                this.invokeRefresh();
            }
            catch (Exception ex2) {
                JOptionPane.showMessageDialog(UIUtils.getAncestorFrame(this), ServerResAdptInspector.ERROR_DELETING(cr2.getName(), ex2.toString()));
            }
        }
    }

    public void refresh() {
        this.treeView.buildView(false);
    }

    public void notification(NotificationEvent ne) {
        this.invokeRefresh();
    }

    public String toString() {
        return "Resource Adapters inspector";
    }

    private ResourceAdptTreeView getResourceAdptTreeView() {
        if (this.treeView == null) {
            this.treeView = new ResourceAdptTreeView(this.resourceAdptTree);
            this.resourceAdptTree.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e10) {
                    if (e10.getModifiers() == 17) {
                        ServerResAdptInspector.this.treeView.buildView(false);
                        return;
                    }
                }
            });
            this.resourceAdptTree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent tse) {
                    Object obj;
                    JTree srcTree = (JTree)tse.getSource();
                    ServerResAdptInspector.this.selectedNode = (DefaultMutableTreeNode)srcTree.getLastSelectedPathComponent();
                    Object object = obj = ServerResAdptInspector.this.selectedNode != null ? ServerResAdptInspector.this.selectedNode.getUserObject() : null;
                    if (obj == null) {
                        ServerResAdptInspector.this.enableButtons(false);
                    } else if (!(obj instanceof ConnectorResource)) {
                        ServerResAdptInspector.this.enableButtons(false);
                    } else {
                        ServerResAdptInspector.this.enableButtons(true);
                    }
                    ServerResAdptInspector.this.resourceAdptTree.grabFocus();
                }
            });
        }
        this.treeView.setPreferredSize(this.treeView.getMaximumSize());
        return this.treeView;
    }

    public static void main(String[] args) {
        JFrame frm = new JFrame();
        frm.getContentPane().setLayout(new BorderLayout());
        frm.getContentPane().add(new ServerResAdptInspector("DeploymentMode"));
        ((Component)frm).setSize(610, 630);
        frm.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e10) {
                System.exit(0);
            }
        });
        ((Component)frm).setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class RootTreeCellRenderer
    extends DefaultTreeCellRenderer {
        RootTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Color textColor = Color.black;
            JLabel defaultRenderingLabel = (JLabel)super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
            if (value instanceof DescriptorTreeNode) {
                DescriptorTreeNode dtn = (DescriptorTreeNode)value;
                Class type = dtn.getType();
                defaultRenderingLabel.setIcon(UIIcons.getIconFor(type));
            }
            return defaultRenderingLabel;
        }
    }

    private class DescriptorTreeNode
    extends DefaultMutableTreeNode {
        private boolean tag = false;
        private Class type = class$java$lang$Object == null ? (class$java$lang$Object = DescriptorTreeNode.class$("java.lang.Object")) : class$java$lang$Object;
        private ConnectorResource factory = null;
        static /* synthetic */ Class class$java$lang$Object;

        public void setTag(boolean t2) {
            this.tag = t2;
        }

        public boolean isTagged() {
            return this.tag;
        }

        public DescriptorTreeNode(Object userObj, Class type) {
            super(userObj, true);
            this.type = type != null ? type : (class$java$lang$Object == null ? (class$java$lang$Object = DescriptorTreeNode.class$("java.lang.Object")) : class$java$lang$Object);
        }

        public DescriptorTreeNode(ConnectorResource cr2) {
            super(cr2.getName(), false);
            this.setFactory(cr2);
        }

        public void setFactory(ConnectorResource cr2) {
            this.factory = cr2;
            this.type = this.factory.getClass();
        }

        public Class getType() {
            return this.type;
        }

        public Object getUserObject() {
            return this.factory != null ? this.factory : super.getUserObject();
        }

        public boolean equals(Object obj) {
            if (obj instanceof String && this.toString().equals((String)obj)) {
                return true;
            }
            return obj instanceof DescriptorTreeNode && this.toString().equals(obj.toString());
        }

        public String toString() {
            Object obj = this.getUserObject();
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof ConnectorResource) {
                return ((ConnectorResource)obj).getName();
            }
            if (obj instanceof Descriptor) {
                return ((Descriptor)obj).getName();
            }
            return obj.toString();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class ResourceAdptTreeView
    extends JPanel {
        private JTree tree;
        static /* synthetic */ Class class$com$sun$enterprise$deployment$Application;
        static /* synthetic */ Class class$com$sun$enterprise$deployment$ConnectorDescriptor;

        public ResourceAdptTreeView(JTree rootTree) {
            this.tree = rootTree;
            this.tree.setModel(new DefaultTreeModel(new DescriptorTreeNode("Root", null)));
            this.tree.setRootVisible(false);
            this.tree.setShowsRootHandles(true);
            this.tree.setCellRenderer(new RootTreeCellRenderer());
            this.setLayout(new BorderLayout());
            JPanel treePanel = new JPanel();
            treePanel.setBorder(new LineBorder(Color.black, 0));
            treePanel.setLayout(new BorderLayout());
            treePanel.add(new JScrollPane(this.tree));
            this.add(treePanel);
            TreeSelectionModel selectionModel = this.tree.getSelectionModel();
            selectionModel.setSelectionMode(1);
            this.tree.setSelectionModel(selectionModel);
            this.buildView(true);
        }

        public void buildView(boolean reload) {
            DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
            DescriptorTreeNode root = (DescriptorTreeNode)treeModel.getRoot();
            if (!reload && root.getChildCount() <= 0) {
                reload = true;
            }
            Enumeration<TreeNode> re = root.depthFirstEnumeration();
            while (re.hasMoreElements()) {
                DescriptorTreeNode dtn = (DescriptorTreeNode)re.nextElement();
                dtn.setTag(false);
            }
            root.setTag(true);
            Vector appNames = null;
            try {
                appNames = InspectorPane.getServerManager().getApplicationNames();
            }
            catch (Exception e10) {
                UIUtils.debugPrintln("Unable to get app-names");
            }
            Vector cflist = null;
            try {
                cflist = ConnectionFactoryDialog.listConnectionFactories();
            }
            catch (Exception ex2) {
                UIUtils.debugPrintln("Unable to get Connection Factory list: " + ex2.toString());
                return;
            }
            Enumeration cfenum = cflist.elements();
            while (cfenum.hasMoreElements()) {
                String connName;
                DescriptorTreeNode connNode;
                DescriptorTreeNode topNode = root;
                ConnectorResource cr2 = (ConnectorResource)cfenum.nextElement();
                String applName = cr2.getApplicationName();
                if (applName != null && !applName.equals("")) {
                    topNode = this.getNamedChildNode(root, applName, class$com$sun$enterprise$deployment$Application == null ? ResourceAdptTreeView.class$("com.sun.enterprise.deployment.Application") : class$com$sun$enterprise$deployment$Application);
                    if (topNode == null) {
                        topNode = new DescriptorTreeNode(applName, class$com$sun$enterprise$deployment$Application == null ? ResourceAdptTreeView.class$("com.sun.enterprise.deployment.Application") : class$com$sun$enterprise$deployment$Application);
                        treeModel.insertNodeInto(topNode, root, root.getChildCount());
                    }
                    topNode.setTag(true);
                }
                if ((connNode = this.getNamedChildNode(topNode, connName = cr2.getConnectorName(), class$com$sun$enterprise$deployment$ConnectorDescriptor == null ? ResourceAdptTreeView.class$("com.sun.enterprise.deployment.ConnectorDescriptor") : class$com$sun$enterprise$deployment$ConnectorDescriptor)) == null) {
                    connNode = new DescriptorTreeNode(connName, class$com$sun$enterprise$deployment$ConnectorDescriptor == null ? ResourceAdptTreeView.class$("com.sun.enterprise.deployment.ConnectorDescriptor") : class$com$sun$enterprise$deployment$ConnectorDescriptor);
                    treeModel.insertNodeInto(connNode, topNode, topNode.getChildCount());
                }
                connNode.setTag(true);
                DescriptorTreeNode factNode = this.getNamedChildNode(connNode, cr2.getName(), null);
                if (factNode == null) {
                    factNode = new DescriptorTreeNode(cr2);
                    treeModel.insertNodeInto(factNode, connNode, connNode.getChildCount());
                } else {
                    factNode.setFactory(cr2);
                }
                factNode.setTag(true);
            }
            Vector<DescriptorTreeNode> delNodes = new Vector<DescriptorTreeNode>();
            Enumeration<TreeNode> re2 = root.depthFirstEnumeration();
            while (re2.hasMoreElements()) {
                DescriptorTreeNode dtn = (DescriptorTreeNode)re2.nextElement();
                if (dtn.isTagged()) continue;
                delNodes.add(dtn);
            }
            Enumeration e11 = delNodes.elements();
            while (e11.hasMoreElements()) {
                DescriptorTreeNode dtn = (DescriptorTreeNode)e11.nextElement();
                treeModel.removeNodeFromParent(dtn);
            }
            if (reload) {
                treeModel.reload();
            }
        }

        private DescriptorTreeNode getNamedChildNode(DescriptorTreeNode root, String name, Class type) {
            Enumeration<TreeNode> e10 = root.children();
            while (e10.hasMoreElements()) {
                DescriptorTreeNode node = (DescriptorTreeNode)e10.nextElement();
                if (!node.toString().equals(name) || type != null && node.getType() != type) continue;
                return node;
            }
            return null;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

