/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.NamedDescriptor;
import com.sun.enterprise.deployment.NamedReferencePair;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.web.EjbReference;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.descriptor.EjbRefsInspector;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.table.TableModel;

public class JndiNameInspector
extends InspectorPane {
    private static final boolean SHOW_LOCAL_EJB_LINKS = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$JndiNameInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$JndiNameInspector = JndiNameInspector.class$("com.sun.enterprise.tools.deployment.ui.JndiNameInspector")) : class$com$sun$enterprise$tools$deployment$ui$JndiNameInspector);
    private static final String REFTYPE_EJB = localStrings.getLocalString("ui.jndinameinspector.ref_type.ejb", "EJB");
    private static final String REFTYPE_EJB_REF = localStrings.getLocalString("ui.jndinameinspector.ref_type.ejb_ref", "EJB Ref");
    private static final String REFTYPE_RESOURCE = localStrings.getLocalString("ui.jndinameinspector.ref_type.resource_ref", "Resource");
    private static final String REFTYPE_ENV_RESOURCE = localStrings.getLocalString("ui.jndinameinspector.ref_type.env_resource", "Env Resource");
    private static final String COMPONENT_TITLE = localStrings.getLocalString("ui.jndinameinspector.component.gen_title", "Components");
    private static final String WEB_TITLE = localStrings.getLocalString("ui.jndinameinspector.component.web_title", "Web Components");
    private static final String EJB_TITLE = localStrings.getLocalString("ui.jndinameinspector.component.ejb_title", "EJBs");
    private static final String CLI_TITLE = localStrings.getLocalString("ui.jndinameinspector.component.appclient_title", "App Clients");
    private static final String APP_TITLE = localStrings.getLocalString("ui.jndinameinspector.component.app_title", "Application");
    private static final String COMP_TABLE_TOOLTIP = localStrings.getLocalString("ui.jndinameinspector.component.tooltip", "Component JNDI names");
    private static final String COMP_COL_COMP_TYPE = localStrings.getLocalString("ui.jndinameinspector.component.comp_type", "Component Type");
    private static final String COMP_COL_COMPONENT = localStrings.getLocalString("ui.jndinameinspector.component.component", "Component");
    private static final String COMP_COL_JNDINAME = localStrings.getLocalString("ui.jndinameinspector.component.jndiname", "JNDI Name");
    private static final String REFERENCES = localStrings.getLocalString("ui.jndinameinspector.reference.title", "References");
    private static final String REF_TABLE_TOOLTIP = localStrings.getLocalString("ui.jndinameinspector.reference.tooltip", "Reference JNDI names");
    private static final String REF_COL_REF_TYPE = localStrings.getLocalString("ui.jndinameinspector.reference.ref_type", "Ref. Type");
    private static final String REF_COL_REF_BY = localStrings.getLocalString("ui.jndinameinspector.reference.ref_by", "Referenced By");
    private static final String REF_COL_REF_NAME = localStrings.getLocalString("ui.jndinameinspector.reference.ref_name", "Reference Name");
    private static final String REF_COL_JNDI_NAME = localStrings.getLocalString("ui.jndinameinspector.reference.jndiname", "JNDI Name");
    private static final String TABNAME = localStrings.getLocalString("ui.jndinameinspector.tabname", "JNDI Names");
    private static String wizardHelpID = "JNDI";
    private static String deployHelpID = "JNDI";
    private Descriptor descriptor = null;
    private UITitledBox compJndiBox = null;
    private UITitledTable compJndiView = null;
    private ComponentJndiTable compJndiTable = null;
    private UITitledTable refJndiView = null;
    private ReferenceJndiTable refJndiTable = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$JndiNameInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$Descriptor;

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new JndiNameInspector();
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return this.descriptor != null ? this.descriptor.getClass() : (class$com$sun$enterprise$deployment$Descriptor == null ? (class$com$sun$enterprise$deployment$Descriptor = JndiNameInspector.class$("com.sun.enterprise.deployment.Descriptor")) : class$com$sun$enterprise$deployment$Descriptor);
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc;
            this.compJndiTable.clearTableData();
            this.refJndiTable.clearTableData();
            this.compJndiBox.setVisible(!(desc instanceof WebBundleDescriptor));
        }
        this.invokeRefresh();
    }

    private JndiNameInspector() {
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c10 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.compJndiBox = new UITitledBox(null, false);
        c10.weightx = 1.0;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        this.add((Component)this.compJndiBox, c10);
        GridBagConstraints cjb_gc = this.compJndiBox.getGBConstraints();
        cjb_gc.weighty = 0.5;
        cjb_gc.gridy = 0;
        cjb_gc.gridwidth = 1;
        cjb_gc.gridheight = 1;
        cjb_gc.insets = new Insets(0, 0, 0, 0);
        cjb_gc.fill = 1;
        this.compJndiView = new UITitledTable("", true);
        cjb_gc.weightx = 0.75;
        cjb_gc.gridx = 0;
        this.compJndiBox.add((Component)this.compJndiView, cjb_gc);
        this.compJndiTable = new ComponentJndiTable(new ComponentJndiTableModel());
        this.compJndiView.setTableView(this.compJndiTable);
        cjb_gc.weightx = 0.25;
        cjb_gc.gridx = 1;
        this.compJndiBox.add((Component)new JPanel(), cjb_gc);
        this.refJndiView = new UITitledTable(REFERENCES, true);
        c10.weightx = 1.0;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        this.add((Component)this.refJndiView, c10);
        this.refJndiTable = new ReferenceJndiTable(new ReferenceJndiTableModel());
        this.refJndiView.setTableView(this.refJndiTable);
    }

    public void refresh() {
        Descriptor d10;
        Vector<CMPJndiRef> jndiMisc = null;
        Vector refPairs = null;
        boolean showTypeColumn = false;
        if (this.descriptor instanceof EjbBundleDescriptor) {
            d10 = (EjbBundleDescriptor)this.descriptor;
            this.compJndiView.setTitle(EJB_TITLE);
            refPairs = ((EjbBundleDescriptor)d10).getNamedReferencePairs();
            CMPJndiRef cjr = this.createCMPJndiRef((EjbBundleDescriptor)d10);
            if (cjr != null) {
                if (jndiMisc == null) {
                    jndiMisc = new Vector<CMPJndiRef>();
                }
                jndiMisc.add(cjr);
            }
        } else if (this.descriptor instanceof WebBundleDescriptor) {
            d10 = (WebBundleDescriptor)this.descriptor;
            this.compJndiView.setTitle(WEB_TITLE);
            refPairs = ((WebBundleDescriptor)d10).getNamedReferencePairs();
        } else if (this.descriptor instanceof ApplicationClientDescriptor) {
            d10 = (ApplicationClientDescriptor)this.descriptor;
            this.compJndiView.setTitle(CLI_TITLE);
            refPairs = ((ApplicationClientDescriptor)d10).getNamedReferencePairs();
        } else if (this.descriptor instanceof Application) {
            d10 = (Application)this.descriptor;
            this.compJndiView.setTitle(APP_TITLE);
            refPairs = ((Application)d10).getNamedReferencePairs();
            Set ejbs = ((Application)d10).getEjbBundleDescriptors();
            Iterator i2 = ejbs.iterator();
            while (i2.hasNext()) {
                EjbBundleDescriptor ejbd = (EjbBundleDescriptor)i2.next();
                CMPJndiRef cjr = this.createCMPJndiRef(ejbd);
                if (cjr == null) continue;
                if (jndiMisc == null) {
                    jndiMisc = new Vector();
                }
                jndiMisc.add(cjr);
            }
            showTypeColumn = true;
        } else {
            this.compJndiView.setTitle(COMPONENT_TITLE);
            refPairs = new Vector();
        }
        Vector<NamedReferencePair> comp = new Vector<NamedReferencePair>();
        Vector<Object> ref = new Vector<Object>();
        Enumeration e10 = refPairs.elements();
        while (e10.hasMoreElements()) {
            NamedReferencePair nrp = (NamedReferencePair)e10.nextElement();
            NamedDescriptor referee = nrp.getReferee();
            Descriptor referant = nrp.getReferant();
            if (referee instanceof EjbReference && ((EjbReference)((Object)referee)).isLocal()) continue;
            if (referant.getName().equals(referee.getName())) {
                comp.add(nrp);
                continue;
            }
            ref.add(nrp);
        }
        if (jndiMisc != null) {
            ref.addAll(jndiMisc);
        }
        this.compJndiTable.updateTableData(comp, showTypeColumn);
        this.refJndiTable.updateTableData(ref);
    }

    private CMPJndiRef createCMPJndiRef(EjbBundleDescriptor ejbd) {
        ResourceReferenceDescriptor rrd = ejbd.getCMPResourceReference();
        return rrd != null ? new CMPJndiRef(ejbd, rrd) : null;
    }

    private static String getRefereeTypeName(NamedReferencePair nd) {
        switch (nd.getPairType()) {
            case 1: {
                return REFTYPE_EJB;
            }
            case 2: {
                return REFTYPE_EJB_REF;
            }
            case 3: {
                return REFTYPE_RESOURCE;
            }
            case 4: {
                return REFTYPE_ENV_RESOURCE;
            }
        }
        return "?";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class ReferenceJndiTableModel
    extends InspectorTableModel {
        public ReferenceJndiTableModel() {
            super(new String[]{REF_COL_REF_TYPE, REF_COL_REF_BY, REF_COL_REF_NAME, REF_COL_JNDI_NAME});
        }

        public boolean isCellEditable(int row, int col) {
            return col == 3;
        }

        public Object getObjectValue(Object obj, int col) {
            String value = "<???>";
            switch (col) {
                case 0: {
                    value = obj instanceof NamedReferencePair ? JndiNameInspector.getRefereeTypeName((NamedReferencePair)obj) : ((CMPJndiRef)obj).getRefType();
                    break;
                }
                case 1: {
                    value = obj instanceof NamedReferencePair ? ((NamedReferencePair)obj).getReferant().getName() : ((CMPJndiRef)obj).getRefBy();
                    break;
                }
                case 2: {
                    value = obj instanceof NamedReferencePair ? ((NamedReferencePair)obj).getReferee().getName() : ((CMPJndiRef)obj).getRefName();
                    break;
                }
                case 3: {
                    value = obj instanceof NamedReferencePair ? this._getJndiName(((NamedReferencePair)obj).getReferee()) : ((CMPJndiRef)obj).getJndiName();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            switch (col) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (obj instanceof NamedReferencePair) {
                        NamedReferencePair jndiRef = (NamedReferencePair)obj;
                        NamedDescriptor referee = jndiRef.getReferee();
                        this._setJndiName(referee, (String)value);
                        break;
                    }
                    ((CMPJndiRef)obj).setJndiName((String)value);
                }
            }
        }

        private String _getJndiName(NamedDescriptor ref) {
            String jndiName = ref.getJndiName();
            if (jndiName == null && ref instanceof EjbReferenceDescriptor) {
                jndiName = EjbRefsInspector.getEjbReferenceJndiName((EjbReferenceDescriptor)ref);
            }
            return jndiName;
        }

        private void _setJndiName(NamedDescriptor ref, String value) {
            if (ref instanceof EjbReferenceDescriptor) {
                ref = EjbRefsInspector.convertEjbReference((EjbReferenceDescriptor)ref);
                ref.setJndiName(value);
            } else {
                ref.setJndiName(value);
            }
            if (ref instanceof Descriptor) {
                ((Descriptor)((Object)ref)).changed();
            }
            if (JndiNameInspector.this.descriptor != null) {
                JndiNameInspector.this.descriptor.changed();
            }
        }
    }

    private class ReferenceJndiTable
    extends InspectorTable {
        public ReferenceJndiTable(TableModel model) {
            super(model);
            this.setToolTipText(REF_TABLE_TOOLTIP);
            this.setSelectionMode(0);
        }
    }

    public class ComponentJndiTableModel
    extends InspectorTableModel {
        public ComponentJndiTableModel() {
            super(new String[]{COMP_COL_COMP_TYPE, COMP_COL_COMPONENT, COMP_COL_JNDINAME});
        }

        public boolean isCellEditable(int row, int col) {
            return col == 2;
        }

        public Object getObjectValue(Object obj, int col) {
            NamedReferencePair jndiRef = (NamedReferencePair)obj;
            NamedDescriptor referee = jndiRef.getReferee();
            Descriptor referant = jndiRef.getReferant();
            String value = "<???>";
            switch (col) {
                case 0: {
                    value = JndiNameInspector.getRefereeTypeName(jndiRef);
                    break;
                }
                case 1: {
                    value = referee.getName();
                    break;
                }
                case 2: {
                    value = referee.getJndiName();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            NamedReferencePair jndiRef = (NamedReferencePair)obj;
            NamedDescriptor referee = jndiRef.getReferee();
            switch (col) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    referee.setJndiName((String)value);
                    if (referee instanceof Descriptor) {
                        ((Descriptor)((Object)referee)).changed();
                    }
                    if (JndiNameInspector.this.descriptor == null) break;
                    JndiNameInspector.this.descriptor.changed();
                }
            }
        }
    }

    private class ComponentJndiTable
    extends InspectorTable {
        public ComponentJndiTable(TableModel model) {
            super(model);
            this.setToolTipText(COMP_TABLE_TOOLTIP);
            this.setSelectionMode(0);
        }

        public void updateTableData(Vector v2, boolean showTypeColumn) {
            super.updateTableData(v2);
            super.setColumnHidden(0, !showTypeColumn);
        }
    }

    private class CMPJndiRef {
        private EjbBundleDescriptor ejbd = null;
        private ResourceReferenceDescriptor rrd = null;

        public CMPJndiRef(EjbBundleDescriptor ejbd, ResourceReferenceDescriptor rrd) {
            this.ejbd = ejbd;
            this.rrd = rrd;
        }

        public String getRefType() {
            return REFTYPE_RESOURCE;
        }

        public String getRefBy() {
            return this.ejbd.getName() + "[CMP]";
        }

        public String getRefName() {
            return "";
        }

        public String getJndiName() {
            return this.rrd.getJndiName();
        }

        public void setJndiName(String jndiName) {
            this.rrd.setJndiName(jndiName);
        }
    }
}

