/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.tools.deployment.ui.UIUtils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public abstract class InspectorTableModel
extends AbstractTableModel {
    public static final int ORDERING_DEFAULT = 0;
    public static final int ORDERING_SORTED = 1;
    public static final int ORDERING_ORIGINAL = 2;
    private int maxColUneditable = 0;
    protected int maximumEditableRowIndex;
    protected Object[] columnNames = null;
    private boolean compareWithEquals = false;
    private int dataOrder = 0;
    private Comparator sortCompare = null;
    private boolean dataMayContainDuplicates = true;
    private List data = Collections.synchronizedList(new ArrayList());
    static /* synthetic */ Class class$java$lang$String;

    protected InspectorTableModel() {
    }

    public InspectorTableModel(String[] columnNames) {
        this.setColumnNames(columnNames);
        this.maximumEditableRowIndex = this.getData().size() - 1;
    }

    public InspectorTableModel(String[] columnNames, int maxColUneditable) {
        this.setColumnNames(columnNames);
        this.maxColUneditable = maxColUneditable;
    }

    public InspectorTableModel(List data, String[] columnNames) {
        this.getData().addAll(data);
        this.setColumnNames(columnNames);
        this.maximumEditableRowIndex = this.getData().size() - 1;
    }

    public InspectorTableModel(ArrayList data, String[] columnNames) {
        this.getData().addAll(data);
        this.setColumnNames(columnNames);
        this.maximumEditableRowIndex = this.getData().size() - 1;
    }

    public InspectorTableModel(List data, String[] columnNames, int maxColUneditable) {
        this.getData().addAll(data);
        this.setColumnNames(columnNames);
        this.maxColUneditable = maxColUneditable;
    }

    public InspectorTableModel(ArrayList data, String[] columnNames, int maxColUneditable) {
        this.getData().addAll(data);
        this.setColumnNames(columnNames);
        this.maxColUneditable = maxColUneditable;
    }

    public List getData() {
        if (this.data == null) {
            this.setData(null);
        }
        return this.data;
    }

    public void setData(List data) {
        this.data = data == null ? Collections.synchronizedList(new ArrayList()) : Collections.synchronizedList(data);
    }

    public void setColumnNames(Object[] columnNames) {
        this.columnNames = columnNames;
    }

    public void setColumnNames(Vector columnNames) {
        this.columnNames = columnNames.toArray();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int col) {
        return this.columnNames[col].toString();
    }

    public boolean isValidColumn(int column) {
        return column >= 0 && column < this.columnNames.length;
    }

    public Class getColumnClass(int c10) {
        Object value = this.getValueAt(0, c10);
        if (value == null) {
            UIUtils.debugPrintln("InspectorTableModel.getColumnClass", "Value at <0," + c10 + "> is null! " + "[rowCount = " + this.getRowCount() + "]");
            return class$java$lang$String == null ? (class$java$lang$String = InspectorTableModel.class$("java.lang.String")) : class$java$lang$String;
        }
        return value.getClass();
    }

    public void setMaximumEditableRowIndex(int maximumEditableRowIndex) {
        this.maximumEditableRowIndex = maximumEditableRowIndex;
    }

    public int getMaximumEditableRowIndex() {
        return this.maximumEditableRowIndex;
    }

    public int getRowCount() {
        return this.getData().size();
    }

    public Object getRowObject(int row) {
        return this.isValidRow(row) ? this.getData().get(row) : null;
    }

    public int getObjectIndex(Object obj) {
        if (this.dataMayContainDuplicates) {
            List data = this.getData();
            int size = data.size();
            int ndx = size - 1;
            while (ndx >= 0) {
                if (obj == data.get(ndx)) break;
                --ndx;
            }
            return ndx;
        }
        return this.getData().indexOf(obj);
    }

    public Object getRowWithValue(int startRow, int col, Object value) {
        return this.getRowObject(this.findRowWithValue(startRow, col, value));
    }

    public Object getRowWithValue(int col, Object value) {
        return this.getRowObject(this.findRowWithValue(-1, col, value));
    }

    public int findRowWithValue(int col, Object value) {
        return this.findRowWithValue(-1, col, value);
    }

    public int findRowWithValue(int startRow, int col, Object value) {
        int row = startRow <= 0 ? 0 : startRow;
        int rowCnt = this.getRowCount();
        while (row < rowCnt) {
            Object objVal = this.getValueAt(row, col);
            if (objVal.equals(value)) {
                return row;
            }
            ++row;
        }
        return -1;
    }

    public boolean isValidRow(int row) {
        return row >= 0 && row < this.getRowCount();
    }

    public boolean isCellEditable(int row, int col) {
        return col >= this.maxColUneditable && row <= this.maximumEditableRowIndex;
    }

    public Object getValueAt(int row, int col) {
        Object obj = this.getRowObject(row);
        return obj != null ? this.getObjectValue(obj, col) : null;
    }

    public abstract Object getObjectValue(Object var1, int var2);

    public void setValueAt(Object value, int row, int col) {
        if (value != null) {
            Object obj = this.getRowObject(row);
            if (obj != null) {
                this.setObjectValue(obj, col, value);
                this.fireTableCellUpdated(row, col);
            }
        } else {
            UIUtils.printImplementationError("InspectorTableModel.setValueAt", "Attempting to set a 'null' value!");
        }
    }

    public abstract void setObjectValue(Object var1, int var2, Object var3);

    public InspectorDataWrapper wrapDataItem(Object obj) {
        return obj instanceof InspectorDataWrapper ? (InspectorDataWrapper)obj : new InspectorDataWrapper(obj);
    }

    public InspectorDataWrapper wrapDataItem(Object[] obj) {
        return new InspectorDataWrapper(obj);
    }

    public Vector wrapData(Collection objSet) {
        Vector<InspectorDataWrapper> v2 = new Vector<InspectorDataWrapper>();
        Iterator i2 = objSet.iterator();
        while (i2.hasNext()) {
            v2.add(this.wrapDataItem(i2.next()));
        }
        return v2;
    }

    public Vector wrapData(Enumeration objEnum) {
        Vector<InspectorDataWrapper> v2 = new Vector<InspectorDataWrapper>();
        while (objEnum.hasMoreElements()) {
            v2.add(this.wrapDataItem(objEnum.nextElement()));
        }
        return v2;
    }

    public int getDataOrdering() {
        return this.dataOrder;
    }

    public void setDataOrdering(int order) {
        if (this.dataOrder == order) {
            return;
        }
        this.dataOrder = order;
        if (this.dataOrder == 1) {
            this.sortCompare = this.createSortComparator();
            Collections.sort(this.getData(), this.sortCompare);
        } else {
            this.sortCompare = null;
        }
    }

    public boolean isOriginalDataOrdering() {
        return this.dataOrder == 2;
    }

    public boolean isSortedDataOrdering() {
        return this.dataOrder == 1;
    }

    public void _updateTableData(Collection c10) {
        if (c10 == null || this.isOriginalDataOrdering()) {
            try {
                this.getData().clear();
            }
            catch (UnsupportedOperationException uso) {
                // empty catch block
            }
        }
        Iterator i2 = this.getData().iterator();
        while (i2.hasNext()) {
            if (c10 != null && !this.isOriginalDataOrdering() && this._listContainsObject(c10, i2.next())) continue;
            i2.remove();
        }
        if (c10 != null) {
            Iterator i3 = c10.iterator();
            while (i3.hasNext()) {
                this.addRowObject(i3.next());
            }
        }
        this.maximumEditableRowIndex = this.getData().size() - 1;
        if (this.maximumEditableRowIndex < 0 || this.isOriginalDataOrdering()) {
            this.fireTableDataChanged();
        } else {
            this.fireTableRowsInserted(0, this.maximumEditableRowIndex);
        }
    }

    public void _updateTableData(Set s2) {
        this._updateTableData((Collection)s2);
    }

    public void _updateTableData(Enumeration e10) {
        ArrayList c10 = null;
        if (e10 != null) {
            c10 = new ArrayList();
            while (e10.hasMoreElements()) {
                c10.add(e10.nextElement());
            }
        }
        this._updateTableData(c10);
    }

    public void addRowObject(Object obj) {
        if (!this._listContainsObject(this.getData(), obj)) {
            if (this.sortCompare != null) {
                int loc = Collections.binarySearch(this.getData(), obj, this.sortCompare);
                if (loc < 0) {
                    this.getData().add(-(loc + 1), obj);
                } else {
                    UIUtils.debugPrintln("Replacing object at " + loc);
                    this.getData().remove(loc);
                    this.getData().add(loc, obj);
                }
            } else {
                this.getData().add(obj);
            }
        }
    }

    public int replaceRowObject(Object obj, Object newObj) {
        List data = this.getData();
        int size = data.size();
        int i2 = 0;
        while (i2 < size) {
            if (obj == data.get(i2)) {
                data.set(i2, newObj);
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    private boolean _listContainsObject(Collection data, Object item) {
        Object itemRef = item instanceof InspectorDataWrapper ? ((InspectorDataWrapper)item).getObject() : item;
        boolean checkEquals = this.compareWithEquals ? true : itemRef instanceof String;
        Iterator i2 = data.iterator();
        while (i2.hasNext()) {
            Object nextItemRef;
            Object nextItem = i2.next();
            Object object = nextItemRef = nextItem instanceof InspectorDataWrapper ? ((InspectorDataWrapper)nextItem).getObject() : nextItem;
            if (nextItemRef == itemRef) {
                return true;
            }
            if (!checkEquals || !nextItemRef.equals(itemRef)) continue;
            return true;
        }
        return false;
    }

    public void setCompareWithEquals(boolean state) {
        this.compareWithEquals = state;
    }

    protected Comparator createSortComparator() {
        return new StringSortComparator();
    }

    public String validatePrimitiveValue(String type, String value) {
        String v2;
        String string = v2 = value != null ? value : "";
        if (type == null || type.equals("java.lang.String")) {
            return v2;
        }
        if (type.equals("java.lang.Character")) {
            String cval = v2.length() > 0 ? v2.substring(0, 1) : " ";
            return cval;
        }
        Class<?> tc = null;
        try {
            tc = Class.forName(type);
        }
        catch (Throwable t2) {
            UIUtils.debugImplementationError("Invalid type: " + type);
            return "";
        }
        Constructor<?> c10 = null;
        try {
            c10 = tc.getConstructor(class$java$lang$String == null ? (class$java$lang$String = InspectorTableModel.class$("java.lang.String")) : class$java$lang$String);
        }
        catch (Throwable t3) {
            UIUtils.debugPrintln("No constructor: " + type + "(String)");
        }
        String newValue = null;
        if (c10 != null) {
            try {
                newValue = c10.newInstance(v2).toString();
            }
            catch (Throwable t4) {
                UIUtils.debugPrintln("Can't instantiate: " + type + "(\"" + v2 + "\")");
            }
        }
        if (newValue == null) {
            try {
                newValue = tc.newInstance().toString();
            }
            catch (Throwable t5) {
                UIUtils.debugPrintln("Can't instantiate: " + type + "()");
            }
        }
        return newValue != null ? newValue : "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class StringSortComparator
    implements Comparator {
        public int compare(Object r1, Object r2) {
            Object c22;
            Object c12 = InspectorTableModel.this.getObjectValue(r1, 0);
            if (c12 == (c22 = InspectorTableModel.this.getObjectValue(r2, 0))) {
                return 0;
            }
            if (c12 == null) {
                return -1;
            }
            if (c22 == null) {
                return 1;
            }
            return this.compareStrings(c12.toString(), c22.toString());
        }

        private int compareStrings(String s1, String s2) {
            if (s1.equals(s2)) {
                return 0;
            }
            if (s1.equals("")) {
                return 1;
            }
            if (s2.equals("")) {
                return -1;
            }
            return s1.compareTo(s2);
        }
    }

    public static class InspectorDataWrapper {
        private Object DefaultNullValue = null;
        private Object[] items = null;

        public InspectorDataWrapper() {
        }

        public void setDefaultNullValue(Object val) {
            this.DefaultNullValue = val;
        }

        public InspectorDataWrapper(Object[] obj) {
            this();
            this.setObject(obj);
        }

        public void setObject(Object[] obj) {
            Object[] objectArray;
            if (obj != null && obj.length > 0) {
                objectArray = obj;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = null;
            }
            this.items = objectArray;
        }

        public Object setObject(int index, Object obj) {
            if (this.items == null) {
                this.items = new Object[index + 1];
            } else if (index >= this.items.length) {
                Object[] newItems = new Object[index + 1];
                System.arraycopy(this.items, 0, newItems, 0, this.items.length);
                this.items = newItems;
            }
            this.items[index] = obj;
            return obj;
        }

        public Object getObject(int index, Object dftValue) {
            Object v2 = this.items != null && this.items.length > index ? this.items[index] : dftValue;
            return v2 != null ? v2 : this.DefaultNullValue;
        }

        public Object getObject(int index) {
            return this.getObject(index, null);
        }

        public InspectorDataWrapper(Object obj) {
            this();
            if (obj instanceof Object[]) {
                this.setObject((Object[])obj);
            } else {
                this.setObject(obj);
            }
        }

        public Object setObject(Object obj) {
            return this.setObject(0, obj);
        }

        public Object getObject(Object dftValue) {
            return this.getObject(0, dftValue);
        }

        public Object getObject() {
            return this.getObject(0);
        }

        public boolean equals(Object obj) {
            Object v2 = this.getObject();
            return v2 != null ? v2.equals(obj) : false;
        }

        public String toString() {
            Object v2 = this.getObject();
            return v2 != null ? v2.toString() : "";
        }
    }
}

