/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class InspectorTable
extends JTable
implements DescriptionInspector.UpdateListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$InspectorTable == null ? (class$com$sun$enterprise$tools$deployment$ui$InspectorTable = InspectorTable.class$("com.sun.enterprise.tools.deployment.ui.InspectorTable")) : class$com$sun$enterprise$tools$deployment$ui$InspectorTable);
    private int descriptionColumn = -1;
    private DescriptionInspector.UpdateListener descUpdateListener = null;
    private boolean handleDescriptionUpdates = false;
    private boolean superDidInitialize = true;
    private boolean isCustomModelSet = false;
    private JTextField tableTextEditor = null;
    private int selectRowOnUpdate_Column = -1;
    private Object selectRowOnUpdate_Value = null;
    private boolean enableHorizontalScrolling = false;
    private boolean _did_setupInspectorTable = false;
    private boolean _did_setupDescriptionColumn = false;
    private Vector updaterList = null;
    private int editMethod = -1;
    private int editingStopped_recursion = 0;
    private InspectorCellRenderer[] delegateRenderers = null;
    public boolean settingSelection = false;
    private static final String JAVA_LANG = "java.lang.";
    private static final String[] primitiveType = new String[]{"java.lang.String", "java.lang.Character", "java.lang.Boolean", "java.lang.Byte", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double"};
    private TableCellEditor[] primitiveEditor = new TableCellEditor[primitiveType.length];
    private TableCellEditor primitiveTypeEditor = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$InspectorTable;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;

    public InspectorTable() {
        this.isCustomModelSet = false;
        this._setupInspectorTable();
    }

    public InspectorTable(TableModel model) {
        super(model);
        this.isCustomModelSet = true;
        this._setupInspectorTable();
    }

    public InspectorTable(TableModel model, boolean horizonalScroll) {
        this.setHorizontalScrollingEnabled(horizonalScroll);
        this.setModel(model);
        this._setupInspectorTable();
    }

    private void _setupInspectorTable() {
        if (this._did_setupInspectorTable) {
            return;
        }
        this._did_setupInspectorTable = true;
        this.tableTextEditor = new JTextField();
        this.tableTextEditor.setCursor(Cursor.getPredefinedCursor(2));
        DefaultCellEditor tableEditor = new DefaultCellEditor(this.tableTextEditor);
        this.setDefaultEditor(class$java$lang$Object == null ? (class$java$lang$Object = InspectorTable.class$("java.lang.Object")) : class$java$lang$Object, tableEditor);
        this.setDefaultEditor(class$java$lang$Integer == null ? (class$java$lang$Integer = InspectorTable.class$("java.lang.Integer")) : class$java$lang$Integer, this.getIntegerEditor(5));
        this.setCellSelectionEnabled(true);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                InspectorTable.this._processMouseClicked(me);
            }
        });
        this._setupDescriptionColumn();
    }

    private void _setupDescriptionColumn() {
        if (this.isCustomModelSet && !this._did_setupDescriptionColumn) {
            TableModel model = this.getModel();
            int colLen = model.getColumnCount();
            if (colLen > 0 && model.getColumnName(colLen - 1).equals(DescriptionInspector.DESCRIPTION_COLUMN_INIT)) {
                this.setDescriptionColumn(colLen - 1);
            }
            this._did_setupDescriptionColumn = true;
        }
    }

    public InspectorTableModel getInspectorTableModel() {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            return (InspectorTableModel)model;
        }
        InspectorTable._printDataModelError();
        return null;
    }

    public boolean isHorizonalScrollingEnabled() {
        return this.enableHorizontalScrolling;
    }

    public void setHorizontalScrollingEnabled(boolean enable) {
        this.enableHorizontalScrolling = enable;
    }

    public int getColumnIndexWithTitle(String title) {
        return this.getColumnModel().getColumnIndex(title);
    }

    public TableColumn getColumn(int n2, boolean realColumn) {
        return n2 >= 0 && n2 < this.getColumnCount() ? this.getInspectorColumnModel().getColumn(n2, realColumn) : null;
    }

    public TableColumn getColumn(int n2) {
        return n2 >= 0 && n2 < this.getColumnCount() ? this.getColumnModel().getColumn(n2) : null;
    }

    public void setColumnHidden(String title, boolean hide) {
        int n2 = this.getColumnIndexWithTitle(title);
        if (n2 < 0) {
            UIUtils.debugImplementationError("Title not found in table: " + title);
            return;
        }
        this.setColumnHidden(n2, hide);
    }

    public void setColumnHidden(int n2, boolean hide) {
        this.getInspectorColumnModel().setColumnHidden(n2, hide);
    }

    public boolean isColumnHidden(String title) {
        int n2 = this.getColumnIndexWithTitle(title);
        if (n2 < 0) {
            UIUtils.debugImplementationError("Title not found in table: " + title);
            return true;
        }
        return this.isColumnHidden(n2);
    }

    public boolean isColumnHidden(int n2) {
        return this.getInspectorColumnModel().isColumnHidden(n2);
    }

    protected TableColumnModel createDefaultColumnModel() {
        return new InspectorTableColumnModel();
    }

    public InspectorTableColumnModel getInspectorColumnModel() {
        TableColumnModel tcm = super.getColumnModel();
        if (tcm instanceof InspectorTableColumnModel) {
            return (InspectorTableColumnModel)tcm;
        }
        UIUtils.printImplementationError("ColumnModel is not 'InspectorTableColumnModel'");
        return null;
    }

    protected JTableHeader createDefaultTableHeader() {
        return new InspectorTableHeader(this.columnModel);
    }

    public void setAutoResizeMode(int mode) {
        super.setAutoResizeMode(mode);
    }

    private DescriptionInspector getDescriptionInspector() {
        return DescriptionInspector.findDescriptionInspector(this);
    }

    public int getDescriptionColumn() {
        return this.descriptionColumn;
    }

    public void setDescriptionColumn(int column) {
        if (this.descriptionColumn == column) {
            return;
        }
        if (column < 0) {
            UIUtils.debugImplementationError("Invalid description column");
        }
        this.descriptionColumn = column;
        DescriptionInspector.setDescriptionColumnForTable(this, column);
        this.descUpdateListener = new DescriptionInspector.UpdateListener(){

            public void descriptionUpdated(String description, Object ref) {
                if (InspectorTable.this.handleDescriptionUpdates) {
                    InspectorTableModel model = (InspectorTableModel)InspectorTable.this.getModel();
                    model.setObjectValue(ref, InspectorTable.this.descriptionColumn, description);
                } else if (ref != null && ref instanceof Descriptor) {
                    ((Descriptor)ref).setDescription(description);
                } else {
                    UIUtils.debugImplementationError("Description not updated");
                }
            }
        };
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e10) {
                if (!e10.getValueIsAdjusting() && InspectorTable.this.handleDescriptionUpdates) {
                    InspectorTable.this.showSelectedDescription();
                }
            }
        });
    }

    public void setDescriptionInspector(String description, String refName, DescriptionInspector.UpdateListener listener, Object refObject) {
        DescriptionInspector din;
        if (this.updaterList == null || !this.updaterList.contains(listener)) {
            this.updaterList = new Vector();
            this.updaterList.add(this);
            this.updaterList.add(listener);
        }
        if ((din = this.getDescriptionInspector()) != null) {
            din.setDescription(description, refName, this.updaterList, refObject);
        }
    }

    public void clearDescriptionInspector() {
        DescriptionInspector din = this.getDescriptionInspector();
        if (din != null) {
            din.clearDescription();
        }
    }

    public void descriptionUpdated(String description, Object refObject) {
        TableModel model = this.getModel();
        if (model instanceof AbstractTableModel) {
            ((AbstractTableModel)model).fireTableCellUpdated(this.getSelectedRow(), this.descriptionColumn);
        }
    }

    public void showSelectedDescription() {
        if (!this.handleDescriptionUpdates) {
            return;
        }
        Object ref = this.getSelectedRowObject();
        if (ref != null) {
            if (this.descUpdateListener != null) {
                String name = this.getObjectValue(ref, 0).toString();
                String desc = (String)this.getObjectValue(ref, this.descriptionColumn);
                this.setDescriptionInspector(desc, name, this.descUpdateListener, ref);
            } else {
                UIUtils.debugPrintln("'descUpdateListener' was never initialized!");
            }
        } else {
            this.clearDescriptionInspector();
        }
    }

    public void setHandleDescriptionUpdates(boolean state) {
        this.handleDescriptionUpdates = state;
    }

    public Object getValueAt(int row, int col) {
        Object obj = null;
        if (this.isValidIndex(row, col)) {
            obj = this.descriptionColumn == col ? super.getValueAt(row, col) : super.getValueAt(row, col);
        } else {
            UIUtils.debugPrintln("Table Rows = " + this.getRowCount());
            UIUtils.debugPrintln("Model Rows = " + this.getModel().getRowCount());
            UIUtils.debugImplementationError("Row/Column out of range [" + row + "/" + col + "]");
        }
        return obj;
    }

    public void processKeyEvent(KeyEvent ke) {
        JTextComponent c10;
        TableCellEditor editor;
        super.processKeyEvent(ke);
        if (this.editMethod == 0) {
            Component t2;
            TableCellEditor tce;
            int col;
            if (this.isEditing()) {
                return;
            }
            if (ke.isActionKey() || ke.getID() != 400 || ke.getKeyChar() < ' ') {
                return;
            }
            int row = this.getSelectedRow();
            if (this.isValidIndex(row, col = this.getSelectedColumn()) && (tce = this.getCellEditor(row, col)) instanceof DefaultCellEditor && (t2 = ((DefaultCellEditor)tce).getComponent()) instanceof JTextComponent) {
                UIUtils.debugPrintln("Editing cell at " + row + "/" + col + " [(int)char=" + ke.getKeyChar() + "]");
                this.editCellAt(row, col);
            }
        } else if (this.editMethod == 1 && (editor = this.getCellEditor()) instanceof DefaultCellEditor && ((DefaultCellEditor)editor).getComponent() instanceof JTextComponent && !(c10 = (JTextComponent)((DefaultCellEditor)editor).getComponent()).getCaret().isVisible()) {
            c10.getCaret().setVisible(true);
        }
    }

    private void _processMouseClicked(MouseEvent me) {
        int col;
        int row;
        if (me.getClickCount() == 2 && !this.isEditing() && this.isValidIndex(row = this.getSelectedRow(), col = this.getSelectedColumn())) {
            this.editCellAt(row, col);
        }
    }

    public boolean editCellAt(int row, int col) {
        return super.editCellAt(row, col);
    }

    public void valueChanged(ListSelectionEvent lse) {
        super.valueChanged(lse);
    }

    public void editingStopped(ChangeEvent e10) {
        JComboBox cb2;
        ComboBoxEditor cbe;
        Component comp;
        Component c10;
        if (this.editingStopped_recursion > 0) {
            return;
        }
        ++this.editingStopped_recursion;
        TableCellEditor tce = this.getCellEditor();
        if (tce instanceof DefaultCellEditor && (c10 = ((DefaultCellEditor)tce).getComponent()) instanceof JComboBox && ((JComboBox)c10).isEditable() && (comp = (cbe = (cb2 = (JComboBox)c10).getEditor()).getEditorComponent()) instanceof JTextField) {
            String selTxt;
            String text = ((JTextField)comp).getText();
            Object selObj = cb2.getSelectedItem();
            String string = selTxt = selObj != null ? selObj.toString() : "";
            if (!text.equals(selTxt)) {
                ActionEvent ae2 = new ActionEvent(comp, 1001, "");
                cb2.actionPerformed(ae2);
            }
        }
        super.editingStopped(e10);
        --this.editingStopped_recursion;
    }

    public boolean isValidIndex(int row, int col) {
        return row >= 0 && col >= 0 && row < this.getRowCount() && col < this.getColumnCount();
    }

    public void setValueAt(Object value, int row, int column) {
        if (this.isValidIndex(row, column)) {
            if (value != null) {
                super.setValueAt(value, row, column);
            } else {
                UIUtils.debugPrintln("Attempting to set a 'null' value!");
            }
        } else {
            UIUtils.debugPrintln("Row/Column out of range (" + row + "/" + column + ") " + "[size = " + this.getRowCount() + "/" + this.getColumnCount() + "] " + this.getClass().getName());
        }
    }

    public void setModel(TableModel model) {
        super.setModel(model);
        if (!this.superDidInitialize) {
            return;
        }
        this.isCustomModelSet = true;
        this._setupDescriptionColumn();
        int dataModelCnt = model.getColumnCount();
        int thisModelCnt = this.getColumnCount();
        if (dataModelCnt != thisModelCnt) {
            UIUtils.debugPrintln("Column count mismatch: " + dataModelCnt + " != " + thisModelCnt);
        }
        if (this.enableHorizontalScrolling) {
            this.setAutoResizeMode(0);
        } else {
            this.setAutoResizeMode(4);
            this.sizeColumnsToFit(0);
        }
    }

    public void createDefaultColumnsFromModel() {
        if (this.isEditing()) {
            return;
        }
        TableModel dm2 = this.getModel();
        TableColumnModel cm2 = this.getColumnModel();
        if (dm2 != null && cm2 != null && cm2.getColumnCount() != dm2.getColumnCount()) {
            super.createDefaultColumnsFromModel();
        }
    }

    public TableCellRenderer getCellRenderer(int r2, int c10) {
        if (this.delegateRenderers == null) {
            this.delegateRenderers = new InspectorCellRenderer[this.getColumnCount()];
        } else if (this.delegateRenderers.length < this.getColumnCount()) {
            InspectorCellRenderer[] newList = new InspectorCellRenderer[this.getColumnCount()];
            System.arraycopy(this.delegateRenderers, 0, newList, 0, this.delegateRenderers.length);
            this.delegateRenderers = newList;
        }
        TableCellRenderer renderer = super.getCellRenderer(r2, c10);
        if (renderer instanceof InspectorCellRenderer) {
            return renderer;
        }
        if (this.delegateRenderers[c10] == null) {
            this.delegateRenderers[c10] = new InspectorCellRenderer();
        }
        this.delegateRenderers[c10].setDelegate(renderer != null ? renderer : this.getDefaultRenderer(this.getColumnClass(c10)));
        return this.delegateRenderers[c10];
    }

    private void _installInspectorCellRenderers() {
        TableModel model = this.getModel();
        int cnt = model.getColumnCount();
        int col = 0;
        while (col < cnt) {
            if (!model.isCellEditable(0, col)) {
                TableColumn tc = this.getColumn(col, true);
                TableCellRenderer renderer = tc.getCellRenderer();
                if (renderer == null) {
                    renderer = this.getDefaultRenderer(this.getColumnClass(col));
                }
                if (!(renderer instanceof InspectorCellRenderer)) {
                    InspectorCellRenderer icr = new InspectorCellRenderer(renderer);
                    tc.setCellRenderer(icr);
                }
            }
            ++col;
        }
    }

    public void setEnabled(boolean state) {
        super.setEnabled(state);
    }

    public List getTableData() {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            return ((InspectorTableModel)model).getData();
        }
        InspectorTable._printDataModelError();
        return null;
    }

    public void clearTableData() {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            this.clearSelection();
            ((InspectorTableModel)model)._updateTableData((Collection)null);
        } else {
            InspectorTable._printDataModelError();
        }
    }

    public void updateTableData(Collection c10) {
        this._updateTableData(c10);
    }

    public void updateTableData(Set s2) {
        this._updateTableData(s2);
    }

    public void updateTableData(Enumeration e10) {
        this._updateTableData(e10);
    }

    private void _updateTableData(Object s2) {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            int minSel = -1;
            int maxSel = -1;
            Object refSel = null;
            if (this.selectRowOnUpdate_Column < 0) {
                if (this.isSingleSelection()) {
                    refSel = this.getSelectedRowObject();
                } else {
                    minSel = this.getMinSelectionIndex();
                    maxSel = this.getMaxSelectionIndex();
                }
            }
            if (s2 instanceof Collection) {
                ((InspectorTableModel)model)._updateTableData((Collection)s2);
            } else if (s2 instanceof Enumeration) {
                ((InspectorTableModel)model)._updateTableData((Enumeration)s2);
            } else {
                UIUtils.printImplementationError("Unsupported data type - " + s2.getClass().getName());
            }
            if (this.selectRowOnUpdate_Column >= 0) {
                this.selectRowWithValue(this.selectRowOnUpdate_Column, this.selectRowOnUpdate_Value);
                this.selectRowOnUpdate_Column = -1;
                this.selectRowOnUpdate_Value = null;
            } else if (refSel != null && this.getObjectIndex(refSel) >= 0) {
                this.setSelectedRowObject(refSel);
            } else {
                this.setSelectionInterval(minSel, maxSel);
            }
            if (this.handleDescriptionUpdates) {
                this.showSelectedDescription();
            }
        } else {
            InspectorTable._printDataModelError();
        }
    }

    public void addRowObject(Object obj) {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            ((InspectorTableModel)model).addRowObject(obj);
        } else {
            InspectorTable._printDataModelError();
        }
    }

    public boolean isSettingSelection() {
        return this.settingSelection;
    }

    public boolean isSingleSelection() {
        return this.getSelectionModel().getSelectionMode() == 0;
    }

    public int getSelectedRow() {
        return super.getSelectedRow();
    }

    public Object getSelectedRowObject() {
        return this.getRowObject(this.getSelectedRow());
    }

    public int getMinSelectionIndex() {
        return this.getSelectionModel().getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.getSelectionModel().getMaxSelectionIndex();
    }

    public void clearSelection() {
        this.settingSelection = true;
        this.getSelectionModel().clearSelection();
        this.settingSelection = false;
    }

    public ListSelectionModel getColumnSelectionModel() {
        return this.getColumnModel().getSelectionModel();
    }

    public void setSelectionInterval(int minSel, int maxSel) {
        int lastRow;
        if (maxSel < minSel) {
            maxSel = minSel;
        }
        if (minSel < 0) {
            this.clearSelection();
            return;
        }
        TableModel model = this.getModel();
        int n2 = lastRow = model instanceof InspectorTableModel ? ((InspectorTableModel)model).getMaximumEditableRowIndex() : this.getRowCount() - 1;
        if (lastRow < 0) {
            this.clearSelection();
        } else {
            if (minSel > lastRow) {
                minSel = lastRow;
            }
            if (maxSel > lastRow) {
                maxSel = lastRow;
            }
            this.settingSelection = true;
            this.getSelectionModel().setSelectionInterval(minSel, maxSel);
            this.settingSelection = false;
        }
    }

    public void setSelectedIndex(int ndx) {
        this.setSelectionInterval(ndx, ndx);
    }

    public void setSelectedRowObject(Object ref) {
        int ndx = this.getObjectIndex(ref);
        if (ref != null && ndx < 0) {
            UIUtils.debugPrintln("Specified object not found in table: " + ref);
        }
        this.setSelectionInterval(ndx, ndx);
    }

    public void selectRowWithValue(int column, Object value) {
        int ndx = this.findRowWithValue(column, value);
        this.setSelectedIndex(ndx);
    }

    public void selectBlankRow(int column) {
        this.selectRowWithValue(column, "");
    }

    public void selectRowWithValueOnUpdate(int column, Object value) {
        this.selectRowOnUpdate_Column = column;
        this.selectRowOnUpdate_Value = value;
    }

    public Object[] confirmDeleteSelection(String msg, String title) {
        Object ref = this.getSelectedRowObject();
        if (ref != null) {
            String optTitle;
            String optMsg = msg == null ? localStrings.getLocalString("ui.inspectortable.confirm_delete_selection", "Are you sure you want to delete the selected row(s)?\n {0}", new Object[]{this.getObjectValue(ref, 0)}) : msg;
            String string = optTitle = title == null ? localStrings.getLocalString("ui.inspectortable.delete_selection", "Delete Selection") : title;
            if (UIOptionPane.showConfirmDialog((Component)this, optMsg, optTitle)) {
                return new Object[]{ref};
            }
        } else {
            UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.inspectortable.first_select_item", "You must first select an item from the list"));
        }
        return null;
    }

    public Object getRowObject(int row) {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            return ((InspectorTableModel)model).getRowObject(row);
        }
        InspectorTable._printDataModelError();
        return null;
    }

    public int getObjectIndex(Object obj) {
        if (obj != null) {
            TableModel model = this.getModel();
            if (model instanceof InspectorTableModel) {
                return ((InspectorTableModel)model).getObjectIndex(obj);
            }
            InspectorTable._printDataModelError();
        }
        return -1;
    }

    public int findRowWithValue(int col, Object value) {
        return this.findRowWithValue(-1, col, value);
    }

    public int findRowWithValue(int startRow, int col, Object value) {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            return ((InspectorTableModel)model).findRowWithValue(startRow, col, value);
        }
        InspectorTable._printDataModelError();
        return -1;
    }

    public Object getRowWithValue(int col, Object value) {
        return this.getRowWithValue(-1, col, value);
    }

    public Object getRowWithValue(int startRow, int col, Object value) {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            return ((InspectorTableModel)model).getRowWithValue(startRow, col, value);
        }
        InspectorTable._printDataModelError();
        return null;
    }

    public Object getObjectValue(Object obj, int col) {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            return ((InspectorTableModel)model).getObjectValue(obj, col);
        }
        InspectorTable._printDataModelError();
        return null;
    }

    public void setObjectValue(Object obj, int col, Object value) {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            ((InspectorTableModel)model).setObjectValue(obj, col, value);
            return;
        }
        InspectorTable._printDataModelError();
    }

    public InspectorTableModel.InspectorDataWrapper wrapDataItem(Object obj) {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            return ((InspectorTableModel)model).wrapDataItem(obj);
        }
        InspectorTable._printDataModelError();
        return new InspectorTableModel.InspectorDataWrapper();
    }

    public InspectorTableModel.InspectorDataWrapper wrapDataItem(Object[] obj) {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            return ((InspectorTableModel)model).wrapDataItem(obj);
        }
        InspectorTable._printDataModelError();
        return new InspectorTableModel.InspectorDataWrapper();
    }

    public Vector wrapData(Collection objSet) {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            return ((InspectorTableModel)model).wrapData(objSet);
        }
        InspectorTable._printDataModelError();
        return new Vector();
    }

    public Vector wrapData(Enumeration objEnum) {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            return ((InspectorTableModel)model).wrapData(objEnum);
        }
        InspectorTable._printDataModelError();
        return new Vector();
    }

    private static void _printDataModelError() {
        UIUtils.printImplementationError("getModel() is not an instance of InspectorTableModel");
    }

    public void tableChanged(TableModelEvent e10) {
        super.tableChanged(e10);
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        return super.prepareRenderer(renderer, row, column);
    }

    public TableComboBoxEditor getComboBoxEditor(Object[] items) {
        return new TableComboBoxEditor(items);
    }

    public TableComboBoxEditor getComboBoxEditor(Vector items) {
        return new TableComboBoxEditor(items);
    }

    public TableComboBoxEditor getComboBoxEditor(ComboBoxModel cbm) {
        return new TableComboBoxEditor(cbm);
    }

    public TableCellEditor getIntegerEditor(int width) {
        return new NumericCellEditor(new NumericEditorField(true, width));
    }

    public TableCellEditor getDecimalEditor(int width) {
        return new NumericCellEditor(new NumericEditorField(false, width));
    }

    public TableCellEditor getCharacterEditor(int width) {
        return new CharacterCellEditor(new CharacterEditorField(width));
    }

    private static int getPrimitiveTypeIndex(String type) {
        int i2 = 0;
        while (i2 < primitiveType.length) {
            if (primitiveType[i2].equals(type)) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public String[] getPrimitiveTypes() {
        return primitiveType;
    }

    public String getPrimitiveTypeName(String type) {
        return type.startsWith(JAVA_LANG) ? type.substring(JAVA_LANG.length()) : type;
    }

    public TableCellEditor getPrimitiveTypesEditor() {
        if (this.primitiveTypeEditor == null) {
            Object[] list = new String[primitiveType.length];
            int i2 = 0;
            while (i2 < primitiveType.length) {
                list[i2] = this.getPrimitiveTypeName(primitiveType[i2]);
                ++i2;
            }
            this.primitiveTypeEditor = this.getComboBoxEditor(list);
        }
        return this.primitiveTypeEditor;
    }

    public TableCellEditor getPrimitiveValueEditor(Class type) {
        return this.getPrimitiveValueEditor(type.getName());
    }

    public TableCellEditor getPrimitiveValueEditor(String type) {
        int ndx = InspectorTable.getPrimitiveTypeIndex(type);
        if (ndx < 0) {
            UIUtils.debugPrintln("Unsupported type: " + type);
            return super.getDefaultEditor(class$java$lang$Object == null ? (class$java$lang$Object = InspectorTable.class$("java.lang.Object")) : class$java$lang$Object);
        }
        if (this.primitiveEditor[ndx] == null) {
            TableCellEditor dce = null;
            switch (ndx) {
                case 0: {
                    dce = super.getDefaultEditor(class$java$lang$String == null ? (class$java$lang$String = InspectorTable.class$("java.lang.String")) : class$java$lang$String);
                    break;
                }
                case 1: {
                    dce = this.getCharacterEditor(1);
                    break;
                }
                case 2: {
                    dce = this.getComboBoxEditor(new String[]{"false", "true"});
                    break;
                }
                case 3: {
                    dce = this.getIntegerEditor(3);
                    break;
                }
                case 4: {
                    dce = this.getIntegerEditor(5);
                    break;
                }
                case 5: {
                    dce = this.getIntegerEditor(5);
                    break;
                }
                case 6: {
                    dce = this.getIntegerEditor(10);
                    break;
                }
                case 7: {
                    dce = this.getDecimalEditor(16);
                    break;
                }
                case 8: {
                    dce = this.getDecimalEditor(16);
                }
            }
            this.primitiveEditor[ndx] = dce;
        }
        return this.primitiveEditor[ndx];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class CharacterEditorField
    extends JTextField {
        public CharacterEditorField(int width) {
            super(width);
            this.setText("");
        }

        public char getCharacterValue() {
            String value = this.getText().trim();
            return value.length() > 0 ? value.charAt(0) : (char)' ';
        }

        protected Document createDefaultModel() {
            return new CharacterDocument();
        }

        protected class CharacterDocument
        extends PlainDocument {
            protected CharacterDocument() {
            }

            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                super.remove(0, this.getLength());
                String c10 = str.length() > 0 ? str.substring(0, 1) : " ";
                super.insertString(0, c10, a);
            }
        }
    }

    protected class CharacterCellEditor
    extends DefaultCellEditor {
        CharacterEditorField field = null;

        public CharacterCellEditor(CharacterEditorField field) {
            super(field);
            this.field = field;
        }

        public Object getCellEditorValue() {
            Character c10 = new Character(this.field.getCharacterValue());
            return c10;
        }
    }

    protected class NumericEditorField
    extends JTextField {
        private Toolkit toolkit = null;
        private NumberFormat formatter = null;
        private boolean allowsDecimal = false;

        public NumericEditorField(boolean intOnly, int width) {
            super(width);
            this.allowsDecimal = !intOnly;
            this.toolkit = Toolkit.getDefaultToolkit();
            this.formatter = NumberFormat.getNumberInstance();
            this.formatter.setParseIntegerOnly(intOnly);
            if (intOnly) {
                this.setValue(0);
            } else {
                this.setValue(0.0);
            }
        }

        public boolean getAllowsDecimal() {
            return this.allowsDecimal;
        }

        public long getLongValue() {
            long retVal = 0L;
            try {
                retVal = this.formatter.parse(this.getText()).longValue();
            }
            catch (ParseException e10) {
                this.toolkit.beep();
            }
            return retVal;
        }

        public double getDoubleValue() {
            double retVal = 0.0;
            try {
                retVal = this.formatter.parse(this.getText()).doubleValue();
            }
            catch (ParseException e10) {
                this.toolkit.beep();
            }
            return retVal;
        }

        public void setValue(int value) {
            this.setText(this.formatter.format(value));
        }

        public void setValue(double value) {
            this.setText(this.formatter.format(value));
        }

        protected Document createDefaultModel() {
            return new NumericDocument();
        }

        protected class NumericDocument
        extends PlainDocument {
            protected NumericDocument() {
            }

            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                char[] s2 = str.toCharArray();
                char[] r2 = new char[s2.length];
                int j2 = 0;
                int i2 = 0;
                while (i2 < r2.length) {
                    if (Character.isDigit(s2[i2]) || s2[i2] == '-') {
                        r2[j2++] = s2[i2];
                    } else if (NumericEditorField.this.getAllowsDecimal() && (s2[i2] == '.' || s2[i2] == 'E')) {
                        r2[j2++] = s2[i2];
                    } else {
                        NumericEditorField.this.toolkit.beep();
                    }
                    ++i2;
                }
                super.insertString(offs, new String(r2, 0, j2), a);
            }
        }
    }

    protected class NumericCellEditor
    extends DefaultCellEditor {
        NumericEditorField field = null;

        public NumericCellEditor(NumericEditorField field) {
            super(field);
            this.field = field;
        }

        public Object getCellEditorValue() {
            return this.field.getAllowsDecimal() ? (Number)new Double(this.field.getDoubleValue()) : (Number)new Long(this.field.getLongValue());
        }
    }

    public class TableComboBoxEditor
    extends DefaultCellEditor {
        public TableComboBoxEditor() {
            super(new JComboBox());
        }

        public TableComboBoxEditor(Vector items) {
            super(new JComboBox(items));
        }

        public TableComboBoxEditor(Object[] items) {
            super(new JComboBox<Object>(items));
        }

        public TableComboBoxEditor(ComboBoxModel cbm) {
            super(new JComboBox(cbm));
        }

        public JComboBox getComboBox() {
            return (JComboBox)this.getComponent();
        }

        public void setSelectedItem(Object obj) {
            this.getComboBox().setSelectedItem(obj);
        }

        public void setModel(Vector list) {
            this.getComboBox().setModel(new DefaultComboBoxModel(list));
        }

        public void setModel(Object[] items) {
            this.getComboBox().setModel(new DefaultComboBoxModel<Object>(items));
        }

        public void setModel(ComboBoxModel cbm) {
            this.getComboBox().setModel(cbm);
        }
    }

    public class TableIconCellRenderer
    implements TableCellRenderer {
        private JLabel iconLabel = new JLabel();
        private Hashtable iconKeys = null;

        public TableIconCellRenderer() {
            this.setIconKeys(new Object[0][]);
        }

        public TableIconCellRenderer(Hashtable iconKeys) {
            this.setIconKeys(iconKeys);
        }

        public TableIconCellRenderer(Object[][] iconKeys) {
            this.setIconKeys(iconKeys);
        }

        public void setIconKeys(Hashtable iconKeys) {
            this.iconKeys = iconKeys;
        }

        public void setIconKeys(Object[][] iconKeys) {
            this.iconKeys = new Hashtable();
            int i2 = 0;
            while (i2 < iconKeys.length) {
                this.iconKeys.put(iconKeys[i2][0], iconKeys[i2][1]);
                ++i2;
            }
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object obj;
            this.iconLabel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            if (value == null) {
                value = "";
            }
            if ((obj = this.iconKeys.get(value)) == null) {
                this.iconLabel.setIcon(null);
                this.iconLabel.setText(value.toString());
            } else if (obj instanceof Icon) {
                this.iconLabel.setIcon((Icon)obj);
                this.iconLabel.setText(null);
            } else {
                this.iconLabel.setIcon(null);
                this.iconLabel.setText(obj.toString());
            }
            return this.iconLabel;
        }
    }

    public class InspectorCellRenderer
    implements TableCellRenderer {
        private TableCellRenderer delegate = null;

        public InspectorCellRenderer(TableCellRenderer renderer) {
            this.setDelegate(renderer);
        }

        public InspectorCellRenderer() {
            this(new DefaultTableCellRenderer());
        }

        public void setDelegate(TableCellRenderer renderer) {
            this.delegate = renderer;
        }

        public TableCellRenderer getDelegate() {
            return this.delegate;
        }

        public Component getTableCellRendererComponent(JTable tbl, Object val, boolean isSel, boolean focus, int r2, int c10) {
            Component renderer = this.delegate.getTableCellRendererComponent(tbl, val, isSel, focus, r2, c10);
            if (renderer instanceof JComponent) {
                JComponent comp = (JComponent)renderer;
                if (isSel) {
                    comp.setBackground(tbl.getSelectionBackground());
                    comp.setOpaque(true);
                } else {
                    comp.setBackground(tbl.getModel().isCellEditable(r2, c10) ? UITitledBox.EnabledBackgroundColor : UITitledBox.DisabledBackgroundColor);
                    comp.setOpaque(true);
                }
            } else {
                UIUtils.debugPrintln("Not a JComponent: " + renderer.getClass().getName());
            }
            return renderer;
        }
    }

    private class InspectorTableHeader
    extends JTableHeader {
        public InspectorTableHeader() {
            this(null);
            this.setReorderingAllowed(false);
        }

        public InspectorTableHeader(TableColumnModel cm2) {
            super(cm2);
            this.setReorderingAllowed(false);
        }

        public String getToolTipText(MouseEvent me) {
            Object v2;
            String tip = null;
            int c10 = this.columnModel.getColumnIndexAtX(me.getPoint().x);
            if (c10 >= 0 && c10 != InspectorTable.this.getDescriptionColumn() && (v2 = this.columnModel.getColumn(c10).getHeaderValue()) instanceof String) {
                tip = (String)v2;
            }
            return tip != null ? tip : super.getToolTipText(me);
        }
    }

    private class HiddenTableColumn
    extends TableColumn {
        private TableColumn realColumn = null;

        public HiddenTableColumn(TableColumn tc) {
            super(tc.getModelIndex(), 0);
            this.setMinWidth(0);
            this.setMaxWidth(0);
            this.setResizable(false);
            this.realColumn = tc;
        }

        public TableColumn getRealColumn() {
            return this.realColumn;
        }
    }

    private class InspectorTableColumnModel
    extends DefaultTableColumnModel {
        private Hashtable hiddenColumns = new Hashtable();

        public void setColumnHidden(int tcNdx, boolean hide) {
            TableColumn tc = InspectorTable.this.getColumn(tcNdx, true);
            if (tc != null) {
                if (!hide) {
                    this.hiddenColumns.remove(tc);
                } else if (!this.hiddenColumns.containsKey(tc)) {
                    this.hiddenColumns.put(tc, new HiddenTableColumn(tc));
                }
                this.totalColumnWidth = -1;
                this.fireColumnMarginChanged();
            }
        }

        public boolean isColumnHidden(int n2) {
            TableColumn tc = this.getColumn(n2, false);
            return tc != null ? tc instanceof HiddenTableColumn : true;
        }

        public TableColumn getColumn(int ndx) {
            return this.getColumn(ndx, false);
        }

        public TableColumn getColumn(int ndx, boolean realColumn) {
            TableColumn tc = super.getColumn(ndx);
            if (realColumn) {
                return tc;
            }
            Object htc = this.hiddenColumns.get(tc);
            return htc != null ? (TableColumn)htc : tc;
        }

        public Enumeration getColumns() {
            Enumeration<TableColumn> enumeration = super.getColumns();
            if (!this.hiddenColumns.isEmpty()) {
                Vector v2 = new Vector();
                while (enumeration.hasMoreElements()) {
                    TableColumn tc = enumeration.nextElement();
                    Object htc = this.hiddenColumns.get(tc);
                    v2.add(htc != null ? htc : tc);
                }
                enumeration = v2.elements();
            }
            return enumeration;
        }
    }
}

