/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.tools.deployment.main.ApplicationManager;
import com.sun.enterprise.tools.deployment.main.ServerManager;
import com.sun.enterprise.tools.deployment.main.StandAloneManager;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.DescriptorInspector;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.Wizard;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;

public abstract class InspectorPane
extends JPanel
implements DescriptorInspector {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$InspectorPane == null ? (class$com$sun$enterprise$tools$deployment$ui$InspectorPane = InspectorPane.class$("com.sun.enterprise.tools.deployment.ui.InspectorPane")) : class$com$sun$enterprise$tools$deployment$ui$InspectorPane);
    private static final String defaultMode = "DeploymentMode";
    private String mode = null;
    private InspectorPaneOwner inspectorOwner = null;
    protected static final String LARGE_ICON = "large";
    protected static final String SMALL_ICON = "small";
    private static String DEFAULT_HELP_GROUP = "XX";
    private Vector dialogButtonList = null;
    private Vector updaterList = null;
    private DescriptionInspector.UpdateListener buttonUpdateListener = null;
    private boolean firstRefresh = false;
    private int refreshCount = 0;
    private Runnable _doRefresh = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$InspectorPane;

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        throw new UnsupportedOperationException("This class doesn't implement the static method 'newInspectorPane(String,Object)'");
    }

    public void setOwner(InspectorPaneOwner owner) {
        this.inspectorOwner = owner;
    }

    public InspectorPaneOwner getOwner() {
        if (this.inspectorOwner == null) {
            UIUtils.debugPrintln("Unknown owner for " + UIUtils.debugClassName(this.getClass()));
        }
        return this.inspectorOwner;
    }

    public Vector getArchiveContents() {
        InspectorPaneOwner owner = this.getOwner();
        return owner != null ? owner.getArchiveContents() : null;
    }

    public Descriptor getBundleDescriptor() {
        InspectorPaneOwner owner = this.getOwner();
        if (owner instanceof DescriptorInspector) {
            return ((DescriptorInspector)((Object)owner)).getDescriptor();
        }
        UIUtils.printImplementationError("Owner doesn't implement 'DescriptorInspector' - " + owner.getClass().getName());
        return null;
    }

    public Vector getArchiveClasses() {
        InspectorPaneOwner owner = this.getOwner();
        return owner != null ? owner.getArchiveClasses() : null;
    }

    public Vector getArchiveClassNames() {
        return this._cvtClassToName(this.getArchiveClasses());
    }

    public Vector getArchiveClasses(Class[] classTypes) {
        Vector classList = this.getArchiveClasses();
        if (classList == null) {
            return null;
        }
        Vector<Class> impClasses = new Vector<Class>();
        Enumeration e10 = classList.elements();
        block0: while (e10.hasMoreElements()) {
            Class c10 = (Class)e10.nextElement();
            int i2 = 0;
            while (i2 < classTypes.length) {
                if (classTypes[i2].isAssignableFrom(c10)) {
                    impClasses.add(c10);
                    continue block0;
                }
                ++i2;
            }
        }
        return impClasses;
    }

    public Vector getArchiveClassNames(Class[] classTypes) {
        return this._cvtClassToName(this.getArchiveClasses(classTypes));
    }

    private Vector _cvtClassToName(Vector classObj) {
        Vector<String> classNam = null;
        if (classObj != null) {
            classNam = new Vector<String>();
            Enumeration e10 = classObj.elements();
            while (e10.hasMoreElements()) {
                classNam.add(((Class)e10.nextElement()).getName());
            }
        }
        return classNam;
    }

    public abstract Class getDescriptorClass();

    public abstract Descriptor getDescriptor();

    public abstract void setDescriptor(Descriptor var1);

    public void resetRefresh() {
        this.firstRefresh = true;
    }

    public boolean isFirstRefresh() {
        return this.firstRefresh;
    }

    public String getIconInspectorName() {
        Descriptor desc = this.getDescriptor();
        return desc != null ? desc.getName() : "";
    }

    public String getLargeIconUri() {
        Descriptor desc = this.getDescriptor();
        return desc != null ? desc.getLargeIconUri() : "";
    }

    public File getLargeIconUriFile() {
        String name = this.getLargeIconUri();
        return name != null ? new File(name) : null;
    }

    public String getSmallIconUri() {
        Descriptor desc = this.getDescriptor();
        return desc != null ? desc.getSmallIconUri() : "";
    }

    public File getSmallIconUriFile() {
        String name = this.getSmallIconUri();
        return name != null ? new File(name) : null;
    }

    protected void _addWizardIcon(String iconType, File iconFile, FileContentsDescriptor contentsMap, Descriptor desc) {
        String fileName;
        if (iconType == null || !iconType.equals(SMALL_ICON) && !iconType.equals(LARGE_ICON)) {
            UIUtils.printImplementationError("Invalid icon type specified: " + iconType);
            return;
        }
        String string = fileName = iconType.equals(SMALL_ICON) ? desc.getSmallIconUri() : desc.getLargeIconUri();
        if (!fileName.equals("")) {
            File file = new File(fileName);
            File nameFile = new File(file.getName());
            contentsMap.removeFile(nameFile);
        }
        String iconFileName = null;
        if (iconFile != null) {
            File absoluteIconFile = new File(iconFile.getAbsolutePath());
            contentsMap.add(new File(absoluteIconFile.getName()), absoluteIconFile.getParentFile());
            iconFileName = absoluteIconFile.getPath();
        }
        if (iconType.equals(SMALL_ICON)) {
            desc.setSmallIconUri(iconFileName);
        } else {
            desc.setLargeIconUri(iconFileName);
        }
    }

    protected void _addDeploymentIcon(String iconType, File iconFile, ApplicationArchivist archivist, BundleDescriptor bundleDesc, Descriptor desc) {
        if (iconType == null || !iconType.equals(SMALL_ICON) && !iconType.equals(LARGE_ICON)) {
            UIUtils.printImplementationError("Invalid icon type specified: " + iconType);
            return;
        }
        try {
            if (bundleDesc == null) {
                InspectorPane._setDescriptorIcon(archivist.getDescriptor(), archivist, iconFile, iconType);
            } else {
                InspectorPane._setDescriptorIcon(desc, bundleDesc.getArchivist(), iconFile, iconType);
            }
        }
        catch (Throwable t2) {
            UIUtils.printException("Adding Icons", t2);
            UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.inspectorpane.cant_add_icon", "Icon could not be added/removed.\n {0}", new Object[]{t2.getMessage()}));
        }
    }

    private static void _setDescriptorIcon(Descriptor desc, Archivist archivist, File iconFile, String iconType) throws Exception {
        boolean small = iconType.equals(SMALL_ICON);
        String iconName = null;
        if (iconFile != null) {
            iconName = iconFile.getName();
            Hashtable<String, File> ht = new Hashtable<String, File>();
            ht.put(iconName, iconFile);
            archivist.addFiles(ht);
        }
        if (small) {
            desc.setSmallIconUri(iconName != null ? iconName : "");
        } else {
            desc.setLargeIconUri(iconName != null ? iconName : "");
        }
    }

    public void _checkForRemovedIcons(Object[] removed) {
        Descriptor desc = this.getDescriptor();
        File smallFile = this.getSmallIconUriFile();
        File largeFile = this.getLargeIconUriFile();
        if (removed != null && (smallFile != null || largeFile != null)) {
            int i2 = 0;
            while (i2 < removed.length) {
                if (removed[i2] instanceof File) {
                    File file = (File)removed[i2];
                    if (smallFile != null && smallFile.getName().equals(file.getName())) {
                        desc.setSmallIconUri(null);
                        smallFile = null;
                    }
                    if (largeFile != null && largeFile.getName().equals(file.getName())) {
                        desc.setLargeIconUri(null);
                        largeFile = null;
                    }
                    if (smallFile == null && largeFile == null) break;
                }
                ++i2;
            }
        }
    }

    public boolean validateEntries() {
        return true;
    }

    public abstract String getTabName();

    public abstract String getHelpID();

    public String getHelpGroup() {
        String hg = this.getOwner().getHelpGroup();
        return hg != null ? hg : DEFAULT_HELP_GROUP;
    }

    public String getHelpIDKey() {
        String helpKey = null;
        String id = this.getHelpID();
        if (id != null && this.getOwner() != null) {
            String hg = this.getOwner().getHelpGroup();
            helpKey = (hg != null ? hg : DEFAULT_HELP_GROUP) + id;
        }
        return helpKey;
    }

    public String[] getWizardDescription() {
        return null;
    }

    public void setInspectorMode(String m2) {
        this.mode = m2 != null ? m2 : defaultMode;
    }

    public String getInspectorMode() {
        if (this.mode == null) {
            this.mode = this.getOwner() instanceof Wizard ? "WizardMode" : defaultMode;
            UIUtils.debugPrintln(UIUtils.debugClassName(this.getClass()) + " => " + this.mode);
        }
        return this.mode;
    }

    public boolean isDeploymentMode() {
        return this.getInspectorMode().equals(defaultMode);
    }

    public boolean isDevelopmentMode() {
        return this.isWizardMode();
    }

    public boolean isWizardMode() {
        return this.getInspectorMode().equals("WizardMode");
    }

    protected static ServerManager getServerManager() {
        return DT.getServerManager();
    }

    protected static ApplicationManager getApplicationManager() {
        return DT.getApplicationManager();
    }

    protected static StandAloneManager getStandAloneManager() {
        return DT.getStandAloneManager();
    }

    protected static String getCurrentApplicationName() {
        ApplicationManager am2 = DT.getApplicationManager();
        Application appDescriptor = am2.getActiveApplication();
        return appDescriptor == null ? "" : appDescriptor.getName();
    }

    protected String getApplicationName() {
        return InspectorPane.getCurrentApplicationName();
    }

    private DescriptionInspector getDescriptionInspector() {
        return DescriptionInspector.findDescriptionInspector(this);
    }

    public void _setDescriptionInspector(String description, String refName, DescriptionInspector.UpdateListener listener, Object refObject) {
        DescriptionInspector din;
        if (this.buttonUpdateListener == null) {
            this.buttonUpdateListener = new DescriptionInspector.UpdateListener(){

                public void descriptionUpdated(String d10, Object refObject) {
                    if (InspectorPane.this.dialogButtonList != null) {
                        boolean hd = d10 != null && !d10.equals("");
                        Enumeration enumeration = InspectorPane.this.dialogButtonList.elements();
                        while (enumeration.hasMoreElements()) {
                            ((DescriptionInspector.DialogDisplayButton)enumeration.nextElement()).setHasDescription(hd);
                        }
                    }
                }
            };
        }
        if (this.updaterList == null || !this.updaterList.contains(listener)) {
            this.updaterList = new Vector();
            this.updaterList.add(listener);
            this.updaterList.add(this.buttonUpdateListener);
        }
        if ((din = this.getDescriptionInspector()) != null) {
            din.setDescription(description, refName, this.updaterList, refObject);
        }
        this.buttonUpdateListener.descriptionUpdated(description, null);
    }

    public void _clearDescriptionInspector() {
        DescriptionInspector din = this.getDescriptionInspector();
        if (din != null) {
            din.clearDescription();
        }
    }

    public void _showDescriptionInspector() {
        DescriptionInspector din = this.getDescriptionInspector();
        if (din != null) {
            din.showDescriptionInspector();
        }
    }

    public void addDescriptionButtonUpdate(DescriptionInspector.DialogDisplayButton button) {
        if (this.dialogButtonList == null) {
            this.dialogButtonList = new Vector();
        }
        this.dialogButtonList.add(button);
    }

    protected abstract void refresh();

    public void invokeRefresh() {
        if (this.inspectorOwner == null) {
            UIUtils.debugImplementationError("Forwarding directly to 'refresh()'");
            this.refresh();
            this.firstRefresh = false;
            return;
        }
        if (!this.isCurrentInspectorPane()) {
            UIUtils.debugImplementationError("invokeRefresh() called on non-visible inspector: " + this.getClass().getName());
            return;
        }
        if (this.refreshCount == 0) {
            if (this._doRefresh == null) {
                this._doRefresh = new Runnable(){

                    public void run() {
                        InspectorPane.this._refresh();
                        InspectorPane.this.refreshCount = 0;
                    }
                };
            }
            ++this.refreshCount;
            EventQueue.invokeLater(this._doRefresh);
        } else {
            ++this.refreshCount;
        }
    }

    private void _refresh() {
        if (!this.isCurrentInspectorPane()) {
            UIUtils.debugImplementationError("_refresh() invoked on non-visible inspector: " + this.getClass().getName());
            return;
        }
        this.refresh();
        this.firstRefresh = false;
    }

    public boolean isCurrentInspectorPane() {
        InspectorPaneOwner owner = this.getOwner();
        return owner != null && owner.isCurrentInspectorPane(this);
    }

    protected void _clearTables(Container container) {
        Component[] c10 = container.getComponents();
        int i2 = 0;
        while (i2 < c10.length) {
            JTable table;
            if (c10[i2] instanceof UITitledTable && (table = ((UITitledTable)c10[i2]).getTableView()) instanceof InspectorTable) {
                ((InspectorTable)table).clearTableData();
            }
            if (c10[i2] instanceof Container) {
                this._clearTables((Container)c10[i2]);
            }
            ++i2;
        }
    }

    public Window getMyParentWindow() {
        return UIUtils.getAncestorWindow(this);
    }

    public Frame getMyParentFrame() {
        return UIUtils.getAncestorFrame(this);
    }

    public Dialog getMyParentDialog() {
        return UIUtils.getAncestorDialog(this);
    }

    public InspectorPaneDialog createInspectorPaneDialog(InspectorPaneOwner inspOwner, Component winOwner, boolean modal) {
        if (winOwner == null && inspOwner instanceof Component) {
            winOwner = (Component)((Object)inspOwner);
        }
        if (winOwner == null) {
            UIUtils.printImplementationError("Window owner not specified");
        } else if (this.getParent() != null) {
            UIUtils.printImplementationError("This InspectorPane is already part of another container");
        } else {
            Window win = UIUtils.getAncestorWindow(winOwner);
            InspectorPaneDialog ipd = this._createInspectorPaneDialog(win, inspOwner, modal);
            if (ipd != null) {
                return ipd;
            }
            UIUtils.printImplementationError("Could not find an ancestor Frame/Dialog");
        }
        return null;
    }

    protected InspectorPaneDialog _createInspectorPaneDialog(Window win, InspectorPaneOwner inspOwner, boolean modal) {
        if (win instanceof Frame) {
            return new InspectorPaneDialog((Frame)win, inspOwner, modal);
        }
        if (win instanceof Dialog) {
            return new InspectorPaneDialog((Dialog)win, inspOwner, modal);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface InspectorPaneOwner {
        public Vector getArchiveContents();

        public Vector getArchiveClasses();

        public String getHelpGroup();

        public boolean isCurrentInspectorPane(InspectorPane var1);
    }

    public class InspectorPaneDialog
    extends UIDialog
    implements InspectorPaneOwner,
    DescriptionInspector.DescriptionInspectorManager,
    ActionListener {
        private InspectorPaneOwner delegateOwner = null;
        private JButton okButton = null;
        private JButton cancelButton = null;
        private DescriptionInspector descriptionInspector = null;

        public InspectorPaneDialog(Frame frame, InspectorPaneOwner owner, boolean isModal) {
            super(frame, isModal);
            this.delegateOwner = owner;
            InspectorPane.this.setOwner(this);
            this._init();
        }

        public InspectorPaneDialog(Dialog dialog, InspectorPaneOwner owner, boolean isModal) {
            super(dialog, isModal);
            this.delegateOwner = owner;
            InspectorPane.this.setOwner(this);
            this._init();
        }

        public void _init() {
            this.descriptionInspector = new DescriptionInspector(this);
            UITitledControlButtonBox content = new UITitledControlButtonBox(null, false);
            this.setContentPane(content);
            content.setControlButtonLocation(101);
            content.setView(InspectorPane.this);
            this.okButton = UIButton.createOkButton(this);
            content.addControlButton(this.okButton);
            this.cancelButton = UIButton.createCancelButton(this);
            content.addControlButton(this.cancelButton);
            this.setCancelEnabled(false);
            UIHelpButton hb = new UIHelpButton(InspectorPane.this.getHelpIDKey());
            content.addControlButton(hb);
        }

        public void setLocationRelativeTo(Component comp) {
            if (comp instanceof InspectorPane) {
                Rectangle b10 = comp.getBounds();
                Point sl = comp.getLocationOnScreen();
                ((Component)this).setBounds(sl.x + 10, sl.y + 10, b10.width, b10.height);
            } else {
                super.setLocationRelativeTo(comp);
            }
        }

        public void setDescriptor(Descriptor d10) {
            InspectorPane.this.setDescriptor(d10);
        }

        public void setCancelEnabled(boolean enable) {
            this.cancelButton.setVisible(enable);
        }

        public void actionPerformed(ActionEvent ae2) {
            JButton btn = (JButton)ae2.getSource();
            if (btn == this.okButton) {
                this.okAction();
            } else if (this.cancelButton != null && btn == this.cancelButton) {
                this.cancelAction();
            }
        }

        public void okAction() {
            this.hide();
        }

        public void cancelAction() {
            this.hide();
        }

        public DescriptionInspector getDescriptionInspector() {
            return this.descriptionInspector;
        }

        protected void _showDialog() {
            InspectorPane.this.refresh();
            InspectorPane.this.firstRefresh = false;
            super._showDialog();
        }

        public void setDelegateOwner(InspectorPaneOwner owner) {
            this.delegateOwner = owner;
        }

        public Vector getArchiveContents() {
            return this.delegateOwner != null ? this.delegateOwner.getArchiveContents() : null;
        }

        public Vector getArchiveClasses() {
            return this.delegateOwner != null ? this.delegateOwner.getArchiveClasses() : null;
        }

        public String getHelpGroup() {
            return this.delegateOwner != null ? this.delegateOwner.getHelpGroup() : "??";
        }

        public boolean isCurrentInspectorPane(InspectorPane pane) {
            return pane == InspectorPane.this;
        }
    }
}

