/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIComponentUpdateHandler;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIFileChooser;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class IconInspector {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$IconInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$IconInspector = IconInspector.class$("com.sun.enterprise.tools.deployment.ui.IconInspector")) : class$com$sun$enterprise$tools$deployment$ui$IconInspector);
    private static String SMALL_ICON = localStrings.getLocalString("ui.iconinspector.small_icon", "Small Icon (16x16)");
    private static String LARGE_ICON = localStrings.getLocalString("ui.iconinspector.large_icon", "Large Icon (32x32)");
    private static String ICON_INSPECTOR = localStrings.getLocalString("ui.iconinspector.icons", "Icons");
    private static String ICON_INSPECTOR_FOR = localStrings.getLocalString("ui.iconinspector.iconsfor", "Icons for");
    private static String CHOOSE_ICON = localStrings.getLocalString("ui.iconinspector.choose_icon", "Choose Icon");
    private static String ICON_BUTTON = localStrings.getLocalString("ui.iconinspector.icon_button", "Icons...");
    private static String HELP_ID = "Icons";
    private static InspectorPanel iconInspector = null;
    private static UITitledControlButtonBox iconInspectorContent = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$IconInspector;

    public static void showIconInspector(Component parent, UpdateListener iconUpdater) {
        Window window = UIUtils.getAncestorWindow(parent);
        if (window == null) {
            UIUtils.printImplementationError("IconInspector", "parent frame not found for component");
            return;
        }
        UIDialog iconDialog = UIDialog.newDialog(window, true);
        iconDialog.doNothingOnClose();
        iconDialog.setContentPane(IconInspector.getIconInspectorPane(iconUpdater));
        String name = iconUpdater.getIconInspectorName();
        iconDialog.setTitle(name == null || name.equals("") ? ICON_INSPECTOR : ICON_INSPECTOR_FOR + " " + name);
        Rectangle newBounds = window.getBounds();
        Dimension d10 = new Dimension(380, 205);
        newBounds.x += 20;
        newBounds.y += 20;
        newBounds.width = d10.width;
        newBounds.height = d10.height;
        ((Component)iconDialog).setBounds(newBounds);
        iconDialog.show();
    }

    private static JPanel getIconInspectorPane(UpdateListener iconUpdater) {
        if (iconInspector == null) {
            iconInspector = new InspectorPanel(null, true);
        }
        IconInspector.iconInspector.setUpdateListener(iconUpdater);
        if (iconInspectorContent != null) {
            return iconInspectorContent;
        }
        iconInspectorContent = new UITitledControlButtonBox(null, false);
        iconInspectorContent.setControlButtonLocation(15);
        iconInspectorContent.setControlButtonAnchor(13);
        iconInspectorContent.setView(iconInspector);
        UIButton ok_btn = UIButton.createOkButton(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                Component c10 = (Component)e10.getSource();
                iconInspector.updateIconsNow();
                ((Dialog)UIUtils.getAncestorWindow(c10)).dispose();
            }
        });
        iconInspectorContent.addControlButton(ok_btn);
        UIButton cancel_btn = UIButton.createCancelButton(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                Component c10 = (Component)e10.getSource();
                ((Dialog)UIUtils.getAncestorWindow(c10)).dispose();
            }
        });
        iconInspectorContent.addControlButton(cancel_btn);
        UIHelpButton help_btn = new UIHelpButton(HELP_ID);
        iconInspectorContent.addControlButton(help_btn);
        return iconInspectorContent;
    }

    private IconInspector() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class InspectorPanel
    extends UITitledBox {
        private UITitledTextField smallIconTextField;
        private UITitledTextField largeIconTextField;
        private UpdateListener iconUpdater = null;
        private boolean modalPanelMode = false;
        private String smallIconPath = null;
        private File smallIconFile = null;
        private String largeIconPath = null;
        private File largeIconFile = null;

        public InspectorPanel(UpdateListener iconUpdater) {
            this(iconUpdater, false);
        }

        public InspectorPanel(UpdateListener iconUpdater, boolean modalPanelMode) {
            super(ICON_INSPECTOR, true);
            this.modalPanelMode = modalPanelMode;
            this.smallIconTextField = new UITitledTextField(SMALL_ICON, false);
            this.smallIconTextField.addUpdateHandler(new UIComponentUpdateHandler(this){
                private final /* synthetic */ InspectorPanel this$0;
                {
                    this.this$0 = this$0;
                }

                public void updateComponent(JComponent c10) {
                    this.this$0.addSmallAction(InspectorPanel.access$600(this.this$0).getText());
                }
            });
            this.smallIconTextField.setBrowserActionListener(new ActionListener(this){
                private final /* synthetic */ InspectorPanel this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent ae2) {
                    this.this$0.addSmallAction(null);
                }
            });
            this.addWithGBConstraints(this.smallIconTextField);
            this.largeIconTextField = new UITitledTextField(LARGE_ICON, false);
            this.largeIconTextField.addUpdateHandler(new UIComponentUpdateHandler(this){
                private final /* synthetic */ InspectorPanel this$0;
                {
                    this.this$0 = this$0;
                }

                public void updateComponent(JComponent c10) {
                    this.this$0.addLargeAction(InspectorPanel.access$800(this.this$0).getText());
                }
            });
            this.largeIconTextField.setBrowserActionListener(new ActionListener(this){
                private final /* synthetic */ InspectorPanel this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent ae2) {
                    this.this$0.addLargeAction(null);
                }
            });
            this.addWithGBConstraints(this.largeIconTextField);
            this.setUpdateListener(iconUpdater);
        }

        protected GridBagConstraints getDefaultGBConstraints(GridBagConstraints c10) {
            c10 = super.getDefaultGBConstraints(c10);
            c10.weightx = 0.5;
            c10.weighty = 0.0;
            c10.insets = new Insets(0, 0, 5, 0);
            c10.fill = 2;
            c10.anchor = 10;
            return c10;
        }

        public void addSmallAction(String pathName) {
            if (pathName == null) {
                JFileChooser jfc = UIFileChooser.getFileChooser();
                int returnValue = jfc.showDialog(this, CHOOSE_ICON);
                if (returnValue != 0) {
                    return;
                }
                this.smallIconFile = jfc.getSelectedFile().getAbsoluteFile();
                if (this.modalPanelMode || this.iconUpdater == null) {
                    this.smallIconPath = this.smallIconFile.getPath();
                } else {
                    this.iconUpdater.addSmallIcon(this.smallIconFile);
                    this.smallIconPath = this.iconUpdater.getSmallIconUri();
                }
                this.smallIconTextField.setText(this.smallIconPath);
            } else if (!pathName.equals("")) {
                this.smallIconFile = new File(pathName);
                this.smallIconPath = this.smallIconFile.getPath();
            } else {
                this.smallIconFile = null;
                this.smallIconPath = null;
            }
        }

        public void addLargeAction(String pathName) {
            if (pathName == null) {
                JFileChooser jfc = UIFileChooser.getFileChooser();
                int returnValue = jfc.showDialog(this, CHOOSE_ICON);
                if (returnValue != 0) {
                    return;
                }
                this.largeIconFile = jfc.getSelectedFile().getAbsoluteFile();
                if (this.modalPanelMode || this.iconUpdater == null) {
                    this.largeIconPath = this.largeIconFile.getPath();
                } else {
                    this.iconUpdater.addLargeIcon(this.largeIconFile);
                    this.largeIconPath = this.iconUpdater.getLargeIconUri();
                }
                this.largeIconTextField.setText(this.largeIconPath);
            } else if (!pathName.equals("")) {
                this.largeIconFile = new File(pathName);
                this.largeIconPath = this.largeIconFile.getPath();
            } else {
                this.largeIconFile = null;
                this.largeIconPath = null;
            }
        }

        private void setUpdateListener(UpdateListener iconUpdater) {
            this.iconUpdater = iconUpdater;
            if (this.iconUpdater != null) {
                this.smallIconPath = this.iconUpdater.getSmallIconUri();
                this.largeIconPath = this.iconUpdater.getLargeIconUri();
            } else {
                this.smallIconPath = "";
                this.largeIconPath = "";
            }
            this.smallIconTextField.setText(this.smallIconPath);
            this.largeIconTextField.setText(this.largeIconPath);
        }

        private void updateIconsNow() {
            if (this.iconUpdater != null) {
                this.iconUpdater.addSmallIcon(this.smallIconFile);
                this.smallIconPath = this.iconUpdater.getSmallIconUri();
                this.iconUpdater.addLargeIcon(this.largeIconFile);
                this.largeIconPath = this.iconUpdater.getLargeIconUri();
            }
        }

        public void setDescriptor(Descriptor obj) {
            this.smallIconPath = this.iconUpdater.getSmallIconUri();
            this.smallIconTextField.setText(this.smallIconPath);
            this.largeIconPath = this.iconUpdater.getLargeIconUri();
            this.largeIconTextField.setText(this.largeIconPath);
        }

        static /* synthetic */ UITitledTextField access$600(InspectorPanel x0) {
            return x0.smallIconTextField;
        }

        static /* synthetic */ UITitledTextField access$800(InspectorPanel x0) {
            return x0.largeIconTextField;
        }
    }

    public static class DialogDisplayButton
    extends JButton
    implements ActionListener {
        private String titleName = null;
        private UpdateListener iconUpdater = null;

        public DialogDisplayButton(UpdateListener iconUpdater) {
            super(ICON_BUTTON);
            this.iconUpdater = iconUpdater;
            super.addActionListener(this);
        }

        public void setTitleName(String name) {
            this.titleName = name;
        }

        public void actionPerformed(ActionEvent ae2) {
            IconInspector.showIconInspector(this, this.iconUpdater);
        }
    }

    public static interface UpdateListener {
        public String getIconInspectorName();

        public String getLargeIconUri();

        public void addLargeIcon(File var1);

        public String getSmallIconUri();

        public void addSmallIcon(File var1);
    }
}

