/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ConnectorArchivist;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.Project;
import com.sun.enterprise.tools.deployment.backend.DeploymentSessionImpl;
import com.sun.enterprise.tools.deployment.backend.JarInstaller;
import com.sun.enterprise.tools.deployment.main.Log;
import com.sun.enterprise.tools.deployment.main.ProjectImpl;
import com.sun.enterprise.tools.deployment.main.ServerException;
import com.sun.enterprise.tools.deployment.ui.ApplicationWebContextInspector;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.DeployToolActions;
import com.sun.enterprise.tools.deployment.ui.DeployToolWindow;
import com.sun.enterprise.tools.deployment.ui.JndiNameInspector;
import com.sun.enterprise.tools.deployment.ui.TreeCombo;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.Wizard;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIFileChooser;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UIIcons;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIProgressBar;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledHTMLText;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DeploymentManager {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$DeploymentManager == null ? (class$com$sun$enterprise$tools$deployment$ui$DeploymentManager = DeploymentManager.class$("com.sun.enterprise.tools.deployment.ui.DeploymentManager")) : class$com$sun$enterprise$tools$deployment$ui$DeploymentManager);
    private static final String PREDEPLOY_INTRO = localStrings.getLocalString("ui.deploymentmanager.predeployment.introduction", "Introduction");
    private static final String READY_TO_DEPLOY = localStrings.getLocalString("ui.deploymentmanager.predeployment.ready_to_deploy", "Ready to deploy");
    private static final String SAVE_DEPLOY_LABEL = localStrings.getLocalString("ui.deploymentmanager.predeployment.save_deploy_label", "Finish");
    private static final String PREDEPLOY_JNDI_NAMES = localStrings.getLocalString("ui.deploymentmanager.predeployment.jndinames", "JNDI Names");
    private static final String PREDEPLOY_WAR_ROOT = localStrings.getLocalString("ui.deploymentmanager.predeployment.war_context_root", ".WAR Context Root");
    private static final String PREDEPLOY_REVIEW = localStrings.getLocalString("ui.deploymentmanager.predeployment.review", "Review");
    private static final String PLEASE_SELECT_SERVER = localStrings.getLocalString("ui.deploymentmanager.please_select_server", "Please select a server");
    private static final String PREDEPLOY_RETURN_JAR = localStrings.getLocalString("ui.deploymentmanager.predeployment.return_client_jar", "Return Client Jar");
    private static String PREDEPLOY_SELECT_SERVER = localStrings.getLocalString("ui.deploymentmanager.predeployment.select_server_help", "Please select the object to be deployed and the server to which it should be deployed:");
    private static final String PREDEPLOY_TARGET_SERVER = localStrings.getLocalString("ui.deploymentmanager.predeployment.target_server", "Target Server:");
    private static final String PREDEPLOY_DEPLOYED_OBJECTS = localStrings.getLocalString("ui.deploymentmanager.predeployment.deployed_object", "Object to Deploy:");
    private static final String PREDEPLOY_CJAR_HELP = localStrings.getLocalString("ui.deploymentmanager.predeployment.client_jar_help", "The server can send back a client JAR file. It contains the extra RMI/IIOP stub classes that client applications written to access this application will need at runtime.");
    private static final String PREDEPLOY_CHOOSE_FILE = localStrings.getLocalString("ui.deploymentmanager.predeployment.choose_file", "Choose File");
    private static final String PREDEPLOY_SAVE_ON_DEPLOY = localStrings.getLocalString("ui.deploymentmanager.predeployment.save_on_deploy", "Save object before deploying");
    private static String PREDEPLOY_CJAR_FILE = localStrings.getLocalString("ui.deploymentmanager.predeployment.client_jar_file", "Client JAR File Name:");
    private static final String PROGRESS_DIALOG_TITLE = localStrings.getLocalString("ui.deploymentmanager.progress.dialog_title", "Deployment Progress");
    private static final String PROGRESS_BOX_TITLE = localStrings.getLocalString("ui.deploymentmanager.progress.box_title", "Progress");
    private static final int NEVER_SAVE = 0;
    private static final int ALWAYS_SAVE = 1;
    private static final int CONFIRM_SAVE = 2;
    private static final int DEFAULT_SAVE_ON_DEPLOY = 2;
    private static int SaveOnDeploy = -1;
    private Frame frameOwner = null;
    private int saveOnDeploy = 2;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$DeploymentManager;

    private static String ERROR_SERVER_COMMUNICATION(String v0) {
        return localStrings.getLocalString("ui.deploymentmanager.error_server_communication", "There was an error communicating with {0}\nto establish whether this object was already deployed.\n Please refer to \n<J2EE_HOME>/logs/<machine-name>/j2ee/j2ee/error.log\n for more information. Please verify your Application with the Verifier tool.", new Object[]{v0});
    }

    private static String ERROR_SERVER_CONNECTION(String v0) {
        return localStrings.getLocalString("ui.deploymentmanager.error_server_connection", "There was a server connection error\n {0}.\n Please refer to \n<J2EE_HOME>/logs/<machine-name>/j2ee/j2ee/error.log\n for more information.", new Object[]{v0});
    }

    private static String ERROR_SERVER_DEPLOY(String v0) {
        return localStrings.getLocalString("ui.deploymentmanager.error_server_deploy", "There was a deployment error\n {0}.\n Please refer to \n<J2EE_HOME>/logs/<machine-name>/j2ee/j2ee/error.log\n for  more information. Please verify your Application with the Verifier tool.", new Object[]{v0});
    }

    private static String ERROR_SERVER_UNDEPLOY(String v0, String v1) {
        return localStrings.getLocalString("ui.deploymentmanager.error_server_undeploy", "Error uninstalling {0} from {1}.\n Please refer to \n<J2EE_HOME>/logs/<machine-name>/j2ee/j2ee/error.log\n for more information. Please verify your Application with the Verifier tool.", new Object[]{v0, v1});
    }

    private static String ERROR_SAVING(String v0, String v1) {
        return localStrings.getLocalString("ui.deploymentmanager.error_saving", "Error encountered while saving ''{0}''\n {1}.\n Please refer to \n<J2EE_HOME>/logs/<machine-name>/j2ee/j2ee/error.log\n for more information. Please verify your Application with the Verifier tool.", new Object[]{v0, v1});
    }

    private static String PLEASE_CONNECT_DEPLOY(String v0) {
        return localStrings.getLocalString("ui.deploymentmanager.deploy.connect_to_server", "Please connect to a server before deploying ''{0}''", new Object[]{v0});
    }

    private static String PLEASE_CONNECT_REDEPLOY(String v0) {
        return localStrings.getLocalString("ui.deploymentmanager.redeploy.connect_to_server", "Please connect to a server before redeploying ''{0}''", new Object[]{v0});
    }

    private static String APP_UPDATE_MESSAGE(String v0, String v1) {
        return localStrings.getLocalString("ui.deploymentmanager.app_updated_message", "The following entries in ''{0}'' were changed:\n  {1}\nPlease ensure the deployment descriptors are valid,\nthen save the application to update its EAR file.", new Object[]{v0, v1});
    }

    private static String ALL_UP_TO_DATE(String v0) {
        return localStrings.getLocalString("ui.deploymentmanager.all_up_to_date", "All entries are up to date for ''{0}''", new Object[]{v0});
    }

    private static String NO_PROJECT(String v0) {
        return localStrings.getLocalString("ui.deploymentmanager.no_project_info", "No project information available for ''{0}''", new Object[]{v0});
    }

    private static String UPDATE_FAILED(String v0, String v1) {
        return localStrings.getLocalString("ui.deploymentmanager.update_failed", "Update failed for ''{0}''\n  {1}.\nPlease refer to \n<J2EE_HOME>/logs/<machine-name>/j2ee/j2ee/error.log\n for more information. Please verify your Application with the Verifier tool.", new Object[]{v0, v1});
    }

    private static String PREDEPLOY_TITLE(String v0) {
        return localStrings.getLocalString("ui.deploymentmanager.predeployment.deploy_title", "Deploy {0}", new Object[]{v0});
    }

    private static String PREDEPLOY_HELP(String v0) {
        return localStrings.getLocalString("ui.deploymentmanager.predeployment.ready_deploy", "''{0}'' will be saved before it is deployed on the selected server.\n  Click ''Finish'' to deploy the object.\n", new Object[]{v0});
    }

    private static String RAR_DEPLOY_SUCCEEDED(String v0, String v1) {
        return localStrings.getLocalString("ui.deploymentmanager.connector.deployed_successfully", "Resource Adapter ''{0}'' was successfully deployed to server ''{1}''", new Object[]{v0, v1});
    }

    private static String CONFIRM_SAVE_OBJECT(String v0) {
        return localStrings.getLocalString("ui.deploymentmanager.confirm_save", "''{0}'' has been modified.  Do you wish to save prior to deployment?", new Object[]{v0});
    }

    public DeploymentManager(Frame owner) {
        this.frameOwner = owner;
        if (SaveOnDeploy == -1) {
            SaveOnDeploy = UIConfig.getConfigInteger("ui.deploy.saveOnDeploy", 2);
        }
        this.saveOnDeploy = SaveOnDeploy;
    }

    public void update(Descriptor desc, boolean interactive) {
        this.updateProjectFiles(desc, interactive);
    }

    private boolean saveIfDirty(Descriptor desc) {
        boolean okToSave;
        int saveMode = this.saveOnDeploy;
        boolean isDirty = true;
        isDirty = desc instanceof Application ? ((Application)desc).isDirty() : (desc instanceof ConnectorDescriptor ? ((ConnectorDescriptor)desc).isDirty() : true);
        if (!isDirty) {
            UIUtils.debugPrintln("Object doesn't need to be saved: " + desc.getName());
            return true;
        }
        if (saveMode == 0) {
            UIUtils.debugPrintln("NOT Saving Object: " + desc.getName());
            return false;
        }
        boolean bl2 = okToSave = saveMode == 2 ? UIOptionPane.showConfirmDialog(this.frameOwner, DeploymentManager.CONFIRM_SAVE_OBJECT(desc.getName())) : true;
        if (okToSave) {
            UIUtils.debugPrintln("Saving Object: " + desc.getName());
            return this.save(desc);
        }
        UIUtils.debugPrintln("NOT Saving Object: " + desc.getName());
        return false;
    }

    private boolean save(Descriptor desc) {
        UIUtils.debugPrintln("Saving " + desc.getName());
        try {
            if (desc instanceof Application) {
                DT.getApplicationManager().saveApplication((Application)desc);
            } else {
                DT.getStandAloneManager().saveStandAlone(desc);
            }
            return true;
        }
        catch (IOException ioe) {
            UIOptionPane.showErrorDialog(this.frameOwner, DeploymentManager.ERROR_SAVING(desc.getName(), ioe.toString()));
            return false;
        }
    }

    private File getSavedFile(Descriptor desc) {
        File descFile = null;
        if (this.saveIfDirty(desc)) {
            if (desc instanceof Application) {
                Application app = (Application)desc;
                ApplicationArchivist appArch = app.getApplicationArchivist();
                descFile = appArch.getApplicationFile();
            } else if (desc instanceof ConnectorDescriptor) {
                ConnectorDescriptor cd2 = (ConnectorDescriptor)desc;
                ConnectorArchivist ca2 = (ConnectorArchivist)cd2.getArchivist();
                descFile = new File(ca2.getArchiveUri());
            }
        } else {
            try {
                if (desc instanceof Application) {
                    Application app = (Application)desc;
                    boolean wasDirty = app.isDirty();
                    ApplicationArchivist appArch = app.getApplicationArchivist();
                    File appFile = appArch.getApplicationFile();
                    descFile = this.createTempFile("deploy_application", ".ear");
                    appArch.save(descFile, true);
                    appArch.setApplicationFile(appFile);
                    if (wasDirty) {
                        app.changed(true);
                    }
                } else if (desc instanceof ConnectorDescriptor) {
                    ConnectorDescriptor cd3 = (ConnectorDescriptor)desc;
                    boolean wasDirty = cd3.isDirty();
                    ConnectorArchivist ca3 = (ConnectorArchivist)cd3.getArchivist();
                    descFile = this.createTempFile("deploy_connector", ".rar");
                    String cdFile = ca3.getArchiveUri();
                    ca3.save(descFile);
                    ca3.setArchiveUri(cdFile);
                    if (wasDirty) {
                        cd3.setVendorName(cd3.getVendorName());
                    }
                } else {
                    UIUtils.printImplementationError("Unsupported descriptor type: " + desc.getClass().getName());
                }
            }
            catch (Throwable t2) {
                UIOptionPane.showErrorDialog(this.frameOwner, localStrings.getLocalString("ui.deploymentmanager.error_creating_temp", "Error creating temporary deployment file\n{0}", new Object[]{t2.toString()}));
            }
        }
        return descFile;
    }

    private File createTempFile(String prefix, String extn) throws IOException {
        File tmpDir = UIConfig.getTempDirectory();
        File tmpFile = File.createTempFile(prefix, extn, tmpDir);
        tmpFile.deleteOnExit();
        return tmpFile;
    }

    public void updateProjectFiles(Descriptor desc, boolean interactive) {
        block11: {
            try {
                ProjectImpl proj = (ProjectImpl)Project.getProject(desc);
                if (proj != null) {
                    Vector updatedEntries = proj.updateProjectFiles();
                    String updatedString = null;
                    if (updatedEntries.size() > 0) {
                        StringBuffer sb = new StringBuffer("");
                        Enumeration e10 = updatedEntries.elements();
                        while (e10.hasMoreElements()) {
                            sb.append(" ");
                            sb.append((String)e10.nextElement());
                            sb.append("\n");
                        }
                        updatedString = DeploymentManager.APP_UPDATE_MESSAGE(desc.getName(), sb.toString());
                    } else {
                        updatedString = DeploymentManager.ALL_UP_TO_DATE(desc.getName());
                    }
                    if (interactive) {
                        UIOptionPane.showInfoDialog(this.frameOwner, updatedString);
                    } else {
                        UIUtils.println(updatedString);
                    }
                } else {
                    String noProj = DeploymentManager.NO_PROJECT(desc.getName());
                    if (interactive) {
                        UIOptionPane.showErrorDialog(this.frameOwner, noProj);
                    } else {
                        UIUtils.println(noProj);
                    }
                }
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
                String updFail = DeploymentManager.UPDATE_FAILED(desc.getName(), ioe.getMessage());
                UIUtils.println(updFail);
                if (!interactive) break block11;
                UIOptionPane.showErrorDialog(this.frameOwner, updFail);
            }
        }
    }

    public void deployObject(Descriptor desc) {
        if (desc == null) {
            return;
        }
        String currentServer = DT.getServerManager().getCurrentServer();
        if (currentServer == null) {
            UIOptionPane.showErrorDialog(this.frameOwner, DeploymentManager.PLEASE_CONNECT_DEPLOY(desc.getName()));
            return;
        }
        PreDeployWizard preDeployWizard = new PreDeployWizard(this.frameOwner, desc);
        preDeployWizard.show();
        if (!preDeployWizard.didComplete()) {
            return;
        }
        desc = preDeployWizard.getDescriptor();
        File descSavedFile = this.getSavedFile(desc);
        if (desc instanceof Application) {
            Application app = (Application)desc;
            File clientCodeFile = null;
            String clientFileName = preDeployWizard.getClientFilename();
            if (clientFileName != null) {
                clientCodeFile = new File(clientFileName);
            }
            this._deployApplication(app, descSavedFile, clientCodeFile, currentServer);
            if (clientCodeFile != null) {
                ProjectImpl proj = (ProjectImpl)Project.getProject(app);
                if (proj != null) {
                    proj.setClientCodeFile(clientCodeFile);
                } else {
                    UIUtils.debugPrintln("No Project! - " + app.getName());
                }
            }
        } else if (desc instanceof ConnectorDescriptor) {
            ConnectorDescriptor cd2 = (ConnectorDescriptor)desc;
            this._deployStandAlone(cd2, descSavedFile, currentServer);
        } else {
            this._deployStandAlone(desc, descSavedFile, currentServer);
        }
    }

    public void redeployObject(Descriptor desc) {
        if (desc == null) {
            return;
        }
        String currentServer = DT.getServerManager().getCurrentServer();
        if (currentServer == null) {
            UIOptionPane.showErrorDialog(this.frameOwner, DeploymentManager.PLEASE_CONNECT_REDEPLOY(desc.getName()));
            return;
        }
        this.updateProjectFiles(desc, false);
        boolean isInstalled = false;
        try {
            isInstalled = DT.getServerManager().isInstalled(desc.getName(), currentServer);
        }
        catch (Exception e10) {
            UIOptionPane.showErrorDialog(this.frameOwner, DeploymentManager.ERROR_SERVER_COMMUNICATION(currentServer));
            DT.getServerManager().removeServer(currentServer);
            return;
        }
        if (!isInstalled) {
            this.deployObject(desc);
            return;
        }
        File descSavedFile = this.getSavedFile(desc);
        if (desc instanceof Application) {
            Application app = (Application)desc;
            ProjectImpl proj = (ProjectImpl)Project.getProject(app);
            this._deployApplication(app, descSavedFile, proj.getClientCodeFile(), currentServer);
        } else if (desc instanceof ConnectorDescriptor) {
            ConnectorDescriptor cd2 = (ConnectorDescriptor)desc;
            this._deployStandAlone(cd2, descSavedFile, currentServer);
        } else {
            this._deployStandAlone(desc, descSavedFile, currentServer);
        }
    }

    private void _deployApplication(final Application app, final File appSavedFile, final File clientFile, final String currentServer) {
        int ejbs = app.getEjbDescriptors().size();
        int webs = app.getWebBundleDescriptors().size();
        final ProgressPanel progressPanel = new ProgressPanel(this.frameOwner, ejbs, webs);
        try {
            final DeploymentSessionImpl session = (DeploymentSessionImpl)DT.getServerManager().createDeploymentSession(currentServer);
            session.addNotificationListener(progressPanel);
            new Thread(progressPanel).start();
            new Thread(){

                public void run() {
                    try {
                        DT.getDeployTool().deploy(app, appSavedFile, currentServer, session, clientFile);
                        progressPanel.done();
                        DT.getServerManager().deployedApplication(app);
                    }
                    catch (ServerException se) {
                        UIOptionPane.showErrorDialog(progressPanel, DeploymentManager.ERROR_SERVER_CONNECTION(se.getMessage()));
                        progressPanel.done();
                        DT.getServerManager().removeServer(currentServer);
                    }
                    catch (Throwable t2) {
                        UIOptionPane.showErrorDialog(progressPanel, DeploymentManager.ERROR_SERVER_DEPLOY(t2.toString()));
                        progressPanel.done();
                    }
                }
            }.start();
        }
        catch (Exception e10) {
            Log.print(this.frameOwner, e10);
        }
    }

    public void undeployApplication(String appName, String srvName) throws ServerException {
        UIUtils.debugPrintln("Undeploy application '" + appName + "' from '" + srvName + "'");
        try {
            DT.getServerManager().undeployApplication(appName, srvName);
        }
        catch (Throwable t2) {
            UIUtils.debugPrintln("Error undeploying: " + t2.toString());
            throw new ServerException(DeploymentManager.ERROR_SERVER_UNDEPLOY(appName, srvName));
        }
    }

    private void _deployStandAlone(Descriptor desc, File descSavedFile, String currentServer) {
        try {
            if (desc instanceof ConnectorDescriptor) {
                ConnectorDescriptor cd2 = (ConnectorDescriptor)desc;
                UIUtils.debugPrintln("Deploying " + desc.getName());
                File file = descSavedFile;
                byte[] data = new byte[(int)file.length()];
                DataInputStream ds2 = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                ds2.readFully(data);
                String connectorName = null;
                connectorName = UIConfig.getConfigBoolean("ui.deploy.connectors.useDisplayName") ? cd2.getName() : file.getName();
                JarInstaller backend = DT.getServerManager().getServerForName(currentServer);
                backend.deployConnector(data, connectorName);
                DT.getServerManager().deployedStandAlone(desc);
                UIUtils.debugPrintln("Deployment succeeded");
                UIOptionPane.showInfoDialog(this.frameOwner, DeploymentManager.RAR_DEPLOY_SUCCEEDED(desc.getName(), currentServer));
            }
        }
        catch (ServerException se) {
            UIUtils.debugPrintln(se.toString());
            UIOptionPane.showErrorDialog(this.frameOwner, DeploymentManager.ERROR_SERVER_CONNECTION(se.getMessage()));
            DT.getServerManager().removeServer(currentServer);
            return;
        }
        catch (Throwable t2) {
            UIUtils.debugPrintln(t2.toString());
            UIOptionPane.showErrorDialog(this.frameOwner, DeploymentManager.ERROR_SERVER_DEPLOY(t2.toString()));
            return;
        }
    }

    public void undeployStandAlone(String descName, String serverName) throws ServerException {
        if (serverName == null && (serverName = DT.getServerManager().getCurrentServer()) == null) {
            throw new ServerException(DeploymentManager.ERROR_SERVER_UNDEPLOY(descName, "<null>"));
        }
        UIUtils.debugPrintln("Undeploy stand-alone '" + descName + "' from '" + serverName + "'");
        try {
            UIUtils.debugPrintln("Undeploying connector");
            DT.getServerManager().undeployConnector(descName, serverName);
        }
        catch (Throwable t2) {
            UIUtils.debugPrintln("Error undeploying: " + t2.toString());
            throw new ServerException(DeploymentManager.ERROR_SERVER_UNDEPLOY(descName, serverName));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ String access$2200() {
        return PREDEPLOY_CHOOSE_FILE;
    }

    private class ProgressPanel
    extends UIDialog
    implements NotificationListener,
    Runnable {
        private JTextArea progressTextArea = null;
        private JScrollPane scrollPane;
        private JScrollBar scrollBar;
        private JPanel buttonsPanel = null;
        private UIProgressBar ejbBar = null;
        private UIProgressBar webBar = null;
        private UIProgressBar appBar = null;
        private DeploymentSessionImpl session = null;

        public ProgressPanel(Frame fr, int ejbs, int webs) {
            super(fr, true);
            super.dialogInit();
            super.setTitle(PROGRESS_DIALOG_TITLE);
            if (fr != null) {
                int x2 = fr.getBounds().x + fr.getBounds().width / 6;
                int y2 = fr.getBounds().y + fr.getBounds().height / 6;
                int width = (int)((double)fr.getBounds().width / 1.5);
                int height = (int)((double)fr.getBounds().height / 1.5);
                ((Component)this).setBounds(x2, y2, width, height);
            } else {
                ((Component)this).setBounds(0, 0, 200, 200);
            }
            this.initializeWidgets(ejbs, webs);
        }

        private void initializeWidgets(int ejbs, int webComponents) {
            this.getContentPane().setLayout(new BorderLayout());
            JPanel displayPanel = UIUtils.createBorderedPanel(PROGRESS_BOX_TITLE, null);
            displayPanel.setLayout(new GridLayout(1, 1));
            this.progressTextArea = new JTextArea("");
            this.progressTextArea.setEnabled(false);
            this.progressTextArea.setSelectionColor(((Component)this).getBackground());
            this.progressTextArea.setBackground(((Component)this).getBackground());
            this.progressTextArea.setLineWrap(false);
            this.progressTextArea.setWrapStyleWord(false);
            this.progressTextArea.setDisabledTextColor(Color.black);
            this.scrollPane = new JScrollPane(this.progressTextArea);
            this.scrollBar = this.scrollPane.getVerticalScrollBar();
            displayPanel.add(this.scrollPane);
            this.getContentPane().add("Center", displayPanel);
            this.buttonsPanel = new JPanel();
            UIButton canBtn = UIButton.createCancelButton(new ActionListener(this){
                private final /* synthetic */ ProgressPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae2) {
                    this.this$1.cancelAction();
                }
            });
            this.buttonsPanel.add(canBtn);
            this.getContentPane().add("South", this.buttonsPanel);
            UITitledBox eastPanel = new UITitledBox(null, false);
            GridBagConstraints progGbc = eastPanel.getGBConstraints();
            progGbc.weightx = 0.0;
            progGbc.weighty = 1.0;
            progGbc.gridx = 0;
            progGbc.gridy = -1;
            progGbc.fill = 3;
            progGbc.insets = new Insets(5, 3, 5, 2);
            int ejbLength = 3;
            int webLength = webComponents;
            int appLength = ejbLength + webLength + 5;
            if (webComponents > 0) {
                this.webBar = this.newProgressBar(UIIcons.WEB_BUNDLE_ICON, webLength, Color.cyan);
                eastPanel.add((Component)this.webBar, progGbc);
                ++progGbc.gridx;
            }
            if (ejbs > 0) {
                this.ejbBar = this.newProgressBar(UIIcons.EJB_BUNDLE_ICON, ejbLength, Color.blue);
                eastPanel.add((Component)this.ejbBar, progGbc);
                ++progGbc.gridx;
            }
            this.appBar = this.newProgressBar(UIIcons.APPLICATION_ICON, appLength, Color.green);
            eastPanel.add((Component)this.appBar, progGbc);
            ++progGbc.gridx;
            this.getContentPane().add("West", eastPanel);
        }

        public UIProgressBar newProgressBar(String iconName, int max, Color color) {
            UIProgressBar bar = new UIProgressBar(UIIcons.getImageIconFor(iconName), true, max, color);
            bar.setBarWidth(30);
            return bar;
        }

        public void cancelAction() {
            if (this.session != null) {
                this.session.setCancelled(true, true);
            }
        }

        public void run() {
            this.show();
        }

        public void notification(NotificationEvent ne) {
            if (ne.getSource() instanceof DeploymentSessionImpl) {
                String t2 = ne.getType();
                this.session = (DeploymentSessionImpl)ne.getSource();
                if (t2.equals("Status Changed")) {
                    this.progressTextArea.append(this.session.getStatusMessage());
                    this.progressTextArea.append("\n");
                    this.scrollBar.setValue(this.scrollBar.getMaximum());
                } else if (t2.equals("Error")) {
                    Exception e10 = this.session.getException();
                    this.progressTextArea.append("\n" + this.session.getStatusMessage() + "\n");
                    this.scrollBar.setValue(this.scrollBar.getMaximum());
                    this.session.setCancelled(true, false);
                } else if (t2.equals("Ejb Code Generation complete") || t2.equals("Ejb Compilation complete")) {
                    this.ejbBar.increment();
                    this.appBar.increment();
                } else if (t2.equals("Web Component Deployed")) {
                    this.webBar.increment();
                    this.appBar.increment();
                } else if (t2.equals("Application Transferred")) {
                    this.appBar.increment();
                } else if (t2.equals("Server JARs made")) {
                    this.appBar.increment();
                } else if (t2.equals("Client JARs made")) {
                    this.appBar.increment();
                } else if (t2.equals("Done Deploying")) {
                    this.appBar.increment();
                } else if (t2.equals("Client Code Saved")) {
                    this.appBar.increment();
                } else {
                    UIUtils.debugPrintln("DeploymentManager.ProgressPanel.notification", "Unrecognized notification type: " + t2.toString());
                }
            }
            this.doLayout();
            this.validate();
            this.repaint();
        }

        public void notificationEjb(int i2) {
            this.ejbBar.setValue(i2);
            this.validate();
        }

        public void notificationWebComponent(int j2) {
            this.webBar.setValue(j2);
            this.validate();
        }

        public void notificationTransferDone() {
        }

        public void done() {
            if (this.ejbBar != null) {
                this.ejbBar.setValue(this.ejbBar.getMaximum());
            }
            if (this.webBar != null) {
                this.webBar.setValue(this.webBar.getMaximum());
            }
            if (this.appBar != null) {
                this.appBar.setValue(this.appBar.getMaximum());
            }
            this.buttonsPanel.removeAll();
            UIButton okBtn = UIButton.createOkButton(new ActionListener(this){
                private final /* synthetic */ ProgressPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae2) {
                    this.this$1.hide();
                }
            });
            this.buttonsPanel.add(okBtn);
            this.buttonsPanel.doLayout();
            this.buttonsPanel.validate();
            this.buttonsPanel.repaint();
        }
    }

    private class PreDeployPanel
    extends UITitledBox {
        private String helpSetMapID = "DServer";
        private UITitledTextField clientCode = null;
        private JCheckBox checkBox = null;
        private JCheckBox saveOnDeployCB = null;
        private TreeCombo deployables = null;
        private UITitledComboBox serverList = null;
        private UITitledHTMLText cjarFile = null;
        private PreDeployWizard wizard = null;
        private Descriptor defaultDescriptor = null;

        public PreDeployPanel(PreDeployWizard wizard, Descriptor desc) {
            super((String)null, false);
            this.wizard = wizard;
            this.defaultDescriptor = desc;
            CSH.setHelpIDString((Component)this, (String)this.helpSetMapID);
            this.initializeLayout();
        }

        private void initializeLayout() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = this.getGBConstraints();
            gbc.gridx = 0;
            gbc.gridy = -1;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.5;
            gbc.weighty = 0.0;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 5, 10, 10);
            UITitledBox objectBox = new UITitledBox(null, false);
            ++gbc.gridy;
            gbc.anchor = 18;
            this.add((Component)objectBox, gbc);
            UITitledHTMLText serverInstr = new UITitledHTMLText(null, false);
            objectBox.addWithGBConstraints(serverInstr);
            serverInstr.setText(PREDEPLOY_SELECT_SERVER, "h3");
            this.deployables = DeployToolWindow.getDeployToolWindow().getDescriptorTreeView().getDeployableObjectsCombo(PREDEPLOY_DEPLOYED_OBJECTS, false);
            objectBox.addWithGBConstraints(this.deployables);
            this.deployables.getComboBox().addActionListener(new ActionListener(this){
                private final /* synthetic */ PreDeployPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae2) {
                    PreDeployPanel.access$1300(this.this$1);
                }
            });
            this.serverList = new UITitledComboBox(PREDEPLOY_TARGET_SERVER, false);
            objectBox.getGBConstraints().insets.top = 5;
            objectBox.addWithGBConstraints(this.serverList);
            Object[] srvNames = DT.getServerManager().getServerNames().toArray();
            if (srvNames == null || srvNames.length == 0) {
                srvNames = new Object[]{""};
            }
            this.serverList.setModel(srvNames);
            this.serverList.getComboBox().addActionListener(new ActionListener(this){
                private final /* synthetic */ PreDeployPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae2) {
                    String srvName = (String)PreDeployPanel.access$1500(this.this$1).getSelectedItem();
                    if (srvName != null) {
                        DT.getServerManager().setCurrentServer(srvName);
                    }
                }
            });
            String selServer = DT.getServerManager().getCurrentServer();
            if (selServer == null || selServer.equals("")) {
                selServer = (String)srvNames[0];
                DT.getServerManager().setCurrentServer(selServer);
            }
            this.serverList.setSelectedItem(selServer);
            this._addDivider(this, gbc);
            UITitledBox clientJarBox = new UITitledBox(null, false);
            ++gbc.gridy;
            this.add((Component)clientJarBox, gbc);
            this.cjarFile = new UITitledHTMLText(null, false);
            clientJarBox.addWithGBConstraints(this.cjarFile);
            this.cjarFile.setText(PREDEPLOY_CJAR_HELP, "h3");
            this.checkBox = new JCheckBox(PREDEPLOY_RETURN_JAR);
            clientJarBox.addWithGBConstraints(this.checkBox);
            this.checkBox.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ PreDeployPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void stateChanged(ChangeEvent e10) {
                    if (PreDeployPanel.access$1800(this.this$1) != null) {
                        PreDeployPanel.access$1800(this.this$1).setEnabled(PreDeployPanel.access$1900(this.this$1).isSelected());
                    }
                }
            });
            this.checkBox.setSelected(false);
            this.clientCode = new UITitledTextField(PREDEPLOY_CJAR_FILE, false);
            clientJarBox.addWithGBConstraints(this.clientCode);
            this.clientCode.setBrowserActionListener(new ActionListener(this){
                private final /* synthetic */ PreDeployPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae2) {
                    JFileChooser jfc = UIFileChooser.getFileChooser();
                    int rtn = jfc.showDialog(PreDeployPanel.access$2100(this.this$1), DeploymentManager.access$2200());
                    if (rtn != 0) {
                        return;
                    }
                    PreDeployPanel.access$1800(this.this$1).setText(jfc.getSelectedFile().toString());
                }
            });
            this.clientCode.setEnabled(false);
            this._addDivider(this, gbc);
            UITitledBox deploySaveBox = new UITitledBox(null, false);
            ++gbc.gridy;
            gbc.anchor = 16;
            this.add((Component)deploySaveBox, gbc);
            UITitledHTMLText deploySaveInstr = new UITitledHTMLText(null, false);
            deploySaveBox.addWithGBConstraints(deploySaveInstr);
            this.saveOnDeployCB = new JCheckBox(PREDEPLOY_SAVE_ON_DEPLOY);
            deploySaveBox.addWithGBConstraints(this.saveOnDeployCB);
            if (SaveOnDeploy == 0) {
                DeploymentManager.this.saveOnDeploy = 0;
                this.saveOnDeployCB.setSelected(false);
            } else {
                DeploymentManager.this.saveOnDeploy = 1;
                this.saveOnDeployCB.setSelected(true);
            }
            this.saveOnDeployCB.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ PreDeployPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void stateChanged(ChangeEvent e10) {
                    int save = PreDeployPanel.access$2600(this.this$1).isSelected() ? 1 : 0;
                    DeploymentManager.access$2502(PreDeployPanel.access$2700(this.this$1), save);
                }
            });
            if (this.defaultDescriptor != null) {
                this.deployables.setSelectedDescriptor(this.defaultDescriptor);
            }
            this.selectedDescriptor();
        }

        private void _addDivider(JPanel panel, GridBagConstraints gbc) {
            ++gbc.gridy;
            GridBagConstraints c10 = (GridBagConstraints)gbc.clone();
            c10.weightx = 0.5;
            c10.weighty = 0.0;
            c10.fill = 2;
            c10.anchor = 10;
            c10.insets = new Insets(0, 3, 0, 5);
            panel.add((Component)new JPanel(this){
                private final /* synthetic */ PreDeployPanel this$1;
                {
                    this.this$1 = this$1;
                }

                protected void paintComponent(Graphics g2) {
                    g2.drawLine(0, this.getSize().height / 2, this.getSize().width, this.getSize().height / 2);
                }
            }, c10);
        }

        private void selectedDescriptor() {
            Descriptor desc = (Descriptor)this.deployables.getSelectedDescriptor();
            if (desc instanceof Application) {
                this.defaultDescriptor = desc;
                this.checkBox.setEnabled(true);
                File descFile = ((Application)this.defaultDescriptor).getApplicationArchivist().getApplicationFile();
                String dir = new File(descFile.getAbsolutePath()).getParentFile().toString();
                String name = descFile.getName();
                int p2 = name.indexOf(".");
                if (p2 >= 0) {
                    name = name.substring(0, p2);
                }
                this.clientCode.setText(dir + File.separator + name + "Client.jar");
                this.clientCode.setEnabled(this.checkBox.isSelected());
            } else if (desc instanceof ConnectorDescriptor) {
                this.defaultDescriptor = desc;
                this.checkBox.setEnabled(false);
                this.clientCode.setEnabled(false);
                this.clientCode.setText("");
            } else {
                this.defaultDescriptor = null;
                this.checkBox.setEnabled(false);
                this.clientCode.setEnabled(false);
                this.clientCode.setText("");
                UIUtils.printImplementationError("Unsupported descriptor type: " + desc.getClass().getName());
            }
            this.wizard.refreshTitle(this.defaultDescriptor);
        }

        public Descriptor getDescriptor() {
            return this.defaultDescriptor;
        }

        public String getFilename() {
            return this.checkBox.isSelected() ? this.clientCode.getText() : null;
        }

        static /* synthetic */ void access$1300(PreDeployPanel x0) {
            x0.selectedDescriptor();
        }

        static /* synthetic */ UITitledComboBox access$1500(PreDeployPanel x0) {
            return x0.serverList;
        }

        static /* synthetic */ UITitledTextField access$1800(PreDeployPanel x0) {
            return x0.clientCode;
        }

        static /* synthetic */ JCheckBox access$1900(PreDeployPanel x0) {
            return x0.checkBox;
        }

        static /* synthetic */ PreDeployWizard access$2100(PreDeployPanel x0) {
            return x0.wizard;
        }

        static /* synthetic */ JCheckBox access$2600(PreDeployPanel x0) {
            return x0.saveOnDeployCB;
        }

        static /* synthetic */ DeploymentManager access$2700(PreDeployPanel x0) {
            return x0.DeploymentManager.this;
        }
    }

    private class PreDeployWizard
    extends Wizard {
        private PreDeployPanel preDeploymentPanel = null;
        private ApplicationWebContextInspector webContextsInspector = null;
        private JndiNameInspector jndiNamesInspector = null;
        private UIHelpPanel helpPanel = null;

        public String getHelpGroup() {
            return "D";
        }

        public PreDeployWizard(Frame owner, Descriptor desc) {
            super(owner);
            super.setDoneLabelString(SAVE_DEPLOY_LABEL);
            super.setBounds(100, 100, 500, 500);
            this.preDeploymentPanel = new PreDeployPanel(this, desc);
            this.addComponent(this.preDeploymentPanel, PREDEPLOY_INTRO, "");
            this.jndiNamesInspector = (JndiNameInspector)JndiNameInspector.newInspectorPane("DeploymentMode", null);
            this.addInspectorPane(this.jndiNamesInspector, PREDEPLOY_JNDI_NAMES, "");
            this.webContextsInspector = (ApplicationWebContextInspector)ApplicationWebContextInspector.newInspectorPane("DeploymentMode", null);
            this.addInspectorPane(this.webContextsInspector, PREDEPLOY_WAR_ROOT, "");
            this.helpPanel = new UIHelpPanel();
            CSH.setHelpIDString((Component)this.helpPanel, (String)(this.getHelpGroup() + "Ready"));
            this.addComponent(this.helpPanel, PREDEPLOY_REVIEW, "");
            DeployToolActions.enableHelpOnButton(this.helpButton, CSH.getHelpIDString((Component)this.preDeploymentPanel));
        }

        public void refreshTitle(Descriptor d10) {
            super.setTitle(DeploymentManager.PREDEPLOY_TITLE(d10 != null ? d10.getName() : "?"));
        }

        public Descriptor getDescriptor() {
            return this.preDeploymentPanel.getDescriptor();
        }

        public String getClientFilename() {
            return this.preDeploymentPanel.getFilename();
        }

        public void goForward() {
            JComponent currentComponent = super.getCurrentComponent();
            if (currentComponent == this.preDeploymentPanel && DT.getServerManager().getCurrentServer() == null) {
                UIOptionPane.showErrorDialog(this, PLEASE_SELECT_SERVER);
                return;
            }
            super.goForward();
            DeployToolActions.enableHelpOnButton(this.helpButton, CSH.getHelpIDString((Component)super.getCurrentComponent()));
        }

        public void goBackward() {
            super.goBackward();
            JComponent currentComponent = super.getCurrentComponent();
            DeployToolActions.enableHelpOnButton(this.helpButton, CSH.getHelpIDString((Component)currentComponent));
        }

        protected boolean isInspectorAcceptable(int inspIndex) {
            if (inspIndex <= this.getIndexOf(this.preDeploymentPanel)) {
                return true;
            }
            Descriptor d10 = this.preDeploymentPanel.getDescriptor();
            if (inspIndex == this.getIndexOf(this.helpPanel)) {
                this.helpPanel.setHelpText(DeploymentManager.PREDEPLOY_HELP(d10.getName()), READY_TO_DEPLOY);
                return true;
            }
            if (!(d10 instanceof Application)) {
                return false;
            }
            Application app = (Application)d10;
            if (inspIndex == this.getIndexOf(this.jndiNamesInspector)) {
                if (app.getNamedDescriptors().size() > 0) {
                    this.jndiNamesInspector.setDescriptor(app);
                    return true;
                }
                return false;
            }
            if (inspIndex == this.getIndexOf(this.webContextsInspector)) {
                if (app.getWebBundleDescriptors().size() > 0) {
                    this.webContextsInspector.setDescriptor(app);
                    return true;
                }
                return false;
            }
            return true;
        }
    }
}

