/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ApplicationClientArchivist;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorArchivist;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.deployment.main.ApplicationManager;
import com.sun.enterprise.tools.deployment.main.DeployTool;
import com.sun.enterprise.tools.deployment.main.Log;
import com.sun.enterprise.tools.deployment.main.ServerManager;
import com.sun.enterprise.tools.deployment.main.StandAloneManager;
import com.sun.enterprise.tools.deployment.ui.AboutDialog;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.DeployToolActions;
import com.sun.enterprise.tools.deployment.ui.DeployToolWindowController;
import com.sun.enterprise.tools.deployment.ui.DeployedAppDescriptor;
import com.sun.enterprise.tools.deployment.ui.DeployedObjectDescriptor;
import com.sun.enterprise.tools.deployment.ui.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.DescriptorTreeView;
import com.sun.enterprise.tools.deployment.ui.DescriptorViewer;
import com.sun.enterprise.tools.deployment.ui.InspectorEventDelegator;
import com.sun.enterprise.tools.deployment.ui.InspectorManager;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.NewAppClientWizard;
import com.sun.enterprise.tools.deployment.ui.NewAppDialog;
import com.sun.enterprise.tools.deployment.ui.NewEjbWizard;
import com.sun.enterprise.tools.deployment.ui.NewResAdaptWizard;
import com.sun.enterprise.tools.deployment.ui.NewWebComponentWizard;
import com.sun.enterprise.tools.deployment.ui.ServerDescriptor;
import com.sun.enterprise.tools.deployment.ui.ServerGeneralInspector;
import com.sun.enterprise.tools.deployment.ui.TreeCombo;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.descriptor.ConnectionFactoryDialog;
import com.sun.enterprise.tools.deployment.ui.descriptor.RolesDialog;
import com.sun.enterprise.tools.deployment.ui.rescfg.ConfigurationDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIActionDispatcher;
import com.sun.enterprise.tools.deployment.ui.utils.UIBusyCursor;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIFileChooser;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIRadioButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledHTMLText;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.tools.verifier.gui.MainFrame;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.help.CSH;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class DeployToolWindow
extends JFrame
implements WindowListener,
DescriptionInspector.DescriptionInspectorManager {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$DeployToolWindow == null ? (class$com$sun$enterprise$tools$deployment$ui$DeployToolWindow = DeployToolWindow.class$("com.sun.enterprise.tools.deployment.ui.DeployToolWindow")) : class$com$sun$enterprise$tools$deployment$ui$DeployToolWindow);
    private static String TITLE = localStrings.getLocalString("ui.deploytoolwindow.title", "Application Deployment Tool");
    private static String ADD_SERVER_LABEL = localStrings.getLocalString("ui.deploytoolwindow.add_server_label", "Server Name:");
    private static String ADD_SERVER_TITLE = localStrings.getLocalString("ui.deploytoolwindow.add_server_title", "Add Server");
    private static String ROLES_PRINCIPALS_LABEL = localStrings.getLocalString("ui.deploytoolwindow.roles_principals_label", "Role Mapping Editor");
    private static String RESOURCE_IDENTITIES_LABEL = localStrings.getLocalString("ui.deploytoolwindow.resource_identities_label", "Resource Identities Inspector");
    private static String NOTHING_SELECTED_ = null;
    private static String ERROR_LOCATING_APPS_ = null;
    private static String ERROR_LOCATING_SRV_ = null;
    private static final String CLIPBOARD = localStrings.getLocalString("ui.deploytoolwindow.clipboard", "clipboard");
    private static final String CLIPBOARD_J2EE = localStrings.getLocalString("ui.deploytoolwindow.j2ee", "J2EE");
    private static final String AMA_ADD_MODULE_TITLE = localStrings.getLocalString("ui.deploytoolwindow.add_module.title", "Add Module to Application");
    private static final String AMA_SELECT_APP = localStrings.getLocalString("ui.deploytoolwindow.add_module.instructions", "This module must be added to an application file.  Please choose to add it to an existing application or to create a new application.");
    private static final String AMA_ADD_TO_EXISTING = localStrings.getLocalString("ui.deploytoolwindow.add_module.add_to_existing", "Add to Existing Application");
    private static final String AMA_ADD_TO_NEW = localStrings.getLocalString("ui.deploytoolwindow.add_module.add_to_new", "Add to New Application");
    private static final String AMA_APP_FILE = localStrings.getLocalString("ui.deploytoolwindow.add_module.app_file_name", "Application File:");
    private static final String AMA_APP_NAME = localStrings.getLocalString("ui.deploytoolwindow.add_module.app_display_name", "Application Display Name:");
    private static final int DEFAULT_DIVIDER_SIZE = 3;
    private static final int DEFAULT_DIVIDER_LOCATION = 200;
    private static final String DOT_EAR = ".ear";
    private static final String APP_TEMP_SUBDIR = "j2eeApps";
    private static DeployToolWindow deployToolWindowInstance = null;
    private static int defaultMinWidth = 562;
    private static int defaultMinHeight = 516;
    private DeployToolWindowController controller;
    private DescriptorTreeView treeView;
    private JSplitPane workspacePanel = null;
    private MainFrame verifierFrame = null;
    private JPanel inspectorPanel = new JPanel();
    private UITitledBox inspectingLabel = null;
    private JFileChooser fileChooser;
    private DescriptorViewer viewer = null;
    private JTree rootTree = null;
    private ConfigurationDialog configInstFrame = null;
    private DescriptionInspector descriptionInspector = null;
    private DeployToolActions deployToolActions = null;
    private File clipboard = new File(CLIPBOARD);
    private AddModuleDialog addModuleDialog = null;
    private static final boolean USE_ADD_SERVER_THREAD = true;
    private static final int ADD_SERVER_TIMEOUT = 10000;
    private static Object addServerLock = new Object();
    private static String addServerHelpId = "AddServer";
    private static String addModuleHelpId = "AddModule";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$DeployToolWindow;

    private static String INSPECTING_LABEL(String v0) {
        return localStrings.getLocalString("ui.deploytoolwindow.inspecting_label", "Inspecting: {0}", new Object[]{v0});
    }

    private static String DELETE_FAILED(String v0) {
        return localStrings.getLocalString("ui.deploytoolwindow.delete_failed", "Delete failed: {0}", new Object[]{v0});
    }

    private static String COULD_NOT_REOPEN(String v0, String v1) {
        return localStrings.getLocalString("ui.deploytoolwindow.could_not_reopen", "Warning: Could not re-open {0}\n{1}", new Object[]{v0, v1});
    }

    private static String COULD_NOT_OPEN(String v0, String v1) {
        return localStrings.getLocalString("ui.deploytoolwindow.could_not_open", "Error: Could not open file {0}\n{1}", new Object[]{v0, v1});
    }

    private static String SOMETHING_CHANGED(String v0) {
        return localStrings.getLocalString("ui.deploytoolwindow.something_changed", "{0} (changed)", new Object[]{v0});
    }

    private static String OKTOREMOVE_SERVER(String v0) {
        return localStrings.getLocalString("ui.deploytoolwindow.confirm_remove_server", "Are you sure you want to remove selected J2EE server?\n ''{0}''", new Object[]{v0});
    }

    private static String OKTODELETE_SELECTION(String v0) {
        return localStrings.getLocalString("ui.deploytoolwindow.confirm_delete_selection", "Are you sure you want to delete selection?\n ''{0}''", new Object[]{v0});
    }

    private static String WAS_SAVED(String v0, String v1) {
        return localStrings.getLocalString("ui.deploytoolwindow.was_saved", "{0} was saved to \n{1}", new Object[]{v0, v1});
    }

    private static String ALREADY_EXISTS(Object v0) {
        return localStrings.getLocalString("ui.deploytoolwindow.already_exists", "{0} already exists.\n\nDo you wish to overwrite?", new Object[]{v0});
    }

    private static String IS_CORRUPT(String v0) {
        return localStrings.getLocalString("ui.deploytoolwindow.is_corrupt", "{0} is corrupt or cannot be read.", new Object[]{v0});
    }

    private static String NOTHING_SELECTED() {
        return NOTHING_SELECTED_ != null ? NOTHING_SELECTED_ : (NOTHING_SELECTED_ = localStrings.getLocalString("ui.deploytoolwindow.no_app_selected", "No application selected."));
    }

    private static String ERROR_LOCATING_APPS() {
        return ERROR_LOCATING_APPS_ != null ? ERROR_LOCATING_APPS_ : (ERROR_LOCATING_APPS_ = localStrings.getLocalString("ui.deploytoolwindow.locating_or_corrupt", "Error locating the applications on disk last open in the tool"));
    }

    private static String ERROR_LOCATING_SRV() {
        return ERROR_LOCATING_SRV_ != null ? ERROR_LOCATING_SRV_ : (ERROR_LOCATING_SRV_ = localStrings.getLocalString("ui.deploytoolwindow.bad_server_list", "Error locating the servers to which the tool was last connected"));
    }

    public DeployToolWindow(File toolHomeDir, DeployToolWindowController controller) {
        deployToolWindowInstance = this;
        this.controller = controller;
        DT.setFrameWindow(this);
        DT.setDeployTool(this.controller.getDeployTool());
        UIConfig.loadConfig(toolHomeDir);
        UIUtils.debugPrintln("debug mode is enabled");
        UIUtils.testPrintln("test mode is enabled");
        new UIBusyCursor(this).install();
        this.descriptionInspector = new DescriptionInspector(this);
        this.deployToolActions = new DeployToolActions(this);
        JToolBar toolBar = this.deployToolActions.createToolBar();
        JMenuBar menuBar = this.deployToolActions.createMenuBar();
        this.doRestorations();
        DT.getInspectorManager();
        this.registerForTitleUpdates();
        this.getDescriptorTreeView().setSelectedDescriptor(null, false);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", this.getWorkspacePanel());
        this.inspectorPanel.setLayout(new GridLayout(1, 1));
        this.setJMenuBar(menuBar);
        this.getContentPane().add("North", toolBar);
        this.deployToolActions.setEnabled("ApplicationSelected", false);
        this.deployToolActions.setEnabled("StandAloneSelected", false);
        this.deployToolActions.setEnabled("ServerSelected", false);
        this.deployToolActions.setEnabled("ServerObjectSelected", false);
        this.deployToolActions.setEnabled("InspectorSelected", false);
        Rectangle screenRectangle = new Rectangle(new Point(0, 0), Toolkit.getDefaultToolkit().getScreenSize());
        Rectangle centerScreen = UIUtils.getCenterRectangleFrom(screenRectangle, 0.6, 0.7);
        ((Component)this).setBounds((int)centerScreen.getX(), (int)centerScreen.getY(), (int)centerScreen.getWidth(), (int)centerScreen.getHeight());
        UIUtils.hideSplashPanel();
        ((Component)this).setVisible(true);
        this.fileChooser = UIFileChooser.getFileChooser();
        this.addWindowListener(this);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent ce2) {
                boolean changed = false;
                Rectangle bounds = DeployToolWindow.this.getBounds();
                if (bounds.width < defaultMinWidth) {
                    bounds.width = defaultMinWidth;
                    changed = true;
                }
                if (bounds.height < defaultMinHeight) {
                    bounds.height = defaultMinHeight;
                    changed = true;
                }
                if (changed) {
                    ((Component)DeployToolWindow.this).setBounds(bounds);
                }
            }
        });
        if (UIConfig.debugMode()) {
            String cmd = "debugInfo";
            this.inspectorPanel.getInputMap(1).put(KeyStroke.getKeyStroke(114, 0), cmd);
            this.inspectorPanel.getActionMap().put(cmd, new UIActionDispatcher((Object)this, "debugStatus"));
        }
    }

    protected DeployToolWindow(DeployToolWindowController controller) {
        deployToolWindowInstance = this;
        this.controller = controller;
        DT.setFrameWindow(this);
        DT.setDeployTool(this.controller.getDeployTool());
    }

    public void debugStatus() {
        StringBuffer sb = new StringBuffer();
        Descriptor desc = this.treeView.getSelectedDescriptor();
        sb.append("  Descriptor : " + this.uiClassName(desc) + "\n");
        InspectorManager inspMgr = DT.getInspectorManager();
        InspectorEventDelegator insp = inspMgr.getCurrentInspector();
        sb.append("  Tab Manager: " + this.uiClassName(insp) + "\n");
        if (insp != null) {
            InspectorPane pane = insp.getCurrentInspectorPane();
            sb.append("  Inspector  : " + this.uiClassName(pane) + "\n");
        }
        UIUtils.debugPrintln("\n" + sb.toString());
    }

    private String uiClassName(Object obj) {
        if (obj == null) {
            return "null";
        }
        String cn2 = obj instanceof Class ? ((Class)obj).getName() : obj.getClass().getName();
        int p2 = cn2.indexOf(".ui.");
        return p2 < 0 ? cn2 : cn2.substring(p2 + 4);
    }

    public DescriptionInspector getDescriptionInspector() {
        return this.descriptionInspector;
    }

    public static DeployToolWindow getDeployToolWindow() {
        return deployToolWindowInstance;
    }

    public static DeployTool getDeployTool() {
        return DeployToolWindow.deployToolWindowInstance.controller.getDeployTool();
    }

    public static ApplicationManager getApplicationManager() {
        return DT.getApplicationManager();
    }

    public static StandAloneManager getStandAloneManager() {
        return DT.getStandAloneManager();
    }

    public static ServerManager getServerManager() {
        return DT.getServerManager();
    }

    public void doRestorations() {
        Throwable exception;
        String filename;
        Enumeration e10;
        Hashtable err;
        if (!UIConfig.getConfigBoolean("ui.startup.skipApplicationRestore")) {
            UIUtils.debugPrintln("Restoring Applications ...");
            try {
                err = DT.getApplicationManager().restoreFromUserHome();
                e10 = err.keys();
                while (e10.hasMoreElements()) {
                    filename = (String)e10.nextElement();
                    exception = (Throwable)err.get(filename);
                    UIUtils.println(DeployToolWindow.COULD_NOT_REOPEN(filename, exception.getMessage()));
                }
            }
            catch (IOException oie) {
                UIUtils.println(DeployToolWindow.ERROR_LOCATING_APPS());
            }
        } else {
            UIUtils.println("WARNING: Skipping application restoration.");
        }
        if (!UIConfig.getConfigBoolean("ui.startup.skipStandAloneRestore")) {
            UIUtils.debugPrintln("Restoring Stand-Alone ...");
            try {
                err = DT.getStandAloneManager().restoreFromUserHome();
                e10 = err.keys();
                while (e10.hasMoreElements()) {
                    filename = (String)e10.nextElement();
                    exception = (Throwable)err.get(filename);
                    UIUtils.println(DeployToolWindow.COULD_NOT_REOPEN(filename, exception.getMessage()));
                }
            }
            catch (IOException oie) {
                UIUtils.println(DeployToolWindow.ERROR_LOCATING_APPS());
            }
        } else {
            UIUtils.println("WARNING: Skipping stand-alone restoration.");
        }
        if (!UIConfig.getConfigBoolean("ui.startup.skipServerRestore")) {
            UIUtils.debugPrintln("Restoring Servers ...");
            try {
                err = DT.getServerManager().restoreFromUserHome();
                e10 = err.keys();
                while (e10.hasMoreElements()) {
                    String servername = (String)e10.nextElement();
                    exception = (Throwable)err.get(servername);
                    UIUtils.println(localStrings.getLocalString("ui.deploytoolwindow.could_not_reconnect", "Warning: Could not reconnect to {0}\n {1}", new Object[]{servername, exception.getMessage()}));
                }
            }
            catch (Exception e11) {
                UIUtils.println(DeployToolWindow.ERROR_LOCATING_SRV());
            }
            this.addServer(ServerManager.LOCAL_HOST, 15000L, false);
        } else {
            UIUtils.println("WARNING: Skipping server restoration.");
        }
        UIUtils.debugPrintln("... done");
    }

    private void registerForTitleUpdates() {
        this.setTitle(TITLE);
        NotificationListener notifyTitle = new NotificationListener(){

            public void notification(NotificationEvent ne) {
                DeployToolWindow.this.resetTitle();
            }
        };
        DT.getApplicationManager().addNotificationListener(notifyTitle);
        DT.getStandAloneManager().addNotificationListener(notifyTitle);
        DT.getServerManager().addNotificationListener(notifyTitle);
    }

    public void resetTitle() {
        Application selApp = this.getDescriptorTreeView().getSelectedApplication();
        if (selApp != null) {
            String appName = selApp.isDirty() ? DeployToolWindow.SOMETHING_CHANGED(selApp.getName()) : selApp.getName();
            this.setTitle(TITLE + ": " + appName);
            return;
        }
        Descriptor selSA = this.getDescriptorTreeView().getSelectedStandAlone();
        if (selSA != null) {
            StandAloneManager saMgr = DT.getStandAloneManager();
            String objName = saMgr.isDirty(selSA) ? DeployToolWindow.SOMETHING_CHANGED(selSA.getName()) : selSA.getName();
            this.setTitle(TITLE + ": " + objName);
            return;
        }
        ServerDescriptor selServ = this.getDescriptorTreeView().getSelectedServer();
        if (selServ != null) {
            this.setTitle(TITLE + ": " + selServ.getName());
        }
        this.setTitle(TITLE);
    }

    public JComponent getWorkspacePanel() {
        if (this.workspacePanel == null) {
            this.inspectingLabel = new UITitledBox(DeployToolWindow.INSPECTING_LABEL(""), false);
            this.inspectingLabel.setMinimumWidth(450);
            this.inspectingLabel.addWithGBConstraints(this.inspectorPanel);
            this.workspacePanel = new JSplitPane(1, this.getDescriptorTreeView(), this.inspectingLabel);
            this.workspacePanel.setDividerSize(3);
            this.workspacePanel.setDividerLocation(200);
            this.workspacePanel.setResizeWeight(0.2);
        }
        return this.workspacePanel;
    }

    public DescriptorTreeView getDescriptorTreeView() {
        if (this.treeView == null) {
            this.treeView = new DescriptorTreeView();
            this.rootTree = this.treeView.getRootTree();
            this.rootTree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent tse) {
                    TreePath selPath = tse.getNewLeadSelectionPath();
                    if (selPath == null) {
                        DeployToolWindow.this.resetTitle();
                    }
                    Descriptor clickDesc = selPath != null ? (Descriptor)((DefaultMutableTreeNode)selPath.getLastPathComponent()).getUserObject() : null;
                    InspectorEventDelegator inspector = DeployToolWindow.this.refreshInspectorFor(clickDesc);
                    Descriptor clickNode = DeployToolWindow.this.treeView.getMainDescriptorFor(selPath);
                    DeployToolWindow.this.deployToolActions.setEnabled("ApplicationSelected", clickNode instanceof Application);
                    DeployToolWindow.this.deployToolActions.setEnabled("StandAloneSelected", DT.getStandAloneManager().isStandAloneDescriptor(clickNode));
                    DeployToolWindow.this.deployToolActions.setEnabled("ServerSelected", clickNode instanceof ServerDescriptor);
                    DeployToolWindow.this.deployToolActions.setEnabled("ServerObjectSelected", clickDesc instanceof DeployedObjectDescriptor);
                    DeployToolWindow.this.deployToolActions.setEnabled("InspectorSelected", inspector.isValidInspector());
                }
            });
        }
        return this.treeView;
    }

    private InspectorEventDelegator refreshInspectorFor(Descriptor inspectable) {
        InspectorEventDelegator inspector = InspectorEventDelegator.getInspectorFor(inspectable);
        if (this.inspectorPanel.getComponentCount() == 1) {
            if (this.inspectorPanel.getComponent(0) != inspector) {
                this.inspectorPanel.removeAll();
                DeployToolWindow.addComponentToPanelWorkaround(inspector, this.inspectorPanel);
                this.inspectorPanel.doLayout();
                this.inspectorPanel.repaint();
            } else {
                this.inspectorPanel.doLayout();
            }
        } else {
            DeployToolWindow.addComponentToPanelWorkaround(inspector, this.inspectorPanel);
            this.inspectorPanel.doLayout();
        }
        inspector.setInspectorDescriptor(inspectable);
        this.inspectingLabel.setTitle(DeployToolWindow.INSPECTING_LABEL(this.getDescriptorTreeView().getSelectionAsString()));
        return inspector;
    }

    private String extractFileToTmpDir(String jarFile, Descriptor selectedDescriptor) {
        File tmpJarFile = null;
        try {
            tmpJarFile = new File(System.getProperty("java.io.tmpdir"));
            tmpJarFile = new File(tmpJarFile, jarFile);
            BundleDescriptor bd2 = (BundleDescriptor)selectedDescriptor;
            bd2.getApplication().getApplicationArchivist().extractBundleToFile(bd2, tmpJarFile);
            tmpJarFile.deleteOnExit();
        }
        catch (IOException e10) {
            UIUtils.println(localStrings.getLocalString("ui.deploytoolwindow.error_extracting_files", "{0} trying to extract file [{1}] to Temp Dir. Starting verifier without initial file seeded in ''Items to be Verified'' panel.", new Object[]{e10.getMessage(), jarFile}));
            return "";
        }
        return tmpJarFile.getAbsolutePath();
    }

    public void openConfigDlgAction() {
        if (this.configInstFrame == null) {
            this.configInstFrame = new ConfigurationDialog((Frame)this, null);
        } else {
            this.configInstFrame.refresh(null);
            this.configInstFrame.setVisible(true);
        }
    }

    public void verifyAction() {
        Descriptor selectedDescriptor = this.getDescriptorTreeView().getSelectedSaveableDescriptor();
        if (selectedDescriptor != null && selectedDescriptor instanceof Application) {
            if (this.verifierFrame == null) {
                this.verifierFrame = new MainFrame(((Application)selectedDescriptor).getApplicationArchivist().getApplicationFile().getAbsolutePath(), false);
            } else {
                this.verifierFrame.getMainPanel().reset();
                this.verifierFrame.getMainPanel().setJarFilename(((Application)selectedDescriptor).getApplicationArchivist().getApplicationFile().getAbsolutePath());
            }
        } else if (selectedDescriptor != null && selectedDescriptor instanceof EjbBundleDescriptor) {
            if (this.verifierFrame == null) {
                this.verifierFrame = new MainFrame(this.extractFileToTmpDir(((EjbBundleArchivist)((EjbBundleDescriptor)selectedDescriptor).getArchivist()).getEjbJarFile().getName(), selectedDescriptor), false);
            } else {
                this.verifierFrame.getMainPanel().reset();
                this.verifierFrame.getMainPanel().setJarFilename(this.extractFileToTmpDir(((EjbBundleArchivist)((EjbBundleDescriptor)selectedDescriptor).getArchivist()).getEjbJarFile().getName(), selectedDescriptor));
            }
        } else if (selectedDescriptor != null && selectedDescriptor instanceof WebBundleDescriptor) {
            if (this.verifierFrame == null) {
                this.verifierFrame = new MainFrame(this.extractFileToTmpDir(((WebBundleArchivist)((WebBundleDescriptor)selectedDescriptor).getArchivist()).getWebJarFile().getName(), selectedDescriptor), false);
            } else {
                this.verifierFrame.getMainPanel().reset();
                this.verifierFrame.getMainPanel().setJarFilename(this.extractFileToTmpDir(((WebBundleArchivist)((WebBundleDescriptor)selectedDescriptor).getArchivist()).getWebJarFile().getName(), selectedDescriptor));
            }
        } else if (selectedDescriptor != null && selectedDescriptor instanceof ApplicationClientDescriptor) {
            if (this.verifierFrame == null) {
                this.verifierFrame = new MainFrame(this.extractFileToTmpDir(((ApplicationClientArchivist)((ApplicationClientDescriptor)selectedDescriptor).getArchivist()).getApplicationClientJarFile().getName(), selectedDescriptor), false);
            } else {
                this.verifierFrame.getMainPanel().reset();
                this.verifierFrame.getMainPanel().setJarFilename(this.extractFileToTmpDir(((ApplicationClientArchivist)((ApplicationClientDescriptor)selectedDescriptor).getArchivist()).getApplicationClientJarFile().getName(), selectedDescriptor));
            }
        } else if (this.verifierFrame == null) {
            this.verifierFrame = new MainFrame();
        }
        ((Component)this.verifierFrame).setBounds(this.getBounds().x + 20, this.getBounds().y + 20, this.getBounds().width + 50, this.getBounds().height);
        ((Component)this.verifierFrame).setVisible(true);
    }

    public void descriptorViewerAction() {
        Descriptor selectedDescriptor = this.getDescriptorTreeView().getSelectedSaveableDescriptor();
        if (this.viewer == null) {
            this.viewer = new DescriptorViewer(this);
        }
        if (selectedDescriptor != null) {
            this.viewer.setDescriptor(selectedDescriptor);
            this.viewer.setVisible(true);
        } else {
            UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.deploytoolwindow.select_an_app", "Please select an application first"));
        }
    }

    public void addServerAction() {
        AddServerDialog addServerDialog = new AddServerDialog(this);
        addServerDialog.show();
    }

    public void showAboutBox() {
        AboutDialog a = new AboutDialog(this);
        a.setVisible(true);
    }

    public void removeServerAction() {
        String currentServer = DT.getServerManager().getCurrentServer();
        if (currentServer != null) {
            if (UIOptionPane.showConfirmDialog(this, DeployToolWindow.OKTOREMOVE_SERVER(currentServer))) {
                DT.getServerManager().removeServer(currentServer);
            }
        } else {
            UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.deploytoolwindow.selectservertoremove", "Please select a server to remove"));
        }
    }

    public void saveAction() {
        try {
            ApplicationManager appMgr = DT.getApplicationManager();
            Application app = appMgr.getActiveApplication();
            if (app != null) {
                appMgr.saveApplication(app);
                return;
            }
            StandAloneManager saMgr = DT.getStandAloneManager();
            Descriptor desc = saMgr.getActiveStandAlone();
            if (desc != null) {
                saMgr.saveStandAlone(desc);
                return;
            }
            this.selectApplicationDialog();
        }
        catch (Throwable t2) {
            UIUtils.printException("Saving", t2);
            UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.deploytoolwindow.save_failed", "Save failed."));
        }
    }

    public void saveAsAction() {
        try {
            this.saveAs();
        }
        catch (Throwable t2) {
            UIUtils.printException("Saving As", t2);
            UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.deploytoolwindow.error_saving", "There was an error saving the selected component or application:\n{0}", new Object[]{t2.getMessage()}));
        }
    }

    private void saveAs() throws Exception {
        Descriptor toSave = this.getDescriptorTreeView().getSelectedSaveableDescriptor();
        if (toSave != null) {
            if (toSave instanceof BundleDescriptor) {
                Application app;
                BundleDescriptor bd2 = (BundleDescriptor)toSave;
                String label = "";
                label = bd2 instanceof ConnectorDescriptor ? localStrings.getLocalString("ui.deploytoolwindow.save_rar_as", "Save RAR As") : (bd2 instanceof EjbBundleDescriptor ? localStrings.getLocalString("ui.deploytoolwindow.save_ejb_jar_as", "Save EJB JAR As") : (bd2 instanceof WebBundleDescriptor ? localStrings.getLocalString("ui.deploytoolwindow.save_war_as", "Save WAR As") : (bd2 instanceof ApplicationClientDescriptor ? localStrings.getLocalString("ui.deploytoolwindow.save_app_client_as", "Save Application Client As") : localStrings.getLocalString("ui.deploytoolwindow.unknown", "Unknown"))));
                this.fileChooser.rescanCurrentDirectory();
                int rtn = this.fileChooser.showDialog(this, label);
                if (rtn != 0) {
                    return;
                }
                File newFile = this.fileChooser.getSelectedFile();
                if (newFile.exists()) {
                    boolean overwrite = UIOptionPane.showConfirmDialog(this, DeployToolWindow.ALREADY_EXISTS(newFile));
                    if (!overwrite) {
                        return;
                    }
                    newFile.delete();
                }
                if ((app = bd2.getApplication()) != null) {
                    app.getApplicationArchivist().extractBundleToFile(bd2, newFile);
                    UIOptionPane.showInfoDialog(this, DeployToolWindow.WAS_SAVED(bd2.getName(), newFile.toString()));
                    return;
                }
                StandAloneManager sam = DT.getStandAloneManager();
                if (sam.isStandAloneDescriptor(bd2)) {
                    sam.saveStandAloneAs(bd2, newFile);
                    UIOptionPane.showInfoDialog(this, DeployToolWindow.WAS_SAVED(bd2.getName(), newFile.toString()));
                    return;
                }
                UIUtils.debugPrintln("Object has no application: " + bd2.getClass().getName());
            } else if (toSave instanceof Application) {
                Application application = (Application)toSave;
                File currentFile = application.getApplicationArchivist().getApplicationFile();
                this.fileChooser.rescanCurrentDirectory();
                int rtn = this.fileChooser.showDialog(this, localStrings.getLocalString("ui.deploytoolwindow.save_app_as", "Save Application As"));
                if (rtn == 0) {
                    ApplicationManager appMgr = DT.getApplicationManager();
                    File newFile = this.fileChooser.getSelectedFile();
                    if (newFile.exists() && !newFile.isDirectory()) {
                        if (newFile.equals(currentFile)) {
                            UIUtils.debugPrintln("Invoking standard 'Save'");
                            appMgr.saveApplication(application);
                            return;
                        }
                        Application newApp = appMgr.getApplicationWithJar(newFile);
                        if (newApp != null) {
                            UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.deploytoolwindow.please_close_app", "The selected file ({0}) is owned by the open application ''{1}''.\nYou must first close ''{1}'' before overwriting its archive file.", new Object[]{newFile.getPath(), newApp.getName()}));
                            return;
                        }
                        boolean overwrite = UIOptionPane.showConfirmDialog(this, DeployToolWindow.ALREADY_EXISTS(newFile));
                        if (!overwrite) {
                            return;
                        }
                        newFile.delete();
                    }
                    appMgr.saveAsApplication(application, newFile);
                }
            }
        } else {
            UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.deploytoolwindow.no_object_selected", "No object was selected."));
        }
    }

    private File createNewClipboardFile() throws IOException {
        if (this.clipboard != null && this.clipboard.exists()) {
            this.clipboard.delete();
        }
        this.clipboard = File.createTempFile(CLIPBOARD_J2EE, CLIPBOARD);
        this.clipboard.deleteOnExit();
        return this.clipboard;
    }

    private Component getTransferActionComponent() {
        return SwingUtilities.findFocusOwner(this.getWorkspacePanel());
    }

    public void cutAction() {
        if (this.copyAction(true)) {
            this.deleteAction();
        }
    }

    public void copyAction() {
        this.copyAction(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean copyAction(boolean isCutAction) {
        Component c10 = this.getTransferActionComponent();
        if (c10 instanceof JTextComponent) {
            ((JTextComponent)c10).grabFocus();
            ((JTextComponent)c10).copy();
            return true;
        }
        Descriptor selCopy = null;
        if (c10 instanceof InspectorEventDelegator) {
            InspectorEventDelegator ied = (InspectorEventDelegator)c10;
            if (!ied.isValidInspector()) return false;
            selCopy = ied.getDescriptor();
        } else if (c10 instanceof JTree || c10 == null) {
            selCopy = this.treeView.getSelectedDescriptor();
        } else {
            UIUtils.debugPrintln("'" + (isCutAction ? "Cut" : "Copy") + "' was pressed on component - " + c10.getClass().getName());
            return false;
        }
        if (selCopy == null) {
            String msg = isCutAction ? localStrings.getLocalString("ui.deploytoolwindow.nothing_to_cut", "Nothing to cut") : localStrings.getLocalString("ui.deploytoolwindow.nothing_to_copy", "Nothing to copy");
            UIOptionPane.showWarningDialog(this, msg);
            return false;
        }
        if (isCutAction && (selCopy instanceof DeployedAppDescriptor || selCopy instanceof DeployedObjectDescriptor)) {
            UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.deploytoolwindow.please_use_undeploy", "Please use 'Undeploy' to remove deployed objects"));
            return false;
        }
        try {
            File clipboard = this.createNewClipboardFile();
            if (selCopy instanceof Application) {
                Application application = (Application)selCopy;
                boolean wasDirty = application.isDirty();
                ApplicationArchivist oldArchivist = application.getApplicationArchivist();
                File appFile = oldArchivist.getApplicationFile();
                oldArchivist.save(clipboard, true);
                oldArchivist.setApplicationFile(appFile);
                if (!wasDirty) return true;
                application.changed(true);
                return true;
            }
            if (selCopy instanceof EjbBundleDescriptor) {
                EjbBundleDescriptor ebd = (EjbBundleDescriptor)selCopy;
                Application application = ebd.getApplication();
                application.getApplicationArchivist().extractBundleToFile(ebd, clipboard);
                return true;
            }
            if (selCopy instanceof WebBundleDescriptor) {
                WebBundleDescriptor wbd = (WebBundleDescriptor)selCopy;
                Application application = wbd.getApplication();
                application.getApplicationArchivist().extractBundleToFile(wbd, clipboard);
                return true;
            }
            if (selCopy instanceof ConnectorDescriptor) {
                ConnectorDescriptor cd2 = (ConnectorDescriptor)selCopy;
                boolean wasDirty = cd2.isDirty();
                Application app = cd2.getApplication();
                if (app != null) {
                    app.getApplicationArchivist().extractBundleToFile(cd2, clipboard);
                } else {
                    DT.getStandAloneManager().saveStandAloneAs(cd2, clipboard);
                }
                if (!wasDirty) return true;
                cd2.setVendorName(cd2.getVendorName());
                return true;
            }
            if (!(selCopy instanceof ServerDescriptor)) return false;
            clipboard.delete();
            return false;
        }
        catch (Throwable t2) {
            UIUtils.debugPrintln("Error copying: " + t2.toString());
            UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.deploytoolwindow.error_while_copying", "Error while copying"));
        }
        return false;
    }

    public void pasteAction() {
        Component c10 = this.getTransferActionComponent();
        if (c10 instanceof JTextComponent) {
            ((JTextComponent)c10).grabFocus();
            ((JTextComponent)c10).paste();
            return;
        }
        Descriptor selPaste = null;
        if (c10 instanceof InspectorEventDelegator) {
            InspectorEventDelegator ied = (InspectorEventDelegator)c10;
            if (ied.isValidInspector()) {
                selPaste = ied.getDescriptor();
            }
        } else if (c10 instanceof JTree || c10 == null) {
            selPaste = this.treeView.getSelectedDescriptor();
        } else {
            UIUtils.debugPrintln("'Paste' was pressed on component - " + c10.getClass().getName());
            return;
        }
        if (selPaste == null) {
            UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.deploytoolwindow.choose_an_application", "Choose an application onto which to paste"));
            return;
        }
        if (selPaste instanceof ServerDescriptor) {
            return;
        }
        if (selPaste instanceof DeployedAppDescriptor || selPaste instanceof DeployedObjectDescriptor) {
            return;
        }
        Application targetApplication = DT.getApplicationManager().getActiveApplication();
        if (targetApplication == null) {
            UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.deploytoolwindow.choose_an_application", "Choose an application onto which to paste"));
            return;
        }
        if (this.clipboard == null || !this.clipboard.exists()) {
            UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.deploytoolwindow.nothing_to_paste", "Nothing to paste"));
            return;
        }
        try {
            ApplicationArchivist appArch = targetApplication.getApplicationArchivist();
            if (ApplicationArchivist.isApplication(this.clipboard)) {
                appArch.addApplicationJar(this.clipboard);
            } else if (EjbBundleArchivist.isEjbBundle(this.clipboard)) {
                appArch.addEjbJar(this.clipboard);
            } else if (WebBundleArchivist.isWebBundle(this.clipboard)) {
                appArch.addWebJar(this.clipboard);
            } else if (ConnectorArchivist.isConnector(this.clipboard)) {
                appArch.addRar(this.clipboard, new HashSet());
            } else {
                UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.deploytoolwindow.nothing_to_paste", "Nothing to paste"));
            }
        }
        catch (Throwable t2) {
            UIUtils.printException("Paste", t2);
            UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.deploytoolwindow.error_while_pasting", "Error while pasting"));
        }
    }

    public void deleteAction() {
        Component c10 = this.getTransferActionComponent();
        if (c10 instanceof JTextComponent) {
            ((JTextComponent)c10).cut();
            return;
        }
        Descriptor selDelete = null;
        Descriptor selParent = null;
        if (c10 instanceof InspectorEventDelegator) {
            InspectorEventDelegator ied = (InspectorEventDelegator)c10;
            if (ied.isValidInspector()) {
                selDelete = ied.getDescriptor();
                selParent = null;
            }
        } else if (c10 instanceof JTree || c10 == null) {
            selDelete = this.treeView.getSelectedDescriptor();
            selParent = this.treeView.getSelectedParent();
        } else {
            UIUtils.debugPrintln("'Delete' was pressed on component - " + c10.getClass().getName());
            return;
        }
        if (selDelete == null) {
            UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.deploytoolwindow.no_object_selected", "No object was selected"));
            return;
        }
        if (selDelete instanceof ServerDescriptor) {
            UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.deploytoolwindow.please_use_remove_server", "Please use 'Remove Server' to remove this server"));
            return;
        }
        if (selDelete instanceof Application) {
            UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.deploytoolwindow.please_use_close_app", "Please use 'Close' to close this Application"));
            return;
        }
        StandAloneManager sam = DT.getStandAloneManager();
        if (sam.isStandAloneDescriptor(selDelete)) {
            UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.deploytoolwindow.please_use_close_obj", "Please use 'Close' to close this object"));
            return;
        }
        if (selDelete instanceof DeployedObjectDescriptor) {
            UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.deploytoolwindow.please_use_undeploy", "Please use 'Undeploy' to remove deployed objects"));
            return;
        }
        boolean opt = UIOptionPane.showConfirmDialog(this, DeployToolWindow.OKTODELETE_SELECTION(selDelete.getName()));
        if (!opt) {
            return;
        }
        if (c10 instanceof JTree || c10 == null) {
            this.treeView.setSelectedDescriptor(selParent, false);
        }
        if (selDelete instanceof BundleDescriptor) {
            BundleDescriptor bd2 = (BundleDescriptor)selDelete;
            try {
                Application app = bd2.getApplication();
                if (app != null) {
                    app.getApplicationArchivist().removeBundleDescriptor(bd2);
                } else {
                    UIUtils.debugPrintln("BundleDescriptor is not part of an Application");
                }
            }
            catch (Throwable t2) {
                if (UIUtils.debugMode()) {
                    UIUtils.printException("Delete failed", t2);
                }
                UIOptionPane.showErrorDialog(this, DeployToolWindow.DELETE_FAILED(t2.toString()));
            }
            return;
        }
        try {
            ApplicationManager appMgr = DT.getApplicationManager();
            Application app = appMgr.getActiveApplication();
            app.getApplicationArchivist().removeDescriptor(selDelete);
        }
        catch (Throwable t3) {
            if (UIUtils.debugMode()) {
                UIUtils.printException("Delete failed", t3);
            }
            UIOptionPane.showErrorDialog(this, DeployToolWindow.DELETE_FAILED(t3.toString()));
        }
    }

    public void newEjbJarAction() {
        ApplicationManager appMgr = DT.getApplicationManager();
        if (appMgr.getApplications().size() <= 0) {
            this.showNeedApplicationDialog();
            return;
        }
        NewEjbWizard nejbw = new NewEjbWizard(this);
        Object target = nejbw.getSelectedParentDescriptor();
        if (nejbw.didComplete() && target != null) {
            this.addEjbJar(nejbw.getEjbBundleDescriptor(), nejbw.getArchiveFileContentsDescriptor(), (Descriptor)target);
        }
    }

    public void addEjbJarAction() {
        Application app = DT.getApplicationManager().getActiveApplication();
        if (app == null) {
            this.selectApplicationDialog();
            return;
        }
        this.fileChooser.rescanCurrentDirectory();
        this.fileChooser.setFileSelectionMode(0);
        int rtn = this.fileChooser.showDialog(this, localStrings.getLocalString("ui.deploytoolwindow.open_ejb_jar", "Add EJB JAR"));
        if (rtn == 0) {
            File ejbJarFile = this.fileChooser.getSelectedFile();
            this.addEjbJar(ejbJarFile, app);
        }
    }

    private void addEjbJar(EjbBundleDescriptor newEjbBundleDescriptor, FileContentsDescriptor fcd, Descriptor target) {
        if (newEjbBundleDescriptor == null) {
            UIUtils.printImplementationError("DeployToolWindow.addEjbJar", "Specified EJB Bundle Descriptor is 'null'");
            this.showErrorAddingDialog();
            return;
        }
        Application app = null;
        if (target instanceof Application) {
            app = (Application)target;
        } else if (target instanceof EjbBundleDescriptor) {
            app = ((EjbBundleDescriptor)target).getApplication();
        }
        if (app == null) {
            UIUtils.printImplementationError("DeployToolWindow.addEjbJar", "No specified application");
            this.showErrorAddingDialog();
            return;
        }
        ApplicationArchivist appArch = app.getApplicationArchivist();
        Archivist oldArchivist = newEjbBundleDescriptor.getArchivist();
        Set libraryJarURIs = oldArchivist != null ? oldArchivist.getManifestClasspaths() : new HashSet();
        try {
            appArch.addEjbJar(newEjbBundleDescriptor, fcd, libraryJarURIs, target);
        }
        catch (Throwable t2) {
            UIUtils.printException("Adding EJB JAR", t2);
            this.showErrorAddingDialog();
            return;
        }
        this.getDescriptorTreeView().expandDescriptor(app);
    }

    private void addEjbJar(File ejbJarFile, Descriptor target) {
        try {
            if (!EjbBundleArchivist.isEjbBundle(ejbJarFile)) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.deploytoolwindow.not_valid_ejb_jar", "{0} does not appear to be a valid EJB JAR", new Object[]{ejbJarFile.getName()}));
                return;
            }
        }
        catch (Throwable t2) {
            UIUtils.printException("Adding EJB JAR", t2);
            this.showErrorAddingDialog();
            return;
        }
        Application app = null;
        if (!(target instanceof Application)) {
            UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.deploytoolwindow.select_app_or_ejb_jar", "Please select either an application or an ejb JAR"));
            return;
        }
        app = (Application)target;
        try {
            app.addEjbJarFile(ejbJarFile);
        }
        catch (Throwable t3) {
            UIUtils.printException("Adding EJB JAR", t3);
            this.showErrorAddingDialog();
            return;
        }
        this.getDescriptorTreeView().expandDescriptor(app);
    }

    public void newWebComponentAction() {
        ApplicationManager appMgr = DT.getApplicationManager();
        if (appMgr.getApplications().size() <= 0) {
            this.showNeedApplicationDialog();
            return;
        }
        NewWebComponentWizard wcw = new NewWebComponentWizard(this);
        Object target = wcw.getSelectedParentDescriptor();
        if (wcw.didComplete() && target != null) {
            this.addWebComponent(wcw.getWebBundleDescriptor(), wcw.getArchiveClassDescriptor(), wcw.getArchiveFileContentsDescriptor(), (Descriptor)target);
        }
    }

    public void addWebComponentAction() {
        Application app = DT.getApplicationManager().getActiveApplication();
        if (app == null) {
            this.selectApplicationDialog();
            return;
        }
        this.fileChooser.rescanCurrentDirectory();
        this.fileChooser.setFileSelectionMode(0);
        int rtn = this.fileChooser.showDialog(this, localStrings.getLocalString("ui.deploytoolwindow.add_web_war", "Add Web WAR"));
        if (rtn == 0) {
            File webJarFile = this.fileChooser.getSelectedFile();
            this.addWebComponent(webJarFile, app);
        }
    }

    private void addWebComponent(File webFile, Descriptor target) {
        try {
            if (!WebBundleArchivist.isWebBundle(webFile)) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.deploytoolwindow.not_valid_web_war", "{0} does not appear to be a valid web JAR", new Object[]{webFile.getName()}));
                return;
            }
        }
        catch (Throwable t2) {
            UIUtils.printException("Adding Web Component", t2);
            this.showErrorAddingDialog();
            return;
        }
        Application app = null;
        if (!(target instanceof Application)) {
            UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.deploytoolwindow.select_app_or_web_war", "Please select either an application or a Web WAR"));
            return;
        }
        app = (Application)target;
        try {
            app.addWebJarFile(webFile);
        }
        catch (Throwable t3) {
            UIUtils.printException("Adding Web Component", t3);
            this.showErrorAddingDialog();
            return;
        }
        this.getDescriptorTreeView().expandDescriptor(app);
    }

    private void addWebComponent(WebBundleDescriptor newWebBundleDescriptor, FileContentsDescriptor classes, FileContentsDescriptor staticContent, Descriptor target) {
        if (newWebBundleDescriptor == null) {
            UIUtils.printImplementationError("Specified Web Bundle Descriptor is 'null'");
            this.showErrorAddingDialog();
            return;
        }
        Application app = null;
        if (target instanceof Application) {
            app = (Application)target;
        } else if (target instanceof WebBundleDescriptor) {
            app = ((WebBundleDescriptor)target).getApplication();
        }
        if (app == null) {
            UIUtils.printImplementationError("No specified application");
            this.showErrorAddingDialog();
            return;
        }
        ApplicationArchivist appArch = app.getApplicationArchivist();
        try {
            appArch.addWebComponent(newWebBundleDescriptor, classes, staticContent, target);
        }
        catch (Throwable t2) {
            UIUtils.printException("Adding Web Component", t2);
            this.showErrorAddingDialog();
            return;
        }
        this.getDescriptorTreeView().expandDescriptor(app);
    }

    public void newAppClientAction() {
        ApplicationManager appMgr = DT.getApplicationManager();
        if (appMgr.getApplications().size() <= 0) {
            this.showNeedApplicationDialog();
            return;
        }
        TreeCombo targetChooser = this.getDescriptorTreeView().getApplicationsCombo(DescriptorTreeView.AppType_AppsOnly);
        targetChooser.setSelectedDescriptor(DT.getApplicationManager().getActiveApplication());
        NewAppClientWizard acw = new NewAppClientWizard((Frame)this, targetChooser);
        Object target = targetChooser.getSelectedDescriptor();
        if (acw.didComplete() && target != null) {
            this.addApplicationClient(acw.getApplicationClientDescriptor(), acw.getFileContentsDescriptor(), (Application)target);
        }
    }

    public void addApplicationClientAction() {
        Application app = DT.getApplicationManager().getActiveApplication();
        if (app == null) {
            this.selectApplicationDialog();
            return;
        }
        this.fileChooser.rescanCurrentDirectory();
        this.fileChooser.setFileSelectionMode(0);
        int rtn = this.fileChooser.showDialog(this, localStrings.getLocalString("ui.deploytoolwindow.add_app_client_jar", "Add Application Client JAR"));
        if (rtn == 0) {
            File jarFile = this.fileChooser.getSelectedFile();
            this.addApplicationClient(jarFile, app);
        }
    }

    private void addApplicationClient(File jarFile, Application app) {
        try {
            if (!ApplicationClientArchivist.isApplicationClientJar(jarFile)) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.deploytoolwindow.not_valid_app_client", "{0} does not appear to be a valid Application Client JAR", new Object[]{jarFile.getName()}));
                return;
            }
        }
        catch (Throwable t2) {
            UIUtils.printException("Adding Application Client", t2);
            this.showErrorAddingDialog();
            return;
        }
        try {
            app.getApplicationArchivist().addApplicationClientJar(jarFile, new HashSet());
        }
        catch (Throwable t3) {
            UIUtils.printException("Adding Application Client", t3);
            this.showErrorAddingDialog();
            return;
        }
        this.getDescriptorTreeView().expandDescriptor(app);
    }

    private void addApplicationClient(ApplicationClientDescriptor descriptor, FileContentsDescriptor fcd, Application app) {
        try {
            Archivist oldArchivist = descriptor.getArchivist();
            Set libraryJarURIs = oldArchivist != null ? oldArchivist.getManifestClasspaths() : new HashSet();
            app.getApplicationArchivist().addApplicationClient(descriptor, fcd, libraryJarURIs, app);
        }
        catch (Throwable t2) {
            UIUtils.printException("Adding Application Client", t2);
            this.showErrorAddingDialog();
            return;
        }
        this.getDescriptorTreeView().expandDescriptor(app);
    }

    public void newConnectionFactoryAction() {
        ConnectionFactoryDialog.showNewDialog(this);
    }

    public void newResourceAdapterAction() {
        NewResAdaptWizard raw;
        TreeCombo targetChooser = null;
        ApplicationManager appMgr = DT.getApplicationManager();
        if (appMgr.getApplications().size() > 0) {
            targetChooser = this.getDescriptorTreeView().getApplicationsCombo(DescriptorTreeView.AppType_AppsOnly);
            targetChooser.setSelectedDescriptor(DT.getApplicationManager().getActiveApplication());
        }
        if ((raw = new NewResAdaptWizard((Frame)this, targetChooser)).didComplete()) {
            ConnectorDescriptor cd2 = raw.getCurrentConnectorDescriptor();
            if (raw.isStandAlone()) {
                this.newStandAloneResourceAdapter(raw.getCurrentConnectorDescriptor(), raw.getFileContentsDescriptor(), raw.getStandAloneArchiveFileName());
            } else {
                Object target = targetChooser.getSelectedDescriptor();
                this.addApplicationResourceAdapter(raw.getCurrentConnectorDescriptor(), raw.getFileContentsDescriptor(), (Application)target);
            }
        }
    }

    public void newStandAloneResourceAdapter(ConnectorDescriptor descriptor, FileContentsDescriptor fcd, String archiveFileName) {
        try {
            StandAloneManager sam = DT.getStandAloneManager();
            Archivist oldArchivist = descriptor.getArchivist();
            Set libraryJarURIs = oldArchivist != null ? oldArchivist.getManifestClasspaths() : new HashSet();
            ConnectorArchivist ca2 = new ConnectorArchivist(false, archiveFileName, descriptor, libraryJarURIs);
            Hashtable entriesToFileNames = ca2.createEntryNameMap(fcd);
            ca2.addFiles(entriesToFileNames);
            ca2.save(new File(ca2.getArchiveUri()));
            sam.addStandAlone(descriptor);
            this.getDescriptorTreeView().expandDescriptor(descriptor);
        }
        catch (Throwable t2) {
            UIUtils.printException("Adding Resource Adapter", t2);
            this.showErrorAddingDialog();
            return;
        }
    }

    public void addResourceAdapterAction() {
        Application app = DT.getApplicationManager().getActiveApplication();
        if (app == null) {
            this.selectApplicationDialog();
            return;
        }
        this.fileChooser.rescanCurrentDirectory();
        this.fileChooser.setFileSelectionMode(0);
        int rtn = this.fileChooser.showDialog(this, localStrings.getLocalString("ui.deploytoolwindow.add_resource_adapter_jar", "Add Resource Adapter RAR"));
        if (rtn == 0) {
            File jarFile = this.fileChooser.getSelectedFile();
            this.addApplicationResourceAdapter(jarFile, app);
        }
    }

    private void addApplicationResourceAdapter(File jarFile, Application app) {
        try {
            if (!ConnectorArchivist.isConnector(jarFile)) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.deploytoolwindow.not_valid_resource_adapter", "{0} does not appear to be a valid Resource Adapter JAR", new Object[]{jarFile.getName()}));
                return;
            }
        }
        catch (Throwable t2) {
            UIUtils.printException("Adding Resource Adapter", t2);
            this.showErrorAddingDialog();
            return;
        }
        try {
            app.getApplicationArchivist().addRar(jarFile, new HashSet());
        }
        catch (Throwable t3) {
            UIUtils.printException("Adding Resource Adapter", t3);
            this.showErrorAddingDialog();
            return;
        }
        this.getDescriptorTreeView().expandDescriptor(app);
    }

    private void addApplicationResourceAdapter(ConnectorDescriptor descriptor, FileContentsDescriptor fcd, Application app) {
        try {
            Archivist oldArchivist = descriptor.getArchivist();
            Set libraryJarURIs = oldArchivist != null ? oldArchivist.getManifestClasspaths() : new HashSet();
            app.getApplicationArchivist().addRar(descriptor, fcd, libraryJarURIs, app);
        }
        catch (Throwable t2) {
            UIUtils.printException("Adding Resource Adapter", t2);
            this.showErrorAddingDialog();
            return;
        }
        this.getDescriptorTreeView().expandDescriptor(app);
    }

    void showErrorAddingDialog() {
        UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.deploytoolwindow.error_importing", "There was an error importing component(s) into this application.\nThe application file has not been updated."));
    }

    private void selectApplicationDialog() {
        UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.deploytoolwindow.select_app_first", "Please select an application first."));
    }

    private void showNeedApplicationDialog() {
        UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.deploytoolwindow.create_new_app", "Please create a new application to hold your components."));
    }

    private void _openApplication(File applicationFile) {
        ApplicationManager appMgr = DT.getApplicationManager();
        Application opennedApp = appMgr.getApplicationWithJar(applicationFile);
        if (opennedApp != null) {
            boolean doUpdate = UIOptionPane.showConfirmDialog(this, localStrings.getLocalString("ui.deploytoolwindow.already_open_continue_updating", "{0} is already open. Continue by updating {0} from disk ?", new Object[]{opennedApp.getName()}));
            if (doUpdate) {
                appMgr.closeApplication(opennedApp);
            } else {
                return;
            }
        }
        try {
            if (!ApplicationArchivist.isApplication(applicationFile)) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.deploytoolwindow.not_valid_app_jar", "{0} does not appear to be a valid application JAR", new Object[]{applicationFile.getName()}));
                return;
            }
        }
        catch (Throwable t2) {
            UIUtils.printException("Openning Application", t2);
            UIOptionPane.showErrorDialog(this, DeployToolWindow.IS_CORRUPT(applicationFile.getName()));
            return;
        }
        try {
            appMgr.openApplication(applicationFile);
        }
        catch (Throwable t3) {
            UIUtils.printException("Openning Application", t3);
            UIOptionPane.showErrorDialog(this, DeployToolWindow.IS_CORRUPT(applicationFile.getName()));
            return;
        }
        Application app = appMgr.getActiveApplication();
        this.getDescriptorTreeView().expandDescriptor(app);
        this.refreshInspectorFor(app);
    }

    private void _openResourceAdapter(File rarFile) {
        StandAloneManager saMgr = DT.getStandAloneManager();
        Descriptor opennedDesc = saMgr.getStandAloneWithJar(rarFile);
        if (opennedDesc != null) {
            boolean doUpdate = UIOptionPane.showConfirmDialog(this, localStrings.getLocalString("ui.deploytoolwindow.already_open_continue_updating", "{0} is already open. Continue by updating {0} from disk ?", new Object[]{opennedDesc.getName()}));
            if (doUpdate) {
                saMgr.closeStandAlone(opennedDesc);
            } else {
                return;
            }
        }
        try {
            if (!ConnectorArchivist.isConnector(rarFile)) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.deploytoolwindow.not_valid_resource_adapter", "{0} does not appear to be a valid Resource Adapter JAR", new Object[]{rarFile.getName()}));
                return;
            }
        }
        catch (Throwable t2) {
            UIUtils.printException("Openning Resource Adapter", t2);
            UIOptionPane.showErrorDialog(this, DeployToolWindow.IS_CORRUPT(rarFile.getName()));
            return;
        }
        try {
            saMgr.openStandAlone(rarFile);
        }
        catch (Throwable t3) {
            UIUtils.printException("Openning Resource Adapter", t3);
            UIOptionPane.showErrorDialog(this, DeployToolWindow.IS_CORRUPT(rarFile.getName()));
            return;
        }
        Descriptor desc = saMgr.getActiveStandAlone();
        this.getDescriptorTreeView().expandDescriptor(desc);
        this.refreshInspectorFor(desc);
    }

    private Application _createStandAloneApp(File jarFile) {
        File tmpDir = UIConfig.getTempDirectory();
        if (tmpDir == null) {
            tmpDir = new File("");
            UIUtils.debugPrintln("No temp dir found");
        } else {
            File appTmpDir = new File(tmpDir, APP_TEMP_SUBDIR);
            if (!appTmpDir.exists()) {
                appTmpDir.mkdirs();
                if (appTmpDir.isDirectory()) {
                    tmpDir = appTmpDir;
                } else {
                    UIUtils.debugPrintln("Could not create dirs: " + appTmpDir.getPath());
                }
            } else if (appTmpDir.isDirectory()) {
                tmpDir = appTmpDir;
            } else {
                UIUtils.debugPrintln("File exists and is not a directory: " + appTmpDir.getPath());
            }
        }
        String appName = "app." + jarFile.getName().replace('.', '_');
        File appFile = new File(tmpDir, appName + DOT_EAR);
        int i2 = 1;
        while (appFile.exists()) {
            appFile = new File(tmpDir, appName + "_" + i2 + DOT_EAR);
            ++i2;
        }
        String appFilename = appFile.toString();
        if (this.addModuleDialog == null) {
            this.addModuleDialog = new AddModuleDialog();
        }
        this.addModuleDialog.setApplicationName(appName, appFilename);
        this.addModuleDialog.show();
        if (!this.addModuleDialog.isOk()) {
            return null;
        }
        Application app = null;
        if (this.addModuleDialog.addToNewApplication()) {
            appName = this.addModuleDialog.getApplicationName();
            appFilename = this.addModuleDialog.getApplicationFilename();
            ApplicationManager appMgr = DT.getApplicationManager();
            app = appMgr.newApplication(appName, appFilename);
            app.setDescription("");
        } else {
            app = this.addModuleDialog.getExistingApplication();
        }
        return app;
    }

    public void openObjectAction() {
        this.fileChooser.setCurrentDirectory(UIConfig.getStartingDirectory());
        this.fileChooser.rescanCurrentDirectory();
        this.fileChooser.setFileSelectionMode(0);
        int returnValue = this.fileChooser.showDialog(this, localStrings.getLocalString("ui.deploytoolwindow.open_object", "Open Object"));
        if (returnValue != 0) {
            return;
        }
        ApplicationManager appMgr = DT.getApplicationManager();
        File file = this.fileChooser.getSelectedFile();
        try {
            if (ApplicationArchivist.isApplication(file)) {
                UIUtils.debugPrintln("Openning Application ...");
                this._openApplication(file);
            } else if (EjbBundleArchivist.isEjbBundle(file)) {
                UIUtils.debugPrintln("Openning EjbBundle ...");
                Application app = this._createStandAloneApp(file);
                if (app != null) {
                    this.addEjbJar(file, app);
                }
            } else if (WebBundleArchivist.isWebBundle(file)) {
                UIUtils.debugPrintln("Openning WebBundle ...");
                Application app = this._createStandAloneApp(file);
                if (app != null) {
                    this.addWebComponent(file, app);
                }
            } else if (ConnectorArchivist.isConnector(file)) {
                UIUtils.debugPrintln("Openning Connector ...");
                this._openResourceAdapter(file);
            } else if (ApplicationClientArchivist.isApplicationClientJar(file)) {
                UIUtils.debugPrintln("Openning ApplicationClient ...");
                Application app = this._createStandAloneApp(file);
                if (app != null) {
                    this.addApplicationClient(file, app);
                }
            }
            UIConfig.addStartingDirectory(file.getParentFile());
            UIConfig.saveConfig();
        }
        catch (IOException ex2) {
            UIOptionPane.showErrorDialog(this, DeployToolWindow.COULD_NOT_OPEN(file.toString(), ex2.getMessage()));
        }
    }

    public void newApplicationAction() {
        ApplicationManager appMgr = DT.getApplicationManager();
        NewAppDialog myDialog = new NewAppDialog(this, appMgr);
        myDialog.setVisible(true);
        Application application = appMgr.getActiveApplication();
        if (application != null) {
            this.refreshInspectorFor(application);
            this.rootTree.setSelectionPath(this.getDescriptorTreeView().getTreePathFor(application));
        }
    }

    public void updateAction(Boolean interactive) {
        this.updateAction((boolean)interactive);
    }

    public void updateAction(boolean interactive) {
        Application app = DT.getApplicationManager().getActiveApplication();
        if (app != null) {
            DT.getDeploymentManager().updateProjectFiles(app, interactive);
            return;
        }
        Descriptor desc = DT.getStandAloneManager().getActiveStandAlone();
        if (desc != null) {
            DT.getDeploymentManager().updateProjectFiles(desc, interactive);
            return;
        }
        this.selectApplicationDialog();
    }

    public void deployAction() {
        Descriptor desc = null;
        desc = DT.getApplicationManager().getActiveApplication();
        if (desc == null && (desc = DT.getStandAloneManager().getActiveStandAlone()) == null) {
            UIOptionPane.showWarningDialog(this, DeployToolWindow.NOTHING_SELECTED());
            return;
        }
        DT.getDeploymentManager().deployObject(desc);
    }

    public void undeployAction() {
        Descriptor d10 = this.getDescriptorTreeView().getSelectedServerObject();
        ServerGeneralInspector.undeployObject(this, new Object[]{d10});
        this.getDescriptorTreeView().clearSelection();
    }

    public void redeployAction() {
        Descriptor desc = null;
        desc = DT.getApplicationManager().getActiveApplication();
        if (desc == null && (desc = DT.getStandAloneManager().getActiveStandAlone()) == null) {
            UIOptionPane.showWarningDialog(this, DeployToolWindow.NOTHING_SELECTED());
            return;
        }
        DT.getDeploymentManager().redeployObject(desc);
    }

    public void closeAction() {
        ApplicationManager appMgr = DT.getApplicationManager();
        Application app = appMgr.getActiveApplication();
        if (app != null) {
            this.closeAction(app, appMgr);
            return;
        }
        StandAloneManager saMgr = DT.getStandAloneManager();
        Descriptor desc = saMgr.getActiveStandAlone();
        if (desc != null) {
            this.closeAction(desc, saMgr);
            return;
        }
        UIOptionPane.showWarningDialog(this, DeployToolWindow.NOTHING_SELECTED());
    }

    private void closeAction(Application app, ApplicationManager appMgr) {
        if (app.isDirty()) {
            int doSave = this.checkSave(app.getName());
            if (doSave == UIOptionPane.CANCEL_OPTION) {
                return;
            }
            if (doSave == UIOptionPane.YES_OPTION) {
                try {
                    appMgr.saveApplication(app);
                }
                catch (IOException ioe) {
                    Log.print(this, ioe);
                }
            }
        }
        appMgr.closeApplication(app);
        this.refreshInspectorFor(appMgr.getActiveApplication());
    }

    private void closeAction(Descriptor desc, StandAloneManager saMgr) {
        if (saMgr.isDirty(desc)) {
            int doSave = this.checkSave(desc.getName());
            if (doSave == UIOptionPane.CANCEL_OPTION) {
                return;
            }
            if (doSave == UIOptionPane.YES_OPTION) {
                try {
                    saMgr.saveStandAlone(desc);
                }
                catch (IOException ioe) {
                    Log.print(this, ioe);
                }
            }
        }
        saMgr.closeStandAlone(desc);
        this.refreshInspectorFor(saMgr.getActiveStandAlone());
    }

    private int checkSave(String applicationName) {
        return UIOptionPane.showConfirmDialog(this, localStrings.getLocalString("ui.deploytoolwindow.has_unsaved_changes", "{0} has unsaved changes. Save before closing?", new Object[]{applicationName}), null, UIOptionPane.YES_NO_CANCEL_OPTIONS);
    }

    public void exitAction() {
        try {
            DT.getApplicationManager().saveToUserHome();
            DT.getStandAloneManager().saveToUserHome();
            DT.getServerManager().saveToUserHome();
        }
        catch (Throwable t2) {
            UIUtils.printException("Saving on Exit", t2);
        }
        System.exit(0);
    }

    public void editRolesAction() {
        Application app = DT.getApplicationManager().getActiveApplication();
        if (app != null) {
            RolesDialog rolesDialog = RolesDialog.newRolesDialog(this, true);
            rolesDialog.showDialog(app);
        }
    }

    public String toString() {
        return localStrings.getLocalString("ui.deploytoolwindow.my_name", "Deploy Tool Window");
    }

    public void cloneInspectorAction(InspectorEventDelegator currentInspector) {
        if (currentInspector != null) {
            InspectorEventDelegator copy = currentInspector.makeCopy();
            Rectangle bounds = currentInspector.getBounds();
            Point scrLoc = currentInspector.getLocationOnScreen();
            ClonedInspectorFrame frame = new ClonedInspectorFrame(DeployToolWindow.INSPECTING_LABEL(this.getDescriptorTreeView().getSelectionAsString()), currentInspector);
            ((Component)frame).setBounds(scrLoc.x + 10, scrLoc.y + 10, bounds.width, bounds.height);
            frame.getContentPane().setLayout(new BorderLayout());
            DeployToolWindow.addComponentToPanelWorkaround(copy, frame.getContentPane());
            frame.addWindowListener(this);
            ((Component)frame).setVisible(true);
        }
    }

    public void cloneInspectorAction() {
        this.cloneInspectorAction(DT.getInspectorManager().getCurrentInspector());
    }

    public static void addComponentToPanelWorkaround(JComponent c10, Container p2) {
        try {
            p2.add(c10);
        }
        catch (Throwable t2) {
            p2.remove(c10);
            p2.add(c10);
        }
    }

    public void _addServer_state(String serverName, Boolean ok, Boolean show) {
        if (ok.booleanValue()) {
            UIUtils.debugPrintln("Connection to '" + serverName + "' succeeded.");
        } else {
            UIUtils.debugPrintln("Unable to add server '" + serverName + "'");
            if (show.booleanValue()) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.deploytoolwindow.could_not_connect_to_server", "Could not connect to {0}.\nPlease consult your server administrator.", new Object[]{serverName}));
            }
        }
        this.deployToolActions.setEnabled("AddServer", true);
    }

    private void addServer(String serverName, long timeout, boolean showError) {
        this.deployToolActions.setEnabled("AddServer", false);
        if (UIConfig.getConfigBoolean("ui.useAddServerWatchdog")) {
            new AddServerThread(serverName, timeout, showError).start();
        } else {
            Boolean ok;
            try {
                DT.getServerManager().addServer(serverName);
                ok = Boolean.TRUE;
            }
            catch (Throwable t2) {
                ok = Boolean.FALSE;
            }
            this._addServer_state(serverName, ok, new Boolean(showError));
        }
    }

    public void windowActivated(WindowEvent we) {
    }

    public void windowDeactivated(WindowEvent we) {
    }

    public void windowClosing(WindowEvent we) {
        Window win = (Window)we.getSource();
        if (win == this) {
            this.exitAction();
        }
    }

    public void windowClosed(WindowEvent we) {
    }

    public void windowDeiconified(WindowEvent we) {
    }

    public void windowIconified(WindowEvent we) {
    }

    public void windowOpened(WindowEvent we) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class AddModuleDialog
    extends UIDialog {
        private JRadioButton rbExistingApp = null;
        private JRadioButton rbNewApp = null;
        private TreeCombo cbAppCombo = null;
        private UITitledTextField tfAppFileName = null;
        private UITitledTextField tfAppName = null;
        private boolean isOk = false;

        public AddModuleDialog() {
            super((Frame)DeployToolWindow.this, true);
            this._init();
        }

        public void setApplicationName(String appName, String earFilename) {
            this.tfAppName.setText(appName);
            this.tfAppFileName.setText(earFilename);
        }

        public void show() {
            this.cbAppCombo.setModel(DeployToolWindow.this.getDescriptorTreeView().getApplicationsComboModel(DescriptorTreeView.AppType_AppsOnly));
            this.rbExistingApp.setSelected(true);
            super.show();
        }

        public boolean isOk() {
            return this.isOk;
        }

        public boolean addToExistingApplication() {
            return this.rbExistingApp.isSelected();
        }

        public boolean addToNewApplication() {
            return this.rbNewApp.isSelected();
        }

        public String getApplicationName() {
            return this.isOk() && this.addToNewApplication() ? this.tfAppName.getText() : null;
        }

        public String getApplicationFilename() {
            return this.isOk() && this.addToNewApplication() ? this.tfAppFileName.getText() : null;
        }

        public Application getExistingApplication() {
            return this.isOk() && this.addToExistingApplication() ? (Application)this.cbAppCombo.getSelectedDescriptor() : null;
        }

        private void _init() {
            this.setTitle(AMA_ADD_MODULE_TITLE);
            this.setWindowClosingAction(null);
            UITitledControlButtonBox content = new UITitledControlButtonBox(null, false);
            this.setContentPane(content);
            content.setControlButtonLocation(101);
            UITitledBox mainPanel = new UITitledBox(null, false);
            content.setView(mainPanel);
            GridBagConstraints gbc = mainPanel.getGBConstraintsCopy();
            UITitledHTMLText htmlText = new UITitledHTMLText(null, false);
            htmlText.setText(AMA_SELECT_APP);
            gbc.weightx = 0.5;
            gbc.weighty = 0.0;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 5, 0, 5);
            mainPanel.add((Component)htmlText, gbc);
            UIRadioButtonBox rbb = new UIRadioButtonBox(null, false);
            gbc.weightx = 0.5;
            gbc.weighty = 0.5;
            gbc.fill = 1;
            gbc.insets = new Insets(0, 5, 5, 5);
            mainPanel.add((Component)rbb, gbc);
            GridBagConstraints rbbGbc = rbb.getGBConstraintsCopy();
            rbbGbc.insets.left += 25;
            rbb.getGBConstraints().insets.top += 5;
            this.rbExistingApp = new JRadioButton(AMA_ADD_TO_EXISTING);
            rbb.addItem(this.rbExistingApp);
            this.cbAppCombo = new TreeCombo();
            rbb.add((Component)this.cbAppCombo, rbbGbc);
            rbb.addSelectionEnabledComponent(this.cbAppCombo, null);
            this.rbNewApp = new JRadioButton(AMA_ADD_TO_NEW);
            rbb.addItem(this.rbNewApp);
            this.tfAppFileName = new UITitledTextField(AMA_APP_FILE, false);
            this.tfAppFileName.setBrowserActionListener(new ActionListener(this){
                private final /* synthetic */ AddModuleDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e10) {
                    AddModuleDialog.access$1600(this.this$1);
                }
            });
            rbb.add((Component)this.tfAppFileName, rbbGbc);
            rbb.addSelectionEnabledComponent(this.tfAppFileName, null);
            this.tfAppName = new UITitledTextField(AMA_APP_NAME, false);
            rbb.add((Component)this.tfAppName, rbbGbc);
            rbb.addSelectionEnabledComponent(this.tfAppName, null);
            UIButton okButton = UIButton.createOkButton(new ActionListener(this){
                private final /* synthetic */ AddModuleDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae2) {
                    AddModuleDialog.access$1800(this.this$1);
                }
            });
            content.addControlButton(okButton);
            UIButton canBtn = UIButton.createCancelButton(new ActionListener(this){
                private final /* synthetic */ AddModuleDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae2) {
                    AddModuleDialog.access$1900(this.this$1);
                }
            });
            content.addControlButton(canBtn);
            UIHelpButton helpButton = new UIHelpButton(addModuleHelpId);
            content.addControlButton(helpButton);
            this.pack();
            Window owner = this.getOwner();
            int x2 = owner.getBounds().x + this.getBounds().width / 3;
            int y2 = owner.getBounds().y + this.getBounds().height / 3;
            ((Component)this).setBounds(x2, y2, 420, 300);
        }

        private void browseEarFileName() {
            JFileChooser jfc = UIFileChooser.getFileChooser();
            jfc.setFileSelectionMode(0);
            int rtn = jfc.showDialog(this, localStrings.getLocalString("ui.deploytoolwindow.add_module.choose_ear_filename", "New Application EAR Filename"));
            if (rtn == 0) {
                String filename = jfc.getSelectedFile().toString();
                if (!filename.toLowerCase().endsWith(DeployToolWindow.DOT_EAR)) {
                    filename = filename + DeployToolWindow.DOT_EAR;
                }
                this.tfAppFileName.setText(filename);
            }
        }

        private void okAction() {
            this.isOk = true;
            if (this.rbNewApp.isSelected()) {
                File earFile;
                String appFileName = this.getApplicationFilename();
                if (!appFileName.toLowerCase().endsWith(DeployToolWindow.DOT_EAR)) {
                    appFileName = appFileName + DeployToolWindow.DOT_EAR;
                }
                if ((earFile = new File(appFileName)).exists()) {
                    boolean overwrite = UIOptionPane.showConfirmDialog(this, localStrings.getLocalString("ui.deploytoolwindow.add_module.appfile_exists", "{0} already exists. Do you wish to overwrite?", new Object[]{earFile.getName()}));
                    if (!overwrite) {
                        return;
                    }
                    ApplicationManager appMgr = DT.getApplicationManager();
                    if (appMgr.getApplicationWithJar(earFile) != null) {
                        appMgr.closeApplication(appMgr.getApplicationWithJar(earFile));
                    }
                    earFile.delete();
                }
            }
            this.setVisible(false);
        }

        private void cancelAction() {
            this.isOk = false;
            this.setVisible(false);
        }

        static /* synthetic */ void access$1600(AddModuleDialog x0) {
            x0.browseEarFileName();
        }

        static /* synthetic */ void access$1800(AddModuleDialog x0) {
            x0.okAction();
        }

        static /* synthetic */ void access$1900(AddModuleDialog x0) {
            x0.cancelAction();
        }
    }

    class AddServerDialog
    extends UIDialog {
        private UITitledTextField serverNameTextField = null;
        private Frame owner;

        AddServerDialog(Frame owner) {
            super(owner, true);
            this.setWindowClosingAction(null);
            this.setTitle(ADD_SERVER_TITLE);
            CSH.setHelpIDString((Component)this, (String)addServerHelpId);
            this.owner = owner;
            super.dialogInit();
            ((JPanel)this.getContentPane()).setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
            this.getContentPane().setLayout(new BorderLayout());
            this.serverNameTextField = new UITitledTextField(ADD_SERVER_LABEL, false);
            this.serverNameTextField.setText("localhost");
            this.getContentPane().add((Component)this.serverNameTextField, "North");
            UITitledControlButtonBox buttonsPanel = new UITitledControlButtonBox(null, false);
            buttonsPanel.setControlButtonLocation(15);
            this.getContentPane().add((Component)buttonsPanel, "South");
            UIButton okBtn = UIButton.createOkButton(new ActionListener(this){
                private final /* synthetic */ AddServerDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae2) {
                    this.this$1.okAction();
                }
            });
            buttonsPanel.addControlButton(okBtn);
            okBtn.makeDefaultButton(true);
            UIButton canBtn = UIButton.createCancelButton(new ActionListener(this){
                private final /* synthetic */ AddServerDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae2) {
                    this.this$1.setVisible(false);
                }
            });
            buttonsPanel.addControlButton(canBtn);
            UIHelpButton helpButton = new UIHelpButton(addServerHelpId);
            buttonsPanel.addControlButton(helpButton);
            this.pack();
            int x2 = owner.getBounds().x + super.getBounds().width / 3;
            int y2 = owner.getBounds().y + super.getBounds().height / 3;
            ((Component)this).setBounds(x2, y2, super.getBounds().width + 50, super.getBounds().height);
        }

        void okAction() {
            if (!this.isVisible()) {
                UIUtils.debugImplementationError("Dialog is not visible!");
                return;
            }
            String serverName = this.serverNameTextField.getText();
            if ("".equals(serverName)) {
                UIOptionPane.showErrorDialog(this.owner, localStrings.getLocalString("ui.deploytoolwindow.supply_a_server_name", "Please supply the name of the host running the J2EE server"));
            } else {
                DeployToolWindow.this.addServer(serverName, -1L, true);
                this.setVisible(false);
            }
        }
    }

    public class AddServerThread
    extends Thread {
        private String serverName = null;
        private long timeout = 0L;
        private Boolean showError = null;
        private Boolean ok = null;

        public AddServerThread(String serverName, long timeout, boolean showError) {
            this.serverName = serverName;
            this.timeout = timeout >= 0L ? timeout : 10000L;
            this.showError = new Boolean(showError);
        }

        public AddServerThread(String serverName, boolean showError) {
            this(serverName, -1L, showError);
        }

        public void run() {
            Object object = addServerLock;
            synchronized (object) {
                Thread kickMe = null;
                if (this.timeout > 0L) {
                    kickMe = new Thread(new UIActionDispatcher((Object)this, "_watchdog"));
                    kickMe.start();
                }
                UIUtils.debugPrintln("Attempting to connect to '" + this.serverName + "'");
                try {
                    DT.getServerManager().addServer(this.serverName);
                    AddServerThread addServerThread = this;
                    synchronized (addServerThread) {
                        this.ok = Boolean.TRUE;
                        if (kickMe != null) {
                            kickMe.interrupt();
                        }
                    }
                }
                catch (Throwable t2) {
                    if (this.isInterrupted()) {
                        UIUtils.debugPrintln("Server connection timeout!");
                    } else {
                        UIUtils.debugPrintln("Server connection error : " + t2.toString());
                    }
                    AddServerThread addServerThread = this;
                    synchronized (addServerThread) {
                        this.ok = Boolean.FALSE;
                    }
                }
                EventQueue.invokeLater(new UIActionDispatcher((Object)DeployToolWindow.this, "_addServer_state", new Object[]{this.serverName, this.ok, this.showError}));
            }
        }

        public void _watchdog() {
            if (this.timeout <= 0L) {
                return;
            }
            try {
                Thread.sleep(this.timeout);
                AddServerThread addServerThread = this;
                synchronized (addServerThread) {
                    if (this.ok == null) {
                        UIUtils.debugPrintln("Server connection timeout!");
                        this.interrupt();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class ClonedInspectorFrame
    extends JFrame
    implements DescriptionInspector.DescriptionInspectorManager {
        private DescriptionInspector descriptionInspector = null;
        private InspectorEventDelegator inspector = null;

        public ClonedInspectorFrame(String title, InspectorEventDelegator id) {
            super(title);
            this.inspector = id;
            this.descriptionInspector = new DescriptionInspector(this);
        }

        public InspectorEventDelegator getInspector() {
            return this.inspector;
        }

        public DescriptionInspector getDescriptionInspector() {
            return this.descriptionInspector;
        }
    }
}

