/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;

public class ApplicationWebContextInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$ApplicationWebContextInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$ApplicationWebContextInspector = ApplicationWebContextInspector.class$("com.sun.enterprise.tools.deployment.ui.ApplicationWebContextInspector")) : class$com$sun$enterprise$tools$deployment$ui$ApplicationWebContextInspector);
    private static final String COL_WARFILE = localStrings.getLocalString("ui.applicationwebcontextinspector.war_file", "WAR File");
    private static final String COL_CTXROOT = localStrings.getLocalString("ui.applicationwebcontextinspector.context_root", "Context Root");
    private static final String TABNAME = localStrings.getLocalString("ui.applicationwebcontextinspector.tabname", "Web Context");
    private static String wizardHelpID = "WebContext";
    private static String deployHelpID = "WebContext";
    private Application descriptor = null;
    private WebContextTable webContextTable = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$ApplicationWebContextInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$Application;

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new ApplicationWebContextInspector();
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$deployment$Application == null ? (class$com$sun$enterprise$deployment$Application = ApplicationWebContextInspector.class$("com.sun.enterprise.deployment.Application")) : class$com$sun$enterprise$deployment$Application;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (desc != this.descriptor) {
            this.descriptor = desc instanceof Application ? (Application)desc : null;
            this.webContextTable.clearTableData();
        }
    }

    private ApplicationWebContextInspector() {
        this.initializeLayout();
    }

    private void initializeLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c10 = new GridBagConstraints();
        UITitledTable pnlWest = new UITitledTable(null, false);
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        this.add((Component)pnlWest, c10);
        this.webContextTable = new WebContextTable(new WebContextTableModel());
        pnlWest.setTableView(this.webContextTable);
    }

    public void refresh() {
        if (this.descriptor != null) {
            this.webContextTable.updateTableData(this.descriptor.getWebBundleDescriptors());
        } else {
            this.webContextTable.clearTableData();
        }
    }

    public boolean validateEntries() {
        Iterator itr = this.descriptor.getWebBundleDescriptors().iterator();
        while (itr.hasNext()) {
            WebBundleDescriptor wbd = (WebBundleDescriptor)itr.next();
            String cr2 = wbd.getContextRoot();
            if (cr2 != null && !cr2.equals("") && !cr2.equals("/")) continue;
            UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.applicationwebcontextinspector.invalid_context_root", "Context root for ''{0}'' must not be blank or ''/''", new Object[]{wbd.getName()}));
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class WebContextTableModel
    extends InspectorTableModel {
        public WebContextTableModel() {
            super(new String[]{COL_WARFILE, COL_CTXROOT});
        }

        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        public Object getObjectValue(Object obj, int col) {
            WebBundleDescriptor ref = (WebBundleDescriptor)obj;
            String value = "<???>";
            switch (col) {
                case 0: {
                    value = ref.getName();
                    break;
                }
                case 1: {
                    value = ref.getContextRoot();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            WebBundleDescriptor ref = (WebBundleDescriptor)obj;
            switch (col) {
                case 0: {
                    break;
                }
                case 1: {
                    ref.setContextRoot(value.toString());
                }
            }
        }
    }

    private class WebContextTable
    extends InspectorTable {
        public WebContextTable(WebContextTableModel model) {
            super(model);
        }
    }
}

